/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.permission.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.ServiceModel;
import com.digiwin.iam.UserTokenService;
import com.digiwin.lcdp.modeldriven.permission.ModelDrivenDataPermission;
import com.digiwin.lcdp.modeldriven.permission.service.ModelDrivenDataPermissionIAMHttpRequester;
import com.digiwin.lcdp.modeldriven.utils.json.ModelDrivenJacksonUtil;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ModelDataPermissionIAMService {
    public static final String API_LOGIN_INTERNAL = "/api/iam/v2/identity/login/internal";
    private static final String CLASS_LOG_TAG = "[" + ModelDrivenDataPermission.class.getSimpleName() + "]";

    ModelDataPermissionIAMService() {
    }

    public static Object invoke(ServiceModel model) throws Exception {
        return ModelDrivenDataPermissionIAMHttpRequester.submit(model);
    }

    public static String getIntegrationToken(String tenantId) throws Exception {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("tenantId \u4e0d\u53ef\u70ba\u7a7a");
        }
        String userToken = DWServiceContext.getContext().getToken();
        UserTokenService userTokenService = (UserTokenService)SpringContextUtils.getBean((String)"dwUserTokenService");
        HttpResponseModel integrationTokenResponseModel = userTokenService.exchangeToken(userToken, tenantId);
        if (integrationTokenResponseModel != null) {
            String responseBody = integrationTokenResponseModel.getResponseBody();
            if (integrationTokenResponseModel.getHttpStatusCode() != 200) {
                String errorMessage = String.format("%s [getIntegrationToken] failed ,response code:'%s', message:'%s'", CLASS_LOG_TAG, integrationTokenResponseModel.getHttpStatusCode(), responseBody);
                throw new DWException(errorMessage);
            }
            Map result = ModelDrivenJacksonUtil.fromJson(responseBody, Map.class);
            return MapUtils.getString((Map)result, (Object)"token");
        }
        throw new DWBusinessException(CLASS_LOG_TAG + "integrationTokenResponseModel is null");
    }
}

