/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.service.impl;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.dao.DWBatchCondition;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryInfoBuilder;
import com.digiwin.app.dao.DWSQLExecutionResult;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataRowCollection;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.lcdp.modeldriven.aop.ModelDrivenSQLExceptionSQLInfoCustomize;
import com.digiwin.lcdp.modeldriven.config.ModelDrivenProperties;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.constants.BMConstants;
import com.digiwin.lcdp.modeldriven.customize.utils.BMDataEaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewInfoParameterDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewParameterDTO;
import com.digiwin.lcdp.modeldriven.dataview.impl.ModelDrivenDataViewService;
import com.digiwin.lcdp.modeldriven.enums.ModelApiTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.ModelCreateTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.ModelFieldRelationTypeEnum;
import com.digiwin.lcdp.modeldriven.eventcenter.EventCenterUtil;
import com.digiwin.lcdp.modeldriven.eventcenter.constant.EventCenterTriggerTypeEnum;
import com.digiwin.lcdp.modeldriven.model.BindSqlInfo;
import com.digiwin.lcdp.modeldriven.model.ModelApiField;
import com.digiwin.lcdp.modeldriven.model.ModelAppInfoDTO;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelFieldDTO;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelOidDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSwitchCfg;
import com.digiwin.lcdp.modeldriven.pojo.ActivityParamterDTO;
import com.digiwin.lcdp.modeldriven.pojo.QueryConditionDTO;
import com.digiwin.lcdp.modeldriven.report.ModelDrivenReportUtil;
import com.digiwin.lcdp.modeldriven.report.check.ReportCheckResult;
import com.digiwin.lcdp.modeldriven.report.model.SqlValueFields;
import com.digiwin.lcdp.modeldriven.report.model.ValueReference;
import com.digiwin.lcdp.modeldriven.report.pojo.Dictionary;
import com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService;
import com.digiwin.lcdp.modeldriven.service.impl.ModelActivityService;
import com.digiwin.lcdp.modeldriven.service.impl.ModelDataEntryService;
import com.digiwin.lcdp.modeldriven.service.impl.ModelPublishService;
import com.digiwin.lcdp.modeldriven.utils.DBTableUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiRegisterUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiResultUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenContextExtraUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlParserUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelTableHelperExpress;
import com.digiwin.lcdp.modeldriven.utils.ParamFilterUtil;
import com.digiwin.lcdp.modeldriven.utils.ParamValidateUtil;
import com.digiwin.lcdp.modeldriven.utils.QueryConditionUtils;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import com.digiwin.lcdp.modeldriven.utils.SqlParserUtil;
import com.digiwin.lcdp.modeldriven.utils.runtime.ModelDrivenParameterParserUtil;
import com.digiwin.lcdp.modeldriven.utils.validate.ParameterFilterUtil;
import com.digiwin.utils.DWTenantUtils;
import com.google.gson.Gson;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class ModelDrivenEAICrudService
implements IModelDrivenEAICrudService {
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;
    @Autowired(required=false)
    ModelDataEntryService modelDataEntryService;
    @Autowired(required=false)
    ModelDrivenDataViewService modelDrivenDataViewService;
    @Autowired(required=false)
    private ModelPublishService modelPublishService;
    @Autowired(required=false)
    private ModelTableHelperExpress modelTableHelperExpress;
    @Autowired
    EventCenterUtil messageCenterUtil;
    @Autowired
    QueryConditionUtils queryConditionUtils;
    @Autowired
    ModelActivityService modelActivityService;
    @Autowired(required=false)
    @Qualifier(value="dw-modeldriven-properties")
    private ModelDrivenProperties modelDrivenProperties;
    private static final Logger log = LoggerFactory.getLogger(ModelDrivenEAICrudService.class);
    private static final String CLASS_LOG_TAG = "[" + ModelDrivenEAICrudService.class.getSimpleName() + "]";

    @Override
    @ModelDrivenSQLExceptionSQLInfoCustomize
    public Object get(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        String digiService = (String)headers.get("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String prod = digiServiceJo.getString("prod");
        String modelDrivenProdPrefix = EaiRegisterUtil.getEaiServicePrefixOfProd(prod) + ".";
        String name = digiServiceJo.getString("name");
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map<String, Object> modelDrivenContextExtraMap = modelDrivenContext.getExtraMap();
        modelDrivenContextExtraMap.put("currentServiceName", name);
        String targetTableName = this.modelTableHelperExpress.getTableName(name);
        if (StringUtils.isNotEmpty((CharSequence)targetTableName)) {
            log.debug("MDEAI CRUD targetTableName({} from BMCode using digi-service:name({})", (Object)targetTableName, (Object)name);
        } else {
            targetTableName = ModelDataUtil.replaceLast(name.replaceFirst(modelDrivenProdPrefix, ""), ".detail.get", "").replace(".", "_");
            log.debug("MDEAI CRUD targetTableName({} from digi-service:name{}) directly", (Object)targetTableName, (Object)name);
        }
        Object conditions = params.get(targetTableName);
        if (ObjectUtils.isEmpty(conditions)) {
            HashMap<String, Object> returnValue = new HashMap<String, Object>();
            returnValue.put(targetTableName, null);
            return returnValue;
        }
        HashMap<String, Object> dataEntryParams = new HashMap<String, Object>();
        HashMap queryInfoMap = new HashMap();
        if (MapUtils.isNotEmpty((Map)params)) {
            queryInfoMap.put("conditions", conditions);
            queryInfoMap.put("userTableName", targetTableName);
        }
        DWDataRow publishedDataRow = this.modelTableHelperExpress.getModel(targetTableName);
        Assert.notNull((Object)publishedDataRow, (String)String.format(ResourceBundleUtils.getString("lcdp.modeldriven.model.notExist"), targetTableName));
        ModelDTO publishedModel = ModelSchemaUtil.getModel(publishedDataRow);
        modelDrivenContext.setPublishedModel(publishedModel);
        ModelSchemaDTO publishedModelSchema = publishedModel.getSchema();
        queryInfoMap.put("model", publishedModelSchema);
        params.put("query_info", queryInfoMap);
        dataEntryParams.putAll(params);
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
        datas.add((Map)conditions);
        ParamValidateUtil.validateRequestParamWithoutPkAndBk(datas, publishedModelSchema, ModelApiTypeEnum.DETAIL);
        Map<String, List<ModelApiField>> tileResponseApiConfig = ParamValidateUtil.getApiResponseConfigByApiType(publishedModelSchema, ModelApiTypeEnum.DETAIL);
        return this.modelDataEntryService.get(dataEntryParams, tileResponseApiConfig);
    }

    @Override
    @ModelDrivenSQLExceptionSQLInfoCustomize
    public Object getList(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        log.debug("{} enter getList", (Object)CLASS_LOG_TAG);
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        String digiService = (String)headers.get("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String prod = digiServiceJo.getString("prod");
        String modelDrivenProdPrefix = EaiRegisterUtil.getEaiServicePrefixOfProd(prod) + ".";
        String name = digiServiceJo.getString("name");
        String targetTableName = this.modelTableHelperExpress.getTableName(name);
        if (StringUtils.isNotEmpty((CharSequence)targetTableName)) {
            log.debug("MDEAI CRUD targetTableName({} from BMCode using digi-service:name({})", (Object)targetTableName, (Object)name);
        } else {
            String tableNameFromDigiServiceName;
            targetTableName = BMProperties.getProperties().getRole() == BMRole.bmd && !BMConstants.getBmdOldModelServiceName().contains(name) ? ModelDataUtil.replaceLast(name.replaceFirst(modelDrivenProdPrefix, ""), ".std.list.get", "").replace(".", "_") : (tableNameFromDigiServiceName = EaiServiceNameUtil.getTableName(name, modelDrivenProdPrefix, ".get"));
            log.debug("MDEAI CRUD targetTableName({} from digi-service:name{}) directly", (Object)targetTableName, (Object)name);
        }
        HashMap<String, Object> dataEntryParams = new HashMap<String, Object>();
        List searchInfoParams = (List)MapUtils.getObject((Map)params, (Object)"search_info", new ArrayList());
        List sortInfoParams = (List)MapUtils.getObject((Map)params, (Object)"sort_info", new ArrayList());
        DWDataRow publishedDataRow = this.modelTableHelperExpress.getModel(targetTableName);
        Assert.notNull((Object)publishedDataRow, (String)String.format(ResourceBundleUtils.getString("lcdp.modeldriven.model.notExist"), targetTableName));
        ModelDrivenContextExtraUtil.initCrudEnvironment(name, targetTableName, publishedDataRow);
        ModelDTO publishedModel = ModelDrivenContext.getContext().getPublishedModel();
        params.put("model", publishedModel);
        params.put("userTableName", targetTableName);
        params.put("search_info", searchInfoParams);
        params.put("sort_info", sortInfoParams);
        params.put("data_info", params.get(targetTableName));
        params.put("actionId", MapUtils.getObject((Map)params, (Object)"activityId"));
        params.put("moduleId", "basicDataEntry");
        dataEntryParams.putAll(params);
        HashMap paramDatas = new HashMap();
        paramDatas.put(targetTableName, params.get(targetTableName));
        Map<String, List<ModelApiField>> tileResponseApiConfig = ParamValidateUtil.getApiResponseConfigByApiType(publishedModel.getSchema(), ModelApiTypeEnum.LIST);
        ModelDrivenContext.getContext().getExtraMap().put("hasApiConfigResponse", MapUtils.isNotEmpty(tileResponseApiConfig));
        return this.modelDataEntryService.getList(dataEntryParams, tileResponseApiConfig);
    }

    @Override
    @ModelDrivenSQLExceptionSQLInfoCustomize
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Object post(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        Map<String, Object> returnValue = new HashMap<String, Object>();
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        String digiService = (String)headers.get("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String prod = digiServiceJo.getString("prod");
        String modelDrivenProdPrefix = EaiRegisterUtil.getEaiServicePrefixOfProd(prod) + ".";
        String name = digiServiceJo.getString("name");
        String targetTableName = this.modelTableHelperExpress.getTableName(name);
        if (StringUtils.isNotEmpty((CharSequence)targetTableName)) {
            log.debug("MDEAI CRUD targetTableName({} from BMCode using digi-service:name({})", (Object)targetTableName, (Object)name);
        } else {
            targetTableName = ModelDataUtil.replaceLast(name.replaceFirst(modelDrivenProdPrefix, ""), ".create", "").replace(".", "_");
            log.debug("MDEAI CRUD targetTableName({} from digi-service:name{}) directly", (Object)targetTableName, (Object)name);
        }
        DWDataSetOperationOption serviceMappingOption = new DWDataSetOperationOption();
        serviceMappingOption.setTenantEnabled(false);
        serviceMappingOption.setManagementFieldEnabled(false);
        DWQueryInfo queryInfoServiceMapping = new DWQueryInfo(targetTableName);
        queryInfoServiceMapping.setTableName("dw_service_mapping");
        queryInfoServiceMapping.addEqualInfo("table_name", (Object)targetTableName);
        DWDataSet queryDataSet = this.dao.select(queryInfoServiceMapping, serviceMappingOption);
        if (queryDataSet == null || queryDataSet.getTables().getPrimaryTable().getRows().size() < 0) {
            return EaiResultUtil.getDWEAIFalseResult(returnValue);
        }
        DWDataRow publishedDataRow = this.modelTableHelperExpress.getModel(targetTableName);
        ModelDrivenContextExtraUtil.initCrudEnvironment(name, targetTableName, publishedDataRow);
        ModelDTO publishedModel = ModelDrivenContext.getContext().getPublishedModel();
        ModelSchemaDTO masterModelSchema = publishedModel.getSchema();
        String masterTableName = masterModelSchema.getName();
        boolean single = true;
        ArrayList<Map<String, Object>> masterTableParamDatas = new ArrayList<Map>();
        Object tableData = params.get(masterTableName);
        Assert.notNull(tableData, (String)ResourceBundleUtils.getString("paramValidate.create.input.noContent"));
        if (params.get(masterTableName) instanceof List) {
            single = false;
            masterTableParamDatas = (List)params.get(masterTableName);
        } else {
            masterTableParamDatas.add((Map)params.get(masterTableName));
        }
        ParamValidateUtil.validateRequestParamWithoutPkAndBk(masterTableParamDatas, masterModelSchema, ModelApiTypeEnum.CREATE);
        List<Map<String, Object>> businessKeys = null;
        businessKeys = this.modelDataEntryService.insertRows(masterModelSchema, masterTableParamDatas);
        HashMap<String, List<ModelApiField>> tileApiConfig = new HashMap<String, List<ModelApiField>>();
        Map<String, Object> influncedDatas = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(masterTableParamDatas)) {
            returnValue = this.modelDataEntryService.getDatas(single, masterTableName, businessKeys, tileApiConfig);
            influncedDatas = this.modelDataEntryService.getDatas(single, masterTableName, businessKeys, null);
        }
        this.messageCenterUtil.handleEventCenter(publishedDataRow, EventCenterTriggerTypeEnum.CREATE, influncedDatas);
        return EaiResultUtil.getDWEAIResult(returnValue);
    }

    @Override
    @ModelDrivenSQLExceptionSQLInfoCustomize
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Object put(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        Map<String, Object> returnValue = new HashMap<String, Object>();
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        String digiService = (String)headers.get("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String prod = digiServiceJo.getString("prod");
        String modelDrivenProdPrefix = EaiRegisterUtil.getEaiServicePrefixOfProd(prod) + ".";
        String name = digiServiceJo.getString("name");
        String targetTableName = this.modelTableHelperExpress.getTableName(name);
        if (StringUtils.isNotEmpty((CharSequence)targetTableName)) {
            log.debug("MDEAI CRUD targetTableName({} from BMCode using digi-service:name({})", (Object)targetTableName, (Object)name);
        } else {
            targetTableName = ModelDataUtil.replaceLast(name.replaceFirst(modelDrivenProdPrefix, ""), ".update", "").replace(".", "_");
            log.debug("MDEAI CRUD targetTableName({} from digi-service:name{}) directly", (Object)targetTableName, (Object)name);
        }
        DWDataSetOperationOption serviceMappingOption = new DWDataSetOperationOption();
        serviceMappingOption.setTenantEnabled(false);
        serviceMappingOption.setManagementFieldEnabled(false);
        DWQueryInfo queryInfoServiceMapping = new DWQueryInfo(targetTableName);
        queryInfoServiceMapping.setTableName("dw_service_mapping");
        queryInfoServiceMapping.addEqualInfo("table_name", (Object)targetTableName);
        DWDataSet queryDataSet = this.dao.select(queryInfoServiceMapping, serviceMappingOption);
        if (queryDataSet == null || queryDataSet.getTables().getPrimaryTable().getRows().size() < 0) {
            return EaiResultUtil.getDWEAIFalseResult(returnValue);
        }
        DWDataRow publishedDataRow = this.modelTableHelperExpress.getModel(targetTableName);
        ModelDrivenContextExtraUtil.initCrudEnvironment(name, targetTableName, publishedDataRow);
        ModelDTO publishedModel = ModelDrivenContext.getContext().getPublishedModel();
        ModelSchemaDTO masterModelSchema = publishedModel.getSchema();
        String masterTableName = masterModelSchema.getName();
        boolean single = true;
        List<Map<String, Object>> masterTableParamDatas = new ArrayList<Map>();
        if (params.get(masterTableName) instanceof List) {
            single = false;
            masterTableParamDatas = (List)params.get(masterTableName);
        } else {
            masterTableParamDatas.add((Map)params.get(masterTableName));
        }
        List<QueryConditionDTO> queryConditions = ModelDrivenParameterParserUtil.getQueryConditions(params, "queryConditions");
        HashMap<String, List<ModelApiField>> tileApiConfig = new HashMap<String, List<ModelApiField>>();
        masterTableParamDatas.forEach(masterTableParamData -> ParamFilterUtil.filterMgmtParam(masterTableParamData, masterModelSchema, name));
        if (CollectionUtils.isNotEmpty(queryConditions)) {
            returnValue = this.modelDataEntryService.updateMainRowsByQueryConditions(queryConditions, masterModelSchema, masterTableParamDatas, tileApiConfig);
            this.messageCenterUtil.handleEventCenter(publishedDataRow, EventCenterTriggerTypeEnum.UPDATE, returnValue);
            return EaiResultUtil.getDWEAIResult(returnValue);
        }
        ParamValidateUtil.validateRequestParamWithPkAndBk(masterTableParamDatas, masterModelSchema, ModelApiTypeEnum.UPDATE);
        ParamValidateUtil.validateStrategyOfChildrenTableRow(masterModelSchema, masterTableParamDatas);
        Map<String, List<Map<String, Object>>> allExistedDatas = this.modelDataEntryService.queryDatas(masterTableParamDatas, masterModelSchema);
        Map<String, List<Map<String, Object>>> paramterDatas = ParamValidateUtil.tileParameters(masterModelSchema, masterTableParamDatas);
        List<Map<String, Object>> needToCompareExistedDataParam = ParameterFilterUtil.filterParameters(masterModelSchema, masterTableParamDatas);
        List<ModelSchemaDTO> childrenModelSchema = masterModelSchema.getChildren();
        if (CollectionUtils.isNotEmpty(childrenModelSchema) && CollectionUtils.isNotEmpty(needToCompareExistedDataParam)) {
            Map<String, List<Map<String, Object>>> needToCompareDatas = this.modelDataEntryService.queryDatas(needToCompareExistedDataParam, masterModelSchema);
            Map<String, List<Map<String, Object>>> deleteRowsMap = this.modelDataEntryService.getDeleteRows(needToCompareDatas, paramterDatas, masterModelSchema);
            deleteRowsMap.forEach((tableName, datas) -> {
                if (CollectionUtils.isNotEmpty((Collection)datas)) {
                    this.modelDataEntryService.deleteRows(this.modelDataEntryService.getModelSchema(masterModelSchema, (String)tableName), (List<Map<String, Object>>)datas);
                }
            });
        }
        List<Map<String, Object>> businessKeys = this.modelDataEntryService.updateRows(masterModelSchema, masterTableParamDatas, allExistedDatas);
        Map<String, Object> influncedDatas = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(masterTableParamDatas)) {
            returnValue = this.modelDataEntryService.getDatas(single, masterTableName, businessKeys, tileApiConfig);
            influncedDatas = this.modelDataEntryService.getDatas(single, masterTableName, businessKeys, null);
        }
        this.messageCenterUtil.handleEventCenter(publishedDataRow, EventCenterTriggerTypeEnum.UPDATE, influncedDatas);
        return EaiResultUtil.getDWEAIResult(returnValue);
    }

    @Override
    @ModelDrivenSQLExceptionSQLInfoCustomize
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Object delete(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        DWQueryInfo queryInfo;
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        List<QueryConditionDTO> queryConditions = ModelDrivenParameterParserUtil.getQueryConditions(params, "queryConditions");
        String digiService = (String)headers.get("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String prod = digiServiceJo.getString("prod");
        String modelDrivenProdPrefix = EaiRegisterUtil.getEaiServicePrefixOfProd(prod) + ".";
        String name = digiServiceJo.getString("name");
        String targetTableName = this.modelTableHelperExpress.getTableName(name);
        if (StringUtils.isNotEmpty((CharSequence)targetTableName)) {
            log.debug("MDEAI CRUD targetTableName({} from BMCode using digi-service:name({})", (Object)targetTableName, (Object)name);
        } else {
            targetTableName = ModelDataUtil.replaceLast(name.replaceFirst(modelDrivenProdPrefix, ""), ".delete", "").replace(".", "_");
            log.debug("MDEAI CRUD targetTableName({} from digi-service:name{}) directly", (Object)targetTableName, (Object)name);
        }
        DWDataSetOperationOption serviceMappingOption = new DWDataSetOperationOption();
        serviceMappingOption.setTenantEnabled(false);
        serviceMappingOption.setManagementFieldEnabled(false);
        DWQueryInfo queryInfoServiceMapping = new DWQueryInfo(targetTableName);
        queryInfoServiceMapping.setTableName("dw_service_mapping");
        queryInfoServiceMapping.addEqualInfo("table_name", (Object)targetTableName);
        DWDataSet queryDataSet = this.dao.select(queryInfoServiceMapping, serviceMappingOption);
        if (queryDataSet == null || queryDataSet.getTables().getPrimaryTable().getRows().size() < 0) {
            return EaiResultUtil.getDWEAIFalseResult(returnValue);
        }
        DWDataRow publishedDataRow = this.modelTableHelperExpress.getModel(targetTableName);
        ModelDrivenContextExtraUtil.initCrudEnvironment(name, targetTableName, publishedDataRow);
        ModelDTO publishedModel = ModelDrivenContext.getContext().getPublishedModel();
        ModelSchemaDTO masterModelSchema = publishedModel.getSchema();
        String masterTableName = masterModelSchema.getName();
        List inputData = (List)params.get(targetTableName);
        DWBatchCondition batchCondition = new DWBatchCondition();
        if (CollectionUtils.isNotEmpty(queryConditions)) {
            ParamValidateUtil.validateRequestParamWithoutPkAndBk(inputData, masterModelSchema, ModelApiTypeEnum.DELETE);
            queryInfo = new DWQueryInfo(targetTableName);
            this.queryConditionUtils.generateCondition(queryConditions.iterator(), (DWQueryCondition)batchCondition, "");
        } else {
            ParamValidateUtil.validateRequestParamWithPkAndBk(inputData, masterModelSchema, ModelApiTypeEnum.DELETE);
            queryInfo = new DWQueryInfo();
            queryInfo.setTableName(masterTableName);
            DWQueryCondition condition = new DWQueryCondition();
            DWBatchCondition batchConditionTmp = new DWBatchCondition();
            batchConditionTmp.ORJoin();
            queryInfo.setCondition(condition);
            queryInfo.toOR();
            inputData.forEach(param -> {
                DWQueryCondition subCondition = new DWQueryCondition();
                param.forEach((arg_0, arg_1) -> ((DWQueryCondition)subCondition).addEqualInfo(arg_0, arg_1));
                condition.addCondition(subCondition);
            });
            inputData.forEach(param -> {
                DWQueryCondition subCondition = new DWQueryCondition();
                param.forEach((arg_0, arg_1) -> ((DWQueryCondition)subCondition).addEqualInfo(arg_0, arg_1));
                batchConditionTmp.addCondition(subCondition);
            });
            batchCondition = batchConditionTmp;
        }
        Map<String, Object> influncedDatas = this.modelDataEntryService.getListForInnerInvoke(queryInfo, new DWDataSetOperationOption(), false, null);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.getDeleteOption().enableBatchCondition();
        option.setManagementFieldEnabled(false);
        DWDataSet dataSet = new DWDataSet();
        dataSet.newTable(masterTableName).delete(batchCondition);
        DWSQLExecutionResult daoResult = this.dao.execute(dataSet, option);
        List dataList = (List)influncedDatas.get(masterTableName);
        dataList.forEach(masterTableParamData -> masterModelSchema.getChildren().forEach(subTableModel -> this.deleteSubTableData((ModelSchemaDTO)subTableModel, (Map<String, Object>)masterTableParamData, masterTableName)));
        HashMap<String, Integer> createResult = new HashMap<String, Integer>();
        createResult.put("count", daoResult.getCountByTable(targetTableName));
        returnValue.put("return_data", createResult);
        this.messageCenterUtil.handleEventCenter(publishedDataRow, EventCenterTriggerTypeEnum.DELETE, influncedDatas);
        return EaiResultUtil.getDWEAIResult(returnValue);
    }

    @Override
    @ModelDrivenSQLExceptionSQLInfoCustomize
    public Object putValid(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        Map<String, Object> returnValue = new HashMap<String, Object>();
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        String digiService = (String)headers.get("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String prod = digiServiceJo.getString("prod");
        String modelDrivenProdPrefix = EaiRegisterUtil.getEaiServicePrefixOfProd(prod) + ".";
        String name = digiServiceJo.getString("name");
        String targetTableName = this.modelTableHelperExpress.getTableName(name);
        if (StringUtils.isNotEmpty((CharSequence)targetTableName)) {
            log.debug("MDEAI CRUD targetTableName({} from BMCode using digi-service:name({})", (Object)targetTableName, (Object)name);
        } else {
            targetTableName = BMDataEaiServiceNameUtil.getValidTypeTableName(modelDrivenProdPrefix, name, prod, ".valid");
            log.debug("MDEAI CRUD targetTableName({} from digi-service:name{}) directly", (Object)targetTableName, (Object)name);
        }
        DWDataSetOperationOption serviceMappingOption = new DWDataSetOperationOption();
        serviceMappingOption.setTenantEnabled(false);
        serviceMappingOption.setManagementFieldEnabled(false);
        DWQueryInfo queryInfoServiceMapping = new DWQueryInfo(targetTableName);
        queryInfoServiceMapping.setTableName("dw_service_mapping");
        queryInfoServiceMapping.addEqualInfo("table_name", (Object)targetTableName);
        DWDataSet queryDataSet = this.dao.select(queryInfoServiceMapping, serviceMappingOption);
        if (queryDataSet == null || queryDataSet.getTables().getPrimaryTable().getRows().size() < 0) {
            return EaiResultUtil.getDWEAIFalseResult(returnValue);
        }
        DWDataRow publishedDataRow = this.modelTableHelperExpress.getModel(targetTableName);
        ModelDrivenContextExtraUtil.initCrudEnvironment(name, targetTableName, publishedDataRow);
        ModelDTO publishedModel = ModelDrivenContext.getContext().getPublishedModel();
        ModelSchemaDTO masterModelSchema = publishedModel.getSchema();
        String masterTableName = masterModelSchema.getName();
        if (!params.containsKey(masterTableName)) {
            throw new IllegalArgumentException(String.format(ResourceBundleUtils.getString("paramValidate.update.cannot.empty"), new Object[0]));
        }
        boolean single = true;
        ArrayList<Map<String, Object>> masterTableParamDatas = new ArrayList<Map>();
        if (params.get(masterTableName) instanceof List) {
            single = false;
            masterTableParamDatas = (List)params.get(masterTableName);
        } else {
            masterTableParamDatas.add((Map)params.get(masterTableName));
        }
        List<Map<String, Object>> businessKeys = this.modelDataEntryService.retrieveBKOrPKData(masterModelSchema, masterTableParamDatas);
        Map<String, Object> datas = this.modelDataEntryService.getDatas(single, masterTableName, businessKeys, null);
        ArrayList<Map<String, Object>> existedDatas = new ArrayList<Map<String, Object>>();
        if (datas.get(masterTableName) instanceof Map) {
            existedDatas.add((Map)datas.get(masterTableName));
        } else if (datas.get(masterTableName) instanceof List) {
            existedDatas.addAll((List)datas.get(masterTableName));
        }
        ParamValidateUtil.validateRequestParamWithPkAndBk(masterTableParamDatas, masterModelSchema, ModelApiTypeEnum.VALID);
        ParamValidateUtil.validateManageStatusSource(existedDatas, masterTableParamDatas, masterModelSchema, ModelApiTypeEnum.VALID);
        masterTableParamDatas.forEach(masterTableParamData -> {
            ParamFilterUtil.filterMgmtParam(masterTableParamData, masterModelSchema, name);
            ParamValidateUtil.filterParam(masterTableParamData, masterModelSchema);
            ParamValidateUtil.filterOutChildrenTableParam(masterTableParamData, masterModelSchema);
        });
        ArrayList<Map<String, Object>> triggerKeys = new ArrayList<Map<String, Object>>();
        List<ModelIndexDTO> uniqueIndexes = this.modelDataEntryService.getModelSchemaUniqueConstrains(masterModelSchema);
        DWDataSet dataSet = new DWDataSet();
        DWDataSetOperationOption option = this.getDataOptionWithDisableMgmtField();
        option.getUpdateOption().setEnableBatchCondition(true);
        DWDataTable dataTable = dataSet.newTable(masterTableName);
        masterTableParamDatas.forEach(rowdata -> {
            if (rowdata.get(DWTenantUtils.getTenantColumnName().toLowerCase()) != null) {
                rowdata.remove(DWTenantUtils.getTenantColumnName().toLowerCase());
            }
            DWQueryCondition condition = new DWQueryCondition();
            HashMap keys = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)uniqueIndexes)) {
                ModelIndexDTO uniqueIndex = (ModelIndexDTO)uniqueIndexes.get(0);
                uniqueIndex.getMember().forEach(item -> {
                    if (DWTenantUtils.getTenantColumnName().equals(item)) {
                        condition.addEqualInfo(item, DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
                        keys.put(item, DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
                    } else {
                        condition.addEqualInfo(item, rowdata.get(item));
                        keys.put(item, rowdata.get(item));
                    }
                });
            }
            if (MapUtils.getString((Map)rowdata, (Object)"manage_status", (String)"").equals("Y")) {
                triggerKeys.add(keys);
            }
            ModelDataUtil.dealUpdateMgmtFields(rowdata);
            dataTable.newRow(rowdata).setState("U").setCondition(condition);
        });
        this.dao.execute(dataSet, option);
        Map<String, List<ModelApiField>> tileResponseApiConfig = ParamValidateUtil.getApiResponseConfigByApiType(masterModelSchema, ModelApiTypeEnum.VALID);
        Map<String, Object> influncedDatas = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(masterTableParamDatas)) {
            returnValue = this.modelDataEntryService.getDatas(single, masterTableName, businessKeys, tileResponseApiConfig);
            influncedDatas = this.modelDataEntryService.getDatas(single, masterTableName, businessKeys, null);
        }
        if (CollectionUtils.isNotEmpty(triggerKeys) && !ObjectUtils.isEmpty(influncedDatas.get(masterTableName))) {
            this.messageCenterUtil.handleEventCenter(publishedDataRow, EventCenterTriggerTypeEnum.VALID, influncedDatas, triggerKeys);
        }
        return EaiResultUtil.getDWEAIResult(returnValue);
    }

    @Override
    @ModelDrivenSQLExceptionSQLInfoCustomize
    public Object putInvalid(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        Map<String, Object> returnValue = new HashMap<String, Object>();
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        String digiService = (String)headers.get("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String prod = digiServiceJo.getString("prod");
        String modelDrivenProdPrefix = EaiRegisterUtil.getEaiServicePrefixOfProd(prod) + ".";
        String name = digiServiceJo.getString("name");
        String targetTableName = this.modelTableHelperExpress.getTableName(name);
        if (StringUtils.isNotEmpty((CharSequence)targetTableName)) {
            log.debug("MDEAI CRUD targetTableName({} from BMCode using digi-service:name({})", (Object)targetTableName, (Object)name);
        } else {
            targetTableName = BMDataEaiServiceNameUtil.getValidTypeTableName(modelDrivenProdPrefix, name, prod, ".invalid");
            log.debug("MDEAI CRUD targetTableName({} from digi-service:name{}) directly", (Object)targetTableName, (Object)name);
        }
        DWDataSetOperationOption serviceMappingOption = new DWDataSetOperationOption();
        serviceMappingOption.setTenantEnabled(false);
        serviceMappingOption.setManagementFieldEnabled(false);
        DWQueryInfo queryInfoServiceMapping = new DWQueryInfo(targetTableName);
        queryInfoServiceMapping.setTableName("dw_service_mapping");
        queryInfoServiceMapping.addEqualInfo("table_name", (Object)targetTableName);
        DWDataSet queryDataSet = this.dao.select(queryInfoServiceMapping, serviceMappingOption);
        if (queryDataSet == null || queryDataSet.getTables().getPrimaryTable().getRows().size() < 0) {
            return EaiResultUtil.getDWEAIFalseResult(returnValue);
        }
        DWDataRow publishedDataRow = this.modelTableHelperExpress.getModel(targetTableName);
        ModelDrivenContextExtraUtil.initCrudEnvironment(name, targetTableName, publishedDataRow);
        ModelDTO publishedModel = ModelDrivenContext.getContext().getPublishedModel();
        ModelSchemaDTO masterModelSchema = publishedModel.getSchema();
        String masterTableName = masterModelSchema.getName();
        boolean single = true;
        ArrayList<Map<String, Object>> masterTableParamDatas = new ArrayList<Map>();
        if (params.get(masterTableName) instanceof List) {
            single = false;
            masterTableParamDatas = (List)params.get(masterTableName);
        } else {
            masterTableParamDatas.add((Map)params.get(masterTableName));
        }
        if (!params.containsKey(masterTableName)) {
            throw new IllegalArgumentException(String.format(ResourceBundleUtils.getString("paramValidate.update.cannot.empty"), new Object[0]));
        }
        List<Map<String, Object>> businessKeys = this.modelDataEntryService.retrieveBKOrPKData(masterModelSchema, masterTableParamDatas);
        Map<String, Object> datas = this.modelDataEntryService.getDatas(single, masterTableName, businessKeys, null);
        ArrayList<Map<String, Object>> existedDatas = new ArrayList<Map<String, Object>>();
        if (datas.get(masterTableName) instanceof Map) {
            existedDatas.add((Map)datas.get(masterTableName));
        } else if (datas.get(masterTableName) instanceof List) {
            existedDatas.addAll((List)datas.get(masterTableName));
        }
        ParamValidateUtil.validateRequestParamWithPkAndBk(masterTableParamDatas, masterModelSchema, ModelApiTypeEnum.INVALID);
        ParamValidateUtil.validateManageStatusSource(existedDatas, masterTableParamDatas, masterModelSchema, ModelApiTypeEnum.INVALID);
        masterTableParamDatas.forEach(masterTableParamData -> {
            ParamFilterUtil.filterMgmtParam(masterTableParamData, masterModelSchema, name);
            ParamValidateUtil.filterParam(masterTableParamData, masterModelSchema);
            ParamValidateUtil.filterOutChildrenTableParam(masterTableParamData, masterModelSchema);
        });
        ArrayList<Map<String, Object>> triggerKeys = new ArrayList<Map<String, Object>>();
        List<ModelIndexDTO> uniqueIndexes = this.modelDataEntryService.getModelSchemaUniqueConstrains(masterModelSchema);
        DWDataSet dataSet = new DWDataSet();
        DWDataSetOperationOption option = this.getDataOptionWithDisableMgmtField();
        option.getUpdateOption().setEnableBatchCondition(true);
        DWDataTable dataTable = dataSet.newTable(masterTableName);
        masterTableParamDatas.forEach(rowdata -> {
            if (rowdata.get(DWTenantUtils.getTenantColumnName().toLowerCase()) != null) {
                rowdata.remove(DWTenantUtils.getTenantColumnName().toLowerCase());
            }
            DWQueryCondition condition = new DWQueryCondition();
            HashMap keys = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)uniqueIndexes)) {
                ModelIndexDTO uniqueIndex = (ModelIndexDTO)uniqueIndexes.get(0);
                uniqueIndex.getMember().forEach(item -> {
                    if (DWTenantUtils.getTenantColumnName().equals(item)) {
                        condition.addEqualInfo(item, DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
                        keys.put(item, DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
                    } else {
                        condition.addEqualInfo(item, rowdata.get(item));
                        keys.put(item, rowdata.get(item));
                    }
                });
            }
            if (MapUtils.getString((Map)rowdata, (Object)"manage_status", (String)"").equals("V")) {
                triggerKeys.add(keys);
            }
            ModelDataUtil.dealUpdateMgmtFields(rowdata);
            dataTable.newRow(rowdata).setState("U").setCondition(condition);
        });
        this.dao.execute(dataSet, option);
        Map<String, List<ModelApiField>> tileResponseApiConfig = ParamValidateUtil.getApiResponseConfigByApiType(masterModelSchema, ModelApiTypeEnum.INVALID);
        Map<String, Object> influncedDatas = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(masterTableParamDatas)) {
            returnValue = this.modelDataEntryService.getDatas(single, masterTableName, businessKeys, tileResponseApiConfig);
            influncedDatas = this.modelDataEntryService.getDatas(single, masterTableName, businessKeys, null);
        }
        if (CollectionUtils.isNotEmpty(triggerKeys) && !ObjectUtils.isEmpty(influncedDatas.get(masterTableName))) {
            this.messageCenterUtil.handleEventCenter(publishedDataRow, EventCenterTriggerTypeEnum.INVALID, influncedDatas, triggerKeys);
        }
        return EaiResultUtil.getDWEAIResult(returnValue);
    }

    @ModelDrivenSQLExceptionSQLInfoCustomize
    public DWEAIResult getMetadata(Map<String, Object> headers, Map<String, Object> messageBody) {
        HashMap<String, Object> allMetadataData = new HashMap<String, Object>();
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        List datas = (List)params.get("data");
        Map extendConfig = (Map)params.get("extendConfig");
        boolean needFieldsFlag = MapUtils.getBoolean((Map)extendConfig, (Object)"needFieldsFlag", (Boolean)false);
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        if (needFieldsFlag) {
            String executeSql;
            List result;
            String partialTableCodition = "";
            if (CollectionUtils.isNotEmpty((Collection)datas)) {
                List quoteTableNames = datas.stream().map(DBTableUtil::addApostropheSymbol).collect(Collectors.toList());
                String tableList = String.join((CharSequence)", ", quoteTableNames);
                partialTableCodition = " AND dwTables.table_name in (" + tableList + ")";
            }
            if (CollectionUtils.isNotEmpty((Collection)(result = this.dao.select((IDWSQLOptions)option, executeSql = "SELECT dwTables.table_name dwTableName, dwTables.table_description tableComment, dwFields.FIELD_NAME fieldName, dwFields.FIELD_DISPLAY_NAME fieldDisplayName, dwFields.FIELD_TYPE fieldType FROM dw_rdbms_tables dwTables left JOIN dw_rdbms_fields dwFields ON dwTables.table_name = dwFields.table_name WHERE (dwTables.table_name NOT LIKE ('dw_%') AND dwTables.table_name NOT LIKE ('qrtz_%'))" + partialTableCodition, new Object[0])))) {
                for (Map row : result) {
                    Map tableNameData;
                    HashMap<String, String> rowFieldData = new HashMap<String, String>();
                    String fieldName = (String)row.get("fieldName");
                    rowFieldData.put("fieldName", fieldName);
                    String fieldDisplayName = (String)row.get("fieldDisplayName");
                    rowFieldData.put("fieldDisplayName", fieldDisplayName);
                    String fieldType = (String)row.get("fieldType");
                    rowFieldData.put("fieldType", fieldType);
                    String tableName = (String)row.get("dwTableName");
                    if (allMetadataData.containsKey(tableName)) {
                        List val = (List)allMetadataData.get(tableName);
                        if (CollectionUtils.isNotEmpty((Collection)val)) {
                            tableNameData = (Map)val.get(0);
                            List orgTabelField = tableNameData.getOrDefault("tableField", new ArrayList());
                            orgTabelField.add(rowFieldData);
                            continue;
                        }
                        tableNameData = new HashMap();
                        String tableComment = (String)row.get("tableComment");
                        tableNameData.put("tableComment", tableComment);
                        ArrayList<HashMap<String, String>> fieldData = new ArrayList<HashMap<String, String>>();
                        fieldData.add(rowFieldData);
                        tableNameData.put("tableField", fieldData);
                        val.add(tableNameData);
                        continue;
                    }
                    String tableComment = (String)row.get("tableComment");
                    tableNameData = new HashMap<String, String>();
                    tableNameData.put("tableComment", tableComment);
                    ArrayList<HashMap<String, String>> fieldData = new ArrayList<HashMap<String, String>>();
                    fieldData.add(rowFieldData);
                    tableNameData.put("tableField", fieldData);
                    ArrayList val = new ArrayList();
                    val.add(tableNameData);
                    allMetadataData.put(tableName, val);
                }
            }
        } else if (CollectionUtils.isNotEmpty((Collection)datas)) {
            for (String tableName : datas) {
                List result = this.dao.select((IDWSQLOptions)option, "select dw_rdbms_tables.table_description as tableComment from dw_rdbms_tables  where dw_rdbms_tables.table_name = ?", new Object[]{tableName});
                if (CollectionUtils.isNotEmpty((Collection)result)) {
                    ArrayList val = new ArrayList();
                    val.add(result.get(0));
                    allMetadataData.put(tableName, val);
                    continue;
                }
                log.warn("{} tableName({}): No data in dw_rdbms_tables", (Object)CLASS_LOG_TAG, (Object)tableName);
            }
        } else {
            List result = this.dao.select((IDWSQLOptions)option, "select dw_rdbms_tables.table_name as tableName , dw_rdbms_tables.table_description as  tableComment from dw_rdbms_tables  order by dw_rdbms_tables.table_name asc", new Object[0]);
            if (CollectionUtils.isNotEmpty((Collection)result)) {
                result.stream().forEach(tableData -> {
                    HashMap rowMap = new HashMap();
                    rowMap.put("tableComment", tableData.get("tableComment"));
                    ArrayList val = new ArrayList();
                    val.add(rowMap);
                    allMetadataData.put(tableData.get("tableName").toString(), val);
                });
            }
        }
        return EaiResultUtil.getDWEAIResult(allMetadataData);
    }

    public DWDataSetOperationOption getDataOptionWithDisableMgmtField() {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        return option;
    }

    public DWDataRow getPublished(ModelOidDTO modelOid) {
        DWDataSetOperationOption daoOption = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        List<Object> pkList = this.getDataEntryPkList(modelOid);
        DWQueryInfo queryInfo = new DWQueryInfoBuilder().setOids(pkList).create();
        queryInfo.setTableName("dw_lcdp_model");
        DWDataSet dataSet = this.dao.select(queryInfo, daoOption);
        if (dataSet != null && dataSet.getTable("dw_lcdp_model").getRows().size() > 0) {
            return dataSet.getTable("dw_lcdp_model").getRow(0);
        }
        return null;
    }

    private List<Object> getDataEntryPkList(ModelOidDTO modelOid) {
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put("code", modelOid.getCode());
        return Collections.singletonList(pkMap);
    }

    @Override
    @ModelDrivenSQLExceptionSQLInfoCustomize
    public Object getModelSql(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        List codes = (List)params.get("codes");
        String digiService = (String)headers.get("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String prod = digiServiceJo.getString("prod");
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map<String, Object> modelDrivenContextExtraMap = modelDrivenContext.getExtraMap();
        String modelDrivenProdPrefix = EaiRegisterUtil.getEaiServicePrefixOfProd(prod);
        modelDrivenContextExtraMap.put("modelDrivenProdPrefix", modelDrivenProdPrefix);
        if (CollectionUtils.isEmpty((Collection)codes)) {
            Map modelData = (Map)params.get("model");
            String modelStr = DWGsonProvider.getGson().toJson((Object)modelData);
            modelDrivenContextExtraMap.put("modelStr", modelStr);
            ModelDTO model = (ModelDTO)DWGsonProvider.getGson().fromJson(modelStr, ModelDTO.class);
            if (model.getSchema() == null) {
                log.debug("{} code({}) input model_schema is null", (Object)CLASS_LOG_TAG, (Object)model.getCode());
                String modelSchemaStr = (String)modelData.get("model_schema");
                ModelSchemaDTO modelSchema = ModelSchemaUtil.getModelSchema(modelSchemaStr);
                model.setSchema(modelSchema);
            }
            modelDrivenContext.setPublishedModel(model);
            Map<String, Object> codeSqlList = ModelSqlGenerator.getModelSql(model);
            returnValue.putAll(codeSqlList);
        } else {
            BMProperties bmProperties = BMProperties.getProperties();
            ArrayList codesBindedSqls = new ArrayList();
            for (String currentCode : codes) {
                ModelOidDTO modelOidDTO = new ModelOidDTO(currentCode, null, null, null);
                DWDataRow publishedDataRow = this.getPublished(modelOidDTO);
                if (publishedDataRow == null) {
                    returnValue.put(currentCode, new HashMap());
                    continue;
                }
                ModelDTO currentModel = ModelSchemaUtil.getModel(publishedDataRow);
                if (bmProperties != null && bmProperties.getRole() == BMRole.bmd) {
                    Map appInfo = (Map)params.get("appInfo");
                    String bodyProd = (String)appInfo.get("prod");
                    String bodyTargetProd = (String)appInfo.get("targetProd");
                    ModelAppInfoDTO appInfoDTO = new ModelAppInfoDTO();
                    appInfoDTO.setProd(bodyProd);
                    appInfoDTO.setTargetProd(bodyTargetProd);
                    currentModel.setAppInfo(appInfoDTO);
                }
                modelDrivenContext.setPublishedModel(currentModel);
                String modelStr = DWGsonProvider.getGson().toJson((Object)currentModel);
                modelDrivenContextExtraMap.put("modelStr", modelStr);
                BindSqlInfo bindSqlInfo = ModelSqlGenerator.getBindSqlInfo(currentModel);
                returnValue.put(currentCode, bindSqlInfo.getBindSqls());
            }
            returnValue.put("bindedSql", codesBindedSqls);
        }
        return EaiResultUtil.getDWEAIResult(returnValue);
    }

    @Override
    @ModelDrivenSQLExceptionSQLInfoCustomize
    public Object putModelDesign(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        String digiService = (String)headers.get("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String prod = digiServiceJo.getString("prod");
        if (!messageBody.containsKey("std_data")) {
            HashMap<String, Object> errorMsg = new HashMap<String, Object>();
            errorMsg.put("cause", "missing key:std_data");
            return EaiResultUtil.getDWEAIFalseResult(errorMsg);
        }
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map<String, Object> modelDrivenContextExtraMap = modelDrivenContext.getExtraMap();
        String executeTypeValue = MapUtils.getString((Map)params, (Object)"executeType", (String)"");
        if (StringUtils.isNotBlank((CharSequence)executeTypeValue)) {
            modelDrivenContextExtraMap.put("executeType", executeTypeValue);
        }
        Map modelData = (Map)params.get("model");
        String modelStr = DWGsonProvider.getGson().toJson((Object)modelData);
        Assert.notNull((Object)modelStr, (String)"input model must not be null");
        modelDrivenContextExtraMap.put("modelStr", modelStr);
        ModelDTO draftModel = (ModelDTO)DWGsonProvider.getGson().fromJson(modelStr, ModelDTO.class);
        draftModel.setUseExistedTable(ModelCreateTypeEnum.getTypeEnum((String)modelData.get("useExistedTable")));
        ModelDataUtil.preProcessWhenModelDesign(draftModel);
        modelDrivenContext.setCode(draftModel.getCode());
        modelDrivenContext.setDraftModel(draftModel);
        if (draftModel.isExtendModel()) {
            draftModel.setModelType("extend");
            DWEAIResult result = this.modelPublishService.extendSchemaPublishDraft(messageBody);
            return result;
        }
        Map modelSchemaMap = (Map)modelData.get("schema");
        Assert.notNull((Object)modelSchemaMap, (String)"Model 'schema' must not be null");
        if (!modelSchemaMap.containsKey("useExistedTable")) {
            String useExistedTableOfModel = (String)modelData.computeIfAbsent("useExistedTable", key -> ModelCreateTypeEnum.GENERIC.getTypeChar());
            modelSchemaMap.put("useExistedTable", useExistedTableOfModel);
        }
        String modelProd = ModelDataUtil.getProd(draftModel, prod);
        Assert.hasText((String)modelProd, (String)"model prod is null or empty");
        String modelDrivenProdPrefix = EaiRegisterUtil.getEaiServicePrefixOfProd(modelProd);
        modelDrivenContextExtraMap.put("modelDrivenProdPrefix", modelDrivenProdPrefix);
        ModelSchemaDTO draftModelSchema = draftModel.getSchema();
        if (draftModelSchema == null) {
            log.debug("code({}) input model_schema is null", (Object)draftModel.getCode());
            String modelSchemaStr = DWGsonProvider.getGson().toJson((Object)modelSchemaMap);
            draftModelSchema = ModelSchemaUtil.getModelSchema(modelSchemaStr);
            draftModel.setSchema(draftModelSchema);
        }
        Assert.notNull((Object)draftModelSchema, (String)"'draftModelSchema' must not be null");
        ModelSchemaUtil.reorganize(draftModelSchema);
        return this.modelPublishService.publishDraft(messageBody);
    }

    @Override
    @ModelDrivenSQLExceptionSQLInfoCustomize
    public Object deleteModelDesign(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        DWEAIResult dwEaiResult;
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        Map modelData = (Map)params.get("model");
        String modelStr = DWGsonProvider.getGson().toJson((Object)modelData);
        ModelDTO model = (ModelDTO)DWGsonProvider.getGson().fromJson(modelStr, ModelDTO.class);
        DWServiceResult serviceResult = this.modelPublishService.deleteModelSchema(model, messageBody);
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        returnValue.put("code", model.getCode());
        returnValue.put("message", serviceResult.getMessage());
        if (serviceResult.isSuccess()) {
            dwEaiResult = EaiResultUtil.getDWEAIResult(returnValue);
        } else if (serviceResult.getData() instanceof Map) {
            returnValue.putAll((Map)serviceResult.getData());
            dwEaiResult = EaiResultUtil.getDWEAIFalseResult(returnValue);
        } else {
            String message = serviceResult.getMessage();
            returnValue.put("message", message);
            dwEaiResult = EaiResultUtil.getDWEAIFalseResult(returnValue);
        }
        return dwEaiResult;
    }

    @Override
    @ModelDrivenSQLExceptionSQLInfoCustomize
    public Object getSqlReport(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        String sqlFieldsStr = DWGsonProvider.getGson().toJson((Object)params);
        SqlValueFields sqlValueFields = (SqlValueFields)DWGsonProvider.getGson().fromJson(sqlFieldsStr, SqlValueFields.class);
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        String sql = sqlValueFields.getSql();
        ReportCheckResult checkResult = ModelDrivenReportUtil.checkSql(sqlValueFields, this.modelTableHelperExpress);
        if (!checkResult.isSuccess()) {
            returnData.put("error", checkResult.getMessages());
            return EaiResultUtil.getDWEAIFalseResult(returnData);
        }
        String tableName = SqlParserUtil.getMainTable(sql);
        ModelDTO model = this.modelDrivenDataViewService.getModel(tableName);
        Assert.notNull((Object)model, (String)String.format(ResourceBundleUtils.getString("lcdp.modeldriven.model.notExist"), tableName));
        ModelSwitchCfg modelSwitchCfg = model.getSchema().getSwitchCfg();
        if (modelSwitchCfg != null && "Y".equals(modelSwitchCfg.getDataPermission()) && StringUtils.isNotEmpty((CharSequence)sqlValueFields.getActionId()) && StringUtils.isNotEmpty((CharSequence)sqlValueFields.getModuleId()) && StringUtils.isNotEmpty((CharSequence)sqlValueFields.getAppId())) {
            sql = ModelSqlParserUtil.processDataPermissionSql(sql, sqlValueFields, this.modelDataEntryService);
        }
        StopWatch executeWatch = StopWatch.createStarted();
        List sqlQueryData = this.dao.select((IDWSQLOptions)option, sql, new Object[0]);
        int daoDataSize = sqlQueryData.size();
        returnData.put("daoSize", daoDataSize);
        if (daoDataSize > 0) {
            executeWatch.split();
            returnData.put("daoCost", executeWatch.getTime());
            List<String> sqlTableColumnNames = ((Map)sqlQueryData.get(0)).keySet().stream().collect(Collectors.toList());
            List<ValueReference> validValueReferences = ModelDrivenReportUtil.getValidValueReference(sqlValueFields.getFields(), sqlTableColumnNames);
            List keysDictionary = validValueReferences.stream().map(ValueReference::getFullPath).collect(Collectors.toList());
            keysDictionary.retainAll(sqlTableColumnNames);
            if (CollectionUtils.isNotEmpty(keysDictionary)) {
                for (Map rowData : sqlQueryData) {
                    for (Map.Entry entry : rowData.entrySet()) {
                        String keyRowData = (String)entry.getKey();
                        if (!keysDictionary.contains(keyRowData)) continue;
                        Object valueRowData = rowData.get(keyRowData);
                        log.debug("process key({}) value({})", (Object)keyRowData, valueRowData);
                        for (ValueReference valueRef : validValueReferences) {
                            List<Dictionary> dicts;
                            if (!valueRef.getFullPath().equals(keyRowData) || !CollectionUtils.isNotEmpty(dicts = valueRef.getDictionary())) continue;
                            for (Dictionary dict : dicts) {
                                String dictCode = dict.getCode();
                                if (dictCode.equals(String.valueOf(valueRowData))) {
                                    rowData.replace(keyRowData, dict.getValue());
                                    log.debug("found key({}), {} -> {}", new Object[]{keyRowData, dictCode, dict.getValue()});
                                    continue;
                                }
                                log.debug("not found key({})", (Object)dictCode);
                            }
                        }
                    }
                }
                executeWatch.split();
                returnData.put("replaceCost", executeWatch.getSplitTime());
            }
        }
        executeWatch.stop();
        returnData.put("data", sqlQueryData);
        return EaiResultUtil.getDWEAIResult(returnData);
    }

    @Override
    @ModelDrivenSQLExceptionSQLInfoCustomize
    public Object dataViewGet(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        Map<String, Object> modelDrivenContextExtraMap = ModelDrivenContext.getContext().getExtraMap();
        modelDrivenContextExtraMap.put("crudType", "dataView");
        Gson gson = DWGsonProvider.getGson();
        DataViewParameterDTO dataViewParamData = (DataViewParameterDTO)gson.fromJson(gson.toJson((Object)params, Map.class), DataViewParameterDTO.class);
        if (StringUtils.isNotBlank((CharSequence)dataViewParamData.getType()) && dataViewParamData.getType().equals("total")) {
            HashMap returnValue = new HashMap();
            HashMap<String, Integer> dataViewTotalCount = new HashMap<String, Integer>();
            List<String> dataViewList = dataViewParamData.getDataViewList();
            for (String currentDataViewCode : dataViewList) {
                DataViewInfoParameterDTO infoParam = new DataViewInfoParameterDTO();
                infoParam.setCode(currentDataViewCode);
                DataViewParameterDTO currentDataViewParamData = new DataViewParameterDTO();
                currentDataViewParamData.setView_info(infoParam);
                Object currentCodeResult = this.modelDrivenDataViewService.dataviewGet(currentDataViewParamData);
                if (currentCodeResult instanceof Map) {
                    if (MapUtils.isNotEmpty((Map)((Map)currentCodeResult))) {
                        Object codeData = ((Map)currentCodeResult).get(currentDataViewCode);
                        if (codeData instanceof List) {
                            int currentDataCount = ((List)codeData).size();
                            dataViewTotalCount.put(currentDataViewCode, currentDataCount);
                        }
                    } else {
                        dataViewTotalCount.put(currentDataViewCode, 0);
                    }
                }
                returnValue.put("dataViewTotalCount", dataViewTotalCount);
            }
            return returnValue;
        }
        return this.modelDrivenDataViewService.dataviewGet(dataViewParamData);
    }

    void deleteSubTableData(ModelSchemaDTO subTableModel, Map<String, Object> masterTableData, String masterTableName) {
        if (MapUtils.isNotEmpty(masterTableData)) {
            String subTableName = subTableModel.getName();
            List<ModelFieldDTO> quoteFields = subTableModel.getFields().stream().filter(field -> ModelFieldRelationTypeEnum.QUOTE.getValue().equals(field.getType()) && field.getAssociatedInfo().getTableName().equals(masterTableName)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(quoteFields)) {
                DWQueryInfo subTableQueryInfo = new DWQueryInfo();
                subTableQueryInfo.setTableName(subTableName);
                quoteFields.forEach(field -> {
                    String quoteField = field.getFieldId();
                    subTableQueryInfo.addEqualInfo(quoteField, masterTableData.get(quoteField));
                });
                DWDataSet subtableDataSet = this.dao.select(subTableQueryInfo);
                DWDataRowCollection subtableRows = subtableDataSet.getTable(subTableName).getRows();
                if (subtableRows != null && subtableRows.size() > 0) {
                    StringBuilder deleteSql = new StringBuilder("delete from " + subTableName + " where 1=1 ");
                    ArrayList deleteParams = new ArrayList();
                    quoteFields.forEach(field -> {
                        String quoteField = field.getFieldId();
                        deleteSql.append(" and ").append(quoteField).append(" = ? ");
                        deleteParams.add(masterTableData.get(quoteField));
                    });
                    if (DWTenantUtils.isTenantenabled()) {
                        deleteSql.append(DWTenantUtils.getTenantTagByColumnName());
                    }
                    DWDataSetOperationOption option = new DWDataSetOperationOption();
                    option.setManagementFieldEnabled(false);
                    this.dao.update((IDWSQLOptions)option, deleteSql.toString(), deleteParams.toArray(new Object[deleteParams.size()]));
                    subtableRows.forEach(subTableData -> {
                        List<ModelSchemaDTO> subsubTableModels = subTableModel.getChildren();
                        if (CollectionUtils.isNotEmpty(subsubTableModels)) {
                            subsubTableModels.forEach(subsubTableModel -> this.deleteSubTableData((ModelSchemaDTO)subsubTableModel, subTableData.getData(), subTableName));
                        }
                    });
                }
            }
        }
    }

    @Override
    @ModelDrivenSQLExceptionSQLInfoCustomize
    public Object invoke(Map<String, Object> headers, Map<String, Object> messageBody) {
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        String invokeId = Optional.ofNullable((String)params.get("invokeId")).orElseThrow(() -> new RuntimeException("invokeId can not be null"));
        String componentId = "";
        String methodId = "";
        if (invokeId.split("\\/").length != 2) {
            throw new DWRuntimeException("parameter 'invokeId' is illegal");
        }
        componentId = invokeId.split("\\/")[0];
        methodId = invokeId.split("\\/")[1];
        Map param = Optional.ofNullable((Map)params.get("request")).orElseThrow(() -> new RuntimeException("paramter 'request' can not be null"));
        try {
            Object object = Class.forName("com.digiwin.lcdp.modeldriven.extend.dap.decorator." + componentId).newInstance();
            Method method = object.getClass().getDeclaredMethod(methodId, Map.class);
            return method.invoke(object, param);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new DWRuntimeException("modeldriven.commons.eai.invoke exception", (Throwable)e);
        }
    }

    @Override
    public Object updateView(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        Gson gson = DWGsonProvider.getGson();
        DataViewDTO dataView = (DataViewDTO)gson.fromJson(gson.toJson((Object)params, Map.class), DataViewDTO.class);
        return this.modelDrivenDataViewService.updateViewInfos(dataView);
    }

    @Override
    public Object updateActivity(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        Gson gson = DWGsonProvider.getGson();
        ActivityParamterDTO activity = (ActivityParamterDTO)gson.fromJson(gson.toJson((Object)params, Map.class), ActivityParamterDTO.class);
        return this.modelActivityService.updateActivities(activity);
    }

    @Override
    public Object getVersion(Map<String, Object> headers, Map<String, Object> messageBody) {
        log.info("modelDrivenProperties:{}", (Object)this.modelDrivenProperties);
        String currentVersion = this.modelDrivenProperties.getCurrentVersion();
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        returnValue.put("currentVersion", currentVersion);
        returnValue.put("currentSource", (Object)this.modelDrivenProperties.getCurrentSource());
        returnValue.put("currentMap.path", this.modelDrivenProperties.getCurrentMap().get("file"));
        return EaiResultUtil.getDWEAIResult(returnValue);
    }
}

