/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelStringUtil;
import org.apache.commons.lang3.StringUtils;

public class EaiServiceNameUtil {
    private EaiServiceNameUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String covertToServiceName(String data) {
        return ModelStringUtil.replaceUnderScoreToDot(data);
    }

    public static String getEaiPrefixName(String prodPrefix, String masterTableName) {
        return String.join((CharSequence)".", prodPrefix, EaiServiceNameUtil.covertToServiceName(masterTableName));
    }

    public static String getChildListGetEaiServiceId(String eaiServicePrefix, String tableName) {
        String eaiServiceName = EaiServiceNameUtil.covertToServiceName(tableName);
        String eaiServiceIdForServiceMapping = "";
        eaiServiceIdForServiceMapping = StringUtils.isNotBlank((CharSequence)eaiServicePrefix) ? String.join((CharSequence)".", eaiServicePrefix, eaiServiceName, "list.get") : String.join((CharSequence)".", eaiServiceName, "list.get");
        return eaiServiceIdForServiceMapping;
    }

    public static String getBMChildListGetEaiServiceId(String eaiServicePrefix, String tableName) {
        String eaiServiceName = EaiServiceNameUtil.covertToServiceName(tableName);
        String eaiServiceIdForServiceMapping = "";
        eaiServiceIdForServiceMapping = StringUtils.isNotBlank((CharSequence)eaiServicePrefix) ? String.join((CharSequence)".", eaiServicePrefix, eaiServiceName, "std", "list.get") : String.join((CharSequence)".", eaiServiceName, "std", "list.get");
        return eaiServiceIdForServiceMapping;
    }

    public static String getEaiProd(String eaiTableName, String userExposePrefixEaiId) {
        String eaiMasterId = ModelStringUtil.replaceUnderScoreToDot(eaiTableName);
        if (userExposePrefixEaiId.equals(eaiMasterId)) {
            return "";
        }
        return StringUtils.removeEnd((String)userExposePrefixEaiId, (String)("." + eaiMasterId));
    }

    public static String convertEaiIdTypeForServiceMapping(String prod) {
        return ModelStringUtil.replaceUnderScoreAndDashToDot(prod.toLowerCase());
    }

    public static String getTableNameByListGet(String serviceName, String modelDrivenProdPrefix) {
        String targetTableName = "";
        if (StringUtils.endsWith((CharSequence)serviceName, (CharSequence)".get")) {
            targetTableName = StringUtils.endsWith((CharSequence)serviceName, (CharSequence)".list.get") ? ModelDataUtil.replaceLast(serviceName.replaceFirst(modelDrivenProdPrefix, ""), ".list.get", "").replace(".", "_") : ModelDataUtil.replaceLast(serviceName.replaceFirst(modelDrivenProdPrefix, ""), ".get", "").replace(".", "_");
        }
        return targetTableName;
    }

    public static String getTableName(String serviceName, String modelDrivenProdPrefix, String serviceType) {
        String targetTableName = "";
        if (serviceType.equals(".get")) {
            targetTableName = EaiServiceNameUtil.getTableNameByListGet(serviceName, modelDrivenProdPrefix);
        }
        return targetTableName;
    }
}

