/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.data.DWDataRow;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class ModelDrivenContextExtraUtil {
    private ModelDrivenContextExtraUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void updatePublishReturnSql(List<SqlParam> ddlSqlParams, List<SqlParam> dmlSqlParams, Map<String, Object> extraMapOfModelContext) {
        Optional<String> optionalReturnSql = ModelDrivenContextExtraUtil.getExecuteTypeAndReturnSql(extraMapOfModelContext);
        if (optionalReturnSql.isPresent()) {
            Map<String, Object> executeSqls = ModelSqlGenerator.getExecutableSql(ddlSqlParams, dmlSqlParams);
            extraMapOfModelContext.put("returnSql", executeSqls);
        }
    }

    public static Optional<String> getExecuteTypeAndReturnSql(Map<String, Object> extraMapOfModelContext) {
        return extraMapOfModelContext.keySet().stream().filter(key -> StringUtils.equals((CharSequence)key, (CharSequence)"executeType") && StringUtils.equals((CharSequence)"returnSql", (CharSequence)extraMapOfModelContext.getOrDefault("executeType", ""))).findFirst();
    }

    public static Object getPublishReturnSql(Map<String, Object> extraMapOfModelContext) {
        Optional<String> optionalReturnSql = ModelDrivenContextExtraUtil.getExecuteTypeAndReturnSql(extraMapOfModelContext);
        if (optionalReturnSql.isPresent()) {
            return extraMapOfModelContext.get("returnSql");
        }
        return null;
    }

    public static void putPublishedModelSchema(ModelSchemaDTO publishedModelSchema) {
        Map<String, Object> extraMapModelContext = ModelDrivenContextExtraUtil.getExtraMap();
        extraMapModelContext.put("pModelSchema", publishedModelSchema);
    }

    public static void initCrudEnvironment(String serviceName, String targetTableName, DWDataRow publishedDataRow) {
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map<String, Object> modelDrivenContextExtraMap = modelDrivenContext.getExtraMap();
        modelDrivenContextExtraMap.put("currentServiceName", serviceName);
        Assert.notNull((Object)publishedDataRow, (String)String.format(ResourceBundleUtils.getString("lcdp.modeldriven.model.notExist"), targetTableName));
        ModelDTO publishedModel = ModelSchemaUtil.getModel(publishedDataRow);
        modelDrivenContext.setPublishedModel(publishedModel);
    }

    public static String getDataPermissionKey(String actionId, String moduleId) {
        return String.join((CharSequence)"-", actionId, moduleId).toLowerCase();
    }

    public static Object getCachedDataPermissionCache(String dataPermissionKey) {
        Map<String, Object> dataPermDataMap = ModelDrivenContextExtraUtil.getDataPermissionData();
        return dataPermDataMap.get(dataPermissionKey);
    }

    public static Map<String, Object> getDataPermissionData() {
        Map<String, Object> modelDrivenContextExtraMap = ModelDrivenContextExtraUtil.getExtraMap();
        Map dataPermDataMap = modelDrivenContextExtraMap.getOrDefault("dataPermission", new HashMap());
        return dataPermDataMap;
    }

    public static void setDataPermissionData(Map<String, Object> dataPermDataMap) {
        Map<String, Object> modelDrivenContextExtraMap = ModelDrivenContextExtraUtil.getExtraMap();
        modelDrivenContextExtraMap.put("dataPermission", dataPermDataMap);
    }

    public static Map<String, Object> getExtraMap() {
        return ModelDrivenContext.getContext().getExtraMap();
    }
}

