/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.lcdp.modeldriven.utils.DBTableUtil;
import com.digiwin.lcdp.modeldriven.utils.datetime.ModelDrivenDateTimeFormatUtil;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ModelStringUtil {
    private ModelStringUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String replaceUnderScoreToDot(String data) {
        return data.replace("_", ".");
    }

    public static String replaceDotToUnderScore(String data) {
        return data.replace(".", "_");
    }

    public static String replaceDashToDot(String data) {
        return data.replace("-", ".");
    }

    public static String replaceDotToDash(String data) {
        return data.replace(".", "-");
    }

    public static String replaceUnderScoreAndDashToDot(String data) {
        return data.replaceAll("[_-]", ".");
    }

    public static boolean startsWithAnyIgnoreCase(String input, String ... prefixes) {
        if (input == null || prefixes == null) {
            return false;
        }
        for (String prefix : prefixes) {
            if (prefix == null || !StringUtils.startsWithIgnoreCase((CharSequence)input, (CharSequence)prefix)) continue;
            return true;
        }
        return false;
    }

    public static String convertValueStringAndDate(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "'" + value + "'";
        }
        if (value instanceof Date) {
            LocalDateTime localDateTime = ModelDrivenDateTimeFormatUtil.convertDateToLocalDateTime((Date)value);
            return DBTableUtil.addApostropheSymbol(ModelDrivenDateTimeFormatUtil.dashDateTimeFullFormat(localDateTime));
        }
        return value.toString();
    }

    public static String convertValueString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "'" + value + "'";
        }
        return value.toString();
    }
}

