/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryField;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.lcdp.modeldriven.dataview.utils.DataViewFieldUtil;
import com.digiwin.lcdp.modeldriven.dataview.utils.SystemVariableUtil;
import com.digiwin.lcdp.modeldriven.pojo.QueryConditionDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryConditionUtils {
    private final SystemVariableUtil systemVariableUtil;

    @Autowired
    public QueryConditionUtils(Optional<SystemVariableUtil> optionalSystemVariableUtil) {
        this.systemVariableUtil = optionalSystemVariableUtil.orElse(null);
    }

    public DWQueryCondition generateCondition(Iterator<?> it, DWQueryCondition condition, String logic) {
        while (it.hasNext()) {
            QueryConditionDTO currentSearchInfo = (QueryConditionDTO)it.next();
            if ("(".equals(currentSearchInfo.getBracket())) {
                DWQueryCondition childCondition = new DWQueryCondition();
                condition.addCondition(childCondition);
                this.dealQueryConditions(childCondition, currentSearchInfo, logic);
                this.generateCondition(it, childCondition, currentSearchInfo.getLogic());
                continue;
            }
            if (")".equals(currentSearchInfo.getBracket())) {
                this.dealQueryConditions(condition, currentSearchInfo, logic);
                this.generateCondition(it, condition.getParentCondition(), currentSearchInfo.getLogic());
                continue;
            }
            this.dealQueryConditions(condition, currentSearchInfo, logic);
            this.generateCondition(it, condition, currentSearchInfo.getLogic());
        }
        return condition;
    }

    public DWQueryCondition generateCondition(Iterator<?> it, DWQueryCondition condition, List<Map<String, Object>> customizedConditionValues) {
        return this.generateCondition(it, condition, null, customizedConditionValues);
    }

    public DWQueryCondition generateCondition(Iterator<?> it, DWQueryCondition condition, String logic, List<Map<String, Object>> customizedConditionValues) {
        while (it.hasNext()) {
            QueryConditionDTO currentSearchInfo = (QueryConditionDTO)it.next();
            if ("(".equals(currentSearchInfo.getBracket())) {
                DWQueryCondition childCondition = new DWQueryCondition();
                condition.addCondition(childCondition);
                this.dealVariables(childCondition, currentSearchInfo, logic, customizedConditionValues);
                this.generateCondition(it, childCondition, currentSearchInfo.getLogic(), customizedConditionValues);
                continue;
            }
            if (")".equals(currentSearchInfo.getBracket())) {
                this.dealVariables(condition, currentSearchInfo, logic, customizedConditionValues);
                this.generateCondition(it, condition.getParentCondition(), currentSearchInfo.getLogic(), customizedConditionValues);
                continue;
            }
            this.dealVariables(condition, currentSearchInfo, logic, customizedConditionValues);
            this.generateCondition(it, condition, currentSearchInfo.getLogic(), customizedConditionValues);
        }
        return condition;
    }

    public void dealQueryConditions(DWQueryCondition condition, QueryConditionDTO searchInfo, String logic) {
        ArrayList<DWQueryField> result = new ArrayList<DWQueryField>();
        result.add(this.generateQueryFields(searchInfo));
        result.forEach(item -> condition.addFieldInfo(item.getName(), item.getOperator(), item.getValues()));
        if ("OR".equals(logic)) {
            condition.ORJoin();
        } else {
            condition.ANDJoin();
        }
    }

    public void dealVariables(DWQueryCondition condition, QueryConditionDTO searchInfo, String logic, List<Map<String, Object>> customizedConditionValues) {
        List<Object> result = new ArrayList<DWQueryField>();
        if ("equal".equals(searchInfo.getSearch_operator()) || "not_equal".equals(searchInfo.getSearch_operator())) {
            if (CollectionUtils.isNotEmpty(searchInfo.getSearch_value())) {
                result.addAll(this.systemVariableUtil.getSystemVariableValue(searchInfo));
                result.addAll(this.generateQueryFieldsByCustomVariables(searchInfo, customizedConditionValues));
            }
        } else {
            result = this.generateQueryFieldsByCustomVariables(searchInfo, customizedConditionValues);
        }
        result.forEach(item -> condition.addFieldInfo(item.getName(), item.getOperator(), item.getValues()));
        if ("OR".equals(logic)) {
            condition.ORJoin();
        } else {
            condition.ANDJoin();
        }
    }

    public List<DWQueryField> generateQueryFieldsByCustomVariables(QueryConditionDTO searchInfo, List<Map<String, Object>> customizedConditionValues) {
        if (CollectionUtils.isNotEmpty(searchInfo.getSearch_value())) {
            List<?> searchValues = searchInfo.getSearch_value();
            if (CollectionUtils.isNotEmpty(customizedConditionValues)) {
                customizedConditionValues.get(0).forEach((key, val) -> {
                    if (searchValues.contains(key)) {
                        if (val instanceof List) {
                            searchInfo.setSearch_value((List)val);
                        } else {
                            searchInfo.setSearch_value(Arrays.asList(val));
                        }
                    }
                });
            }
            return Arrays.asList(this.generateQueryFields(searchInfo));
        }
        return new ArrayList<DWQueryField>();
    }

    public DWQueryField generateQueryFields(QueryConditionDTO searchInfo) {
        DWQueryField dwQueryField = null;
        String searchField = DataViewFieldUtil.getQueryField(searchInfo);
        switch (searchInfo.getSearch_operator()) {
            case "equal": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.Equals, new Object[]{CollectionUtils.get(searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "not_equal": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.NotEquals, new Object[]{CollectionUtils.get(searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "greater_equal": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.GreaterThanOrEqualTo, new Object[]{CollectionUtils.get(searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "less_equal": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.LessThanOrEqualTo, new Object[]{CollectionUtils.get(searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "greater": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.GreaterThan, new Object[]{CollectionUtils.get(searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "less": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.LessThan, new Object[]{CollectionUtils.get(searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "like_r": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.Like, new Object[]{CollectionUtils.get(searchInfo.getSearch_value(), (int)0).toString().replace("%", "\\\\%") + "%"});
                break;
            }
            case "like": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.Like, new Object[]{"%" + CollectionUtils.get(searchInfo.getSearch_value(), (int)0).toString().replace("%", "\\\\%") + "%"});
                break;
            }
            case "l_like": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.Like, new Object[]{"%" + CollectionUtils.get(searchInfo.getSearch_value(), (int)0).toString().replace("%", "\\\\%")});
                break;
            }
            case "not_like": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.NotLike, new Object[]{"%" + CollectionUtils.get(searchInfo.getSearch_value(), (int)0).toString().replace("%", "\\\\%") + "%"});
                break;
            }
            case "exist": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.In, searchInfo.getSearch_value().toArray(new Object[1]));
                break;
            }
            case "not exist": {
                String[] fields = searchField.split("\\.");
                dwQueryField = new DWQueryField(fields[fields.length - 1], DWQueryValueOperator.NotIn, searchInfo.getSearch_value().toArray(new Object[1]));
                break;
            }
            case "between": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.Between, searchInfo.getSearch_value().toArray(new Object[1]));
                break;
            }
            default: {
                String message = String.format("operator '%s' is not supported", searchInfo.getSearch_operator());
                throw new IllegalArgumentException(message);
            }
        }
        return dwQueryField;
    }

    public <T> List<T> getPrintConditionData(DWQueryCondition queryCondition) {
        ArrayList whereCondition = new ArrayList();
        queryCondition.getItems().stream().forEach(whereRowCondition -> {
            DWQueryField b = (DWQueryField)whereRowCondition;
            StringBuilder whereString = new StringBuilder();
            whereString.append(b.getName()).append(" ").append(b.getOperator().getValue()).append(" ").append(Arrays.asList(b.getValues()));
            whereCondition.add(whereString.toString());
        });
        return whereCondition;
    }

    public DWQueryCondition addAlwaysNotEqual(DWQueryCondition queryCondition) {
        return queryCondition.addEqualInfo("1", (Object)"2");
    }
}

