/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.dao.DWQueryField;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.lcdp.modeldriven.constants.ModelDBConstants;
import com.digiwin.lcdp.modeldriven.dataview.utils.DataViewDataTimeUtil;
import java.util.ArrayList;
import java.util.List;

public class SearchFieldUtil {
    private SearchFieldUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static List<DWQueryField> generateDateToday(String searchField, String searchOperator) {
        ArrayList<DWQueryField> result = new ArrayList<DWQueryField>();
        switch (searchOperator) {
            case "equal": {
                DWQueryField equalQueryField = SearchFieldUtil.getDateTodayEqual(searchField);
                result.add(equalQueryField);
                break;
            }
            case "not_equal": {
                DWQueryField notEqualQueryField = SearchFieldUtil.getDateTodayNotEqual(searchField);
                result.add(notEqualQueryField);
                break;
            }
            default: {
                String errorMessage = SearchFieldUtil.getWrongMessage("{@SYSTEM_DATE_TODAY}", "equal", "not_equal");
                throw new IllegalArgumentException(errorMessage);
            }
        }
        return result;
    }

    public static List<DWQueryField> generateDateWeek(String searchField, String searchOperator) {
        ArrayList<DWQueryField> result = new ArrayList<DWQueryField>();
        String fieldNameForDateWeek = SearchFieldUtil.getFieldNameForYearMonthDay(searchField);
        switch (searchOperator) {
            case "equal": {
                DWQueryField equalQueryField = SearchFieldUtil.getDateWeekEqual(fieldNameForDateWeek);
                result.add(equalQueryField);
                break;
            }
            case "not_equal": {
                List<DWQueryField> notEqualsQueryField = SearchFieldUtil.getDateWeekNotEqual(fieldNameForDateWeek);
                result.add(notEqualsQueryField.get(0));
                result.add(notEqualsQueryField.get(1));
                break;
            }
            default: {
                String errorMessage = SearchFieldUtil.getWrongMessage("{@SYSTEM_DATE_WEEK}", "equal", "not_equal");
                throw new IllegalArgumentException(errorMessage);
            }
        }
        return result;
    }

    public static List<DWQueryField> generateDateMonth(String searchField, String searchOperator) {
        ArrayList<DWQueryField> result = new ArrayList<DWQueryField>();
        List<String> currentMonth = DataViewDataTimeUtil.getCurrentMonth();
        String fieldNameForMonth = SearchFieldUtil.getFieldNameForYearMonth(searchField);
        switch (searchOperator) {
            case "equal": {
                DWQueryField equalQueryField = new DWQueryField(fieldNameForMonth, DWQueryValueOperator.Equals, new Object[]{currentMonth});
                result.add(equalQueryField);
                break;
            }
            case "not_equal": {
                DWQueryField notEqualQueryField = new DWQueryField(fieldNameForMonth, DWQueryValueOperator.NotEquals, new Object[]{currentMonth});
                result.add(notEqualQueryField);
                break;
            }
            default: {
                String errorMessage = SearchFieldUtil.getWrongMessage("{@SYSTEM_DATE_MONTH}", "equal", "not_equal");
                throw new IllegalArgumentException(errorMessage);
            }
        }
        return result;
    }

    public static List<DWQueryField> generateDateIn7(String searchField, String searchOperator) {
        ArrayList<DWQueryField> result = new ArrayList<DWQueryField>();
        List<String> valueDateIn7 = DataViewDataTimeUtil.getLast7Days();
        switch (searchOperator) {
            case "equal": {
                DWQueryField equalQueryField = new DWQueryField(searchField, DWQueryValueOperator.Between, valueDateIn7.toArray(new Object[1]));
                result.add(equalQueryField);
                break;
            }
            case "not_equal": {
                DWQueryField lessQueryField = new DWQueryField(searchField, DWQueryValueOperator.LessThan, new Object[]{valueDateIn7.get(0)});
                DWQueryField greaterQueryField = new DWQueryField(searchField, DWQueryValueOperator.GreaterThan, new Object[]{valueDateIn7.get(1)});
                result.add(lessQueryField);
                result.add(greaterQueryField);
                break;
            }
            default: {
                String errorMessage = SearchFieldUtil.getWrongMessage("{@SYSTEM_DATE_IN_7}", "equal", "not_equal");
                throw new IllegalArgumentException(errorMessage);
            }
        }
        return result;
    }

    public static List<DWQueryField> generateTenantSid(String searchField, String searchOperator) {
        ArrayList<DWQueryField> result = new ArrayList<DWQueryField>();
        Object valueTenantSid = SearchFieldUtil.getTenantSid();
        String formatTenantSid = searchField;
        switch (searchOperator) {
            case "equal": {
                DWQueryField equalQueryField = new DWQueryField(formatTenantSid, DWQueryValueOperator.Equals, new Object[]{valueTenantSid});
                result.add(equalQueryField);
                break;
            }
            case "not_equal": {
                DWQueryField notEqualQueryField = new DWQueryField(formatTenantSid, DWQueryValueOperator.NotEquals, new Object[]{valueTenantSid});
                result.add(notEqualQueryField);
                break;
            }
            default: {
                String errorMessage = SearchFieldUtil.getWrongMessage("{@SYSTEM_TENANT_SID}", "equal", "not_equal");
                throw new IllegalArgumentException(errorMessage);
            }
        }
        return result;
    }

    public static List<DWQueryField> generateUserId(String searchField, String searchOperator) {
        ArrayList<DWQueryField> result = new ArrayList<DWQueryField>();
        Object valueUserId = SearchFieldUtil.getUserId();
        String formatUserId = searchField;
        switch (searchOperator) {
            case "equal": {
                DWQueryField equalQueryField = new DWQueryField(formatUserId, DWQueryValueOperator.Equals, new Object[]{valueUserId});
                result.add(equalQueryField);
                break;
            }
            case "not_equal": {
                DWQueryField notEqualQueryField = new DWQueryField(formatUserId, DWQueryValueOperator.NotEquals, new Object[]{valueUserId});
                result.add(notEqualQueryField);
                break;
            }
            default: {
                String errorMessage = SearchFieldUtil.getWrongMessage("{@SYSTEM_USER_ID}", "equal", "not_equal");
                throw new IllegalArgumentException(errorMessage);
            }
        }
        return result;
    }

    public static List<DWQueryField> generateEmpId(String searchField, String searchOperator, List<String> empIds, String tableName) {
        ArrayList<DWQueryField> result = new ArrayList<DWQueryField>();
        switch (searchOperator) {
            case "equal": {
                DWQueryField equalQueryField = new DWQueryField(searchField, DWQueryValueOperator.In, empIds.toArray(new Object[1]));
                result.add(equalQueryField);
                break;
            }
            case "not_equal": {
                String[] fields = searchField.split("\\.");
                DWQueryField notEqualQueryField = new DWQueryField(fields[fields.length - 1], DWQueryValueOperator.NotIn, empIds.toArray(new Object[1]));
                notEqualQueryField.setTableName(tableName);
                result.add(notEqualQueryField);
                break;
            }
            default: {
                String errorMessage = SearchFieldUtil.getWrongMessage("{@SYSTEM_EMPLOYEE_ID}", "equal", "not_equal");
                throw new IllegalArgumentException(errorMessage);
            }
        }
        return result;
    }

    public static List<DWQueryField> generateDeptId(String searchField, String searchOperator, Object[] deptIdObjs, String tableName) {
        ArrayList<DWQueryField> result = new ArrayList<DWQueryField>();
        switch (searchOperator) {
            case "equal": {
                DWQueryField equalQueryField = new DWQueryField(searchField, DWQueryValueOperator.In, deptIdObjs);
                result.add(equalQueryField);
                break;
            }
            case "not_equal": {
                String[] fields = searchField.split("\\.");
                DWQueryField notEqualQueryField = new DWQueryField(fields[fields.length - 1], DWQueryValueOperator.NotIn, deptIdObjs);
                notEqualQueryField.setTableName(tableName);
                result.add(notEqualQueryField);
                break;
            }
            default: {
                String errorMessage = SearchFieldUtil.getWrongMessage("{@SYSTEM_EMPLOYEE_DEPTID}", "equal", "not_equal");
                throw new IllegalArgumentException(errorMessage);
            }
        }
        return result;
    }

    public static List<DWQueryField> generateDeptIdAll(String searchField, String searchOperator, Object[] deptIdObjs, String tableName) {
        ArrayList<DWQueryField> result = new ArrayList<DWQueryField>();
        switch (searchOperator) {
            case "equal": {
                DWQueryField equalQueryField = new DWQueryField(searchField, DWQueryValueOperator.In, deptIdObjs);
                result.add(equalQueryField);
                break;
            }
            case "not_equal": {
                String[] fields = searchField.split("\\.");
                DWQueryField notEqualQueryField = new DWQueryField(fields[fields.length - 1], DWQueryValueOperator.NotIn, deptIdObjs);
                notEqualQueryField.setTableName(tableName);
                result.add(notEqualQueryField);
                break;
            }
            default: {
                String errorMessage = SearchFieldUtil.getWrongMessage("{@SYSTEM_EMPLOYEE_DEPTID_ALL}", "equal", "not_equal");
                throw new IllegalArgumentException(errorMessage);
            }
        }
        return result;
    }

    private static DWQueryField getDateTodayEqual(String searchField) {
        List<String> currentDate = DataViewDataTimeUtil.getCurrentDate();
        String fieldNameForEqual = SearchFieldUtil.getFieldNameForYearMonthDay(searchField);
        return new DWQueryField(fieldNameForEqual, DWQueryValueOperator.Equals, new Object[]{currentDate});
    }

    private static DWQueryField getDateTodayNotEqual(String searchField) {
        List<String> currentDate = DataViewDataTimeUtil.getCurrentDate();
        String fieldNameForEqual = SearchFieldUtil.getFieldNameForYearMonthDay(searchField);
        return new DWQueryField(fieldNameForEqual, DWQueryValueOperator.NotEquals, new Object[]{currentDate});
    }

    public static DWQueryField getDateWeekEqual(String searchField) {
        List<String> currentWeek = DataViewDataTimeUtil.getCurrentWeek();
        return new DWQueryField(searchField, DWQueryValueOperator.Between, currentWeek.toArray(new Object[1]));
    }

    public static List<DWQueryField> getDateWeekNotEqual(String searchField) {
        List<String> currentWeek = DataViewDataTimeUtil.getCurrentWeek();
        DWQueryField lessQueryField = new DWQueryField(searchField, DWQueryValueOperator.LessThan, new Object[]{currentWeek.get(0)});
        DWQueryField greaterQueryField = new DWQueryField(searchField, DWQueryValueOperator.GreaterThan, new Object[]{currentWeek.get(1)});
        ArrayList<DWQueryField> result = new ArrayList<DWQueryField>();
        result.add(lessQueryField);
        result.add(greaterQueryField);
        return result;
    }

    public static String getFieldNameForYearMonthDay(String searchField) {
        return String.format("DATE_FORMAT(%s, '%s')", searchField, "%Y-%m-%d");
    }

    public static String getFieldNameForYearMonth(String searchField) {
        return String.format("DATE_FORMAT(%s, '%s')", searchField, "%Y-%m");
    }

    private static String getWrongMessage(String variable, String operator1, String operator2) {
        return String.format("%s only support '%s' or '%s' operator", variable, operator1, operator2);
    }

    public static Object getTenantSid() {
        return DWServiceContext.getContext().getProfile().get(ModelDBConstants.IAM_PROFILE_TENANT_SID);
    }

    public static Object getUserId() {
        return DWServiceContext.getContext().getProfile().get("userId");
    }
}

