/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.config;

import com.digiwin.app.service.commons.config.DWServiceCommonsProvider;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.app.service.eai.DWEAIServiceDefinitionParser;
import com.digiwin.lcdp.modeldriven.config.ModelDrivenCommonsAutoConfiguration;
import com.digiwin.lcdp.modeldriven.config.condition.ModelDrivenEaiRegProdSrvCondition;
import com.digiwin.lcdp.modeldriven.config.condition.ModelDrivenEnabledCondition;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.eai.ModelDrivenStandardEaiHeaderUtil;
import com.digiwin.lcdp.modeldriven.enums.RegisterServiceTechTypeEnum;
import com.digiwin.lcdp.modeldriven.listener.ModelDrivenApplicationListener;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMappingProvider;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.pojo.TechEaiData;
import com.digiwin.lcdp.modeldriven.service.impl.ModelDrivenEAIMappingService;
import com.digiwin.lcdp.modeldriven.utils.service.ServiceMappingUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@Conditional(value={ModelDrivenEnabledCondition.class})
@AutoConfigureAfter(value={ModelDrivenCommonsAutoConfiguration.class})
public class ModelDrivenEAIRestfulUrlRegisterAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ModelDrivenEAIRestfulUrlRegisterAutoConfiguration.class);
    private static final String CLASS_LOG_TAG = "[" + ModelDrivenEAIRestfulUrlRegisterAutoConfiguration.class.getSimpleName() + "]";

    @Bean(name={"dw-modeldriven-service-commons-mapping-provider"})
    @DependsOn(value={"dw-service-commons-provider"})
    public DWServiceMappingProvider eaiMappingProvider(@Qualifier(value="dw-modeldriven-commons-eai-mapping-service") ModelDrivenEAIMappingService eaiMappingService, @Qualifier(value="DWEAIServiceParser") DWEAIServiceDefinitionParser dwEaiServiceDefinitionParser, @Qualifier(value="dw-service-commons-provider") DWServiceCommonsProvider serviceCommonsProvider, @Qualifier(value="DWEAIHeaderRepository") DWEAIHeaderRepository dwEAIHeaderRepository, @Qualifier(value="modeldriven-tech-eaiheader") TechEaiData<DWEAIHeader> techEaiData, ModelDrivenStandardEaiHeaderUtil modelDrivenStandardEaiHeaderUtil) throws Exception {
        DWServiceMappingProvider eaiMappingProvider = new DWServiceMappingProvider();
        BMProperties properties = BMProperties.getProperties();
        if (properties == null || !properties.isEnabled()) {
            List serviceMappings = (List)eaiMappingService.getEAIList();
            List<MappingModelInfo> mappingModelInfos = new ArrayList<MappingModelInfo>();
            if (CollectionUtils.isNotEmpty((Collection)serviceMappings)) {
                mappingModelInfos = (List)eaiMappingService.getChildrenTable();
            }
            ServiceMappingUtil.updateProd(serviceMappings, mappingModelInfos);
            List<DWEAIHeader> newHeaders = modelDrivenStandardEaiHeaderUtil.updateAndGetModelDrivenEaiHeaders(serviceMappings, mappingModelInfos);
            HashMap<String, List<DWEAIHeader>> techEaiHeaders = new HashMap<String, List<DWEAIHeader>>();
            techEaiHeaders.put(RegisterServiceTechTypeEnum.ESP.getTechType(), newHeaders);
            int serviceMappingSize = CollectionUtils.isNotEmpty((Collection)serviceMappings) ? serviceMappings.size() : 0;
            int newHeaderSize = CollectionUtils.isNotEmpty(newHeaders) ? newHeaders.size() : 0;
            log.info("{} serviceMapping({}): new DWEAIHeader({}) refreshed", new Object[]{CLASS_LOG_TAG, serviceMappingSize, newHeaderSize});
        }
        return eaiMappingProvider;
    }

    @Conditional(value={ModelDrivenEaiRegProdSrvCondition.class})
    @Bean
    public ModelDrivenApplicationListener buildModelDrivenApplicationListener() {
        return new ModelDrivenApplicationListener();
    }
}

