/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.aop;

import com.digiwin.app.service.DWServiceContext;
import java.lang.reflect.Method;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BMCrudInterceptor
implements MethodInterceptor {
    private static Logger logger = LoggerFactory.getLogger(BMCrudInterceptor.class);
    private static final String CLASS_LOG_TAG = "[" + BMCrudInterceptor.class.getSimpleName() + "]";
    private Object bmAdapter;

    public Object getBmAdapter() {
        return this.bmAdapter;
    }

    public void setBmAdapter(Object bmAdapter) {
        this.bmAdapter = bmAdapter;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String digiServiceName = DWServiceContext.getContext().getDigiServiceName();
        logger.debug("{} invoke eaiId({})", (Object)CLASS_LOG_TAG, (Object)digiServiceName);
        Object[] objects = invocation.getArguments();
        Map headers = (Map)objects[0];
        Map messageBody = (Map)objects[1];
        StopWatch stopWatch = StopWatch.createStarted();
        StringBuilder timeRecord = new StringBuilder();
        Object result = "";
        try {
            String messageBeforeInvoke = String.format("%s bmAdapter beforeInvoke(%d) ", CLASS_LOG_TAG, stopWatch.getTime());
            timeRecord.append(messageBeforeInvoke);
            logger.debug(messageBeforeInvoke);
            Method bmAdapterBeforeInvoke = this.bmAdapter.getClass().getDeclaredMethod("beforeInvoke", Map.class, Map.class);
            bmAdapterBeforeInvoke.invoke(this.bmAdapter, headers, messageBody);
            String messageAfterBeforeInvoke = String.format("%s after invocation.proceed()(%d) ", CLASS_LOG_TAG, stopWatch.getTime());
            timeRecord.append(messageAfterBeforeInvoke);
            result = invocation.proceed();
            String messageAfterInvoke = String.format("%s after invocation.proceed()(%d) ", CLASS_LOG_TAG, stopWatch.getTime());
            timeRecord.append(messageAfterInvoke);
        }
        catch (Throwable e) {
            try {
                timeRecord.append(String.format("%s after doException(%d) ", CLASS_LOG_TAG, stopWatch.getTime()));
                if (!stopWatch.isStopped()) {
                    stopWatch.stop();
                }
                throw e;
            }
            catch (Throwable throwable) {
                Method bmAdapterafterInvoke = this.bmAdapter.getClass().getDeclaredMethod("afterInvoke", Map.class, Object.class);
                bmAdapterafterInvoke.invoke(this.bmAdapter, headers, result);
                if (!stopWatch.isStopped()) {
                    stopWatch.stop();
                }
                logger.debug("{} finally eaiId({})", (Object)CLASS_LOG_TAG, (Object)digiServiceName);
                throw throwable;
            }
        }
        Method bmAdapterafterInvoke = this.bmAdapter.getClass().getDeclaredMethod("afterInvoke", Map.class, Object.class);
        bmAdapterafterInvoke.invoke(this.bmAdapter, headers, result);
        if (!stopWatch.isStopped()) {
            stopWatch.stop();
        }
        logger.debug("{} finally eaiId({})", (Object)CLASS_LOG_TAG, (Object)digiServiceName);
        return result;
    }
}

