/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.config;

import com.digiwin.app.merge.DWAppMergedInfo;
import com.digiwin.app.merge.DWSourceAppAwareUtils;
import com.digiwin.app.merge.DWSourceAppInfo;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.config.condition.ModelDrivenEnabledCondition;
import com.digiwin.lcdp.modeldriven.config.condition.ModelDrivenEnabledLoadBalanceCondition;
import com.digiwin.lcdp.modeldriven.customize.config.BMAutoConfiguration;
import com.digiwin.lcdp.modeldriven.customize.config.BMDataAutoConfiguration;
import com.digiwin.lcdp.modeldriven.customize.config.CustomizeAutoConfiguration;
import com.digiwin.lcdp.modeldriven.customize.config.condition.BMMixRoleCondition;
import com.digiwin.lcdp.modeldriven.customize.eai.BMDataEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.customize.eai.BMEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.customize.eai.BMMixEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.customize.model.BMDataEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.customize.model.BMEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.customize.registry.BMAbstractRegistryApplicationListener;
import com.digiwin.lcdp.modeldriven.customize.registry.BMMixRegistryApplicationListener;
import com.digiwin.lcdp.modeldriven.customize.service.impl.BMDataEAICrudService;
import com.digiwin.lcdp.modeldriven.eai.builder.EaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.eai.builder.ModelStandardEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.pojo.TechEaiData;
import com.digiwin.lcdp.modeldriven.utils.EaiHeaderByProdUtil;
import com.digiwin.loadbalance.esp.ESPLoadBalanceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@Import(value={BMAutoConfiguration.class, BMDataAutoConfiguration.class})
@Configuration
@Conditional(value={BMMixRoleCondition.class, ModelDrivenEnabledCondition.class})
@AutoConfigureAfter(value={CustomizeAutoConfiguration.class, BMAutoConfiguration.class, BMDataAutoConfiguration.class})
@ConditionalOnBean(value={CustomizeAutoConfiguration.class})
public class BMMixAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BMMixAutoConfiguration.class);
    private static final String CLASS_LOG_TAG = "[" + BMMixAutoConfiguration.class.getSimpleName() + "]";
    public static final String BEAN_CREATED_LOG_TAG = "{} bean:{} created!";

    @Bean(name={"modeldriven-customize-bmmix-bm-builder"})
    public BMEaiHeaderBuilder bmEaiHeaderBuilder() {
        log.info(BEAN_CREATED_LOG_TAG, (Object)CLASS_LOG_TAG, (Object)"modeldriven-customize-bmmix-bm-builder");
        return new BMEaiHeaderBuilder();
    }

    @Bean(name={"modeldriven-customize-bmmix-bmd-builder"})
    public BMDataEaiHeaderBuilder bmdEaiHeaderBuilder(@Qualifier(value="dw-modeldriven-crud-eai-builder") ModelStandardEaiHeaderBuilder modelStandardEAIHeaderBuilder, @Qualifier(value="lcdp-bmd-eai-method-repo") BMDataEaiMethodRepository bmdEaiMethodRepository) {
        log.info(BEAN_CREATED_LOG_TAG, (Object)CLASS_LOG_TAG, (Object)"modeldriven-customize-bmmix-bmd-builder");
        return new BMDataEaiHeaderBuilder();
    }

    @Primary
    @Bean(name={"modeldriven-customize-bmmix-builder"})
    public EaiHeaderBuilder bmMixEaiHeaderBuilder(@Qualifier(value="dw-modeldriven-crud-eai-builder") ModelStandardEaiHeaderBuilder modelStandardEAIHeaderBuilder, @Qualifier(value="lcdp-bm-eai-method-repo") BMEaiMethodRepository bmEaiMethodRepository, @Qualifier(value="lcdp-bmd-eai-method-repo") BMDataEaiMethodRepository bmdEaiMethodRepository) {
        log.info(BEAN_CREATED_LOG_TAG, (Object)CLASS_LOG_TAG, (Object)"modeldriven-customize-bmmix-builder");
        return new BMMixEaiHeaderBuilder();
    }

    @Bean
    @Conditional(value={ModelDrivenEnabledLoadBalanceCondition.class})
    @ConditionalOnProperty(name={"lcdp.bm.role"}, havingValue="mix")
    public BMAbstractRegistryApplicationListener<ApplicationEvent> buildBMNacosRegistionApplicationListener() {
        log.info(BEAN_CREATED_LOG_TAG, (Object)CLASS_LOG_TAG, (Object)"bmMixNacosRigestionApplicationListener");
        return new BMMixRegistryApplicationListener();
    }

    @Primary
    @Bean(name={"modeldriven-customize-genEaiHeaders"})
    @DependsOn(value={"modeldriven-tech-eaiheader"})
    @ConditionalOnProperty(name={"lcdp.bm.role"}, havingValue="mix")
    public Object autoGenBMEaiHeaders(@Qualifier(value="modeldriven-tech-eaiheader") TechEaiData<DWEAIHeader> targetTechEaiData, EaiHeaderByProdUtil eaiHeaderByProdUtil, BMDataEAICrudService bmDataEAICrudService, ESPLoadBalanceUtil espLoadBalanceUtil) {
        Map<Object, Object> prodTechEaiData = new HashMap();
        ArrayList<String> mergedAppNames = new ArrayList<String>();
        try {
            DWEAIResult bmCode = (DWEAIResult)bmDataEAICrudService.getBMDCode(null, null);
            List serviceMappings = bmCode.getParameter().getOrDefault("serviceMapping", new ArrayList());
            List mappingModelInfos = bmCode.getParameter().getOrDefault("mappingModelInfos", new ArrayList());
            if (CollectionUtils.isNotEmpty((Collection)serviceMappings)) {
                prodTechEaiData = eaiHeaderByProdUtil.genModelDrivenEaiHeadersByProd(serviceMappings, mappingModelInfos);
                DWAppMergedInfo appMergedInfo = DWSourceAppAwareUtils.getAppMergedInfo();
                DWSourceAppInfo targetAppInfo = appMergedInfo.getTargetAppInfo();
                if (targetAppInfo != null) {
                    mergedAppNames.add(targetAppInfo.getAppId());
                }
                List mergedSourceInfo = appMergedInfo.getSourceAppList();
                mergedSourceInfo.stream().forEach(dwSourceAppInfo -> mergedAppNames.add(dwSourceAppInfo.getAppId()));
            }
        }
        catch (Exception e) {
            String errorRootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
            log.error("{} >>> get codes failed, cause:{}", (Object)CLASS_LOG_TAG, (Object)errorRootCauseMessage);
        }
        return prodTechEaiData;
    }
}

