/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.handler;

import com.digiwin.app.eai.exception.DWEaiException;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.lcdp.modeldriven.customize.handler.BMAdapterCustomizeHandler;
import com.digiwin.lcdp.modeldriven.utils.json.ModelDrivenFastjsonUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BMAdapterDefaultCustomizeHandler
implements BMAdapterCustomizeHandler {
    private static final Logger log = LoggerFactory.getLogger(BMAdapterDefaultCustomizeHandler.class);
    private static final String CLASS_LOG_TAG = "[" + BMAdapterDefaultCustomizeHandler.class.getSimpleName() + "]";

    @Override
    public Object processMessageBody(Object messageBody) {
        Object returnValue;
        if (messageBody instanceof Map) {
            String orgString = ModelDrivenFastjsonUtil.toJson(messageBody);
            returnValue = ModelDrivenFastjsonUtil.fromJson(orgString, Map.class);
            log.debug("{} convertMessageBody JSON.parseObject( map to Map", (Object)CLASS_LOG_TAG);
        } else if (messageBody instanceof String) {
            returnValue = ModelDrivenFastjsonUtil.fromJson((String)messageBody, HashMap.class);
            log.debug("{} convertMessageBody JSON.parseObject(String to Map", (Object)CLASS_LOG_TAG);
        } else {
            returnValue = messageBody;
            log.debug("{} do nothing", (Object)CLASS_LOG_TAG);
        }
        return returnValue;
    }

    @Override
    public Object processBMDataResult(String responseString) throws DWEaiException {
        log.debug("{} processBMDataResult. JSON.parseObject(String to DWEAIResult", (Object)CLASS_LOG_TAG);
        Map stdData = (Map)ModelDrivenFastjsonUtil.fromJson(responseString, Map.class).get("std_data");
        Map execution = (Map)stdData.get("execution");
        String code = MapUtils.getString((Map)execution, (Object)"code", (String)"");
        String description = MapUtils.getString((Map)execution, (Object)"description", (String)"");
        if (!code.equals("0")) {
            DWEaiException dwEaiException = new DWEaiException(code, execution.get("message").toString());
            dwEaiException.setStacktrace(execution.get("stacktrace").toString());
            dwEaiException.setDescription(description);
            throw dwEaiException;
        }
        String sqlCode = MapUtils.getString((Map)execution, (Object)"sql_code", (String)"");
        Map parameter = (Map)stdData.get("parameter");
        return new DWEAIResult(code, sqlCode, description, parameter);
    }
}

