/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.permission;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.data.permission.DWRowPermissionElement;
import com.digiwin.data.permission.DWRowPermissionElementDeserializer;
import com.digiwin.data.permission.DWUserPermission;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.ServiceModel;
import com.digiwin.lcdp.modeldriven.permission.service.ModelDataPermissionIAMService;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelDataPermissionProcessor {
    private static final Logger log = LoggerFactory.getLogger(ModelDataPermissionProcessor.class);
    private static final String CLASS_LOG_TAG = "[" + ModelDataPermissionProcessor.class.getSimpleName() + "]";
    private static Gson customGson = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DWUserPermission invokeDataPermission(ServiceModel serviceModel) throws Exception {
        Map serviceModelParams = serviceModel.getParams();
        DWUserPermission returnValue = new DWUserPermission();
        Gson gson = ModelDataPermissionProcessor.getCustomGson();
        boolean selfTag = serviceModelParams.getOrDefault("self", true);
        try {
            log.debug("{}[invokeDataPermission] serviceModelParams({}) selfTag({})", new Object[]{CLASS_LOG_TAG, serviceModelParams, selfTag});
            HttpResponseModel iamResponseModel = (HttpResponseModel)ModelDataPermissionIAMService.invoke(serviceModel);
            String iamResponseBody = iamResponseModel.getResponseBody();
            int iamResponseStatusCode = iamResponseModel.getHttpStatusCode();
            if (iamResponseStatusCode == 200) return (DWUserPermission)gson.fromJson(iamResponseBody, DWUserPermission.class);
            if (selfTag) {
                selfTag = false;
                serviceModelParams.put("self", selfTag);
                DWUserPermission responseObj = ModelDataPermissionProcessor.invokeDataPermission(serviceModel);
                if (responseObj instanceof DWUserPermission) {
                    return responseObj;
                }
                if (!(responseObj instanceof HttpResponseModel)) return returnValue;
                HttpResponseModel iamResponseModelSelfFalse = (HttpResponseModel)responseObj;
                String iamResponseBodySelfFalse = iamResponseModelSelfFalse.getResponseBody();
                int iamResponseStatusCodeSelfFalse = iamResponseModelSelfFalse.getHttpStatusCode();
                if (iamResponseStatusCodeSelfFalse == 200) return (DWUserPermission)gson.fromJson(iamResponseBodySelfFalse, DWUserPermission.class);
                String errorMessage = String.format(ResourceBundleUtils.getString("lcdp.modeldriven.permission.data.failed"), iamResponseStatusCodeSelfFalse, iamResponseBodySelfFalse);
                log.warn("{}[invokeDataPermission] failed (self={}), cause:{}", new Object[]{CLASS_LOG_TAG, selfTag, errorMessage});
                throw new DWException(errorMessage);
            }
            String errorMessage = String.format(ResourceBundleUtils.getString("lcdp.modeldriven.permission.data.failed"), iamResponseStatusCode, iamResponseBody);
            log.warn("{}[invokeDataPermission] failed (self={}), cause:{}", new Object[]{CLASS_LOG_TAG, selfTag, errorMessage});
            throw new DWException(errorMessage);
        }
        catch (Exception e) {
            log.warn("{}[invokeDataPermission] serviceModelParams({}) selfTag({}) exception:{}", new Object[]{CLASS_LOG_TAG, serviceModelParams, selfTag, ExceptionUtils.getMessage((Throwable)e)});
            if (selfTag) {
                return ModelDataPermissionProcessor.getPublicUserPermission(serviceModel, serviceModelParams);
            }
            log.warn("{}[invokeDataPermission] failed(self={}) in Exception, cause:{}", new Object[]{CLASS_LOG_TAG, selfTag, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            throw e;
        }
    }

    private static DWUserPermission getPublicUserPermission(ServiceModel serviceModel, Map<String, Object> serviceModelParams) throws Exception {
        DWUserPermission returnValue = new DWUserPermission();
        Gson gson = ModelDataPermissionProcessor.getCustomGson();
        serviceModelParams.put("self", false);
        DWUserPermission responseObj = ModelDataPermissionProcessor.invokeDataPermission(serviceModel);
        if (responseObj instanceof DWUserPermission) {
            return responseObj;
        }
        HttpResponseModel iamResponseModelSelfFalse = (HttpResponseModel)responseObj;
        String iamResponseBodySelfFalse = iamResponseModelSelfFalse.getResponseBody();
        int iamResponseStatusCodeSelfFalse = iamResponseModelSelfFalse.getHttpStatusCode();
        if (iamResponseStatusCodeSelfFalse != 200) {
            String errorMessage = String.format(ResourceBundleUtils.getString("lcdp.modeldriven.permission.data.failed"), iamResponseStatusCodeSelfFalse, iamResponseBodySelfFalse);
            log.warn("{}[getSelfUserPermission] failed(self=false) in Exception, cause:{}", (Object)CLASS_LOG_TAG, (Object)errorMessage);
            throw new DWException(errorMessage);
        }
        returnValue = (DWUserPermission)gson.fromJson(iamResponseBodySelfFalse, DWUserPermission.class);
        return returnValue;
    }

    public static synchronized Gson getCustomGson() {
        if (customGson == null) {
            GsonBuilder builder = new GsonBuilder().serializeNulls();
            builder.registerTypeAdapter(DWRowPermissionElement.class, (Object)new DWRowPermissionElementDeserializer());
            customGson = builder.create();
        }
        return customGson;
    }
}

