/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.permission;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.data.DWDataPermissionOption;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.data.permission.DWUserPermission;
import com.digiwin.data.service.DWDataPermission;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import com.digiwin.lcdp.modeldriven.permission.ModelDataPermissionProcessor;
import com.digiwin.lcdp.modeldriven.permission.service.ModelDataPermissionIAMService;
import com.digiwin.lcdp.modeldriven.permission.utils.ModelDataPermissionUtil;
import com.digiwin.lcdp.modeldriven.utils.ApTokenUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenContextExtraUtil;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;

public class ModelDrivenDataPermission
extends DWDataPermission {
    public static String getAppId() {
        return DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-middleware-appid", DWDataPermission.getAppId());
    }

    public static DWUserPermission getDataPermission(String moduleId, String actionId, String sysId) throws Exception {
        Map profile = DWServiceContext.getContext().getProfile();
        Object userId = profile.get("userId");
        String tenantId = ApTokenUtil.getIAMTenantId();
        String integrationToken = ModelDataPermissionIAMService.getIntegrationToken(tenantId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sysId", sysId);
        params.put("userId", userId);
        params.put("moduleId", moduleId);
        params.put("actionId", actionId);
        params.put("self", true);
        ServiceModel serviceModel = new ServiceModel();
        serviceModel.setInvokeURL("/api/iam/v2/permission/data");
        serviceModel.setParams(params);
        serviceModel.setToken(integrationToken);
        return ModelDataPermissionProcessor.invokeDataPermission(serviceModel);
    }

    public static DWUserPermission getDataPermission(String moduleId, String actionId) throws Exception {
        String dataPermissionKey = ModelDrivenContextExtraUtil.getDataPermissionKey(actionId, moduleId);
        Object cachedDataPermission = ModelDrivenContextExtraUtil.getCachedDataPermissionCache(dataPermissionKey);
        if (cachedDataPermission != null && cachedDataPermission instanceof DWUserPermission) {
            return (DWUserPermission)cachedDataPermission;
        }
        Map profile = DWServiceContext.getContext().getProfile();
        Object userId = profile.get("userId");
        String appId = ModelDataPermissionUtil.getSysId();
        String userToken = DWServiceContext.getContext().getToken();
        HashMap params = new HashMap();
        params.put("userId", userId);
        params.put("sysId", appId);
        params.put("moduleId", moduleId);
        params.put("actionId", actionId);
        ServiceModel serviceModel = new ServiceModel();
        serviceModel.setInvokeURL("/api/iam/v2/permission/data");
        serviceModel.setParams(params);
        serviceModel.setToken(userToken);
        HttpResponseModel iamResponseModel = (HttpResponseModel)IAMService.invoke((ServiceModel)serviceModel);
        String iamResponseBody = iamResponseModel.getResponseBody();
        int iamResponseStatusCode = iamResponseModel.getHttpStatusCode();
        if (iamResponseStatusCode != 200) {
            String errorMessage = "IAM\u56de\u50b3\u72c0\u614b\u78bc\u70ba:%s, \u932f\u8aa4\u8a0a\u606f\u70ba:%s";
            throw new DWException(String.format(errorMessage, iamResponseStatusCode, errorMessage));
        }
        Gson gson = ModelDataPermissionProcessor.getCustomGson();
        return (DWUserPermission)gson.fromJson(iamResponseBody, DWUserPermission.class);
    }

    public static DWUserPermission getDataPermission(IDWSQLOptions options) throws Exception {
        DWUserPermission result = null;
        String api = null;
        String moduleId = null;
        String actionId = null;
        if (options instanceof DWDataPermissionOption) {
            DWDataPermissionOption dataPermOption = (DWDataPermissionOption)options;
            api = dataPermOption.getApi();
            moduleId = dataPermOption.getModuleId();
            actionId = dataPermOption.getActionId();
        } else {
            DWServiceContext serviceContext = DWServiceContext.getContext();
            Map requestHeader = serviceContext.getRequestHeader();
            if (requestHeader.containsKey("moduleId")) {
                moduleId = requestHeader.get("moduleId").toString();
            }
            if (requestHeader.containsKey("actionId")) {
                actionId = requestHeader.get("actionId").toString();
            }
            if (serviceContext.getAllowCrossTenant()) {
                api = serviceContext.getRequestURI();
            }
        }
        if (api != null) {
            if (api.startsWith("/")) {
                api = api.substring(1);
            }
            result = (DWUserPermission)DWDataPermission.getDataPermission((String)api);
        } else if (actionId != null && moduleId != null) {
            result = ModelDrivenDataPermission.getDataPermission(moduleId, actionId);
        }
        return result;
    }
}

