/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.container.DWMethod;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.enums.ModelApiTypeEnum;
import com.digiwin.lcdp.modeldriven.pojo.BindApi;
import com.digiwin.lcdp.modeldriven.utils.ApiNameUtil;
import com.digiwin.lcdp.modeldriven.utils.ApiTypeBMUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiTypeUtil {
    private static final Logger logger = LoggerFactory.getLogger(ApiTypeUtil.class);
    private static final String CLASS_LOG_TAG = "[" + ApiTypeUtil.class.getSimpleName() + "]";

    private ApiTypeUtil() {
    }

    public static String getApiType(BMCode bmCode, String digiServiceName) {
        String apiType = "";
        if (!Objects.isNull(bmCode)) {
            apiType = bmCode.getApiType();
        }
        if (StringUtils.isBlank((CharSequence)apiType)) {
            apiType = ApiNameUtil.getServiceNameType(digiServiceName);
            logger.warn("{}[getApiType] get ApiType({}) by serviceName({}}), bmCode({})", new Object[]{CLASS_LOG_TAG, apiType, digiServiceName, bmCode});
        }
        return apiType;
    }

    public static String getStdApiType(DWEAIHeader eaiHeader, String postfix) {
        String serviceType = null;
        String realServiceName = eaiHeader.getServiceType().getSimpleName();
        DWMethod dwMethod = eaiHeader.getMappingMethod();
        String methodName = dwMethod.getMethodName();
        String hitStyle = "";
        if ("IModelDrivenEAICrudService".equals(realServiceName)) {
            hitStyle = "IModelDrivenEAICrudService";
            serviceType = ApiTypeUtil.getStdApiType(methodName);
        } else if ("IBMEAICrudService".equals(realServiceName)) {
            hitStyle = "IBMEAICrudService";
            serviceType = ApiTypeBMUtil.getStdApiType(methodName, postfix);
        }
        logger.debug("{} apiType:{} hitStyle:{}", new Object[]{CLASS_LOG_TAG, serviceType, hitStyle});
        return serviceType;
    }

    public static String getApiType(DWEAIHeader eaiHeader, List<BindApi> bindApiConfigListConfig) {
        String serviceType = null;
        Optional<BindApi> optBindApi = bindApiConfigListConfig.stream().filter(bindApi -> bindApi.getApiName().equals(eaiHeader.getEAIServiceId())).findFirst();
        if (optBindApi.isPresent()) {
            serviceType = optBindApi.get().getApiType();
        }
        return serviceType;
    }

    public static String getApiTypeWithBindApiConfig(DWEAIHeader eaiHeader, List<BindApi> bindApiConfigListConfig, boolean hasBindApiList) {
        String apiType = hasBindApiList ? ApiTypeUtil.getApiType(eaiHeader, bindApiConfigListConfig) : ApiTypeBMUtil.getApiTypeInBMBusinessLayer(eaiHeader);
        return apiType;
    }

    public static String getStdApiType(String methodName) {
        String serviceType = null;
        switch (methodName) {
            case "get": {
                serviceType = ModelApiTypeEnum.DETAIL.getApiTypeName();
                break;
            }
            case "getList": {
                serviceType = ModelApiTypeEnum.LIST.getApiTypeName();
                break;
            }
            case "post": {
                serviceType = ModelApiTypeEnum.CREATE.getApiTypeName();
                break;
            }
            case "put": {
                serviceType = ModelApiTypeEnum.UPDATE.getApiTypeName();
                break;
            }
            case "delete": {
                serviceType = ModelApiTypeEnum.DELETE.getApiTypeName();
                break;
            }
            case "putValid": {
                serviceType = ModelApiTypeEnum.VALID.getApiTypeName();
                break;
            }
            case "putInvalid": {
                serviceType = ModelApiTypeEnum.INVALID.getApiTypeName();
                break;
            }
        }
        logger.debug("{} apiType:{} hitStyle:{}", new Object[]{CLASS_LOG_TAG, serviceType, "IModelDrivenEAICrudService"});
        return serviceType;
    }
}

