/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils.runtime;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWOnColumn;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryJoinRelation;
import com.digiwin.app.dao.DWQueryJoinTable;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.enums.ModelFieldRelationTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelApiField;
import com.digiwin.lcdp.modeldriven.model.ModelFieldDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.utils.DataEntryDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ParamValidateUtil;
import com.digiwin.lcdp.modeldriven.utils.QueryConditionUtils;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ModelSubDataQueryUtil {
    private static final Logger logger = LoggerFactory.getLogger(ModelSubDataQueryUtil.class);
    private static final String CLASS_LOG_TAG = "[" + ModelSubDataQueryUtil.class.getSimpleName() + "]";
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;
    @Autowired
    QueryConditionUtils queryConditionUtils;

    public List<Map<String, Object>> getFastChildrenQueryByCollectionQuoteRelation(String parentTableName, List<Map<String, Object>> parentRows, Map<String, Object> collectionQuoteRelations, ModelSchemaDTO modelSchemaDTO, Map<String, List<ModelApiField>> tileApiConfig) {
        if (CollectionUtils.isEmpty(parentRows)) {
            return parentRows;
        }
        Set<String> subTables = collectionQuoteRelations.keySet();
        Map<String, Object> firstRow = parentRows.get(0);
        List existsFieldsInMasterRow = subTables.stream().filter(firstRow::containsKey).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(existsFieldsInMasterRow)) {
            String errorMessage = String.format(ResourceBundleUtils.getString("paramValidate.subDataMerge.parentDataHaveSubTableName"), StringUtils.join(existsFieldsInMasterRow, (String)","));
            throw new DWRuntimeException(errorMessage);
        }
        for (Map.Entry<String, Object> next : collectionQuoteRelations.entrySet()) {
            Map subRelation;
            ModelApiField subTableApiField;
            Optional<ModelApiField> subTableApiFieldConfig;
            String subTableName = next.getKey();
            logger.debug("{} query subTables({})", (Object)CLASS_LOG_TAG, (Object)subTableName);
            if (MapUtils.isNotEmpty(tileApiConfig) && (subTableApiFieldConfig = tileApiConfig.get(parentTableName).stream().filter(modelApiField -> {
                String[] split = modelApiField.getFullPath().split("\\.");
                int length = split.length;
                String field = split[length - 1];
                return field.equals(subTableName);
            }).findFirst()).isPresent() && !(subTableApiField = subTableApiFieldConfig.get()).getShow()) {
                logger.warn("{}[getFastChildrenQueryByCollectionQuoteRelation] table:{} ApiField's show is {}, ignored to return data", new Object[]{CLASS_LOG_TAG, subTableName, subTableApiField.getShow()});
                continue;
            }
            Optional<ModelSchemaDTO> optionalSubModelSchema = modelSchemaDTO.getChildren().stream().filter(schema -> schema.getName().equals(subTableName)).findFirst();
            if (!optionalSubModelSchema.isPresent()) continue;
            ModelSchemaDTO subModelSchemaDTO = optionalSubModelSchema.get();
            DWQueryInfo queryinfo = new DWQueryInfo();
            queryinfo.setTableName(subTableName);
            DWQueryCondition subTableQueryCondition = new DWQueryCondition();
            ArrayList tableAssociatedFields = new ArrayList();
            ArrayList conditions = new ArrayList();
            AtomicReference parentColOrQutFieldNamesOfChildTable = new AtomicReference();
            ArrayList initFieldNames = new ArrayList();
            parentColOrQutFieldNamesOfChildTable.set(initFieldNames);
            ((Map)collectionQuoteRelations.get(subTableName)).forEach((masterField, associatedFields) -> {
                if (!"#subRelation".equals(masterField)) {
                    ((List)parentColOrQutFieldNamesOfChildTable.get()).add(masterField);
                    List<Object> rowValues = parentRows.stream().map(masterRow -> masterRow.get(masterField)).collect(Collectors.toList());
                    Object[] inValues = rowValues.toArray(new Object[1]);
                    subTableQueryCondition.addFieldInfo(masterField, DWQueryValueOperator.In, inValues);
                    tableAssociatedFields.addAll((List)associatedFields);
                    conditions.add(new DWOnColumn(masterField, DWQueryValueOperator.Equals, masterField));
                }
            });
            if (CollectionUtils.isNotEmpty(tableAssociatedFields)) {
                queryinfo.addJoinTableSelectField(parentTableName, tableAssociatedFields.toArray(new String[1]));
            }
            this.dealQuoteRelation(queryinfo, subModelSchemaDTO);
            queryinfo.setJoinOnColumn(DWQueryJoinRelation.LeftJoin, new DWQueryJoinTable(parentTableName), conditions.toArray(new DWOnColumn[1]));
            queryinfo.setCondition(subTableQueryCondition);
            if (MapUtils.isNotEmpty(tileApiConfig) && CollectionUtils.isNotEmpty((Collection)tileApiConfig.get(subTableName))) {
                ParamValidateUtil.getSelectFieldsByApiConfig(tileApiConfig, subTableName, subModelSchemaDTO, queryinfo).forEach(xva$0 -> queryinfo.addSelectField(new String[]{xva$0}));
            } else {
                queryinfo.addSelectField(new String[]{subTableName + ".*"});
            }
            DWDataTable childrenResult = this.dao.select(queryinfo).getTable(subTableName);
            List<Map<String, Object>> subTableData = DataEntryDataUtil.convertFromJson(childrenResult);
            if (CollectionUtils.isNotEmpty(subTableData)) {
                List relationNames = (List)parentColOrQutFieldNamesOfChildTable.get();
                Map<String, List<Map>> childrenIndexAndData = subTableData.stream().collect(Collectors.groupingBy(childrenRow -> this.buildSearchIndex((Map<String, Object>)childrenRow, relationNames)));
                Map<String, Map> masterIndexAndData = parentRows.stream().collect(Collectors.toMap(masterRow -> this.buildSearchIndex((Map<String, Object>)masterRow, relationNames), masterRow -> masterRow, (existing, replacement) -> existing));
                childrenIndexAndData.forEach((searchIndex, childrenMatchedRows) -> {
                    Map matchedMasterRow = (Map)masterIndexAndData.get(searchIndex);
                    if (MapUtils.isNotEmpty((Map)matchedMasterRow)) {
                        List subDataOfMaster = matchedMasterRow.getOrDefault(subTableName, new ArrayList());
                        subDataOfMaster.addAll(childrenMatchedRows);
                        matchedMasterRow.put(subTableName, subDataOfMaster);
                        masterIndexAndData.remove(searchIndex);
                    }
                });
                masterIndexAndData.values().stream().forEach(retainParentRow -> retainParentRow.put(subTableName, new ArrayList()));
            } else {
                if (logger.isDebugEnabled()) {
                    List whereCondition = this.queryConditionUtils.getPrintConditionData(subTableQueryCondition);
                    logger.debug("{} {} add empty subTable({}) to parent by condition({})", new Object[]{CLASS_LOG_TAG, parentTableName, subTableName, whereCondition});
                }
                parentRows.stream().forEach(parentRow -> parentRow.put(subTableName, new ArrayList()));
            }
            if ((subRelation = (Map)((Map)collectionQuoteRelations.get(subTableName)).get("#subRelation")) == null) continue;
            this.getFastChildrenQueryByCollectionQuoteRelation(subTableName, subTableData, subRelation, subModelSchemaDTO, tileApiConfig);
        }
        return parentRows;
    }

    public Map<String, Object> generateChildernQueryByCollectionQuoteRelation(String masterTableName, Map<String, Object> masterTableRow, Map<String, Object> collectionQuoteRelations, ModelSchemaDTO modelSchemaDTO, Map<String, List<ModelApiField>> tileApiConfig) {
        for (Map.Entry<String, Object> next : collectionQuoteRelations.entrySet()) {
            ModelApiField subTableApiField;
            Optional<ModelApiField> subTableApiFieldConfig;
            String subTableName = next.getKey();
            logger.debug("{} query subTables({}) data", (Object)CLASS_LOG_TAG, (Object)subTableName);
            if (MapUtils.isNotEmpty(tileApiConfig) && (subTableApiFieldConfig = tileApiConfig.get(masterTableName).stream().filter(modelApiField -> {
                String[] split = modelApiField.getFullPath().split("\\.");
                int length = split.length;
                String field = split[length - 1];
                return field.equals(subTableName);
            }).findFirst()).isPresent() && !(subTableApiField = subTableApiFieldConfig.get()).getShow()) {
                logger.warn("{}[generateChildernQueryByCollectionQuoteRelation] table:{} ApiField's show is {}, ignored to return data", new Object[]{CLASS_LOG_TAG, subTableName, subTableApiField.getShow()});
                continue;
            }
            ModelSchemaDTO subModelSchemaDTO = modelSchemaDTO.getChildren().stream().filter(schema -> schema.getName().equals(subTableName)).findFirst().get();
            DWQueryInfo queryinfo = new DWQueryInfo();
            queryinfo.setTableName(subTableName);
            DWQueryCondition subTableQueryCondition = new DWQueryCondition();
            ArrayList tableAssociatedFields = new ArrayList();
            ArrayList conditions = new ArrayList();
            ((Map)collectionQuoteRelations.get(subTableName)).forEach((masterField, associatedFields) -> {
                if (!"#subRelation".equals(masterField)) {
                    subTableQueryCondition.addEqualInfo(masterField, masterTableRow.get(masterField));
                    tableAssociatedFields.addAll((List)associatedFields);
                    conditions.add(new DWOnColumn(masterField, DWQueryValueOperator.Equals, masterField));
                }
            });
            if (CollectionUtils.isNotEmpty(tableAssociatedFields)) {
                queryinfo.addJoinTableSelectField(masterTableName, tableAssociatedFields.toArray(new String[1]));
            }
            this.dealQuoteRelation(queryinfo, subModelSchemaDTO);
            queryinfo.setJoinOnColumn(DWQueryJoinRelation.LeftJoin, new DWQueryJoinTable(masterTableName), conditions.toArray(new DWOnColumn[1]));
            queryinfo.setCondition(subTableQueryCondition);
            if (MapUtils.isNotEmpty(tileApiConfig) && CollectionUtils.isNotEmpty((Collection)tileApiConfig.get(subTableName))) {
                ParamValidateUtil.getSelectFieldsByApiConfig(tileApiConfig, subTableName, subModelSchemaDTO, queryinfo).forEach(path -> queryinfo.addSelectField(new String[]{path}));
            } else {
                queryinfo.addSelectField(new String[]{subTableName + ".*"});
            }
            DWDataTable childrenResult = this.dao.select(queryinfo).getTable(subTableName);
            List<Map<String, Object>> dataList = DataEntryDataUtil.convertFromJson(childrenResult);
            masterTableRow.put(subTableName, dataList);
            Map subRelation = (Map)((Map)collectionQuoteRelations.get(subTableName)).get("#subRelation");
            if (subRelation == null) continue;
            dataList.forEach(childData -> this.generateChildernQueryByCollectionQuoteRelation(subTableName, (Map<String, Object>)childData, subRelation, subModelSchemaDTO, tileApiConfig));
        }
        return masterTableRow;
    }

    public void dealQuoteRelation(DWQueryInfo queryInfo, ModelSchemaDTO modelSchemaDTO) {
        List<ModelFieldDTO> modelFieldDTOs = modelSchemaDTO.getFields();
        if (CollectionUtils.isNotEmpty(modelFieldDTOs)) {
            List quoteQueryFields = modelFieldDTOs.stream().filter(modelField -> ModelFieldRelationTypeEnum.valueOf(modelField.getType()) == ModelFieldRelationTypeEnum.QUOTE_QUERY).collect(Collectors.toList());
            logger.debug("[dealQuoteRelation] quoteQueryFields size({}) in table({})", (Object)quoteQueryFields.size(), (Object)modelSchemaDTO.getName());
            if (CollectionUtils.isNotEmpty(quoteQueryFields)) {
                Map<String, String> tableAliasMap = ParamValidateUtil.generateJoinTableAlias(modelSchemaDTO);
                Map<String, List<ModelFieldDTO>> map = quoteQueryFields.stream().collect(Collectors.groupingBy(modelField -> modelField.getAssociatedInfo().getTableName()));
                for (Map.Entry<String, List<ModelFieldDTO>> next : map.entrySet()) {
                    String quoteTableName = next.getKey();
                    List<ModelFieldDTO> quoteFields = next.getValue();
                    ArrayList<DWOnColumn> conditions = new ArrayList<DWOnColumn>();
                    String quoteTableAlias = tableAliasMap.get(quoteTableName);
                    for (int i = 0; i < quoteFields.size(); ++i) {
                        ModelFieldDTO quoteQueryField = quoteFields.get(i);
                        String fieldId = quoteQueryField.getFieldId();
                        String quoteFieldId = quoteQueryField.getAssociatedInfo().getJoinField().getFieldId();
                        conditions.add(new DWOnColumn(quoteFieldId, DWQueryValueOperator.Equals, fieldId));
                        Map<String, Object> modelContextExtra = ModelDrivenContext.getContext().getExtraMap();
                        if (((Boolean)modelContextExtra.getOrDefault("hasApiConfigResponse", false)).booleanValue()) continue;
                        ArrayList selectFields = new ArrayList();
                        List<ModelFieldDTO> otherAssociatedFields = quoteQueryField.getAssociatedInfo().getAssociatedFields();
                        otherAssociatedFields.stream().filter(associatedField -> associatedField.isSelectedField()).forEach(associatedField -> selectFields.add(quoteTableAlias + "." + associatedField.getFieldId() + " AS " + associatedField.getAlias().getFieldId()));
                        queryInfo.addSelectField(selectFields.toArray(new String[selectFields.size()]));
                    }
                    queryInfo.setJoinOnColumn(DWQueryJoinRelation.LeftJoin, new DWQueryJoinTable(quoteTableName, quoteTableAlias), conditions.toArray(new DWOnColumn[conditions.size()]));
                }
            }
        }
    }

    public String buildSearchIndex(Map<String, Object> row, List<String> relationNames) {
        return relationNames.stream().map(name -> String.valueOf(row.getOrDefault(name, ""))).collect(Collectors.joining("_"));
    }
}

