/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils.thread;

import jodd.util.ThreadUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelDrivenThreadUtil {
    private static final Logger log = LoggerFactory.getLogger(ModelDrivenThreadUtil.class);
    private static final String CLASS_LOG_TAG = "[" + ModelDrivenThreadUtil.class.getSimpleName() + "]";

    private ModelDrivenThreadUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean sleepWithInterruptHandling(long millis) {
        try {
            ThreadUtil.sleep((long)millis);
            return true;
        }
        catch (Exception ex) {
            if (ex instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                log.warn("{} Thread was interrupted during sleep.", (Object)CLASS_LOG_TAG);
                return false;
            }
            log.error("{} Unexpected error during sleep: {}", (Object)CLASS_LOG_TAG, (Object)ex.getMessage());
            return false;
        }
    }
}

