-- 2023S7

update  dw_rdbms_fields set is_key = 'N' where table_name in ('dw_lcdp_model','dw_lcdp_model_draft')  and field_name = 'target_tenant_id';

update  dw_rdbms_fields set is_key = 'N' where table_name = 'dw_lcdp_model_info' and field_name = 'tenant_id';


ALTER TABLE `dw_lcdp_model`
	DROP PRIMARY KEY,
	ADD PRIMARY KEY (`tenantsid`, `app_id`, `code`) USING BTREE;

ALTER TABLE `dw_lcdp_model_draft`
	DROP PRIMARY KEY,
	ADD PRIMARY KEY (`tenantsid`, `app_id`, `code`) USING BTREE;

ALTER TABLE `dw_lcdp_model_info`
 DROP PRIMARY KEY,
 ADD PRIMARY KEY (`code`, `table_name`, `app_id`, `tenantsid`) USING BTREE;

ALTER TABLE `dw_lcdp_model_info`
 DROP INDEX `modelinfo_unqidx2`,
 ADD UNIQUE INDEX `modelinfo_unqidx2` (`code`, `table_name`) USING BTREE;

-- 2023S10

DROP TABLE IF EXISTS `dw_lcdp_model_draft`;

DELETE FROM `dw_rdbms_tables` where  table_name = 'dw_lcdp_model_draft';

DELETE FROM `dw_rdbms_fields` where  table_name = 'dw_lcdp_model_draft';

-- 2024S1 1.0.2.0+
ALTER TABLE `dw_service_mapping`
	ADD COLUMN `target_prod` VARCHAR(100) NULL DEFAULT NULL COMMENT '數據目標' COLLATE 'utf8mb4_bin';

INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_service_mapping', 99, 'target_prod', 'N', 'VARCHAR', 'N', 'target_prod', '0', NULL, 'N', 'N', '100', 'N');

-- 1.0.2.14
ALTER TABLE `dw_lcdp_model`
 DROP PRIMARY KEY,
 ADD PRIMARY KEY (`code`, `tenantsid`, `app_id`) USING BTREE;

-- 1.0.2.39
-- 1.0.2.64 自動補償
insert into dw_rdbms_tables (table_name, table_display_name, table_description, delete_constraint, hint_field) values('dw_lcdp_data_view', '模型驱动-数据视图', '模型驱动-数据视图', 'N', null);
insert into dw_rdbms_fields (table_name, seq, field_name, is_key, field_type, status_code, field_display_name, scale, default_value, nullable, is_version, size, is_auto_increment) values('dw_lcdp_data_view', 1, 'code', 'Y', 'VARCHAR', 'Y', '視圖code', '0', null, 'N', 'N', '50', 'N');
insert into dw_rdbms_fields (table_name, seq, field_name, is_key, field_type, status_code, field_display_name, scale, default_value, nullable, is_version, size, is_auto_increment) values('dw_lcdp_data_view', 2, 'application', 'Y', 'VARCHAR', 'Y', '应用Id', '0', null, 'N', 'N', '50', 'N');
insert into dw_rdbms_fields (table_name, seq, field_name, is_key, field_type, status_code, field_display_name, scale, default_value, nullable, is_version, size, is_auto_increment) values('dw_lcdp_data_view', 3, 'modelId', 'N', 'VARCHAR', 'Y', '模型code', '0', null, 'N', 'N', '50', 'N');
insert into dw_rdbms_fields (table_name, seq, field_name, is_key, field_type, status_code, field_display_name, scale, default_value, nullable, is_version, size, is_auto_increment) values('dw_lcdp_data_view', 4, 'dataView', 'N', 'LONGTEXT', 'Y', '視圖內容', '0', null, 'N', 'N', '2147483647', 'N');
insert into dw_rdbms_fields (table_name, seq, field_name, is_key, field_type, status_code, field_display_name, scale, default_value, nullable, is_version, size, is_auto_increment) values('dw_lcdp_data_view', 5, 'create_date', 'N', 'DATETIME', 'Y', '创建时间', '0', 'current_timestamp()', 'N', 'N', '19', 'N');
insert into dw_rdbms_fields (table_name, seq, field_name, is_key, field_type, status_code, field_display_name, scale, default_value, nullable, is_version, size, is_auto_increment) values('dw_lcdp_data_view', 6, 'create_by', 'N', 'VARCHAR', 'Y', '创建人', '0', null, 'N', 'N', '50', 'N');
insert into dw_rdbms_fields (table_name, seq, field_name, is_key, field_type, status_code, field_display_name, scale, default_value, nullable, is_version, size, is_auto_increment) values('dw_lcdp_data_view', 7, 'modified_date', 'N', 'DATETIME', 'Y', '更新时间', '0', 'NULL', 'Y', 'N', '19', 'N');
insert into dw_rdbms_fields (table_name, seq, field_name, is_key, field_type, status_code, field_display_name, scale, default_value, nullable, is_version, size, is_auto_increment) values('dw_lcdp_data_view', 8, 'modified_by', 'N', 'VARCHAR', 'Y', '更新人', '0', 'NULL', 'Y', 'N', '50', 'N');
CREATE TABLE `dw_lcdp_data_view` (
	`code` VARCHAR(100) NOT NULL COMMENT '視圖code' COLLATE 'utf8mb4_bin',
	`application` VARCHAR(50) NOT NULL COMMENT '应用Id' COLLATE 'utf8mb4_bin',
	`modelId` VARCHAR(50) NOT NULL COMMENT '模型code' COLLATE 'utf8mb4_bin',
	`dataView` LONGTEXT NOT NULL COMMENT '視圖內容' COLLATE 'utf8mb4_bin',
	`create_date` DATETIME NOT NULL DEFAULT current_timestamp() COMMENT '创建时间',
	`create_by` VARCHAR(50) NOT NULL COMMENT '创建人',
	`modified_date` DATETIME NULL DEFAULT NULL ON UPDATE current_timestamp() COMMENT '更新时间',
	`modified_by` VARCHAR(50) NULL DEFAULT NULL COMMENT '更新人',
	PRIMARY KEY (`code`, `application`) USING BTREE
)
COMMENT='模型驱动-数据视图'
COLLATE='utf8mb4_bin'
ENGINE=InnoDB
;

-- 1.0.2.43~1.0.2.47(1.0.2.48+ 啟動自動建立)
insert into dw_rdbms_tables (table_name, table_display_name, table_description, delete_constraint, hint_field) values('dw_lcdp_model_activity', '模型作业映射关系', '模型作业映射关系', 'N', null);
insert into dw_rdbms_fields (table_name, seq, field_name, is_key, field_type, status_code, field_display_name, scale, default_value, nullable, is_version, size, is_auto_increment) values('dw_lcdp_model_activity', 1, 'activity_id', 'Y', 'VARCHAR', 'Y', '作业id', '0', null, 'N', 'N', '100', 'N');
insert into dw_rdbms_fields (table_name, seq, field_name, is_key, field_type, status_code, field_display_name, scale, default_value, nullable, is_version, size, is_auto_increment) values('dw_lcdp_model_activity', 2, 'code', 'N', 'VARCHAR', 'Y', '模型code', '0', null, 'N', 'N', '50', 'N');
insert into dw_rdbms_fields (table_name, seq, field_name, is_key, field_type, status_code, field_display_name, scale, default_value, nullable, is_version, size, is_auto_increment) values('dw_lcdp_model_activity', 3, 'application', 'N', 'VARCHAR', 'Y', '应用code', '0', null, 'N', 'N', '50', 'N');
insert into dw_rdbms_fields (table_name, seq, field_name, is_key, field_type, status_code, field_display_name, scale, default_value, nullable, is_version, size, is_auto_increment) values('dw_lcdp_model_activity', 4, 'create_date', 'N', 'DATETIME', 'Y', null, '0', 'current_timestamp()', 'Y', 'N', '19', 'N');
insert into dw_rdbms_fields (table_name, seq, field_name, is_key, field_type, status_code, field_display_name, scale, default_value, nullable, is_version, size, is_auto_increment) values('dw_lcdp_model_activity', 5, 'create_by', 'N', 'VARCHAR', 'Y', null, '0', null, 'Y', 'N', '50', 'N');
insert into dw_rdbms_fields (table_name, seq, field_name, is_key, field_type, status_code, field_display_name, scale, default_value, nullable, is_version, size, is_auto_increment) values('dw_lcdp_model_activity', 6, 'modified_date', 'N', 'DATETIME', 'Y', null, '0', null, 'Y', 'N', '19', 'N');
insert into dw_rdbms_fields (table_name, seq, field_name, is_key, field_type, status_code, field_display_name, scale, default_value, nullable, is_version, size, is_auto_increment) values('dw_lcdp_model_activity', 7, 'modified_by', 'N', 'VARCHAR', 'Y', null, '0', null, 'Y', 'N', '50', 'N');
CREATE TABLE `dw_lcdp_model_activity` (
	`activity_id` VARCHAR(100) NOT NULL COMMENT '作业id' COLLATE 'utf8mb4_bin',
	`code` VARCHAR(50) NOT NULL COMMENT '模型code' COLLATE 'utf8mb4_bin',
	`application` VARCHAR(50) NOT NULL COMMENT '应用code' COLLATE 'utf8mb4_bin',
	`create_date` DATETIME NOT NULL DEFAULT current_timestamp() COMMENT '创建时间',
	`create_by` VARCHAR(50) NULL DEFAULT NULL COLLATE 'utf8mb4_bin',
    `modified_date` DATETIME NULL DEFAULT NULL ON UPDATE current_timestamp() COMMENT '更新时间',
	`modified_by` VARCHAR(50) NULL DEFAULT NULL COLLATE 'utf8mb4_bin',
	PRIMARY KEY (`activity_id`, `application`) USING BTREE
)
COMMENT='模型作业映射关系'
COLLATE='utf8mb4_bin'
ENGINE=InnoDB
;

-- 1.0.2.73 (啟動自動建立)
CREATE TABLE `dw_lcdp_model_extend` (
	`extend_model_code` VARCHAR(100) NOT NULL COMMENT '繼承模型ID' COLLATE 'utf8mb4_bin',
	`app_code` VARCHAR(100) NOT NULL COMMENT '模型所屬應用ID' COLLATE 'utf8mb4_bin',
	`code` VARCHAR(100) NOT NULL COMMENT '父模型ID' COLLATE 'utf8mb4_bin',
	`main_table_code` VARCHAR(100) NOT NULL COMMENT '來源主模型ID' COLLATE 'utf8mb4_bin',
	`app_id` VARCHAR(100) NOT NULL COMMENT '應用ID' COLLATE 'utf8mb4_bin',
	`tenantsid` BIGINT NOT NULL COMMENT '租户SID',
	`create_time` DATETIME NOT NULL DEFAULT (now()) COMMENT '創建時間',
	`create_user_sid` BIGINT NOT NULL COMMENT '創建人SID',
	`update_time` DATETIME NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '更新時間',
	`update_user_sid` BIGINT NULL DEFAULT NULL COMMENT '更新人SID',
	PRIMARY KEY (`extend_model_code`) USING BTREE,
	UNIQUE INDEX `modelextend_unqidx1` (`code`, `app_code`) USING BTREE,
	INDEX `modelextend_idx2` (`main_table_code`, `app_code`) USING BTREE
)
COMMENT='模型擴展表'
COLLATE='utf8mb4_bin'
ENGINE=InnoDB
;

INSERT INTO `dw_rdbms_tables` (`table_name`, `table_display_name`, `table_description`, `delete_constraint`, `hint_field`, `insert_default_value`, `update_default_value`) VALUES ('dw_lcdp_model_extend', '模型擴展表', '模型擴展表', 'N', NULL, NULL, NULL);

INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model_extend', 1, 'extend_model_code', 'Y', 'VARCHAR', 'N', '繼承模型ID', '0', NULL, 'N', 'N', '100', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model_extend', 2, 'app_code', 'N', 'VARCHAR', 'N', '模型所屬應用ID', '0', NULL, 'N', 'N', '100', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model_extend', 3, 'code', 'N', 'VARCHAR', 'N', '父模型ID', '0', NULL, 'N', 'N', '100', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model_extend', 4, 'main_table_code', 'N', 'VARCHAR', 'N', '來源主模型ID', '0', NULL, 'N', 'N', '100', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model_extend', 5, 'app_id', 'N', 'VARCHAR', 'N', '應用ID', '0', NULL, 'N', 'N', '100', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model_extend', 6, 'tenantsid', 'N', 'BIGINT', 'N', '租户SID', '0', NULL, 'N', 'N', '20', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model_extend', 7, 'create_time', 'N', 'DATETIME', 'N', '創建時間', '0', 'current_timestamp()', 'N', 'N', '19', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model_extend', 8, 'create_by', 'N', 'VARCHAR', 'N', '創建人', '0', NULL, 'N', 'N', '50', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model_extend', 9, 'update_time', 'N', 'DATETIME', 'N', '更新時間', '0', 'NULL', 'Y', 'N', '19', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model_extend', 10, 'update_user_sid', 'N', 'VARCHAR', 'N', '更新人', '0', 'NULL', 'Y', 'N', '50', 'N');
