/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.config;

import com.digiwin.app.autoconfigure.DWGsonNumberProcessorAutoConfiguration;
import com.digiwin.app.autoconfigure.SpringContextAutoConfiguration;
import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.lcdp.modeldriven.config.condition.ModelDrivenEnabledCondition;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.config.condition.BMDataNacosRegEspCondition;
import com.digiwin.lcdp.modeldriven.customize.utils.BMDataCrudUtils;
import com.digiwin.lcdp.modeldriven.customize.utils.BMRoleUtil;
import dap.framework.component.autoconfigure.DapJsonAutoConfiguration;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@Configuration
@Conditional(value={ModelDrivenEnabledCondition.class})
@AutoConfigureAfter(value={DWGsonNumberProcessorAutoConfiguration.class, DapJsonAutoConfiguration.class, SpringContextAutoConfiguration.class})
@AutoConfigureOrder(value=-2147483648)
public class CustomizeAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CustomizeAutoConfiguration.class);
    private static final String CLASS_LOG_TAG = "[" + CustomizeAutoConfiguration.class.getSimpleName() + "]";

    @Bean(name={"modeldriven-bm-properties"})
    @DependsOn(value={"dw-spring-context-utils"})
    @ConditionalOnMissingBean(value={BMProperties.class})
    public BMProperties getBMProperties(Environment env) {
        BMProperties properties = new BMProperties();
        String bmRole = BMRoleUtil.getBMRole(env);
        if (StringUtils.isNotBlank((CharSequence)bmRole)) {
            properties.setEnabled(true);
            properties.setRole(BMRole.valueOf(bmRole));
            String adapterInterceptorName = env.getProperty("lcdp.bm.crud.adapter");
            if (StringUtils.isNotBlank((CharSequence)adapterInterceptorName)) {
                properties.setBmCrudAdapter(adapterInterceptorName);
            }
            if (properties.getRole() == BMRole.bmd || properties.getRole() == BMRole.mix) {
                Map<String, Class<?>> bmdInterfs = BMDataCrudUtils.getInterfaceServices();
                properties.getBmdCrudInterfaceService().putAll(bmdInterfs);
                Map<String, DWServiceInfo> bmdImplets = BMDataCrudUtils.getImplementServices(bmdInterfs);
                properties.getBmdCrudImplementService().putAll(bmdImplets);
            }
        }
        boolean isBmdRegNacosToEsp = BMDataNacosRegEspCondition.isEnabled();
        properties.setBmdRegistryNacosToEsp(isBmdRegNacosToEsp);
        BMProperties.setProperties(properties);
        log.debug("{} bean:{}({}) created!", new Object[]{CLASS_LOG_TAG, "modeldriven-bm-properties", BMProperties.getProperties()});
        return properties;
    }
}

