/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.config.condition;

import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.utils.BMRoleUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class BMMixRoleCondition
implements Condition {
    private static final Logger log = LoggerFactory.getLogger(BMMixRoleCondition.class);

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        boolean roleResult = false;
        String bmRoleValue = BMRoleUtil.getBMRole(context.getEnvironment());
        if (StringUtils.isNotBlank((CharSequence)bmRoleValue) && BMRole.valueOf(bmRoleValue) == BMRole.mix) {
            roleResult = true;
        }
        log.info("[BMMixRoleCondition] condition={} ({}={})", new Object[]{roleResult, "lcdp.bm.role", bmRoleValue});
        return roleResult;
    }
}

