/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.registry;

import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.eai.utils.ModelDrivenESPUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;

public abstract class BMAbstractRegistryApplicationListener<T extends ApplicationEvent>
implements ApplicationListener<T> {
    private static final Logger log = LoggerFactory.getLogger(BMAbstractRegistryApplicationListener.class);
    private static final String CLASS_LOG_TAG = "[" + BMAbstractRegistryApplicationListener.class.getSimpleName() + "]";
    @Autowired
    @Qualifier(value="modeldriven-bm-properties")
    BMProperties bmProperties;

    protected BMAbstractRegistryApplicationListener() {
        ModelDrivenESPUtil.initEspSdkInvoker();
        log.info("{} init", (Object)CLASS_LOG_TAG);
    }

    public void onApplicationEvent(T event) {
        if (this.isAsync()) {
            this.handleEventAsync(event);
        } else {
            this.handleEventSync(event);
        }
    }

    protected boolean isAsync() {
        return true;
    }

    protected void handleEventSync(T event) {
        this.handleEvent(event);
    }

    @Async
    protected void handleEventAsync(T event) {
        this.handleEvent(event);
    }

    protected abstract void handleEvent(T var1);
}

