/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.event;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.lcdp.modeldriven.event.EaiServiceRegisterEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class EaiRegisterEventPublisher {
    private static final Logger _log = LoggerFactory.getLogger(EaiRegisterEventPublisher.class);
    private static final String CLASS_LOG_TAG = "[" + EaiRegisterEventPublisher.class.getSimpleName() + "]";
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    public void publishDataChangeEvent(EaiServiceRegisterEvent eaiServiceRegisterEvent) {
        _log.debug("{}[publishDataChangeEvent] enter publishDataChangeEvent", (Object)CLASS_LOG_TAG);
        Map<String, Object> extraInfo = eaiServiceRegisterEvent.getDataInfo().getExtraInfo();
        HashMap profile = new HashMap(DWServiceContext.getContext().getProfile());
        if (MapUtils.isNotEmpty(profile)) {
            eaiServiceRegisterEvent.getDataInfo().getExtraInfo().put("extra_profile", profile);
        }
        extraInfo.put("token", EaiRegisterEventPublisher.getToken());
        extraInfo.put("traceId", DWServiceContext.getContext().getTraceId());
        _log.debug("{}[publishDataChangeEvent] applicationEventPublisher.publishEvent ({})", (Object)CLASS_LOG_TAG, (Object)eaiServiceRegisterEvent);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)eaiServiceRegisterEvent);
    }

    public static String getToken() {
        String token = DWServiceContext.getContext().getToken();
        if (StringUtils.isNotBlank((CharSequence)token)) {
            return token;
        }
        return "";
    }
}

