/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.eventcenter;

import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.eai.DWEAIBuilder;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.entity.DWJsonEntity;
import com.digiwin.lcdp.modeldriven.eventcenter.config.EventCenterProperties;
import com.digiwin.lcdp.modeldriven.eventcenter.constant.EventCenterProtocolEnum;
import com.digiwin.lcdp.modeldriven.eventcenter.constant.EventCenterTriggerTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelEventMapping;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.EventCenterEventDTO;
import com.digiwin.lcdp.modeldriven.pojo.EventCenterEventHeaderDTO;
import com.digiwin.lcdp.modeldriven.service.impl.ModelDataEntryService;
import com.digiwin.lcdp.modeldriven.utils.DataEntryTokenUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.google.gson.Gson;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class EventCenterUtil {
    private static final Logger log = LoggerFactory.getLogger(EventCenterUtil.class);
    @Autowired
    DWHttpClient dwHttpClient;
    @Autowired
    @Qualifier(value="eventTaskExecutor")
    ThreadPoolTaskExecutor eventTaskExecutor;
    @Autowired
    EventCenterProperties eventCenterProperties;
    @Autowired
    ModelDataEntryService modelDataEntryService;

    public String getSourceId(String tableName, EventCenterTriggerTypeEnum opeartorType) {
        String sourceId = "";
        switch (opeartorType) {
            case CREATE: {
                sourceId = String.format("/%s/%s/%s", DataEntryTokenUtil.getCurrentAppId(), tableName, opeartorType.getValue());
                break;
            }
            case UPDATE: {
                sourceId = String.format("/%s/%s/%s", DataEntryTokenUtil.getCurrentAppId(), tableName, opeartorType.getValue());
                break;
            }
            case DELETE: {
                sourceId = String.format("/%s/%s/%s", DataEntryTokenUtil.getCurrentAppId(), tableName, opeartorType.getValue());
                break;
            }
            case VALID: {
                sourceId = String.format("/%s/%s/%s/%s", DataEntryTokenUtil.getCurrentAppId(), tableName, "manage_status", "Y");
                break;
            }
            case INVALID: {
                sourceId = String.format("/%s/%s/%s/%s", DataEntryTokenUtil.getCurrentAppId(), tableName, "manage_status", "V");
                break;
            }
        }
        return sourceId;
    }

    public String getTargetId(String sourceId, ModelSchemaDTO schema) {
        Optional<ModelEventMapping> modelEventMapping;
        List<ModelEventMapping> eventMappings = schema.getEventMappings();
        if (CollectionUtils.isNotEmpty(eventMappings) && (modelEventMapping = eventMappings.stream().filter(eventMapping -> sourceId.equalsIgnoreCase(eventMapping.getSourceId())).findFirst()).isPresent() && "Y".equalsIgnoreCase(modelEventMapping.get().getEventEnable())) {
            return modelEventMapping.get().getTargetId();
        }
        return null;
    }

    public EventCenterEventDTO buildEvent(String eventId, String appid, String tenantid, Object eventParams) throws Exception {
        EventCenterEventDTO eventCenterEventDTO = new EventCenterEventDTO();
        eventCenterEventDTO.setEventId(eventId);
        EventCenterEventHeaderDTO eventCenterEventHeaderDTO = new EventCenterEventHeaderDTO();
        eventCenterEventHeaderDTO.setAppId(appid);
        eventCenterEventHeaderDTO.setTenantid(tenantid);
        eventCenterEventHeaderDTO.setEventSendTime(new Date());
        eventCenterEventHeaderDTO.setTraceId(UUID.randomUUID().toString());
        HashMap initiator = new HashMap();
        Map profile = DWServiceContext.getContext().getProfile();
        initiator.put("initiatorId", profile.get("userId"));
        initiator.put("initiatorNo", profile.get("userSid"));
        initiator.put("initiatorName", profile.get("userName"));
        eventCenterEventHeaderDTO.setInitiator(initiator);
        eventCenterEventDTO.setEventHeader(eventCenterEventHeaderDTO);
        eventCenterEventDTO.setEventBody(eventParams);
        return eventCenterEventDTO;
    }

    public void callEventCenter(String eventId, String appid, String tenantid, Object eventParams, String token) throws Exception {
        EventCenterEventDTO dto = this.buildEvent(eventId, appid, tenantid, eventParams);
        EventCenterProtocolEnum serviceType = this.eventCenterProperties.getServiceType();
        this.eventTaskExecutor.execute(() -> {
            switch (serviceType) {
                case ESP: {
                    try {
                        this.invokeEsp(dto);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                case HTTP: {
                    try {
                        this.invokeHttp(dto, token);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }

    private void invokeEsp(EventCenterEventDTO dto) throws Exception {
        Gson gson = DWGsonProvider.getGson();
        new DWEAIBuilder("eventcenterprod", "event.trigger.process", (Map)gson.fromJson(gson.toJson((Object)dto), Map.class)).build().execute();
        log.info("[EventCenterUtil][{}] invokeEsp,  dataInfo={}", (Object)Thread.currentThread().getName(), (Object)dto.toString());
    }

    private void invokeHttp(EventCenterEventDTO dto, String token) throws Exception {
        try {
            if (this.eventCenterProperties == null || StringUtils.isBlank((CharSequence)this.eventCenterProperties.getUrl())) {
                throw new RuntimeException("event center Url can not be null");
            }
            String eventCenterUrl = this.eventCenterProperties.getUrl();
            HttpPost post = new HttpPost(eventCenterUrl);
            post.setHeader("token", token);
            post.setEntity((HttpEntity)new DWJsonEntity((Object)dto));
            EntityUtils.toString((HttpEntity)post.getEntity(), (Charset)StandardCharsets.UTF_8);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).build();
            post.setConfig(requestConfig);
            log.info("[EventCenterUtil][{}] invokeHttp,  dataInfo={}", (Object)Thread.currentThread().getName(), (Object)dto.toString());
            HttpResponse response = this.dwHttpClient.execute((HttpUriRequest)post, new DWRequestOption(false));
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                log.error(EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8));
            } else {
                log.debug("send successful response info :{}", (Object)EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            log.error("send event center event failed", (Throwable)e);
        }
    }

    public void handleEventCenter(DWDataRow modelInfos, EventCenterTriggerTypeEnum opeartorType, Map<String, Object> influncedDatas, List<Map<String, Object>> triggerKeys) throws Exception {
        String token = DWServiceContext.getContext().getToken();
        ModelSchemaDTO masterModelSchema = ModelSchemaUtil.parseModelSchema(modelInfos);
        String masterTableName = masterModelSchema.getName();
        String targetAppid = (String)modelInfos.get("app_id");
        String targetTenantid = (String)modelInfos.get("target_tenant_id");
        List influncedDatasObj = influncedDatas.get(masterTableName);
        log.debug("=====influncedDatas:{}", (Object)influncedDatasObj);
        if (influncedDatasObj instanceof List) {
            if (CollectionUtils.isNotEmpty((Collection)influncedDatasObj)) {
                influncedDatasObj = ((List)influncedDatasObj).stream().filter(influncedData -> triggerKeys.stream().anyMatch(keyMap -> keyMap.keySet().stream().allMatch(key -> {
                    Object dbValue = ((Map)influncedData).get(key);
                    Object paramValue = keyMap.get(key);
                    return dbValue.toString().equals(paramValue.toString());
                }))).collect(Collectors.toList());
                String sourceId = this.getSourceId(masterTableName, opeartorType);
                log.debug("======sourceId:{},=====influncedData:{}", (Object)sourceId, influncedDatasObj);
                String targetId = this.getTargetId(sourceId, masterModelSchema);
                log.debug("======targetId:{}", (Object)targetId);
                HashMap influncedDataParam = new HashMap();
                influncedDataParam.put(masterTableName, influncedDatasObj);
                this.callEventCenter(targetId, targetAppid, targetTenantid, influncedDataParam, token);
            }
        } else {
            List influncedDatasObjTmp = influncedDatasObj;
            boolean isManageStatus = triggerKeys.stream().anyMatch(keyMap -> keyMap.keySet().stream().allMatch(key -> {
                Object dbValue = ((Map)((Object)influncedDatasObjTmp)).get(key);
                Object paramValue = keyMap.get(key);
                return dbValue.toString().equals(paramValue.toString());
            }));
            if (!ObjectUtils.isEmpty((Object)influncedDatasObj) && isManageStatus) {
                String sourceId = this.getSourceId(masterTableName, opeartorType);
                log.debug("======sourceId:{},=====influncedDatasObj:{}", (Object)sourceId, influncedDatasObj);
                String targetId = this.getTargetId(sourceId, masterModelSchema);
                log.debug("======targetId:{}", (Object)targetId);
                HashMap influncedDataParam = new HashMap();
                ArrayList influncedDataLst = new ArrayList();
                influncedDataLst.add(influncedDatasObjTmp);
                influncedDataParam.put(masterTableName, influncedDataLst);
                if (StringUtils.isNotEmpty((CharSequence)targetId)) {
                    log.debug("======targetId:{}", (Object)targetId);
                    this.callEventCenter(targetId, targetAppid, targetTenantid, influncedDataParam, token);
                }
            }
        }
    }

    public void handleEventCenter(DWDataRow modelInfos, EventCenterTriggerTypeEnum opeartorType, Map<String, Object> influncedDatas) throws Exception {
        String token = DWServiceContext.getContext().getToken();
        ModelSchemaDTO masterModelSchema = ModelSchemaUtil.parseModelSchema(modelInfos);
        String masterTableName = masterModelSchema.getName();
        String targetAppid = (String)modelInfos.get("app_id");
        String targetTenantid = (String)modelInfos.get("target_tenant_id");
        ModelIndexDTO uniqueIndex = this.modelDataEntryService.getUniqueIndex(masterModelSchema, masterTableName);
        Object influncedDatasObj = influncedDatas.get(masterTableName);
        log.debug("=====influncedDatas:{}", influncedDatasObj);
        if (influncedDatasObj instanceof List) {
            if (CollectionUtils.isNotEmpty((Collection)((List)influncedDatasObj))) {
                String sourceId = this.getSourceId(masterTableName, opeartorType);
                log.debug("======sourceId:{},=====influncedData:{}", (Object)sourceId, influncedDatasObj);
                String targetId = this.getTargetId(sourceId, masterModelSchema);
                log.debug("======targetId:{}", (Object)targetId);
                HashMap<String, Object> influncedDataParam = new HashMap<String, Object>();
                influncedDataParam.put(masterTableName, influncedDatasObj);
                this.callEventCenter(targetId, targetAppid, targetTenantid, influncedDataParam, token);
            }
        } else if (!ObjectUtils.isEmpty((Object)influncedDatasObj)) {
            Object influncedDatasObjTmp = influncedDatasObj;
            String sourceId = this.getSourceId(masterTableName, opeartorType);
            log.debug("======sourceId:{},=====influncedDatasObj:{}", (Object)sourceId, influncedDatasObj);
            String targetId = this.getTargetId(sourceId, masterModelSchema);
            log.debug("======targetId:{}", (Object)targetId);
            HashMap influncedDataParam = new HashMap();
            ArrayList<Object> influncedDataLst = new ArrayList<Object>();
            influncedDataLst.add(influncedDatasObjTmp);
            influncedDataParam.put(masterTableName, influncedDataLst);
            if (StringUtils.isNotEmpty((CharSequence)targetId)) {
                log.debug("======targetId:{}", (Object)targetId);
                this.callEventCenter(targetId, targetAppid, targetTenantid, influncedDataParam, token);
            }
        }
    }
}

