/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.permission;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWPaginationQueryResult;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataRowCollection;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.data.permission.controller.DWDataPermissionSchemasParameters;
import com.digiwin.data.permission.controller.DWDataPermissionValuesParameters;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ModelDrivenPermissionMetadataProvider {
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;
    public static final String KEY_TOTAL = "total";
    public static final String KEY_ITEMS = "items";
    private static final String DATAENTRY = "DataEntry_";

    public String getSchema(DWDataPermissionSchemasParameters parameters) {
        String[] paths = parameters.getActionId().split("__");
        String modelCode = "";
        if (paths.length > 1) {
            modelCode = parameters.getActionId().split("__")[0];
            int dataEntryIndex = modelCode.indexOf(DATAENTRY);
            if (dataEntryIndex == -1) {
                throw new IllegalArgumentException(String.format("actionId format error: correct format is 'DataEntry_\u6a21\u578bcode__xxx', current actionId is '%s'", modelCode));
            }
            modelCode = modelCode.substring(DATAENTRY.length());
        } else {
            String actionId = parameters.getActionId();
            DWDataSetOperationOption option = new DWDataSetOperationOption();
            option.setTenantEnabled(false);
            option.setManagementFieldEnabled(false);
            DWQueryInfo info = new DWQueryInfo("dw_lcdp_model_activity");
            info.addEqualInfo("activity_id", (Object)actionId);
            DWDataSet dwDataSet = this.dao.select(info, option);
            DWDataTable table = dwDataSet.getTable("dw_lcdp_model_activity");
            DWDataRowCollection rows = table.getRows();
            if (rows.size() > 0) {
                modelCode = (String)rows.get(0).get("code");
            } else {
                throw new IllegalArgumentException(String.format("can't find modelCode by actionId: '%s'", actionId));
            }
        }
        ArrayList result = new ArrayList();
        DWQueryInfo queryInfo = new DWQueryInfo("dw_lcdp_model");
        queryInfo.addEqualInfo("code", (Object)modelCode);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        option.setManagementFieldEnabled(false);
        DWDataSet modelTables = this.dao.select(queryInfo, option);
        DWDataRowCollection rows = modelTables.getTable("dw_lcdp_model").getRows();
        DWDataRow row = null;
        if (rows == null || rows.size() <= 0) {
            throw new IllegalStateException(String.format("model '%s' is not existed", modelCode));
        }
        row = rows.get(0);
        ModelSchemaDTO model = ModelSchemaUtil.parseModelSchema(row);
        List iamTableFields = model.getFields().stream().map(meta -> {
            HashMap<String, String> tmp = new HashMap<String, String>();
            tmp.put("id", meta.getFieldId());
            tmp.put("name", meta.getFieldName());
            tmp.put("dataType", meta.getFieldType());
            return tmp;
        }).collect(Collectors.toList());
        HashMap<String, Object> schema = new HashMap<String, Object>();
        schema.put("id", model.getName());
        schema.put("name", model.getComment());
        schema.put("fields", iamTableFields);
        result.add(schema);
        return DWGsonProvider.getGson().toJson(result);
    }

    public String getValues(DWDataPermissionValuesParameters parameters) {
        int pageNum = parameters.getPageNum();
        int pageSize = parameters.getPageSize();
        String tableName = parameters.getTableName();
        String fieldName = parameters.getFieldName();
        DWPagableQueryInfo pageQueryInfo = new DWPagableQueryInfo();
        pageQueryInfo.setPageNumber(pageNum);
        pageQueryInfo.setPageSize(pageSize);
        pageQueryInfo.setTableName(tableName);
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        ArrayList items = new ArrayList();
        if (fieldName.equals("owner_emp_id") || fieldName.equals("create_by")) {
            HashMap<String, String> currentUserId = new HashMap<String, String>();
            currentUserId.put("id", "@currentUserId");
            currentUserId.put("name", "\u5f53\u524d\u7528\u6237");
            HashMap<String, String> currentEmpId = new HashMap<String, String>();
            currentEmpId.put("id", "@currentEmpId");
            currentEmpId.put("name", "\u5f53\u524d\u7528\u6237\u7ed1\u5b9a\u5458\u5de5id");
            HashMap<String, String> subordinateUserId = new HashMap<String, String>();
            subordinateUserId.put("id", "@subordinateUserId");
            subordinateUserId.put("name", "\u5f53\u524d\u7528\u6237\u7ed1\u5b9a\u5458\u5de5\u7684\u4e0b\u5c5e\u7528\u6237id");
            HashMap<String, String> subordinateEmpId = new HashMap<String, String>();
            subordinateEmpId.put("id", "@subordinateEmpId");
            subordinateEmpId.put("name", "\u5f53\u524d\u7528\u6237\u7ed1\u5b9a\u5458\u5de5\u7684\u4e0b\u5c5e\u5458\u5de5id");
            HashMap<String, String> subordinateSubUserId = new HashMap<String, String>();
            subordinateSubUserId.put("id", "@subordinateSubUserId");
            subordinateSubUserId.put("name", "\u5f53\u524d\u7528\u6237\u7ed1\u5b9a\u5458\u5de5\u7684\u4e0b\u5c5e\u7528\u6237id,\u5305\u62ec\u5b50\u4e0b\u5c5e");
            HashMap<String, String> subordinateSubEmpId = new HashMap<String, String>();
            subordinateSubEmpId.put("id", "@subordinateSubEmpId");
            subordinateSubEmpId.put("name", "\u5f53\u524d\u7528\u6237\u7ed1\u5b9a\u5458\u5de5\u7684\u4e0b\u5c5e\u5458\u5de5id,\u5305\u62ec\u5b50\u4e0b\u5c5e");
            items.add(currentUserId);
            items.add(currentEmpId);
            items.add(subordinateUserId);
            items.add(subordinateEmpId);
            items.add(subordinateSubUserId);
            items.add(subordinateSubEmpId);
            result.put(KEY_TOTAL, Integer.valueOf(items.size()));
            result.put(KEY_ITEMS, items);
        } else if (fieldName.equals("owner_dept_id")) {
            HashMap<String, String> currentDeptIds = new HashMap<String, String>();
            currentDeptIds.put("id", "@currentDeptIds");
            currentDeptIds.put("name", "\u5f53\u524d\u7528\u6237\u7ed1\u5b9a\u5458\u5de5\u6240\u5c5e\u90e8\u95e8");
            HashMap<String, String> currentDeptSubIds = new HashMap<String, String>();
            currentDeptSubIds.put("id", "@currentDeptSubIds");
            currentDeptSubIds.put("name", "\u5f53\u524d\u7528\u6237\u7ed1\u5b9a\u5458\u5de5\u6240\u5c5e\u90e8\u95e8\u53ca\u5176\u6240\u6709\u5b50\u90e8\u95e8");
            items.add(currentDeptIds);
            items.add(currentDeptSubIds);
            result.put(KEY_TOTAL, Integer.valueOf(items.size()));
            result.put(KEY_ITEMS, items);
        } else {
            pageQueryInfo.addSelectField(new String[]{String.format(" DISTINCT %s as id ,%s as name", fieldName, fieldName)});
            DWDataSetOperationOption option = new DWDataSetOperationOption();
            option.setTenantEnabled(false);
            option.setManagementFieldEnabled(false);
            DWPaginationQueryResult queryResult = this.dao.selectWithPage(pageQueryInfo, option);
            result.put(KEY_TOTAL, Long.valueOf(queryResult.getRowCount()));
            result.put(KEY_ITEMS, (Serializable)queryResult.getDataSet().getTable(tableName).getDataSet().getSourceMap().get(tableName));
        }
        return DWGsonProvider.getGson().toJson(result);
    }
}

