/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.permission.service;

import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.iam.DWIAMProperties;
import com.digiwin.iam.HttpRequestModel;
import com.digiwin.iam.HttpRequester;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMHttpRequester;
import com.digiwin.iam.ServiceModel;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ModelDrivenDataPermissionIAMHttpRequester {
    ModelDrivenDataPermissionIAMHttpRequester() {
    }

    public static Object submit(ServiceModel model) throws Exception {
        Map<String, String> requestHeader = ModelDrivenDataPermissionIAMHttpRequester.createRequestHeader(model);
        String requestBody = null;
        if (model.getParams() != null) {
            requestBody = IAMHttpRequester.createRequestBody((Object)model.getParams());
        } else if (model.getBody() != null) {
            requestBody = IAMHttpRequester.createRequestBody((Object)model.getBody());
        }
        HttpRequestModel requestModel = IAMHttpRequester.getHttpRequestModel();
        requestModel.setRequestBody(requestBody);
        requestModel.setRequestHeader(requestHeader);
        requestModel.setRequestMethod(model.getRequestMethod());
        requestModel.setHttpContext(model.getHttpContext());
        String iamUrl = IAMHttpRequester.getProperties().getUrl();
        requestModel.setUrl(iamUrl + model.getInvokeURL());
        HttpResponseModel responseModel = HttpRequester.submitRequest((HttpRequestModel)requestModel);
        int httpStatusCode = responseModel.getHttpStatusCode();
        if (httpStatusCode != 200) {
            throw IAMHttpRequester.handleHttpStatus((HttpRequestModel)requestModel, (HttpResponseModel)responseModel);
        }
        return responseModel;
    }

    public static Map<String, String> createRequestHeader(ServiceModel model) {
        Locale locale;
        HashMap<String, String> header = new HashMap<String, String>();
        DWIAMProperties properties = IAMHttpRequester.getProperties();
        header.put("Content-Type", properties.getContentType() + ";" + properties.getCharset());
        String iamApToken = DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-middleware-auth-app", "");
        header.put("digi-middleware-auth-app", iamApToken);
        if (properties.isIAMTokenMode()) {
            header.put("digi-middleware-auth-user", model.getToken());
        }
        if ((locale = DWResourceBundleUtils.getCurrentLocale()) != null) {
            header.put("Accept-Language", locale.toLanguageTag());
        }
        return header;
    }
}

