/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.permission.utils;

import com.digiwin.data.permission.DWUserPermission;
import com.digiwin.lcdp.modeldriven.permission.pojo.ModelDrivenDataPermissionIdData;
import com.digiwin.lcdp.modeldriven.permission.utils.ModelDrivenDataPermissionParamValidateUtil;
import com.digiwin.lcdp.modeldriven.report.model.SqlValueFields;
import com.digiwin.lcdp.modeldriven.service.impl.ModelDataEntryService;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.apache.commons.lang3.StringUtils;

public class ModelDrivenDataPermissionSqlParserUtil {
    public static String processDataPermissionSql(String sql, SqlValueFields sqlValueFields, ModelDataEntryService modelDataEntryService) throws Exception {
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        if (statement instanceof Select) {
            ModelDrivenDataPermissionIdData sqlData = ModelDrivenDataPermissionParamValidateUtil.validateSqlFields(sqlValueFields);
            DWUserPermission dataPermData = (DWUserPermission)modelDataEntryService.getTBBDataPermission(sqlData.appId, sqlData.moduleId, sqlData.actionId, sqlData.tenantId, sqlData.userId);
            PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
            FromItem fromItem = select.getFromItem();
            sql = fromItem instanceof Table ? ModelDrivenDataPermissionSqlParserUtil.getTableInfo(dataPermData, select) : ModelDrivenDataPermissionSqlParserUtil.getSubTableInfo(sql, fromItem, dataPermData, select);
        }
        return sql;
    }

    private static String getSubTableInfo(String sql, FromItem fromItem, DWUserPermission dataPermData, PlainSelect select) throws NoSuchFieldException, IllegalAccessException, JSQLParserException {
        while (fromItem instanceof SubSelect && ((SubSelect)fromItem).getSelectBody() != null) {
            SubSelect subSelect = (SubSelect)fromItem;
            PlainSelect ssubSelect = (PlainSelect)subSelect.getSelectBody();
            FromItem formItemOfSsubSelect = ssubSelect.getFromItem();
            if (formItemOfSsubSelect instanceof Table) {
                PlainSelect subPlanSelect = (PlainSelect)subSelect.getSelectBody();
                String rowConditionSql = ModelSqlGenerator.getUserRowPermissionConditionSql(dataPermData, subPlanSelect);
                if (!StringUtils.isNotEmpty((CharSequence)rowConditionSql)) break;
                sql = ModelDrivenDataPermissionSqlParserUtil.getSsubSelectSql(select, rowConditionSql, subPlanSelect);
                break;
            }
            if (!(formItemOfSsubSelect instanceof SubSelect)) continue;
            fromItem = ssubSelect.getFromItem();
        }
        return sql;
    }

    private static String getSsubSelectSql(PlainSelect plainSelect, String rowConditionSql, PlainSelect subPlainSelect) throws JSQLParserException {
        String newSql = "";
        Expression conditions = CCJSqlParserUtil.parseCondExpression((String)rowConditionSql);
        Expression where = subPlainSelect.getWhere();
        if (conditions != null) {
            if (where == null) {
                subPlainSelect.setWhere(conditions);
            } else {
                AndExpression expression = new AndExpression(where, conditions);
                subPlainSelect.setWhere((Expression)expression);
            }
            newSql = plainSelect.toString();
        }
        return newSql;
    }

    private static String getTableInfo(DWUserPermission dataPermData, PlainSelect plainSelect) throws NoSuchFieldException, IllegalAccessException, JSQLParserException {
        String newSql = "";
        String rowConditionSql = ModelSqlGenerator.getUserRowPermissionConditionSql(dataPermData, plainSelect);
        Expression conditions = CCJSqlParserUtil.parseCondExpression((String)rowConditionSql);
        Expression where = plainSelect.getWhere();
        if (conditions != null) {
            if (where == null) {
                plainSelect.setWhere(conditions);
            } else {
                AndExpression expression = new AndExpression(where, conditions);
                plainSelect.setWhere((Expression)expression);
            }
            newSql = plainSelect.toString();
        }
        return newSql;
    }
}

