/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.service.impl;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.dao.DWBatchCondition;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWOnColumn;
import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWPaginationQueryResult;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryJoinRelation;
import com.digiwin.app.dao.DWQueryJoinTable;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.dao.DWSQLExecutionResult;
import com.digiwin.app.data.DWDataPermissionOption;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.data.permission.DWRowPermissionDefaultMatchOption;
import com.digiwin.data.permission.DWRowPermissionElement;
import com.digiwin.data.permission.DWRowPermissionEmpty;
import com.digiwin.data.permission.DWRowPermissionMatchOption;
import com.digiwin.data.permission.DWUserPermission;
import com.digiwin.data.service.DWDataPermission;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.ModelFieldRelationTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelApiField;
import com.digiwin.lcdp.modeldriven.model.ModelAssociatedInfo;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelFieldDTO;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSwitchCfg;
import com.digiwin.lcdp.modeldriven.permission.ModelDrivenDataPermission;
import com.digiwin.lcdp.modeldriven.permission.utils.ModelDataPermissionUtil;
import com.digiwin.lcdp.modeldriven.pojo.QueryConditionDTO;
import com.digiwin.lcdp.modeldriven.utils.DataEntryDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenContextExtraUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ParamFilterUtil;
import com.digiwin.lcdp.modeldriven.utils.ParamValidateUtil;
import com.digiwin.lcdp.modeldriven.utils.QueryConditionUtils;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import com.digiwin.lcdp.modeldriven.utils.compare.SelectFieldCompareUtil;
import com.digiwin.lcdp.modeldriven.utils.json.ModelDrivenJacksonUtil;
import com.digiwin.lcdp.modeldriven.utils.runtime.ModelDrivenParameterParserUtil;
import com.digiwin.lcdp.modeldriven.utils.runtime.ModelSubDataQueryUtil;
import com.digiwin.utils.DWTenantUtils;
import com.google.gson.Gson;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ModelDataEntryService {
    private static final Logger logger = LoggerFactory.getLogger(ModelDataEntryService.class);
    private static final String CLASS_LOG_TAG = "[" + ModelDataEntryService.class.getSimpleName() + "]";
    private static final String INTEGRATION_ACCOUNT = "integration";
    private static final String PASSWORD_HASH = "6826CC688C4AF1BD0A8DDA2DBDF8897B";
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;
    @Autowired
    QueryConditionUtils queryConditionUtils;
    @Autowired
    ModelSubDataQueryUtil modelSubDataQueryUtil;

    public Object get(Map<String, Object> params, Map<String, List<ModelApiField>> tileApiConfig) {
        DWDataTable dataTable;
        List<Map<String, Object>> dataList;
        HashMap<String, Map<String, Object>> returnValue = new HashMap<String, Map<String, Object>>();
        Map queryInfoMap = MapUtils.getMap(params, (Object)"query_info", new HashMap());
        Map masterTableConditions = (Map)queryInfoMap.get("conditions");
        ModelSchemaDTO modelSchemaDTO = (ModelSchemaDTO)MapUtils.getObject((Map)queryInfoMap, (Object)"model", (Object)new ModelSchemaDTO());
        String masterTableName = modelSchemaDTO.getName();
        List<ModelFieldDTO> modelFieldDTOs = modelSchemaDTO.getFields();
        ArrayList<String> masterCollectionSubTables = new ArrayList<String>();
        Map<String, Object> collectionQuoteRelations = this.generateCollectionQuoteRelations(modelSchemaDTO);
        HashMap<String, Map> quoteRelations = new HashMap<String, Map>();
        for (ModelFieldDTO modelFieldDTO : modelFieldDTOs) {
            ModelFieldRelationTypeEnum fieldRelationType = ModelFieldRelationTypeEnum.valueOf(modelFieldDTO.getType());
            String fieldId = modelFieldDTO.getFieldId();
            ModelAssociatedInfo modelAssociatedInfo = modelFieldDTO.getAssociatedInfo();
            if (fieldRelationType == ModelFieldRelationTypeEnum.QUOTE) {
                if (quoteRelations.containsKey(modelAssociatedInfo.getTableName())) {
                    String masterRelateSubTableName = modelAssociatedInfo.getTableName();
                    List masterRelateSubFieldNames = modelAssociatedInfo.getAssociatedFields().stream().map(ModelFieldDTO::getFieldId).collect(Collectors.toList());
                    ((Map)quoteRelations.get(masterRelateSubTableName)).put(fieldId, masterRelateSubFieldNames);
                    logger.debug("{} found subTables({}),cause upper-table({}), type({}) of fields", new Object[]{CLASS_LOG_TAG, masterCollectionSubTables, masterTableName, fieldRelationType});
                } else {
                    HashMap relation = new HashMap();
                    List associatedFields = modelAssociatedInfo.getAssociatedFields().stream().map(ModelFieldDTO::getFieldId).collect(Collectors.toList());
                    relation.put(fieldId, associatedFields);
                    quoteRelations.put(modelAssociatedInfo.getTableName(), relation);
                }
            }
            if (fieldRelationType != ModelFieldRelationTypeEnum.COLLECTION) continue;
            String associatedTableName = modelAssociatedInfo.getTableName();
            masterCollectionSubTables.add(associatedTableName);
            logger.debug("{} found subTables({}),cause upper-table({}), type({}) of fields", new Object[]{CLASS_LOG_TAG, masterCollectionSubTables, masterTableName, fieldRelationType});
        }
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName(masterTableName);
        quoteRelations.forEach((quoteTable, relations) -> {
            ArrayList conditions = new ArrayList();
            ArrayList quoteTableAssociatedFields = new ArrayList();
            relations.forEach((quoteFiled, asssociateFilds) -> {
                conditions.add(new DWOnColumn(quoteFiled, DWQueryValueOperator.Equals, quoteFiled));
                if (CollectionUtils.isNotEmpty((Collection)asssociateFilds)) {
                    quoteTableAssociatedFields.addAll(asssociateFilds);
                }
            });
            if (CollectionUtils.isNotEmpty(quoteTableAssociatedFields)) {
                queryInfo.addJoinTableSelectField(quoteTable, quoteTableAssociatedFields.toArray(new String[quoteTableAssociatedFields.size()]));
            }
            queryInfo.setJoinOnColumn(DWQueryJoinRelation.LeftJoin, new DWQueryJoinTable(quoteTable), conditions.toArray(new DWOnColumn[1]));
        });
        if (MapUtils.isNotEmpty((Map)masterTableConditions)) {
            masterTableConditions.forEach((arg_0, arg_1) -> ((DWQueryInfo)queryInfo).addEqualInfo(arg_0, arg_1));
        }
        this.dealQuoteRelation(queryInfo, modelSchemaDTO);
        if (CollectionUtils.isNotEmpty((Collection)tileApiConfig.get(masterTableName))) {
            List<Object> selectFields = new ArrayList();
            if (MapUtils.isNotEmpty(tileApiConfig) && CollectionUtils.isNotEmpty((Collection)tileApiConfig.get(masterTableName))) {
                selectFields = ParamValidateUtil.getSelectFieldsByApiConfig(tileApiConfig, masterTableName, modelSchemaDTO, queryInfo);
            }
            if (CollectionUtils.isNotEmpty(selectFields)) {
                selectFields.stream().forEach(xva$0 -> queryInfo.addSelectField(new String[]{xva$0}));
            } else {
                queryInfo.addSelectField(new String[]{masterTableName + ".*"});
            }
        }
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        DWDataSet queryDataSet = this.dao.select(queryInfo, option);
        if (queryDataSet != null && CollectionUtils.isNotEmpty(dataList = DataEntryDataUtil.convertFromJson(dataTable = queryDataSet.getTable(masterTableName)))) {
            Map<String, Object> masterTableRow = dataList.get(0);
            returnValue.put(masterTableName, masterTableRow);
            ArrayList<Map<String, Object>> masterTableRows = new ArrayList<Map<String, Object>>();
            masterTableRows.add(masterTableRow);
            this.modelSubDataQueryUtil.getFastChildrenQueryByCollectionQuoteRelation(masterTableName, masterTableRows, collectionQuoteRelations, modelSchemaDTO, tileApiConfig);
        }
        DWServiceContext context = DWServiceContext.getContext();
        context.setStandardResult(false);
        return returnValue;
    }

    public Object getList(Map<String, Object> params, Map<String, List<ModelApiField>> tileApiConfig) throws Exception {
        DWQueryCondition dataInfoCondition;
        DWQueryCondition searchInfoCondition;
        DWQueryInfo queryInfo;
        Map<String, Object> returnValue = new HashMap();
        List searchInfos = (List)MapUtils.getObject(params, (Object)"search_info", new ArrayList());
        List sortInfos = (List)MapUtils.getObject(params, (Object)"sort_info", new ArrayList());
        List dataInfos = (List)MapUtils.getObject(params, (Object)"data_info", new ArrayList());
        String targetTableName = MapUtils.getString(params, (Object)"userTableName", (String)"");
        ModelDTO model = (ModelDTO)MapUtils.getObject(params, (Object)"model");
        ModelSchemaDTO modelSchema = model.getSchema();
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        if ("Y".equals(Optional.ofNullable(modelSchema.getSwitchCfg()).orElse(new ModelSwitchCfg()).getDataPermission())) {
            String actionId = Optional.ofNullable(MapUtils.getString(params, (Object)"actionId")).orElseThrow(() -> new RuntimeException("actionId of view_info can not be null"));
            String moduleId = Optional.ofNullable(MapUtils.getString(params, (Object)"moduleId")).orElseThrow(() -> new RuntimeException("moduleId of view_info can not be null"));
            String dataPermissionSysId = ModelDataPermissionUtil.getSysId();
            DWUserPermission userPermission = ModelDrivenDataPermission.getDataPermission(moduleId, actionId, dataPermissionSysId);
            Field rowPermissionField = DWUserPermission.class.getDeclaredField("rowPermission");
            rowPermissionField.setAccessible(true);
            DWRowPermissionElement rowPermission = (DWRowPermissionElement)rowPermissionField.get(userPermission);
            if (!userPermission.isSuperadmin() && (rowPermission instanceof DWRowPermissionEmpty || rowPermission == null)) {
                returnValue.put(targetTableName, new ArrayList());
                return returnValue;
            }
            if (logger.isDebugEnabled()) {
                String debugMessage = String.format("%s[getlist permission] %s permission sql", CLASS_LOG_TAG, targetTableName);
                logger.debug(debugMessage, rowPermissionField.get(userPermission));
            }
            Map<String, Object> dataPermDataMap = ModelDrivenContextExtraUtil.getDataPermissionData();
            String dataPermKey = ModelDrivenContextExtraUtil.getDataPermissionKey(actionId, moduleId);
            dataPermDataMap.put(dataPermKey, userPermission);
            ModelDrivenContextExtraUtil.setDataPermissionData(dataPermDataMap);
            option = new DWDataPermissionOption(actionId, moduleId);
            ((DWDataPermissionOption)option).setRowPermissionOption((DWRowPermissionMatchOption)new DWRowPermissionDefaultMatchOption(true));
        }
        boolean useHasNext = MapUtils.getBooleanValue(params, (Object)"use_has_next", (boolean)false);
        ModelDTO modelDTO = (ModelDTO)MapUtils.getObject(params, (Object)"model", (Object)new ModelDTO());
        ModelSchemaDTO modelSchemaDTO = modelDTO.getSchema();
        modelSchemaDTO = this.getTargetModelSchemaDTO(targetTableName, modelSchemaDTO);
        ModelDrivenContext.getContext().getExtraMap().put("modelSchemaDTO", modelSchemaDTO);
        if ("tree".equals(modelSchemaDTO.getModelType())) {
            queryInfo = new DWQueryInfo();
            queryInfo.setTableName(targetTableName);
            DWQueryCondition allConditions = new DWQueryCondition();
            allConditions.ANDJoin();
            queryInfo.setCondition(allConditions);
            ArrayList allInfos = new ArrayList();
            allInfos.addAll(searchInfos);
            allInfos.addAll(dataInfos);
            if (CollectionUtils.isNotEmpty(allInfos)) {
                if (allInfos.stream().anyMatch(searchInfo -> "".equals(searchInfo.get("node_no")))) {
                    allConditions.addEqualInfo("parent_node_id", (Object)"-1");
                } else {
                    searchInfoCondition = this.dealSearchInfo(searchInfos);
                    dataInfoCondition = this.dealDataInfo(dataInfos);
                    if (searchInfoCondition != null) {
                        allConditions.addCondition(searchInfoCondition);
                    }
                    if (dataInfoCondition != null) {
                        allConditions.addCondition(dataInfoCondition);
                    }
                }
            } else {
                allConditions.addEqualInfo("parent_node_id", (Object)"-1");
            }
            this.dealQuoteRelation(queryInfo, modelSchemaDTO);
            this.dealSortInfo(queryInfo, sortInfos);
            returnValue = this.getTreeListForInnerInvoke(queryInfo, option, 10, tileApiConfig);
        } else if (useHasNext) {
            int pageSize = MapUtils.getIntValue(params, (Object)"page_size", (int)10);
            int pageNumber = MapUtils.getIntValue(params, (Object)"page_no", (int)1);
            DWPagableQueryInfo queryInfo2 = new DWPagableQueryInfo();
            queryInfo2.setTableName(targetTableName);
            searchInfoCondition = this.dealSearchInfo(searchInfos);
            dataInfoCondition = this.dealDataInfo(dataInfos);
            DWQueryCondition allConditions = new DWQueryCondition();
            allConditions.ANDJoin();
            if (searchInfoCondition != null) {
                allConditions.addCondition(searchInfoCondition);
            }
            if (dataInfoCondition != null) {
                allConditions.addCondition(dataInfoCondition);
            }
            queryInfo2.setCondition(allConditions);
            this.dealQuoteRelation((DWQueryInfo)queryInfo2, modelSchemaDTO);
            this.dealSortInfo((DWQueryInfo)queryInfo2, sortInfos);
            queryInfo2.setPageNumber(pageNumber);
            queryInfo2.setPageSize(pageSize);
            String pk = modelSchemaDTO.getFields().stream().filter(ModelFieldDTO::isPk).findFirst().orElseThrow(() -> new RuntimeException(String.format("%s has no PK field", targetTableName))).getFieldId();
            queryInfo2.addOrderBy(pk, false);
            returnValue = this.getListForInnerInvoke((DWQueryInfo)queryInfo2, option, true, tileApiConfig);
        } else {
            queryInfo = new DWQueryInfo();
            queryInfo.setTableName(targetTableName);
            DWQueryCondition searchInfoCondition2 = this.dealSearchInfo(searchInfos);
            DWQueryCondition dataInfoCondition2 = this.dealDataInfo(dataInfos);
            DWQueryCondition allConditions = new DWQueryCondition();
            allConditions.ANDJoin();
            if (searchInfoCondition2 != null) {
                allConditions.addCondition(searchInfoCondition2);
            }
            if (dataInfoCondition2 != null) {
                allConditions.addCondition(dataInfoCondition2);
            }
            queryInfo.setCondition(allConditions);
            this.dealQuoteRelation(queryInfo, modelSchemaDTO);
            this.dealSortInfo(queryInfo, sortInfos);
            returnValue = this.getListForInnerInvoke(queryInfo, option, false, tileApiConfig);
        }
        return returnValue;
    }

    public Map<String, Object> getListForInnerInvoke(DWQueryInfo queryInfo, DWDataSetOperationOption option, boolean page, Map<String, List<ModelApiField>> tileApiConfig) {
        String targetTableName = queryInfo.getTableName();
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        ModelDTO publishedModel = modelDrivenContext.getPublishedModel();
        ModelSchemaDTO masterModelSchema = publishedModel.getSchema();
        ModelSchemaDTO modelSchemaDTO = this.getTargetModelSchemaDTO(targetTableName, masterModelSchema);
        Map<String, Object> collectionQuoteRelations = this.generateCollectionQuoteRelations(modelSchemaDTO);
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        List<Object> selectFields = new ArrayList();
        if (MapUtils.isNotEmpty(tileApiConfig) && CollectionUtils.isNotEmpty((Collection)tileApiConfig.get(targetTableName))) {
            selectFields = ParamValidateUtil.getSelectFieldsByApiConfig(tileApiConfig, targetTableName, modelSchemaDTO, queryInfo);
        }
        if (page) {
            DWPagableQueryInfo pageQueryInfo = (DWPagableQueryInfo)queryInfo;
            List existedSelectFields = pageQueryInfo.getSelectObjects();
            int pageNumber = pageQueryInfo.getPageNumber();
            if (CollectionUtils.isNotEmpty(selectFields)) {
                selectFields.stream().filter(apiConfigSelectField -> existedSelectFields.stream().noneMatch(existedSelectField -> SelectFieldCompareUtil.checkEqualCondition(existedSelectField.toString(), apiConfigSelectField))).forEach(xva$0 -> pageQueryInfo.addSelectField(new String[]{xva$0}));
            } else {
                pageQueryInfo.addSelectField(new String[]{targetTableName + ".*"});
            }
            DWPaginationQueryResult queryResult = this.dao.selectWithPage(pageQueryInfo, option);
            DWDataTable dataTable = queryResult.getDataSet().getTable(targetTableName);
            List<Map<String, Object>> masterRows = DataEntryDataUtil.convertFromJson(dataTable);
            if (queryResult.getRowCount() > 0L) {
                StopWatch stopWatch = StopWatch.createStarted();
                this.modelSubDataQueryUtil.getFastChildrenQueryByCollectionQuoteRelation(targetTableName, masterRows, collectionQuoteRelations, modelSchemaDTO, tileApiConfig);
                stopWatch.stop();
                logger.info("{} result: subTable cost {} ms", (Object)CLASS_LOG_TAG, (Object)stopWatch.getTime());
            }
            long totalRowCount = queryResult.getRowCount();
            long totalPageCount = queryResult.getPageCount();
            returnValue.put("total_results", totalRowCount);
            returnValue.put("has_next", (long)pageNumber < totalPageCount);
            returnValue.put(targetTableName, masterRows);
        } else {
            if (CollectionUtils.isNotEmpty(selectFields)) {
                List selectObjects = queryInfo.getSelectObjects();
                selectFields.stream().filter(apiConfigSelectField -> selectObjects.stream().noneMatch(existedSelectField -> SelectFieldCompareUtil.checkEqualCondition(existedSelectField.toString(), apiConfigSelectField))).forEach(xva$0 -> queryInfo.addSelectField(new String[]{xva$0}));
            }
            DWDataSet queryDataSet = this.dao.select(queryInfo, option);
            ArrayList<Map<String, Object>> dataList = new ArrayList();
            if (queryDataSet != null) {
                DWDataTable dataTable = queryDataSet.getTable(targetTableName);
                dataList = DataEntryDataUtil.convertFromJson(dataTable);
                this.modelSubDataQueryUtil.getFastChildrenQueryByCollectionQuoteRelation(targetTableName, dataList, collectionQuoteRelations, modelSchemaDTO, tileApiConfig);
            }
            returnValue.put(targetTableName, dataList);
        }
        return returnValue;
    }

    public Map<String, Object> getForInnerInvoke(DWQueryInfo queryInfo, Map<String, List<ModelApiField>> tileApiConfig) {
        String targetTableName = queryInfo.getTableName();
        DWDataRow publishedDataRow = this.getModel(targetTableName);
        ModelSchemaDTO masterModelSchema = ModelSchemaUtil.parseModelSchema(publishedDataRow);
        Map<String, Object> collectionQuoteRelations = this.generateCollectionQuoteRelations(masterModelSchema);
        this.dealQuoteRelation(queryInfo, masterModelSchema);
        List<Object> selectFields = new ArrayList();
        if (MapUtils.isNotEmpty(tileApiConfig) && CollectionUtils.isNotEmpty((Collection)tileApiConfig.get(targetTableName))) {
            selectFields = ParamValidateUtil.getSelectFieldsByApiConfig(tileApiConfig, targetTableName, masterModelSchema, queryInfo);
        }
        if (CollectionUtils.isNotEmpty(selectFields)) {
            selectFields.stream().forEach(xva$0 -> queryInfo.addSelectField(new String[]{xva$0}));
        } else {
            queryInfo.addSelectField(new String[]{targetTableName + ".*"});
        }
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        DWDataSet queryDataSet = this.dao.select(queryInfo);
        if (queryDataSet.getTable(masterModelSchema.getName()).getRows().size() > 0) {
            DWDataTable dataTable = queryDataSet.getTable(targetTableName);
            List<Map<String, Object>> dataList = DataEntryDataUtil.convertFromJson(dataTable);
            this.modelSubDataQueryUtil.getFastChildrenQueryByCollectionQuoteRelation(targetTableName, dataList, collectionQuoteRelations, masterModelSchema, tileApiConfig);
            returnValue.put(targetTableName, dataList.get(0));
        } else {
            returnValue.put(targetTableName, null);
        }
        return returnValue;
    }

    public Map<String, Object> getTreeListForInnerInvoke(DWQueryInfo queryInfo, DWDataSetOperationOption option, int maxLevel, Map<String, List<ModelApiField>> tileApiConfig) {
        String targetTableName = queryInfo.getTableName();
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        option.setTenantEnabled(false);
        DWDataRow publishedDataRow = this.getModel(targetTableName);
        ModelSchemaDTO modelSchema = ModelSchemaUtil.parseModelSchema(publishedDataRow);
        List<Object> selectFields = new ArrayList();
        if (MapUtils.isNotEmpty(tileApiConfig) && CollectionUtils.isNotEmpty((Collection)tileApiConfig.get(targetTableName))) {
            selectFields = ParamValidateUtil.getSelectFieldsByApiConfig(tileApiConfig, targetTableName, modelSchema, queryInfo);
        }
        if (CollectionUtils.isNotEmpty(selectFields)) {
            selectFields.stream().forEach(xva$0 -> queryInfo.addSelectField(new String[]{xva$0}));
        } else {
            queryInfo.addSelectField(new String[]{targetTableName + ".*"});
        }
        DWDataSet dataset = this.dao.select(queryInfo, option);
        List codes = dataset.getTables().getPrimaryTable().getRows().stream().map(dataRow -> dataRow.get("node_id")).collect(Collectors.toList());
        this.attachMenuChildRows(dataset, 1, maxLevel, codes.toArray(), option, tileApiConfig);
        dataset.getTable(targetTableName).getRows().forEach(row -> row.set(targetTableName, null));
        returnValue.put(targetTableName, DataEntryDataUtil.convertFromJson(dataset.getTable(targetTableName)));
        return returnValue;
    }

    public DWDataRow getModel(String tableName) {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        option.setManagementFieldEnabled(false);
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_lcdp_model_info");
        queryInfo.setJoinOnColumn(DWQueryJoinRelation.Join, "dw_lcdp_model", new DWOnColumn[]{new DWOnColumn("code", DWQueryValueOperator.Equals, "code")});
        queryInfo.addEqualInfo("table_name", (Object)tableName);
        queryInfo.addSelectField(new String[]{"dw_lcdp_model.*"});
        return this.dao.selectOne(queryInfo, option);
    }

    public void dealSortInfo(DWQueryInfo queryInfo, List<Map<String, Object>> sortInfos) {
        if (CollectionUtils.isNotEmpty(sortInfos)) {
            Collections.sort(sortInfos, Comparator.comparingDouble(item -> Double.parseDouble(item.get("sort_seq").toString())));
            sortInfos.forEach(sortInfo -> {
                switch (sortInfo.get("sort_type").toString()) {
                    case "asc": {
                        queryInfo.addOrderBy(sortInfo.get("sort_field").toString(), true);
                        break;
                    }
                    case "desc": {
                        queryInfo.addOrderBy(sortInfo.get("sort_field").toString(), false);
                        break;
                    }
                }
            });
        }
    }

    public DWQueryCondition dealSearchInfo(List<Map<String, Object>> searchInfos) {
        if (CollectionUtils.isNotEmpty(searchInfos)) {
            Collections.sort(searchInfos, Comparator.comparingDouble(item -> Double.parseDouble(item.get("order").toString())));
            DWQueryCondition condition = new DWQueryCondition();
            this.generateConditionV2(searchInfos, condition);
            return condition;
        }
        return null;
    }

    public DWQueryCondition dealDataInfo(List<Map<String, Object>> dataInfos) {
        ModelSchemaDTO modelSchema = (ModelSchemaDTO)ModelDrivenContext.getContext().getExtraMap().get("modelSchemaDTO");
        if (CollectionUtils.isNotEmpty(dataInfos)) {
            boolean anyNotEmpty = dataInfos.stream().anyMatch(MapUtils::isNotEmpty);
            if (anyNotEmpty) {
                DWQueryCondition condition = new DWQueryCondition();
                condition.ORJoin();
                this.reorganizeRowCondition(condition, dataInfos, modelSchema);
                return condition;
            }
            return null;
        }
        return null;
    }

    public List<QueryConditionDTO> getFirstConditionGroup(List<QueryConditionDTO> allQueryConditionDTO, QueryConditionDTO currentCodition) {
        LinkedList<QueryConditionDTO> firstConditionGroup = new LinkedList<QueryConditionDTO>();
        int matchedIndex = -1;
        for (QueryConditionDTO queryCondition : allQueryConditionDTO) {
            if (matchedIndex == -1) {
                if (NumberUtils.compare((int)currentCodition.getOrder(), (int)queryCondition.getOrder()) != 0) continue;
                matchedIndex = currentCodition.getOrder();
                firstConditionGroup.add(queryCondition);
                continue;
            }
            if (matchedIndex <= -1) continue;
            if (StringUtils.equals((CharSequence)")", (CharSequence)queryCondition.getBracket())) {
                firstConditionGroup.add(queryCondition);
                break;
            }
            if (StringUtils.equals((CharSequence)"(", (CharSequence)queryCondition.getBracket())) break;
            firstConditionGroup.add(queryCondition);
        }
        return firstConditionGroup;
    }

    private List<QueryConditionDTO> getConditionGroup(List<QueryConditionDTO> allQueryConditionDTO, QueryConditionDTO parentConditionWithAndOrLogic) {
        LinkedList<QueryConditionDTO> currentConditionGroup = new LinkedList<QueryConditionDTO>();
        int matchedIndex = -1;
        QueryConditionDTO sourceStartQueryCondition = null;
        boolean hasBracketOfSourceStartQueryCondition = false;
        Integer parentOrder = parentConditionWithAndOrLogic.getOrder();
        for (QueryConditionDTO sourceQueryCondition : allQueryConditionDTO) {
            if (matchedIndex == -1) {
                Integer sourceOrder = sourceQueryCondition.getOrder();
                if (NumberUtils.compare((int)parentOrder, (int)sourceOrder) == 0) {
                    matchedIndex = parentOrder;
                    logger.debug("{}[getConditionGroup] hitParentField(parent:{}, current:{})", new Object[]{CLASS_LOG_TAG, parentOrder, sourceOrder});
                    continue;
                }
                logger.debug("{}[getConditionGroup] not hitParentField(parent:{}, current:{})", new Object[]{CLASS_LOG_TAG, parentOrder, sourceOrder});
                continue;
            }
            if (matchedIndex <= -1) continue;
            if (sourceStartQueryCondition == null) {
                sourceStartQueryCondition = sourceQueryCondition;
                hasBracketOfSourceStartQueryCondition = sourceQueryCondition.getBracket() != null;
            }
            String currentBracket = sourceQueryCondition.getBracket();
            if (hasBracketOfSourceStartQueryCondition && StringUtils.equals((CharSequence)currentBracket, (CharSequence)")") || !hasBracketOfSourceStartQueryCondition) {
                logger.debug("{}[getConditionGroup] hitParentField and add current:({}) when bracked({})", new Object[]{CLASS_LOG_TAG, sourceQueryCondition, currentBracket});
                currentConditionGroup.add(sourceQueryCondition);
                break;
            }
            logger.debug("{}[getConditionGroup] hitParentField and add current:({})", (Object)CLASS_LOG_TAG, (Object)sourceQueryCondition);
            currentConditionGroup.add(sourceQueryCondition);
        }
        return currentConditionGroup;
    }

    public DWQueryCondition generateConditionV2(List<Map<String, Object>> searchInfos, DWQueryCondition condition) {
        List<Object> queryConditions = new ArrayList();
        if (CollectionUtils.isNotEmpty(searchInfos)) {
            queryConditions = ModelDrivenParameterParserUtil.getQueryConditions(searchInfos);
        }
        ArrayList processedCondition = new ArrayList();
        List bracketRightAndOr = queryConditions.stream().filter(queryCondition -> StringUtils.equals((CharSequence)queryCondition.getBracket(), (CharSequence)")") && StringUtils.equals((CharSequence)queryCondition.getLogic(), (CharSequence)"OR") || NumberUtils.compare((int)queryCondition.getOrder(), (int)1) == 0 && StringUtils.equals((CharSequence)queryCondition.getLogic(), (CharSequence)"OR") && StringUtils.equals((CharSequence)queryCondition.getBracket(), null)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(bracketRightAndOr)) {
            this.queryConditionUtils.generateCondition(queryConditions.iterator(), condition, "");
        } else {
            LinkedHashMap<Integer, List<QueryConditionDTO>> andConditionGroups = new LinkedHashMap<Integer, List<QueryConditionDTO>>();
            LinkedHashMap<Integer, List<QueryConditionDTO>> orConditionGroups = new LinkedHashMap<Integer, List<QueryConditionDTO>>();
            QueryConditionDTO windowQueryCondition = null;
            for (QueryConditionDTO queryConditionDTO : queryConditions) {
                logger.debug("{}[{}] prepare windowQueryCondition({}) currentSearchInfo({})", new Object[]{CLASS_LOG_TAG, queryConditionDTO.getOrder(), windowQueryCondition, queryConditionDTO});
                if (windowQueryCondition == null) {
                    logger.debug("{}[{}] process currentSearchInfo({}) - style 1", new Object[]{CLASS_LOG_TAG, queryConditionDTO.getOrder(), queryConditionDTO});
                    List<QueryConditionDTO> andConditionGroup = this.getFirstConditionGroup(queryConditions, queryConditionDTO);
                    andConditionGroups.put(andConditionGroup.get(0).getOrder(), andConditionGroup);
                    andConditionGroup.stream().forEach(andCondition -> processedCondition.add(andCondition.getOrder()));
                    windowQueryCondition = andConditionGroup.get(andConditionGroup.size() - 1);
                } else if (windowQueryCondition != null && NumberUtils.compare((int)windowQueryCondition.getOrder(), (int)queryConditionDTO.getOrder()) == 0) {
                    windowQueryCondition = queryConditionDTO;
                } else {
                    logger.debug("{}[{}] ignored, cause added already", (Object)CLASS_LOG_TAG, (Object)queryConditionDTO.getOrder());
                    continue;
                }
                String nextConditionGroupLogic = windowQueryCondition.getLogic();
                if (StringUtils.isNotBlank((CharSequence)nextConditionGroupLogic)) {
                    logger.debug("{}[{}] process currentSearchInfo({}) - style 2", new Object[]{CLASS_LOG_TAG, windowQueryCondition.getOrder(), windowQueryCondition});
                    List<QueryConditionDTO> nextConditionGroup = this.getConditionGroup(queryConditions, windowQueryCondition);
                    if (StringUtils.equals((CharSequence)nextConditionGroupLogic, (CharSequence)"OR")) {
                        orConditionGroups.put(nextConditionGroup.get(0).getOrder(), nextConditionGroup);
                    } else {
                        andConditionGroups.put(nextConditionGroup.get(0).getOrder(), nextConditionGroup);
                    }
                    nextConditionGroup.stream().forEach(andOrOrCondition -> processedCondition.add(andOrOrCondition.getOrder()));
                    windowQueryCondition = nextConditionGroup.get(nextConditionGroup.size() - 1);
                    continue;
                }
                if (StringUtils.equals((CharSequence)nextConditionGroupLogic, null)) {
                    logger.debug("[] ignored end queryCondition({}), cause added already", (Object)windowQueryCondition);
                    continue;
                }
                logger.error("[] processed or not support queryCondition({})", (Object)windowQueryCondition);
            }
            DWQueryCondition allAndOrQueryCondition = new DWQueryCondition();
            allAndOrQueryCondition.ORJoin();
            DWQueryCondition dWQueryCondition = new DWQueryCondition();
            for (Map.Entry andQueryConditionGroup : andConditionGroups.entrySet()) {
                this.queryConditionUtils.generateCondition(((List)andQueryConditionGroup.getValue()).iterator(), dWQueryCondition, "");
            }
            if (CollectionUtils.isNotEmpty((Collection)dWQueryCondition.getItems())) {
                allAndOrQueryCondition.addCondition(dWQueryCondition);
            }
            DWQueryCondition orOnlyCondition = new DWQueryCondition();
            for (Map.Entry orQueryConditionGroup : orConditionGroups.entrySet()) {
                this.queryConditionUtils.generateCondition(((List)orQueryConditionGroup.getValue()).iterator(), orOnlyCondition, "");
            }
            orOnlyCondition.ORJoin();
            if (CollectionUtils.isNotEmpty((Collection)orOnlyCondition.getItems())) {
                allAndOrQueryCondition.addCondition(orOnlyCondition);
            }
            condition.addCondition(allAndOrQueryCondition);
        }
        return condition;
    }

    private void dealQuoteRelation(DWQueryInfo queryInfo, ModelSchemaDTO modelSchemaDTO) {
        List<ModelFieldDTO> modelFieldDTOs = modelSchemaDTO.getFields();
        if (CollectionUtils.isNotEmpty(modelFieldDTOs)) {
            List quoteQueryFields = modelFieldDTOs.stream().filter(modelField -> ModelFieldRelationTypeEnum.valueOf(modelField.getType()) == ModelFieldRelationTypeEnum.QUOTE_QUERY).collect(Collectors.toList());
            logger.debug("[dealQuoteRelation] quoteQueryFields size({}) in table({})", (Object)quoteQueryFields.size(), (Object)modelSchemaDTO.getName());
            if (CollectionUtils.isNotEmpty(quoteQueryFields)) {
                Map<String, String> tableAliasMap = ParamValidateUtil.generateJoinTableAlias(modelSchemaDTO);
                Map<String, List<ModelFieldDTO>> map = quoteQueryFields.stream().collect(Collectors.groupingBy(modelField -> modelField.getAssociatedInfo().getTableName()));
                for (Map.Entry<String, List<ModelFieldDTO>> next : map.entrySet()) {
                    String quoteTableName = next.getKey();
                    List<ModelFieldDTO> quoteFields = next.getValue();
                    ArrayList<DWOnColumn> conditions = new ArrayList<DWOnColumn>();
                    String quoteTableAlias = tableAliasMap.get(quoteTableName);
                    for (int i = 0; i < quoteFields.size(); ++i) {
                        ModelFieldDTO quoteQueryField = quoteFields.get(i);
                        String fieldId = quoteQueryField.getFieldId();
                        String quoteFieldId = quoteQueryField.getAssociatedInfo().getJoinField().getFieldId();
                        conditions.add(new DWOnColumn(quoteFieldId, DWQueryValueOperator.Equals, fieldId));
                        Map<String, Object> modelContextExtra = ModelDrivenContext.getContext().getExtraMap();
                        if (((Boolean)modelContextExtra.getOrDefault("hasApiConfigResponse", false)).booleanValue()) continue;
                        ArrayList selectFields = new ArrayList();
                        List<ModelFieldDTO> otherAssociatedFields = quoteQueryField.getAssociatedInfo().getAssociatedFields();
                        otherAssociatedFields.stream().filter(ModelFieldDTO::isSelectedField).forEach(associatedField -> selectFields.add(quoteTableAlias + "." + associatedField.getFieldId() + " AS " + associatedField.getAlias().getFieldId()));
                        queryInfo.addSelectField(selectFields.toArray(new String[selectFields.size()]));
                    }
                    queryInfo.setJoinOnColumn(DWQueryJoinRelation.LeftJoin, new DWQueryJoinTable(quoteTableName, quoteTableAlias), conditions.toArray(new DWOnColumn[conditions.size()]));
                }
            }
        }
    }

    public Map<String, Object> generateCollectionQuoteRelations(ModelSchemaDTO modelSchemaDTO) {
        LinkedHashMap<String, Object> collectionQuoteRelations = new LinkedHashMap<String, Object>();
        ArrayList<String> masterCollectionSubTables = new ArrayList<String>();
        String masterTableName = modelSchemaDTO.getName();
        for (ModelFieldDTO modelFieldDTO : modelSchemaDTO.getFields()) {
            ModelFieldRelationTypeEnum fieldRelationType = ModelFieldRelationTypeEnum.valueOf(modelFieldDTO.getType());
            ModelAssociatedInfo modelAssociatedInfo = modelFieldDTO.getAssociatedInfo();
            if (fieldRelationType != ModelFieldRelationTypeEnum.COLLECTION) continue;
            if (modelAssociatedInfo == null) {
                throw new DWRuntimeException(String.format("collection field '%s' miss attribute 'associatedInfo'", modelFieldDTO.getFieldName()));
            }
            String associatedTableName = modelAssociatedInfo.getTableName();
            masterCollectionSubTables.add(associatedTableName);
        }
        logger.debug("{} found subTables({}),cause upper-table({}), type({}) of field", new Object[]{CLASS_LOG_TAG, masterCollectionSubTables, masterTableName, ModelFieldRelationTypeEnum.COLLECTION.getValue()});
        List<ModelSchemaDTO> subTables = modelSchemaDTO.getChildren();
        subTables.stream().filter(subTable -> masterCollectionSubTables.contains(subTable.getName())).forEach(subTable -> {
            LinkedHashMap<String, Map<String, Object>> quoteRelations = new LinkedHashMap<String, Map<String, Object>>();
            subTable.getFields().stream().filter(field -> ModelFieldRelationTypeEnum.QUOTE.getValue().equals(field.getType()) && masterTableName.equals(field.getAssociatedInfo().getTableName())).forEach(quoteField -> {
                if (quoteField.getAssociatedInfo().getAssociatedFields() != null) {
                    List associatedFields = quoteField.getAssociatedInfo().getAssociatedFields().stream().map(ModelFieldDTO::getFieldId).collect(Collectors.toList());
                    quoteRelations.put(quoteField.getFieldId(), (Map<String, Object>)((Object)associatedFields));
                } else {
                    quoteRelations.put(quoteField.getFieldId(), (Map<String, Object>)((Object)new ArrayList()));
                }
            });
            collectionQuoteRelations.put(subTable.getName(), quoteRelations);
            Map<String, Object> subsubRelation = this.generateCollectionQuoteRelations((ModelSchemaDTO)subTable);
            if (MapUtils.isNotEmpty(subsubRelation)) {
                quoteRelations.put("#subRelation", subsubRelation);
            }
        });
        return collectionQuoteRelations;
    }

    public ModelSchemaDTO getTargetModelSchemaDTO(String targetTableName, ModelSchemaDTO masterModelDTO) {
        if (masterModelDTO.getName().equals(targetTableName)) {
            return masterModelDTO;
        }
        List<ModelSchemaDTO> childrenModelSchemaDTOs = masterModelDTO.getChildren();
        if (CollectionUtils.isNotEmpty(childrenModelSchemaDTOs)) {
            for (ModelSchemaDTO childrenModelSchemaDTO : childrenModelSchemaDTOs) {
                if (childrenModelSchemaDTO.getName().equals(targetTableName)) {
                    return childrenModelSchemaDTO;
                }
                List<ModelSchemaDTO> cchildrenModelSchemaDTOs = childrenModelSchemaDTO.getChildren();
                if (!CollectionUtils.isNotEmpty(cchildrenModelSchemaDTOs)) continue;
                return this.getTargetModelSchemaDTO(targetTableName, childrenModelSchemaDTO);
            }
            return null;
        }
        return null;
    }

    public ModelIndexDTO getUniqueIndex(ModelSchemaDTO masterModelSchema, String targetTableName) {
        List<ModelIndexDTO> indexLst = this.getModelSchemaUniqueIndexes(masterModelSchema);
        if (CollectionUtils.isEmpty(indexLst)) {
            throw new DWRuntimeException(String.format("table '%s' unique index is null", targetTableName));
        }
        return indexLst.get(0);
    }

    public List<ModelIndexDTO> getModelSchemaUniqueIndexes(ModelSchemaDTO masterModelSchema) {
        return masterModelSchema.getIndex().stream().filter(index -> index.getType().toLowerCase().equals(IndexTypeEnum.UNIQUE_INDEX.getIndexChar())).collect(Collectors.toList());
    }

    public List<ModelIndexDTO> getModelSchemaUniqueConstrains(ModelSchemaDTO masterModelSchema) {
        List<ModelIndexDTO> uniqueIndexLst = this.getModelSchemaUniqueIndexes(masterModelSchema);
        if (CollectionUtils.isNotEmpty(uniqueIndexLst)) {
            logger.debug("{}getModelSchemaUniqueConstrains get unique index({})", (Object)CLASS_LOG_TAG, uniqueIndexLst.stream().map(ModelIndexDTO::getId));
            return uniqueIndexLst;
        }
        ArrayList<ModelIndexDTO> pkLst = new ArrayList<ModelIndexDTO>();
        String msPk = masterModelSchema.getPk();
        if (StringUtils.isNotBlank((CharSequence)msPk)) {
            List<String> pks = Arrays.stream(msPk.split(",")).map(String::trim).collect(Collectors.toList());
            ModelIndexDTO pkModelIndex = new ModelIndexDTO();
            pkModelIndex.setType(IndexTypeEnum.PRIMARY_KEY.getIndexChar());
            pkModelIndex.setMember(pks);
            pkLst.add(pkModelIndex);
        }
        logger.debug("{}getModelSchemaUniqueConstrains get pk({})", (Object)CLASS_LOG_TAG, (Object)msPk);
        return pkLst;
    }

    private void attachMenuChildRows(DWDataSet dataset, int currentLevel, int maxLevel, Object[] codeFieldInfo, DWDataSetOperationOption option, Map<String, List<ModelApiField>> tileApiConfig) {
        if (++currentLevel > maxLevel) {
            return;
        }
        String tableName = dataset.getTables().getPrimaryTable().getName();
        ModelSchemaDTO modelSchema = (ModelSchemaDTO)ModelDrivenContext.getContext().getExtraMap().get("modelSchemaDTO");
        Map<String, ModelSchemaDTO> allModelSchemas = ModelSchemaUtil.getModelSchemaMap(modelSchema);
        ModelSchemaDTO currentModelSchema = allModelSchemas.get(tableName);
        if (currentModelSchema == null) {
            logger.warn("{}[attachMenuChildRows] tableName({}) not exists in modelSchema", (Object)CLASS_LOG_TAG, (Object)tableName);
            return;
        }
        ArrayList masterRows = new ArrayList();
        masterRows.addAll(dataset.getTables().getPrimaryTable().getRows().stream().collect(Collectors.toList()));
        for (DWDataRow row : masterRows) {
            DWQueryInfo queryInfo = new DWQueryInfo(tableName);
            if (MapUtils.isNotEmpty(tileApiConfig) && CollectionUtils.isNotEmpty((Collection)tileApiConfig.get(tableName))) {
                List<String> selectFields = ParamValidateUtil.getSelectFieldsByApiConfig(tileApiConfig, tableName, currentModelSchema, queryInfo);
                for (String selectField : selectFields) {
                    queryInfo.addSelectField(new String[]{selectField});
                }
            }
            queryInfo.addEqualInfo("parent_node_id", row.get("node_id"));
            DWDataSet childMenuDataset = option == null ? this.dao.select(queryInfo) : this.dao.select(queryInfo, option);
            this.attachMenuChildRows(childMenuDataset, currentLevel, maxLevel, codeFieldInfo, option, tileApiConfig);
            row.set(tableName, (Object)childMenuDataset);
        }
    }

    public Object getTBBDataPermission(String appId, String moduleId, String actionId, String tenantId, String userId) throws Exception {
        String integrationToken = null;
        HashMap<String, String> integrationTokenParams = new HashMap<String, String>();
        integrationTokenParams.put("tenantId", tenantId);
        integrationTokenParams.put("userId", INTEGRATION_ACCOUNT);
        integrationTokenParams.put("passwordHash", PASSWORD_HASH);
        ServiceModel integrationTokenModel = new ServiceModel();
        integrationTokenModel.setInvokeURL("/api/iam/v2/identity/login/internal");
        integrationTokenModel.setParams(integrationTokenParams);
        HttpResponseModel integrationTokenResponseModel = (HttpResponseModel)IAMService.invoke((ServiceModel)integrationTokenModel);
        String integrationTokenResponseBody = integrationTokenResponseModel.getResponseBody();
        if (integrationTokenResponseModel.getHttpStatusCode() != 200) {
            String errorMessage = "<<< get IAM integrationToken failed ,response code:'%s', message:'%s'";
            throw new DWException(String.format(errorMessage, integrationTokenResponseModel.getHttpStatusCode(), integrationTokenResponseBody));
        }
        Map result = ModelDrivenJacksonUtil.fromJson(integrationTokenResponseBody, Map.class);
        integrationToken = MapUtils.getString((Map)result, (Object)"token");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("sysId", appId);
        params.put("moduleId", moduleId);
        params.put("actionId", actionId);
        params.put("self", true);
        ServiceModel serviceModel = new ServiceModel();
        serviceModel.setInvokeURL("/api/iam/v2/permission/data");
        serviceModel.setParams(params);
        serviceModel.setToken(integrationToken);
        HttpResponseModel iamResponseModel = (HttpResponseModel)IAMService.invoke((ServiceModel)serviceModel);
        String iamResponseBody = iamResponseModel.getResponseBody();
        int iamResponseStatusCode = iamResponseModel.getHttpStatusCode();
        if (iamResponseStatusCode != 200) {
            String errorMessage = "<<< get IAM permission data failed response code:'%s', message:'%s'";
            throw new DWException(String.format(errorMessage, iamResponseStatusCode, errorMessage));
        }
        Method getCustomGsonMethod = DWDataPermission.class.getDeclaredMethod("getCustomGson", new Class[0]);
        getCustomGsonMethod.setAccessible(true);
        Gson gson = (Gson)getCustomGsonMethod.invoke(DWDataPermission.class, new Object[0]);
        return gson.fromJson(iamResponseBody, DWUserPermission.class);
    }

    public List<Map<String, Object>> insertRows(ModelSchemaDTO parentModelSchema, List<Map<String, Object>> parentTableRows) {
        ArrayList<Map<String, Object>> businessKeys = new ArrayList<Map<String, Object>>();
        parentTableRows.forEach(masterTableRow -> {
            List<String> childTableNames = parentModelSchema.getChildren().stream().map(ModelSchemaDTO::getName).collect(Collectors.toList());
            HashMap<String, List> childTableRowMap = new HashMap<String, List>();
            childTableNames.forEach(childTableName -> {
                if (masterTableRow.keySet().contains(childTableName)) {
                    childTableRowMap.put((String)childTableName, (List)masterTableRow.get(childTableName));
                    masterTableRow.remove(childTableName);
                }
            });
            Map<String, Object> modelDrivenContextExtraMap = ModelDrivenContext.getContext().getExtraMap();
            String serviceName = (String)modelDrivenContextExtraMap.get("currentServiceName");
            ParamFilterUtil.filterMgmtParam(masterTableRow, parentModelSchema, serviceName);
            ParamValidateUtil.filterParam(masterTableRow, parentModelSchema);
            ModelDataUtil.dealInsertMgmtFields(masterTableRow);
            DWDataSet dataSet = new DWDataSet();
            String parentTableName = parentModelSchema.getName();
            DWDataTable dataTable = dataSet.newTable(parentTableName);
            dataTable.newRow(masterTableRow).setState("C");
            DWDataSetOperationOption option = new DWDataSetOperationOption();
            option.setManagementFieldEnabled(false);
            DWSQLExecutionResult execute = null;
            execute = this.dao.execute(dataSet, option);
            Optional<ModelFieldDTO> pkField = parentModelSchema.getFields().stream().filter(field -> field.getAutoIncrement() && field.isPk()).findFirst();
            if (pkField.isPresent()) {
                Object autoIncrementKey = ((List)execute.getGeneratedKeys().get(parentTableName)).get(0);
                masterTableRow.put(pkField.get().getFieldId(), autoIncrementKey);
            }
            ModelIndexDTO uniqueIndex = this.getUniqueIndex(parentModelSchema, parentModelSchema.getName());
            HashMap businessKey = new HashMap();
            uniqueIndex.getMember().forEach(bkField -> businessKey.put(bkField, masterTableRow.get(bkField)));
            businessKeys.add(businessKey);
            Map<String, Object> collectionQuoteRelations = this.generateCollectionQuoteRelations(parentModelSchema);
            childTableRowMap.forEach((subTableName, subTableRows) -> {
                if (CollectionUtils.isNotEmpty((Collection)subTableRows)) {
                    Map quoteRelations = (Map)collectionQuoteRelations.get(subTableName);
                    if (MapUtils.isEmpty((Map)quoteRelations)) {
                        throw new DWRuntimeException(String.format("can't find collection associatedInfo of subtable '%s' ", subTableName));
                    }
                    quoteRelations.keySet().forEach(field -> subTableRows.forEach(subTableRow -> subTableRow.put(field, masterTableRow.get(field))));
                }
            });
            childTableRowMap.forEach((subTableName, subTableRows) -> {
                Optional<ModelSchemaDTO> childModelSchema = parentModelSchema.getChildren().stream().filter(model -> model.getName().equals(subTableName)).findFirst();
                if (!childModelSchema.isPresent()) {
                    throw new DWRuntimeException(String.format("can not find subModelSchema %s in parentModelSchema %s", subTableName, parentTableName));
                }
                this.insertRows(childModelSchema.get(), (List<Map<String, Object>>)subTableRows);
            });
        });
        return businessKeys;
    }

    public List<Map<String, Object>> updateRows(ModelSchemaDTO modelSchema, List<Map<String, Object>> masterTableParamDatas, Map<String, List<Map<String, Object>>> existedDatas) {
        ArrayList<Map<String, Object>> businessKeys = new ArrayList<Map<String, Object>>();
        block8: for (Map<String, Object> masterTableRow : masterTableParamDatas) {
            ParamValidateUtil.filterParam(masterTableRow, modelSchema);
            LinkedHashMap<String, Object> masterTableOriginalRow = new LinkedHashMap<String, Object>(masterTableRow);
            List<String> childTableNames = ModelSchemaUtil.getCurrentLevelChildNames(modelSchema);
            HashMap<String, List> childTableRowMap = new HashMap<String, List>();
            childTableNames.forEach(childTableName -> {
                if (masterTableRow.keySet().contains(childTableName)) {
                    childTableRowMap.put((String)childTableName, (List)masterTableRow.get(childTableName));
                    masterTableRow.remove(childTableName);
                }
            });
            ModelDataUtil.dealUpdateMgmtFields(masterTableRow);
            List<String> bkOrPkFields = this.getPkOrBkFieldsByModelSchema(masterTableRow, modelSchema);
            Optional<Map> matchRow = existedDatas.get(modelSchema.getName()).stream().filter(existedData -> {
                if (CollectionUtils.isNotEmpty((Collection)bkOrPkFields)) {
                    return bkOrPkFields.stream().allMatch(field -> {
                        Object paramColumnValue = null;
                        Object existedColumnValue = existedData.get(field);
                        paramColumnValue = DWTenantUtils.getTenantColumnName().equals(field) ? (Object)DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()) : (Object)masterTableRow.get(field);
                        if (existedColumnValue != null) {
                            if (existedColumnValue instanceof Integer && paramColumnValue instanceof Double) {
                                return paramColumnValue != null && Double.compare((Double)paramColumnValue, ((Integer)existedColumnValue).doubleValue()) == 0;
                            }
                            if (existedColumnValue instanceof Long && paramColumnValue instanceof Double) {
                                return paramColumnValue != null && Double.compare((Double)paramColumnValue, ((Long)existedColumnValue).doubleValue()) == 0;
                            }
                            if (existedColumnValue instanceof Timestamp && paramColumnValue instanceof String) {
                                String paramColumnValueStr = ((String)paramColumnValue).replace("/", "-");
                                int timeEqual = ((Timestamp)existedColumnValue).compareTo(Timestamp.valueOf(paramColumnValueStr));
                                logger.info("updateRows timestamp compare result:{} equal(existedColumnValue:{}, paramColumnValue:{})", new Object[]{timeEqual, existedColumnValue, paramColumnValue});
                                return timeEqual == 0;
                            }
                            return paramColumnValue != null && paramColumnValue.toString().equals(existedColumnValue.toString());
                        }
                        return paramColumnValue == existedColumnValue;
                    });
                }
                return false;
            }).findFirst();
            if (!matchRow.isPresent() && !"update_or_insert".equalsIgnoreCase((String)masterTableRow.get("update_type"))) {
                throw new DWRuntimeException(String.format("table(%s): there is no data found by neither pk nor bk(%s),row info: %s", modelSchema.getName(), bkOrPkFields, masterTableRow.entrySet()));
            }
            HashMap<String, Object> keyMaps = new HashMap<String, Object>();
            if (matchRow.isPresent()) {
                bkOrPkFields.forEach(field -> keyMaps.put((String)field, ((Map)matchRow.get()).get(field)));
                businessKeys.add(keyMaps);
            }
            Object updateType = masterTableRow.get("update_type");
            Map<Object, Object> updatedMasterTableRow = new HashMap();
            if (updateType != null) {
                masterTableRow.remove("update_type");
                switch (updateType.toString().toLowerCase()) {
                    case "update": {
                        if (matchRow.isPresent()) {
                            updatedMasterTableRow = this.executeUpdateSql(masterTableRow, modelSchema, keyMaps);
                            break;
                        }
                        throw new DWRuntimeException(String.format("there is no data found by neither pk nor bk for row {%s} ", masterTableRow.entrySet()));
                    }
                    case "update_or_insert": {
                        if (matchRow.isPresent()) {
                            updatedMasterTableRow = this.executeUpdateSql(masterTableRow, modelSchema, keyMaps);
                            break;
                        }
                        ArrayList<Map<String, Object>> masterTableOriginalRows = new ArrayList<Map<String, Object>>();
                        masterTableOriginalRows.add(masterTableOriginalRow);
                        List<Map<String, Object>> keyMap = this.insertRows(modelSchema, masterTableOriginalRows);
                        businessKeys.addAll(keyMap);
                        continue block8;
                    }
                }
            } else {
                ArrayList<Map<String, Object>> msterTableRowLst = new ArrayList<Map<String, Object>>();
                msterTableRowLst.add(masterTableRow);
                updatedMasterTableRow = this.executeUpdateSql(masterTableRow, modelSchema, keyMaps);
            }
            Map<Object, Object> tmp = updatedMasterTableRow;
            Map<String, Object> collectionQuoteRelations = this.generateCollectionQuoteRelations(modelSchema);
            childTableRowMap.forEach((subTableName, subTableRows) -> {
                if (CollectionUtils.isNotEmpty((Collection)subTableRows)) {
                    Map quoteRelations = (Map)collectionQuoteRelations.get(subTableName);
                    if (MapUtils.isEmpty((Map)quoteRelations)) {
                        throw new DWRuntimeException(String.format("can't find collection associatedInfo of subtable '%s' ", subTableName));
                    }
                    quoteRelations.keySet().forEach(field -> subTableRows.forEach(subTableRow -> subTableRow.put(field, tmp.get(field))));
                }
            });
            childTableRowMap.forEach((subTableName, subTableRows) -> {
                Optional<ModelSchemaDTO> childModelSchema = modelSchema.getChildren().stream().filter(model -> model.getName().equals(subTableName)).findFirst();
                if (childModelSchema.isPresent() && CollectionUtils.isNotEmpty((Collection)subTableRows)) {
                    this.updateChildrenTableRows(childModelSchema.get(), (List<Map<String, Object>>)subTableRows, existedDatas);
                }
            });
        }
        return businessKeys;
    }

    public void updateChildrenTableRows(ModelSchemaDTO childModelSchema, List<Map<String, Object>> childTableParamDatas, Map<String, List<Map<String, Object>>> existedDatas) {
        ArrayList<Map<String, Object>> deleteRowBkOrPks = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> createTableRows = new ArrayList<Map<String, Object>>();
        HashMap<String, List> subChildrenUpdateRows = new HashMap<String, List>();
        for (Map<String, Object> childrenTableRow : childTableParamDatas) {
            List<String> bkOrPkFields = this.getPkOrBkFieldsByModelSchema(childrenTableRow, childModelSchema);
            LinkedHashMap<String, Object> childTableOriginalRow = new LinkedHashMap<String, Object>(childrenTableRow);
            List<String> subChildTableNames = childModelSchema.getChildren().stream().map(ModelSchemaDTO::getName).collect(Collectors.toList());
            HashMap<String, List> subChildTableRowMap = new HashMap<String, List>();
            subChildTableNames.forEach(childTableName -> {
                if (childrenTableRow.keySet().contains(childTableName)) {
                    subChildTableRowMap.put((String)childTableName, (List)childrenTableRow.get(childTableName));
                    childrenTableRow.remove(childTableName);
                }
            });
            ParamValidateUtil.filterParam(childrenTableRow, childModelSchema);
            Object updateType = childrenTableRow.get("update_type");
            if (updateType != null) {
                childrenTableRow.remove("update_type");
                ArrayList existedChildrenTableRows = existedDatas.get(childModelSchema.getName()) == null ? new ArrayList() : existedDatas.get(childModelSchema.getName());
                Optional<Map> matchRow = existedChildrenTableRows.stream().filter(existedChildrenTableRow -> {
                    if (CollectionUtils.isNotEmpty((Collection)bkOrPkFields)) {
                        return bkOrPkFields.stream().allMatch(field -> {
                            Object paramColumnValue = null;
                            paramColumnValue = DWTenantUtils.getTenantColumnName().equals(field) ? (Object)DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()) : (Object)childrenTableRow.get(field);
                            Object dbColumnValue = existedChildrenTableRow.get(field);
                            if (dbColumnValue != null) {
                                if (dbColumnValue instanceof Integer && paramColumnValue instanceof Double) {
                                    return paramColumnValue != null && Double.compare((Double)paramColumnValue, ((Integer)dbColumnValue).doubleValue()) == 0;
                                }
                                if (dbColumnValue instanceof Long && paramColumnValue instanceof Double) {
                                    return paramColumnValue != null && Double.compare((Double)paramColumnValue, ((Long)dbColumnValue).doubleValue()) == 0;
                                }
                                return paramColumnValue != null && paramColumnValue.toString().equals(dbColumnValue.toString());
                            }
                            return dbColumnValue == paramColumnValue;
                        });
                    }
                    return false;
                }).findFirst();
                switch (updateType.toString().toLowerCase()) {
                    case "delete": {
                        if (!matchRow.isPresent()) break;
                        Map<Object, Object> bkOrPk = this.getBKOrPKParamByModelSchema(childModelSchema, childrenTableRow);
                        if (MapUtils.isNotEmpty(bkOrPk)) {
                            deleteRowBkOrPks.add(bkOrPk);
                            break;
                        }
                        logger.error("can't find bkOrPk fields map in subTable row:{}", childrenTableRow.entrySet());
                        break;
                    }
                    case "update": {
                        Map<String, Object> collectionQuoteRelations;
                        Map<String, Object> childrenTableRowMap;
                        if (!matchRow.isPresent()) break;
                        ModelDataUtil.dealUpdateMgmtFields(childrenTableRow);
                        Map<Object, Object> bkOrPk = this.getBKOrPKParamByModelSchema(childModelSchema, childrenTableRow);
                        if (MapUtils.isNotEmpty(bkOrPk)) {
                            childrenTableRowMap = this.executeUpdateSql(childrenTableRow, childModelSchema, bkOrPk);
                            collectionQuoteRelations = this.generateCollectionQuoteRelations(childModelSchema);
                            subChildTableRowMap.forEach((subChildTableName, subChildTableRows) -> {
                                if (CollectionUtils.isNotEmpty((Collection)subChildTableRows)) {
                                    Map quoteRelations = (Map)collectionQuoteRelations.get(subChildTableName);
                                    if (MapUtils.isEmpty((Map)quoteRelations)) {
                                        throw new DWRuntimeException(String.format("can't find collection associatedInfo of subChildTable '%s' ", subChildTableName));
                                    }
                                    quoteRelations.keySet().forEach(field -> subChildTableRows.forEach(subTableRow -> subTableRow.put(field, childrenTableRowMap.get(field))));
                                    if (subChildrenUpdateRows.get(subChildTableName) != null) {
                                        ((List)subChildrenUpdateRows.get(subChildTableName)).addAll(subChildTableRows);
                                    } else {
                                        subChildrenUpdateRows.put((String)subChildTableName, (List)subChildTableRows);
                                    }
                                }
                            });
                            break;
                        }
                        logger.error("can't find bkOrPk fields map in subTable row:{}", childrenTableRow.entrySet());
                        break;
                    }
                    case "insert": {
                        createTableRows.add(childTableOriginalRow);
                        break;
                    }
                    case "del_redundant_adjust": {
                        Map<String, Object> collectionQuoteRelations;
                        Map<String, Object> childrenTableRowMap;
                        Map<Object, Object> bkOrPk;
                        if (matchRow.isPresent()) {
                            ModelDataUtil.dealUpdateMgmtFields(childrenTableRow);
                            bkOrPk = this.getBKOrPKParamByModelSchema(childModelSchema, childrenTableRow);
                            if (MapUtils.isNotEmpty(bkOrPk)) {
                                childrenTableRowMap = this.executeUpdateSql(childrenTableRow, childModelSchema, bkOrPk);
                                collectionQuoteRelations = this.generateCollectionQuoteRelations(childModelSchema);
                                subChildTableRowMap.forEach((subChildTableName, subChildTableRows) -> {
                                    if (CollectionUtils.isNotEmpty((Collection)subChildTableRows)) {
                                        Map quoteRelations = (Map)collectionQuoteRelations.get(subChildTableName);
                                        if (MapUtils.isEmpty((Map)quoteRelations)) {
                                            throw new DWRuntimeException(String.format("can't find collection associatedInfo of subChildTable '%s' ", subChildTableName));
                                        }
                                        quoteRelations.keySet().forEach(field -> subChildTableRows.forEach(subTableRow -> subTableRow.put(field, childrenTableRowMap.get(field))));
                                        if (subChildrenUpdateRows.get(subChildTableName) != null) {
                                            ((List)subChildrenUpdateRows.get(subChildTableName)).addAll(subChildTableRows);
                                        } else {
                                            subChildrenUpdateRows.put((String)subChildTableName, (List)subChildTableRows);
                                        }
                                    }
                                });
                                break;
                            }
                            logger.error("can't find bkOrPk fields map in subTable row:{}", childrenTableRow.entrySet());
                            break;
                        }
                        createTableRows.add(childTableOriginalRow);
                        break;
                    }
                    case "del_then_add": {
                        Map<Object, Object> bkOrPk;
                        if (matchRow.isPresent()) {
                            bkOrPk = new HashMap();
                            bkOrPkFields.forEach(field -> bkOrPk.put(field, childrenTableRow.get(field)));
                            deleteRowBkOrPks.add(bkOrPk);
                            createTableRows.add(childTableOriginalRow);
                            break;
                        }
                        createTableRows.add(childTableOriginalRow);
                        break;
                    }
                }
                continue;
            }
            List<ModelFieldDTO> quoteFields = childModelSchema.getFields().stream().filter(modelField -> ModelFieldRelationTypeEnum.valueOf(modelField.getType()) == ModelFieldRelationTypeEnum.QUOTE).collect(Collectors.toList());
            HashMap quoteFieldsMap = new HashMap();
            if (CollectionUtils.isNotEmpty(quoteFields)) {
                quoteFields.forEach(field -> quoteFieldsMap.put(field.getFieldId(), childrenTableRow.get(field.getFieldId())));
            }
            if (MapUtils.isNotEmpty(quoteFieldsMap)) {
                deleteRowBkOrPks.add(quoteFieldsMap);
            }
            createTableRows.add(childTableOriginalRow);
        }
        if (CollectionUtils.isNotEmpty(deleteRowBkOrPks)) {
            this.deleteRows(childModelSchema, deleteRowBkOrPks);
        }
        if (CollectionUtils.isNotEmpty(createTableRows)) {
            this.insertRows(childModelSchema, createTableRows);
        }
        if (MapUtils.isNotEmpty(subChildrenUpdateRows)) {
            subChildrenUpdateRows.forEach((subChildrenTableName, subChildrenTableRows) -> this.updateChildrenTableRows(this.getModelSchema(childModelSchema, (String)subChildrenTableName), (List<Map<String, Object>>)subChildrenTableRows, existedDatas));
        }
    }

    public Map<String, List<Map<String, Object>>> getDeleteRows(Map<String, List<Map<String, Object>>> existedDatas, Map<String, List<Map<String, Object>>> paramterDatas, ModelSchemaDTO modelSchema) {
        LinkedHashMap<String, List<Map<String, Object>>> result = new LinkedHashMap<String, List<Map<String, Object>>>();
        List<ModelSchemaDTO> childrenModelSchema = modelSchema.getChildren();
        List<String> childrenTableNames = ModelSchemaUtil.getChildrenName(childrenModelSchema);
        existedDatas.keySet().stream().filter(childrenTableNames::contains).forEach(tableName -> {
            ModelSchemaDTO modelSchema1 = this.getModelSchema(modelSchema, (String)tableName);
            List<Map<String, Object>> paramDatasBkOrPkMaps = this.getBKOrPKParamsByModelSchema(modelSchema1, (List)paramterDatas.get(tableName));
            List<Map<String, Object>> existDatasBkOrPkMaps = this.getBKOrPKParamsByModelSchema(modelSchema1, (List)existedDatas.get(tableName));
            List deleteRows = existDatasBkOrPkMaps.stream().filter(existedData -> paramDatasBkOrPkMaps.stream().noneMatch(paramData -> paramData.entrySet().stream().allMatch(paramEntry -> {
                Object paramColumnValue = null;
                paramColumnValue = DWTenantUtils.getTenantColumnName().equals(paramEntry.getKey()) ? (Object)DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()) : (Object)paramEntry.getValue();
                Object dbColumnValue = existedData.get(paramEntry.getKey());
                if (dbColumnValue != null) {
                    if (dbColumnValue instanceof Integer && paramColumnValue instanceof Double) {
                        return paramColumnValue != null && Double.compare((Double)paramColumnValue, ((Integer)dbColumnValue).doubleValue()) == 0;
                    }
                    if (dbColumnValue instanceof Long && paramColumnValue instanceof Double) {
                        return paramColumnValue != null && Double.compare((Double)paramColumnValue, ((Long)dbColumnValue).doubleValue()) == 0;
                    }
                    return paramColumnValue != null && paramColumnValue.toString().equals(dbColumnValue.toString());
                }
                return dbColumnValue == paramColumnValue;
            }))).collect(Collectors.toList());
            logger.debug("{}[getDeleteRows] table({} will be deleted rows size({})", new Object[]{CLASS_LOG_TAG, tableName, deleteRows.size()});
            result.put((String)tableName, deleteRows);
        });
        return result;
    }

    public List<Map<String, Object>> getBKOrPKParamsByModelSchema(ModelSchemaDTO modelSchema, List<Map<String, Object>> params) {
        ArrayList<Map<String, Object>> bkOrPks = new ArrayList<Map<String, Object>>();
        if (CollectionUtils.isNotEmpty(params)) {
            params.forEach(param -> {
                List<String> bkOrPkFields = this.getPkOrBkFieldsByModelSchema((Map<String, Object>)param, modelSchema);
                if (CollectionUtils.isNotEmpty(bkOrPkFields)) {
                    HashMap bkOrPk = new HashMap();
                    bkOrPkFields.forEach(field -> {
                        if (DWTenantUtils.getTenantColumnName().equals(field)) {
                            bkOrPk.put(field, DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
                        } else {
                            bkOrPk.put(field, param.get(field));
                        }
                    });
                    bkOrPks.add(bkOrPk);
                }
            });
        }
        return bkOrPks;
    }

    public List<Map<String, Object>> retrieveBKOrPKData(ModelSchemaDTO modelSchema, List<Map<String, Object>> params) {
        ArrayList<Map<String, Object>> bkOrPks = new ArrayList<Map<String, Object>>();
        if (CollectionUtils.isNotEmpty(params)) {
            params.forEach(param -> {
                List<String> bkOrPkFields = this.getConstrainPKOrBKFieldsByModelSchema((Map<String, Object>)param, modelSchema);
                if (CollectionUtils.isNotEmpty(bkOrPkFields)) {
                    HashMap bkOrPk = new HashMap();
                    bkOrPkFields.forEach(field -> {
                        if (DWTenantUtils.getTenantColumnName().equals(field)) {
                            bkOrPk.put(field, DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
                        } else {
                            bkOrPk.put(field, param.get(field));
                        }
                    });
                    bkOrPks.add(bkOrPk);
                }
            });
        }
        return bkOrPks;
    }

    public Map<String, Object> getBKOrPKParamByModelSchema(ModelSchemaDTO modelSchema, Map<String, Object> param) {
        List<String> bkOrPkFields;
        HashMap<String, Object> bkOrPk = new HashMap<String, Object>();
        if (MapUtils.isNotEmpty(param) && CollectionUtils.isNotEmpty(bkOrPkFields = this.getPkOrBkFieldsByModelSchema(param, modelSchema))) {
            bkOrPkFields.forEach(field -> {
                if (DWTenantUtils.getTenantColumnName().equals(field)) {
                    bkOrPk.put((String)field, DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
                } else {
                    bkOrPk.put((String)field, param.get(field));
                }
            });
        }
        return bkOrPk;
    }

    public void deleteRows(ModelSchemaDTO modelSchema, List<Map<String, Object>> businessKeys) {
        this.deleteRows("delete @targetTable@ from @targetTable@ @joinTable@", modelSchema, businessKeys, true);
    }

    public void deleteSubRows(ModelSchemaDTO modelSchema, List<Map<String, Object>> businessKeys) {
        this.deleteRows("delete @targetTable@ from @targetTable@ @joinTable@", modelSchema, businessKeys, false);
    }

    public void deleteRows(String sql, ModelSchemaDTO modelSchema, List<Map<String, Object>> businessKeys, boolean deleteCurrentLevel) {
        Map<String, Object> collectionQuoteRelations;
        logger.debug("{}[deleteRows] ==== process table({}) ====", (Object)CLASS_LOG_TAG, (Object)modelSchema.getName());
        String deleteSql = "";
        Map<String, ModelSchemaDTO> publishedModelSchema = ModelSchemaUtil.getModelSchemaMap(modelSchema);
        if (deleteCurrentLevel && CollectionUtils.isNotEmpty(businessKeys)) {
            deleteSql = " delete from  " + modelSchema.getName() + " where ";
            ArrayList orCondition = new ArrayList();
            ModelSchemaDTO currentModelSchema = publishedModelSchema.get(modelSchema.getName());
            businessKeys.forEach(businessKey -> {
                ArrayList andConditions = new ArrayList();
                businessKey.forEach((key, val) -> {
                    Object convertedValue = DWTenantUtils.getTenantColumnName().equals(key) ? DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()) : DataEntryDataUtil.getSqlValue(key, val, currentModelSchema);
                    andConditions.add(String.format("%s.%s = %s", modelSchema.getName(), key, convertedValue));
                });
                orCondition.add("(" + String.join((CharSequence)" and ", andConditions) + ")");
            });
            deleteSql = deleteSql + "(" + String.join((CharSequence)" or ", orCondition) + ")";
            if (DWTenantUtils.isTenantenabled()) {
                deleteSql = deleteSql + String.format(" and %s = %s", DWTenantUtils.getTenantColumnName(), DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
            }
        }
        if (MapUtils.isNotEmpty(collectionQuoteRelations = this.generateCollectionQuoteRelations(modelSchema))) {
            Set<String> tableNames = collectionQuoteRelations.keySet();
            String parentTableName = modelSchema.getName();
            for (String tableName : tableNames) {
                Map quoteField = (Map)collectionQuoteRelations.get(tableName);
                String deleteQuoteSql = sql;
                ArrayList joinConditions = new ArrayList();
                quoteField.forEach((key, val) -> {
                    if (!key.equals("#subRelation")) {
                        joinConditions.add(String.format("%s.%s = %s.%s", modelSchema.getName(), key, tableName, key));
                    }
                });
                String tmp = String.format(" @joinTable@ left join %s on ", parentTableName) + String.join((CharSequence)" and ", joinConditions);
                if (CollectionUtils.isNotEmpty(businessKeys)) {
                    ModelSchemaDTO collectionQuoteModelSchema = publishedModelSchema.get(modelSchema.getName());
                    deleteQuoteSql = deleteQuoteSql + " where ";
                    ArrayList orCondition = new ArrayList();
                    businessKeys.forEach(businessKey -> {
                        ArrayList andConditions = new ArrayList();
                        businessKey.forEach((key, val) -> {
                            Object convertedValue = DWTenantUtils.getTenantColumnName().equals(key) ? DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()) : DataEntryDataUtil.getSqlValue(key, val, collectionQuoteModelSchema);
                            andConditions.add(String.format("%s.%s = %s", parentTableName, key, convertedValue));
                        });
                        orCondition.add("(" + String.join((CharSequence)" and ", andConditions) + ")");
                    });
                    deleteQuoteSql = deleteQuoteSql + "(" + String.join((CharSequence)" or ", orCondition) + ")";
                    if (DWTenantUtils.isTenantenabled()) {
                        deleteQuoteSql = deleteQuoteSql + String.format(" and %s.%s = %s", tableName, DWTenantUtils.getTenantColumnName(), DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
                    }
                }
                deleteQuoteSql = deleteQuoteSql.replace("@joinTable@", tmp);
                Set keys = quoteField.keySet();
                for (String key2 : keys) {
                    Optional<ModelSchemaDTO> optionalSubModelSchema;
                    if (!key2.equals("#subRelation") || !(optionalSubModelSchema = modelSchema.getChildren().stream().filter(model -> model.getName().equals(tableName)).findFirst()).isPresent()) continue;
                    ModelSchemaDTO subModelSchema = optionalSubModelSchema.get();
                    this.deleteRows(deleteQuoteSql, subModelSchema, new ArrayList<Map<String, Object>>(), false);
                }
                DWDataSetOperationOption option = new DWDataSetOperationOption();
                option.setManagementFieldEnabled(false);
                option.setTenantEnabled(false);
                this.dao.update((IDWSQLOptions)option, deleteQuoteSql.replace("@targetTable@", tableName).replace("@joinTable@", ""), new Object[0]);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)deleteSql)) {
            DWDataSetOperationOption option = new DWDataSetOperationOption();
            option.setManagementFieldEnabled(false);
            option.setTenantEnabled(false);
            this.dao.update((IDWSQLOptions)option, deleteSql, new Object[0]);
        }
    }

    public Map<String, Object> updateMainRowsByQueryConditions(List<QueryConditionDTO> queryConditions, ModelSchemaDTO modelSchema, List<Map<String, Object>> mainTableRows, Map<String, List<ModelApiField>> tileApiConfig) {
        DWQueryCondition dwQueryCondition = new DWQueryCondition();
        DWBatchCondition dwBatchCondition = new DWBatchCondition();
        this.queryConditionUtils.generateCondition(queryConditions.iterator(), dwQueryCondition, "");
        this.queryConditionUtils.generateCondition(queryConditions.iterator(), (DWQueryCondition)dwBatchCondition, "");
        DWDataSet dataset = new DWDataSet();
        DWDataTable dwDataTable = dataset.newTable(modelSchema.getName());
        mainTableRows.forEach(masterRow -> dwDataTable.newRow(masterRow).setState("U").setCondition((DWQueryCondition)dwBatchCondition));
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        option.getUpdateOption().setEnableBatchCondition(true);
        this.dao.execute(dataset, option);
        DWQueryInfo info = new DWQueryInfo(modelSchema.getName());
        info.setCondition(dwQueryCondition);
        return this.getListForInnerInvoke(info, new DWDataSetOperationOption(), false, tileApiConfig);
    }

    public Map<String, List<Map<String, Object>>> queryDatas(List<Map<String, Object>> masterTableParamDatas, ModelSchemaDTO modelSchema) {
        HashMap<String, List<Map<String, Object>>> allTablesDatas = new HashMap<String, List<Map<String, Object>>>();
        List<Map<String, Object>> bkOrPks = this.getBKOrPKParamsByModelSchema(modelSchema, masterTableParamDatas);
        DWQueryInfo queryInfo = new DWQueryInfo(modelSchema.getName());
        if (CollectionUtils.isNotEmpty(bkOrPks)) {
            DWQueryCondition condition = new DWQueryCondition();
            condition.ORJoin();
            bkOrPks.forEach(keyMap -> {
                DWQueryCondition subCondition = new DWQueryCondition();
                keyMap.forEach((key, value) -> subCondition.addFieldInfo(modelSchema.getName() + "." + key, DWQueryValueOperator.Equals, new Object[]{value}));
                condition.addCondition(subCondition);
            });
            queryInfo.setCondition(condition);
        }
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        DWDataSet queryDataSet = this.dao.select(queryInfo, option);
        allTablesDatas.put(modelSchema.getName(), (List)queryDataSet.getSourceMap().get(modelSchema.getName()));
        List<ModelSchemaDTO> childModelSchemas = modelSchema.getChildren();
        if (CollectionUtils.isNotEmpty(childModelSchemas)) {
            childModelSchemas.forEach(childModelSchema -> {
                Map<String, List<Map<String, Object>>> childrenDatas = this.queryChildrenDatas(bkOrPks, modelSchema.getName(), (ModelSchemaDTO)childModelSchema);
                childrenDatas.forEach((key, value) -> {
                    if (CollectionUtils.isNotEmpty((Collection)((Collection)allTablesDatas.get(key)))) {
                        ((List)allTablesDatas.get(key)).addAll(value);
                    } else {
                        allTablesDatas.put((String)key, (List<Map<String, Object>>)value);
                    }
                });
            });
        }
        return allTablesDatas;
    }

    public Map<String, List<Map<String, Object>>> queryChildrenDatas(List<Map<String, Object>> masterTableKeys, String masterTableName, ModelSchemaDTO childModelSchema) {
        HashMap<String, List<Map<String, Object>>> allChildrenDatas = new HashMap<String, List<Map<String, Object>>>();
        logger.debug("{}[queryChildrenDatas] === current:{}", (Object)CLASS_LOG_TAG, (Object)masterTableName);
        DWQueryInfo queryInfo = new DWQueryInfo(childModelSchema.getName());
        queryInfo.addSelectField(new String[]{childModelSchema.getName() + ".*"});
        List quoteQueryFields = childModelSchema.getFields().stream().filter(modelField -> ModelFieldRelationTypeEnum.valueOf(modelField.getType()) == ModelFieldRelationTypeEnum.QUOTE).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(quoteQueryFields)) {
            Map<String, List<ModelFieldDTO>> quoteTableMap = quoteQueryFields.stream().collect(Collectors.groupingBy(modelField -> modelField.getAssociatedInfo().getTableName()));
            quoteTableMap.forEach((tableName, quoteFields) -> {
                ArrayList<DWOnColumn> conditions = new ArrayList<DWOnColumn>();
                for (int i = 0; i < quoteFields.size(); ++i) {
                    ModelFieldDTO quoteQueryField = (ModelFieldDTO)quoteFields.get(i);
                    String fieldId = quoteQueryField.getFieldId();
                    String quoteFieldId = quoteQueryField.getAssociatedInfo().getJoinField() == null ? quoteQueryField.getFieldId() : quoteQueryField.getAssociatedInfo().getJoinField().getFieldId();
                    conditions.add(new DWOnColumn(quoteFieldId, DWQueryValueOperator.Equals, fieldId));
                }
                queryInfo.setJoinOnColumn(DWQueryJoinRelation.LeftJoin, new DWQueryJoinTable(tableName), conditions.toArray(new DWOnColumn[conditions.size()]));
            });
        }
        if (CollectionUtils.isNotEmpty(masterTableKeys)) {
            DWQueryCondition condition = new DWQueryCondition();
            condition.ORJoin();
            masterTableKeys.forEach(masterTableKeyMap -> {
                DWQueryCondition subCondition = new DWQueryCondition();
                masterTableKeyMap.forEach((key, value) -> {
                    if (DWTenantUtils.getTenantColumnName().equals(key)) {
                        value = DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey());
                    }
                    subCondition.addFieldInfo(masterTableName + "." + key, DWQueryValueOperator.Equals, new Object[]{value});
                });
                condition.addCondition(subCondition);
            });
            queryInfo.setCondition(condition);
        }
        DWDataSet queryDataSet = this.dao.select(queryInfo);
        List currentTableDatas = (List)queryDataSet.getSourceMap().get(childModelSchema.getName());
        allChildrenDatas.put(childModelSchema.getName(), currentTableDatas);
        List<ModelSchemaDTO> subChildModelSchemas = childModelSchema.getChildren();
        if (CollectionUtils.isNotEmpty(subChildModelSchemas)) {
            ArrayList bkOrPks = new ArrayList();
            Optional<ModelIndexDTO> bkIndex = childModelSchema.getIndex().stream().filter(index -> IndexTypeEnum.UNIQUE_INDEX.getIndexChar().equalsIgnoreCase(index.getType())).findAny();
            List pkFields = childModelSchema.getFields().stream().filter(ModelFieldDTO::isPk).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(pkFields)) {
                currentTableDatas.stream().forEach(masterTableRow -> {
                    HashMap pk = new HashMap();
                    pkFields.forEach(field -> pk.put(field.getFieldId(), masterTableRow.get(field.getFieldId())));
                    bkOrPks.add(pk);
                });
            } else if (bkIndex.isPresent()) {
                currentTableDatas.stream().forEach(masterTableRow -> {
                    HashMap bk = new HashMap();
                    ((ModelIndexDTO)bkIndex.get()).getMember().forEach(field -> bk.put(field, masterTableRow.get(field)));
                    bkOrPks.add(bk);
                });
            }
            if (CollectionUtils.isNotEmpty(bkOrPks)) {
                subChildModelSchemas.forEach(eachModelSchema -> {
                    Map<String, List<Map<String, Object>>> childrenTableDatas = this.queryChildrenDatas(bkOrPks, eachModelSchema.getName(), (ModelSchemaDTO)eachModelSchema);
                    if (MapUtils.isNotEmpty(childrenTableDatas)) {
                        childrenTableDatas.forEach((tableName, datas) -> {
                            if (CollectionUtils.isNotEmpty((Collection)((Collection)allChildrenDatas.get(tableName)))) {
                                ((List)allChildrenDatas.get(tableName)).addAll(datas);
                            } else {
                                allChildrenDatas.put((String)tableName, (List<Map<String, Object>>)datas);
                            }
                        });
                    }
                });
            }
        }
        return allChildrenDatas;
    }

    public ModelSchemaDTO getModelSchema(ModelSchemaDTO masterModelSchema, String tableName) {
        ModelSchemaDTO result;
        block2: {
            ModelSchemaDTO modelSchema;
            result = null;
            if (masterModelSchema.getName().equalsIgnoreCase(tableName)) {
                return masterModelSchema;
            }
            if (!CollectionUtils.isNotEmpty(masterModelSchema.getChildren())) break block2;
            Iterator<ModelSchemaDTO> iterator = masterModelSchema.getChildren().iterator();
            while (iterator.hasNext() && (result = this.getModelSchema(modelSchema = iterator.next(), tableName)) == null) {
            }
        }
        return result;
    }

    public Map<String, Object> getDatas(boolean single, String targetTableName, List<Map<String, Object>> businessKeys, Map<String, List<ModelApiField>> tileApiConfig) {
        Map<String, Object> returnValue;
        if (single) {
            DWQueryInfo queryInfo = new DWQueryInfo();
            queryInfo.setTableName(targetTableName);
            DWQueryCondition dwQueryCondition = new DWQueryCondition();
            dwQueryCondition.ORJoin();
            queryInfo.setCondition(dwQueryCondition);
            businessKeys.forEach(item -> {
                DWQueryCondition condition = new DWQueryCondition();
                item.forEach((key, val) -> {
                    if (DWTenantUtils.getTenantColumnName().equals(key)) {
                        condition.addEqualInfo(key, DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
                    } else {
                        condition.addEqualInfo(key, val);
                    }
                });
                dwQueryCondition.addCondition(condition);
            });
            returnValue = this.getForInnerInvoke(queryInfo, tileApiConfig);
        } else {
            DWQueryInfo queryInfo = new DWQueryInfo();
            queryInfo.setTableName(targetTableName);
            DWQueryCondition dwQueryCondition = new DWQueryCondition();
            dwQueryCondition.ORJoin();
            queryInfo.setCondition(dwQueryCondition);
            businessKeys.forEach(item -> {
                DWQueryCondition condition = new DWQueryCondition();
                item.forEach((key, val) -> {
                    if (DWTenantUtils.getTenantColumnName().equals(key)) {
                        condition.addEqualInfo(key, DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
                    } else {
                        condition.addEqualInfo(key, val);
                    }
                });
                dwQueryCondition.addCondition(condition);
            });
            returnValue = this.getListForInnerInvoke(queryInfo, new DWDataSetOperationOption(), false, tileApiConfig);
        }
        return returnValue;
    }

    public List<String> getPkOrBkFieldsByModelSchema(Map<String, Object> paramterRow, ModelSchemaDTO modelSchemaDTO) {
        ArrayList<String> bkOrPkFields = new ArrayList<String>();
        Optional<ModelIndexDTO> bkIndex = modelSchemaDTO.getIndex().stream().filter(index -> IndexTypeEnum.UNIQUE_INDEX.getIndexChar().equalsIgnoreCase(index.getType())).findAny();
        List pkFields = modelSchemaDTO.getFields().stream().filter(ModelFieldDTO::isPk).collect(Collectors.toList());
        if (!bkIndex.isPresent() && CollectionUtils.isNotEmpty(pkFields)) {
            throw new DWRuntimeException(String.format("there is neither PK nor BK in table '%s'", modelSchemaDTO.getName()));
        }
        if (bkIndex.isPresent()) {
            ArrayList bkValues = new ArrayList();
            List<String> bkIndexMember = bkIndex.get().getMember();
            bkIndexMember.forEach(field -> bkValues.add(paramterRow.get(field)));
            if (bkValues.stream().allMatch(Objects::isNull)) {
                ArrayList pkValues = new ArrayList();
                if (CollectionUtils.isNotEmpty(pkFields)) {
                    List<String> pkFieldStr = pkFields.stream().map(ModelFieldDTO::getFieldId).collect(Collectors.toList());
                    pkFieldStr.forEach(field -> pkValues.add(paramterRow.get(field)));
                    if (pkValues.stream().allMatch(Objects::isNull)) {
                        if ("update_or_insert".equalsIgnoreCase((String)paramterRow.get("update_type")) || "insert".equalsIgnoreCase((String)paramterRow.get("update_type"))) {
                            return bkOrPkFields;
                        }
                    } else {
                        bkOrPkFields.addAll(pkFieldStr);
                    }
                }
            } else {
                bkOrPkFields.addAll(bkIndexMember);
            }
        } else {
            ArrayList pkValues = new ArrayList();
            if (CollectionUtils.isNotEmpty(pkFields)) {
                List<String> pkFieldStr = pkFields.stream().map(ModelFieldDTO::getFieldId).collect(Collectors.toList());
                pkFieldStr.forEach(field -> pkValues.add(paramterRow.get(field)));
                if (pkValues.stream().allMatch(Objects::isNull)) {
                    throw new DWRuntimeException(String.format("PK fields can't be all null at the same time in row: %s", paramterRow.entrySet()));
                }
                bkOrPkFields.addAll(pkFieldStr);
            }
        }
        return bkOrPkFields;
    }

    public List<String> getConstrainPKOrBKFieldsByModelSchema(Map<String, Object> parameterRow, ModelSchemaDTO modelSchemaDTO) {
        ArrayList<String> bkOrPkFields = new ArrayList<String>();
        Optional<ModelIndexDTO> bkIndex = modelSchemaDTO.getIndex().stream().filter(index -> IndexTypeEnum.UNIQUE_INDEX.getIndexChar().equalsIgnoreCase(index.getType())).findAny();
        List pkFieldsOfModelSchema = modelSchemaDTO.getFields().stream().filter(ModelFieldDTO::isPk).collect(Collectors.toList());
        if (!bkIndex.isPresent() && CollectionUtils.isEmpty(pkFieldsOfModelSchema)) {
            throw new IllegalArgumentException(String.format(ResourceBundleUtils.getString("paramValidate.pkAndBkNotExist"), modelSchemaDTO.getName()));
        }
        if (bkIndex.isPresent()) {
            ArrayList bkValues = new ArrayList();
            bkIndex.get().getMember().forEach(field -> bkValues.add(parameterRow.get(field)));
            if (bkValues.stream().allMatch(Objects::isNull)) {
                ArrayList pkValues = new ArrayList();
                if (CollectionUtils.isNotEmpty(pkFieldsOfModelSchema)) {
                    List<String> pkFieldStr = pkFieldsOfModelSchema.stream().map(ModelFieldDTO::getFieldId).collect(Collectors.toList());
                    pkFieldStr.forEach(field -> pkValues.add(parameterRow.get(field)));
                    if (pkValues.stream().allMatch(Objects::isNull)) {
                        if ("update_or_insert".equalsIgnoreCase((String)parameterRow.get("update_type")) || "insert".equalsIgnoreCase((String)parameterRow.get("update_type"))) {
                            return bkOrPkFields;
                        }
                    } else {
                        bkOrPkFields.addAll(pkFieldStr);
                    }
                }
            } else {
                bkOrPkFields.addAll(bkIndex.get().getMember());
            }
        } else {
            ArrayList pkValues = new ArrayList();
            if (CollectionUtils.isNotEmpty(pkFieldsOfModelSchema)) {
                List<String> pkModelFields = pkFieldsOfModelSchema.stream().map(ModelFieldDTO::getFieldId).collect(Collectors.toList());
                pkModelFields.forEach(pkField -> pkValues.add(parameterRow.get(pkField)));
                if (pkValues.stream().allMatch(Objects::isNull)) {
                    throw new IllegalArgumentException(String.format("PK fields can't be all null at the same time in row: %s", parameterRow.entrySet()));
                }
                bkOrPkFields.addAll(pkModelFields);
            }
        }
        return bkOrPkFields;
    }

    public Map<String, Object> executeUpdateSql(Map<String, Object> rowData, ModelSchemaDTO modelSchema, Map<String, Object> params) {
        String tableName = modelSchema.getName();
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        StringBuilder updateBuilder = new StringBuilder();
        updateBuilder.append("update `").append(tableName).append("` ").append(" set ");
        ArrayList updateFields = new ArrayList();
        ArrayList updateValues = new ArrayList();
        if (MapUtils.isNotEmpty(rowData)) {
            List<ModelFieldDTO> modelFields = modelSchema.getFields();
            List modelFieldIds = modelFields.stream().map(ModelFieldDTO::getFieldId).collect(Collectors.toList());
            rowData.forEach((key, value) -> {
                if (modelFieldIds.contains(key)) {
                    updateFields.add("`" + key + "` =?");
                    updateValues.add(value);
                }
            });
            updateBuilder.append(String.join((CharSequence)",", updateFields));
        }
        StringBuilder conditionBuilder = new StringBuilder();
        ArrayList conditionFields = new ArrayList();
        ArrayList conditionValues = new ArrayList();
        if (MapUtils.isNotEmpty(params)) {
            params.forEach((key, value) -> {
                conditionFields.add("`" + key + "` =?");
                conditionValues.add(value);
            });
            if (CollectionUtils.isNotEmpty(conditionFields)) {
                conditionBuilder.append(" where ").append(String.join((CharSequence)" and ", conditionFields));
                if (DWTenantUtils.isTenantenabled()) {
                    conditionBuilder.append(" and `" + DWTenantUtils.getTenantColumnName() + "`=?");
                    conditionValues.add(DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
                }
            }
        }
        updateValues.addAll(conditionValues);
        int updatedCount = this.dao.update((IDWSQLOptions)option, updateBuilder.append((CharSequence)conditionBuilder).toString(), updateValues.toArray());
        logger.debug("{}[executeUpdateSql] updated count:{}", (Object)CLASS_LOG_TAG, (Object)updatedCount);
        List result = this.dao.select((IDWSQLOptions)option, "select * from " + tableName + " " + conditionBuilder.toString(), conditionValues.toArray());
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            return (Map)result.get(0);
        }
        return new HashMap<String, Object>();
    }

    public void reorganizeRowCondition(DWQueryCondition condition, List<Map<String, Object>> dataInfos, ModelSchemaDTO modelSchema) {
        dataInfos.forEach(dataInfo -> {
            if (MapUtils.isNotEmpty((Map)dataInfo)) {
                DWQueryCondition rowCondition = new DWQueryCondition();
                dataInfo.forEach((key, val) -> {
                    String[] split = key.split("\\.");
                    String column = split[split.length - 1];
                    ModelFieldDTO modelFieldDTO = modelSchema.getFields().stream().filter(modelSchemaField -> modelSchemaField.getFieldId().equals(column)).findFirst().orElse(null);
                    if (modelFieldDTO != null) {
                        rowCondition.addEqualInfo(key, val);
                    } else {
                        logger.warn("{} field({}) doesn't existed", (Object)CLASS_LOG_TAG, (Object)column);
                        this.queryConditionUtils.addAlwaysNotEqual(rowCondition);
                    }
                });
                condition.addCondition(rowCondition);
            }
        });
    }
}

