/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.utils.DWTenantUtils;
import org.apache.commons.lang3.StringUtils;

public class ApTokenUtil {
    private ApTokenUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String getRequestAppId() {
        String requestAppId = DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-middleware-appid", "");
        return requestAppId;
    }

    public static String getCurrentAppId() {
        String currnetAppId = ApTokenUtil.getRequestAppId();
        if (!StringUtils.isNotEmpty((CharSequence)currnetAppId)) {
            throw new DWRuntimeException("ApTokenUtil", "common_wrong_profile_appid.Covert request header and get digi-middleware-appid=" + currnetAppId);
        }
        currnetAppId = ApTokenUtil.getLcdpAppId(currnetAppId);
        return currnetAppId;
    }

    public static String getLcdpAppId(String inputAppId) {
        return inputAppId.toLowerCase();
    }

    public static String getIAMTenantId() {
        return DWServiceContext.getContext().getProfile().getOrDefault(DWTenantUtils.getIamTenantIdKey(), "");
    }

    public static String getLcdpTenantId(String tenantId) {
        return tenantId.toLowerCase();
    }

    public static String getCurrentTenantId() {
        String tenantId = ApTokenUtil.getIAMTenantId();
        if (!StringUtils.isNotEmpty((CharSequence)tenantId)) {
            boolean bTenantEnabled = DWTenantUtils.isTenantenabled();
            throw new DWRuntimeException("ApTokenUtil", "common_wrong_profile_tenantid. Current tenantEnabled=" + bTenantEnabled);
        }
        tenantId = ApTokenUtil.getLcdpTenantId(tenantId);
        return tenantId;
    }

    public static String getAppIdByApplicationConfig() {
        return DWApplicationConfigUtils.getProperty((String)"appId");
    }
}

