/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.pojo.BindApi;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.utils.ApiTypeBMUtil;
import com.digiwin.lcdp.modeldriven.utils.ApiTypeUtil;
import com.digiwin.lcdp.modeldriven.utils.BindedApiUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BMCodeUtil {
    private static final Logger log = LoggerFactory.getLogger(BMCodeUtil.class);
    private static final String CLASS_LOG_TAG = "[" + BMCodeUtil.class.getSimpleName() + "]";

    private BMCodeUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static BMCode getBMCodeByServiceName(Map<String, BMCode> bmCodes, String serviceName) {
        Optional<String> optionalMatchedServiceName = bmCodes.keySet().stream().filter(bmCodeServiceName -> StringUtils.equals((CharSequence)bmCodeServiceName, (CharSequence)serviceName)).findFirst();
        if (optionalMatchedServiceName.isPresent()) {
            return bmCodes.get(serviceName);
        }
        return null;
    }

    public static BMCode getBMCodeByModelCode(Map<String, BMCode> bmCodes, String modelCode) {
        BMCode returnValue = null;
        Collection<BMCode> allBMCodes = bmCodes.values();
        Optional<BMCode> optionalMatchedBMCode = allBMCodes.stream().filter(bmCode -> StringUtils.equals((CharSequence)modelCode, (CharSequence)bmCode.getCode())).findFirst();
        if (optionalMatchedBMCode.isPresent()) {
            returnValue = optionalMatchedBMCode.get();
        }
        return returnValue;
    }

    public static Map<String, BMCode> getBMDataLayerBMCodes(DWServiceMapping eaiService, List<DWEAIHeader> eaiHeaders, List<BindApi> apiListConfig, BMRole bmRole) {
        HashMap<String, BMCode> returnValue = new HashMap<String, BMCode>();
        String modelCode = eaiService.getCode();
        String targetProdOfDWServiceMapping = eaiService.getTargetProd();
        String eaiTableName = eaiService.getTableName();
        boolean hasBindApiList = BindedApiUtil.hasBindApiConfig(apiListConfig);
        eaiHeaders.stream().forEach(eaiHeader -> {
            BMCode bmCode = new BMCode(modelCode, targetProdOfDWServiceMapping, eaiTableName, bmRole);
            String apiType = ApiTypeBMUtil.getApiTypeForBMDataLayer(eaiHeader, apiListConfig, hasBindApiList);
            bmCode.setApiType(apiType);
            String eaiServiceId = eaiHeader.getEAIServiceId();
            returnValue.put(eaiServiceId, bmCode);
        });
        return returnValue;
    }

    public static Map<String, BMCode> getBMBusinessLayerBMCodes(DWServiceMapping eaiService, List<DWEAIHeader> eaiHeaders, List<BindApi> apiListConfig, BMRole bmRole) {
        HashMap<String, BMCode> returnValue = new HashMap<String, BMCode>();
        String modelCode = eaiService.getCode();
        String targetProdOfDWServiceMapping = eaiService.getTargetProd();
        String eaiTableName = eaiService.getTableName();
        boolean hasBindApiList = BindedApiUtil.hasBindApiConfig(apiListConfig);
        eaiHeaders.stream().forEach(eaiHeader -> {
            BMCode bmCode = new BMCode(modelCode, targetProdOfDWServiceMapping, eaiTableName, bmRole);
            String apiType = ApiTypeUtil.getApiTypeWithBindApiConfig(eaiHeader, apiListConfig, hasBindApiList);
            bmCode.setApiType(apiType);
            String eaiServiceId = eaiHeader.getEAIServiceId();
            returnValue.put(eaiServiceId, bmCode);
        });
        return returnValue;
    }

    public static Map<String, BMCode> getStandardBMCodes(DWServiceMapping eaiService, List<DWEAIHeader> stdEaiHeaders) {
        HashMap<String, BMCode> returnValue = new HashMap<String, BMCode>();
        if (CollectionUtils.isNotEmpty(stdEaiHeaders)) {
            stdEaiHeaders.stream().forEach(stdEaiHeader -> {
                String apiType = ApiTypeUtil.getStdApiType(stdEaiHeader, "");
                BMCode bmCode = new BMCode(eaiService.getCode(), eaiService.getTargetProd(), eaiService.getTableName());
                bmCode.setApiType(apiType);
                String eaiServiceId = stdEaiHeader.getEAIServiceId();
                returnValue.put(eaiServiceId, bmCode);
            });
        } else {
            log.debug("{}[getStandardBMCodes] stdEaiHeaders is null, ignored to update", (Object)CLASS_LOG_TAG);
        }
        return returnValue;
    }
}

