/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.lcdp.modeldriven.model.ModelApiField;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.BindApi;
import com.digiwin.lcdp.modeldriven.utils.ParamValidateUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;

public class BindedApiUtil {
    private BindedApiUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Map<String, List<ModelApiField>> getBindApiFields(ModelSchemaDTO modelSchema, String apiName) {
        Optional<BindApi> apiConfigOpt;
        List<BindApi> bindApiListConfigs = modelSchema.getBindApiListConfig();
        Map<String, List<ModelApiField>> tileApiConfig = null;
        if (CollectionUtils.isNotEmpty(bindApiListConfigs) && (apiConfigOpt = bindApiListConfigs.stream().filter(apiConfig -> apiConfig.getApiName().equals(apiName)).findFirst()).isPresent()) {
            tileApiConfig = ParamValidateUtil.tileApiField(apiConfigOpt.get().getApiConfig().getRequest_parameters());
        }
        return tileApiConfig;
    }

    public static boolean hasBindApiConfig(List<BindApi> bindApiListConfig) {
        List<String> bindApis;
        boolean isBindApiList = false;
        if (Objects.nonNull(bindApiListConfig) && CollectionUtils.isNotEmpty(bindApis = BindedApiUtil.getBindApiNames(bindApiListConfig))) {
            isBindApiList = true;
        }
        return isBindApiList;
    }

    public static List<String> getBindApiNames(List<BindApi> bindApiListConfig) {
        ArrayList<String> bindApiNames = new ArrayList<String>();
        if (Objects.nonNull(bindApiListConfig)) {
            bindApiListConfig.stream().filter(bindApi -> bindApi.getApiName() != null).forEach(bindApi -> bindApiNames.add(bindApi.getApiName()));
        }
        return bindApiNames;
    }
}

