/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils.compare;

import com.digiwin.lcdp.modeldriven.constants.ModelDBConstants;
import com.digiwin.lcdp.modeldriven.enums.AlterIndexEnum;
import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.utils.DBColumnUtil;
import com.digiwin.lcdp.modeldriven.utils.DBTableUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexCompareUtil {
    private static final Logger log = LoggerFactory.getLogger(IndexCompareUtil.class);
    private static final String CLASS_LOG_TAG = "[" + IndexCompareUtil.class.getSimpleName() + "]";

    private IndexCompareUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static List<TableIndex> getAddIndexes(List<TableIndex> draftTableIndexes, List<TableIndex> actualTableIndexes) {
        return draftTableIndexes.stream().filter(draftTableIndex -> actualTableIndexes.stream().noneMatch(actulTableIndex -> Objects.equals(draftTableIndex.getName(), actulTableIndex.getName()))).collect(Collectors.toList());
    }

    public static List<TableIndex> getModifyIndexes(List<TableIndex> draftTableIndexes, List<TableIndex> actualTableIndexes) {
        return draftTableIndexes.stream().filter(draftIndex -> actualTableIndexes.stream().anyMatch(actualIndex -> Objects.equals(draftIndex.getName(), actualIndex.getName()) && !draftIndex.equals(actualIndex))).collect(Collectors.toList());
    }

    public static List<TableIndex> getDropIndexes(List<TableIndex> draftTableIndexes, List<TableIndex> actualTableIndexes, List<TableIndex> publishedTableIndexes) {
        List<TableIndex> validDropIndexes;
        if (CollectionUtils.isNotEmpty(publishedTableIndexes)) {
            List dropIndexesByComparedModel = publishedTableIndexes.stream().filter(publishedIndex -> draftTableIndexes.stream().noneMatch(draftIndex -> Objects.equals(publishedIndex.getName(), draftIndex.getName()))).collect(Collectors.toList());
            validDropIndexes = dropIndexesByComparedModel.stream().filter(dropColumn -> actualTableIndexes.stream().anyMatch(actualIndex -> Objects.equals(dropColumn.getName(), actualIndex.getName()))).collect(Collectors.toList());
            log.info("{} validDropIndexes({}) = dropIndexesByComparedModel({}) anyMatch in actualTableIndexes:({})", new Object[]{CLASS_LOG_TAG, validDropIndexes.stream().map(TableIndex::getName).collect(Collectors.toList()), dropIndexesByComparedModel.stream().map(TableIndex::getName).collect(Collectors.toList()), actualTableIndexes.stream().map(TableIndex::getName).collect(Collectors.toList())});
        } else {
            validDropIndexes = actualTableIndexes.stream().filter(actualIndex -> draftTableIndexes.stream().noneMatch(draftIndex -> Objects.equals(actualIndex.getName(), draftIndex.getName()))).collect(Collectors.toList());
        }
        return validDropIndexes;
    }

    public static Map<AlterIndexEnum, List<TableIndex>> getAlterColumnUniqueIndexes(List<TableColumn> draftTableColumns, List<TableColumn> actualTableColumns) {
        List diffUniqueTableColumns = draftTableColumns.stream().filter(drfColumn -> DBColumnUtil.checkValidType(drfColumn) && drfColumn.getAutoIncrement() == false && !ModelDBConstants.UNIQUE_INDEX_EXCLUDED_DATATYPE.contains(drfColumn.getDataType().getName()) && actualTableColumns.stream().anyMatch(actColumn -> Objects.equals(drfColumn.getColumnName(), actColumn.getColumnName()) && !Objects.equals(drfColumn.getUnique(), actColumn.getUnique()))).collect(Collectors.toList());
        log.info("{}[getAlterColumnUniqueIndexes] compared column-unique -> diffUniqueTableColumns({})", (Object)CLASS_LOG_TAG, diffUniqueTableColumns);
        List validAddColumnUniqueIndexes = diffUniqueTableColumns.stream().filter(TableColumn::getUnique).map(ModelSchemaUtil::convertTableColumnToTableUniqueIndex).collect(Collectors.toList());
        List validDropColumnUniqueIndexes = diffUniqueTableColumns.stream().filter(diffUnqTableColumn -> diffUnqTableColumn.getUnique() == false).map(ModelSchemaUtil::convertTableColumnToTableUniqueIndex).collect(Collectors.toList());
        EnumMap<AlterIndexEnum, List<TableIndex>> alterColumnUniqueIndexes = new EnumMap<AlterIndexEnum, List<TableIndex>>(AlterIndexEnum.class);
        if (CollectionUtils.isNotEmpty(validAddColumnUniqueIndexes)) {
            alterColumnUniqueIndexes.put(AlterIndexEnum.ADD, validAddColumnUniqueIndexes);
        }
        if (CollectionUtils.isNotEmpty(validDropColumnUniqueIndexes)) {
            alterColumnUniqueIndexes.put(AlterIndexEnum.DROP, validDropColumnUniqueIndexes);
        }
        log.info("{}[getAlterColumnUniqueIndexes] compared column-unique -> alterColumnUniqueIndexes({})", (Object)CLASS_LOG_TAG, alterColumnUniqueIndexes);
        return alterColumnUniqueIndexes;
    }

    public static LinkedHashMap<AlterIndexEnum, TableIndex> getChangePkIndex(ModelTable draftModelTable, ModelTable actualModelTable) {
        LinkedHashMap<AlterIndexEnum, TableIndex> changeMap = new LinkedHashMap<AlterIndexEnum, TableIndex>();
        TableIndex draftPk = draftModelTable.getIndexes().stream().filter(index -> index.getType() == IndexTypeEnum.PRIMARY_KEY).findFirst().orElse(null);
        TableIndex actualPk = actualModelTable.getIndexes().stream().filter(index -> index.getType() == IndexTypeEnum.PRIMARY_KEY).findFirst().orElse(null);
        IndexCompareUtil.updatePKChangeMap(draftPk, actualPk, changeMap);
        log.debug("{}[isPkChange] {} = compare actualPks({}) ({})", new Object[]{CLASS_LOG_TAG, changeMap, actualPk, draftPk});
        return changeMap;
    }

    private static void updatePKChangeMap(TableIndex draftPk, TableIndex actualPk, LinkedHashMap<AlterIndexEnum, TableIndex> changeMap) {
        boolean hasDraftPk = draftPk != null;
        boolean hasActualPk = actualPk != null;
        boolean shouldChangePk = hasActualPk && hasDraftPk;
        boolean addPk = actualPk == null && hasDraftPk;
        boolean deletePk = hasActualPk && draftPk == null;
        log.debug("{} pk status, draft({}), actual({})", new Object[]{CLASS_LOG_TAG, draftPk, actualPk});
        if (shouldChangePk) {
            if (!actualPk.equals(draftPk)) {
                changeMap.put(AlterIndexEnum.DROP, actualPk);
                changeMap.put(AlterIndexEnum.ADD, draftPk);
                log.info("{} autoIncrement drop actual({}),add draft({})", new Object[]{CLASS_LOG_TAG, actualPk, draftPk});
            } else {
                log.info("{} autoIncrement ignore change(same pk)", (Object)CLASS_LOG_TAG);
            }
        } else if (addPk) {
            changeMap.put(AlterIndexEnum.ADD, draftPk);
        } else if (deletePk) {
            changeMap.put(AlterIndexEnum.DROP, actualPk);
            log.warn("{} autoIncrement drop actual({})", (Object)CLASS_LOG_TAG, (Object)actualPk);
        }
    }

    public static String generatePrimaryKeys(List<TableColumn> customColumns) {
        List<String> pks = ModelSchemaUtil.getPrimaryKeys(customColumns);
        return IndexCompareUtil.generatePrimaryKeySql(pks);
    }

    public static String generatePrimaryKeySql(List<String> pkMembers) {
        String sql = "PRIMARY KEY (%s)";
        return String.format(sql, pkMembers.stream().map(DBTableUtil::addBackQuoteSymbol).collect(Collectors.joining(",")));
    }

    public static String generateIndexes(TableIndex tableIndex) {
        String indexCommand = tableIndex.getType().getIndexCommandChar();
        String indexName = tableIndex.getName();
        String memberStr = tableIndex.getMember().stream().map(member -> "`" + member + "`").collect(Collectors.joining(","));
        return String.format(" %s `%s` ( %s ) ", indexCommand, indexName, memberStr);
    }

    public static String generateIndexes(List<TableIndex> indexes) {
        return indexes.stream().filter(index -> index.getType() != IndexTypeEnum.PRIMARY_KEY).map(IndexCompareUtil::generateIndexes).collect(Collectors.joining(","));
    }
}

