/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.config;

import com.digiwin.lcdp.modeldriven.config.DWEAICustomizeProcess;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;

public class DWEAICustomizeAspect {
    private static final Log _logger = LogFactory.getLog(DWEAICustomizeAspect.class);
    @Autowired(required=false)
    @Qualifier(value="eaiCustomizeProcess")
    DWEAICustomizeProcess eaiCustomizeProcess;
    @Autowired
    private ApplicationContext applicationContext;

    @Pointcut(value="execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.*(..))")
    public void eaiServiceMethodExecution() {
        _logger.debug((Object)"[Aspect] eaiServiceMethodExecution");
    }

    @Around(value="DWEAICustomizeAspect.eaiServiceMethodExecution()")
    public Object customizeProcess(ProceedingJoinPoint joinPoint) throws Throwable {
        Object proceed;
        _logger.debug((Object)"[Aspect] DWEAICustomizeAspect");
        if (this.eaiCustomizeProcess == null) {
            proceed = joinPoint.proceed();
        } else {
            this.eaiCustomizeProcess.preProcess();
            proceed = joinPoint.proceed();
            this.eaiCustomizeProcess.postProcess();
        }
        return proceed;
    }
}

