/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.merge.processor.DWSourceAppSwitchProcessor;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.athena.esp.sdk.Invoker;
import com.digiwin.athena.esp.sdk.enums.InvokeTypeEnum;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.constants.BMConstants;
import com.digiwin.lcdp.modeldriven.customize.handler.BMAdapterCustomizeHandler;
import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.customize.utils.BMCenterUtil;
import com.digiwin.lcdp.modeldriven.customize.utils.BMDataEaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.customize.utils.BMDataRequestHeaderUtil;
import com.digiwin.lcdp.modeldriven.customize.utils.BMEaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.eai.utils.EaiServiceInvoker;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import com.digiwin.utils.DWTenantUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class BMDInvoker {
    private static final String _CLASSTAG = "[" + BMDInvoker.class.getSimpleName() + "]";
    private static final Logger logger = LoggerFactory.getLogger(BMDInvoker.class);
    @Autowired
    @Qualifier(value="bmCodes")
    Map<String, BMCode> bmCodes;
    @Autowired(required=false)
    @Qualifier(value="modeldriven-customize-bm-adapter-handler")
    private BMAdapterCustomizeHandler bmAdapterHandler;
    @Autowired(required=false)
    @Qualifier(value="DWEAIHeaderRepository")
    private DWEAIHeaderRepository eaiHeaderRepository;
    @Autowired(required=false)
    EaiServiceInvoker eaiServiceInvoker;
    private static List<String> excludeService = BMConstants.SERVICE_MODEL_PUBLISH;
    private static List<String> serviceWithAppInfo = BMConstants.SERVICE_QUERY_DATA_WITH_APPINFO;

    public Object invoker(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        String digiService = (String)headers.get("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String serviceName = digiServiceJo.getString("name");
        String targetProd = null;
        String bmdServiceName = "";
        if (excludeService.contains(serviceName)) {
            if (BMConstants.SERVICE_MODEL_UPDATE.contains(serviceName)) {
                modelData = (Map)((Map)((Map)messageBody.get("std_data")).get("parameter")).get("model");
                String modelStr = DWGsonProvider.getGson().toJson((Object)modelData);
                ModelDTO draftModel = (ModelDTO)DWGsonProvider.getGson().fromJson(modelStr, ModelDTO.class);
                targetProd = draftModel.getAppInfo().getTargetProd();
                bmdServiceName = serviceName;
            } else if (BMConstants.SERVICE_MODEL_DELETE.contains(serviceName)) {
                modelData = (Map)((Map)((Map)messageBody.get("std_data")).get("parameter")).get("model");
                boolean isBMCodeExisted = false;
                if (MapUtils.isNotEmpty((Map)modelData) && modelData.containsKey("code")) {
                    String modelCode = (String)modelData.get("code");
                    if (StringUtils.isBlank((CharSequence)modelCode)) {
                        throw new RuntimeException(ResourceBundleUtils.getString("lcdp.modeldriven.publish.fail.code.NotBlack"));
                    }
                    Collection<BMCode> allBMCodes = this.bmCodes.values();
                    Optional<BMCode> optionalMatchedBMCode = allBMCodes.stream().filter(bmCode -> StringUtils.equals((CharSequence)modelCode, (CharSequence)bmCode.getCode())).findFirst();
                    if (optionalMatchedBMCode.isPresent()) {
                        BMCode targetBMCode = optionalMatchedBMCode.get();
                        targetProd = targetBMCode.getTargetProd();
                        bmdServiceName = serviceName;
                        isBMCodeExisted = true;
                    }
                } else {
                    throw new RuntimeException("lcdp.modeldriven.publish.fail.code.NotExisted");
                }
                if (!isBMCodeExisted) {
                    throw new RuntimeException("lcdp.modeldriven.publish.fail.BMCode.NotExisted");
                }
            }
        } else if (serviceWithAppInfo.contains(serviceName)) {
            Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
            Map appInfo = (Map)params.get("appInfo");
            targetProd = (String)appInfo.get("targetProd");
            bmdServiceName = serviceName;
        } else {
            String bmServiceType;
            BMCode bmCode2 = BMCenterUtil.getBMCode(serviceName, this.bmCodes);
            if (bmCode2 == null) {
                bmServiceType = BMEaiServiceNameUtil.getServiceActionType(serviceName);
                logger.warn("{} BETA can't find bmCode by servieName({})", (Object)_CLASSTAG, (Object)serviceName);
            } else {
                bmServiceType = bmCode2.getApiType();
                logger.debug("{} BETA find serviceName({})'s bmServiceType({})", new Object[]{_CLASSTAG, serviceName, bmServiceType});
            }
            if (BMConstants.SERVICE_VALID_TYPE_POSTFIX.contains(bmServiceType)) {
                targetProd = bmCode2.getTargetProd();
                String orgBMDServiceNameByBMCode = BMDataEaiServiceNameUtil.getBMDEaiId(serviceName, bmCode2);
                HashMap<String, String> orgBMDataServiceInfo = new HashMap<String, String>();
                orgBMDataServiceInfo.put("name", orgBMDServiceNameByBMCode);
                orgBMDataServiceInfo.put("prod", targetProd);
                String bmdOrgDigiService = DWGsonProvider.getGson().toJson(orgBMDataServiceInfo);
                headers.put("digi-modeldriven", bmdOrgDigiService);
                bmdServiceName = String.join((CharSequence)".", "modeldriven.commons.eai", bmServiceType);
                logger.warn("{} BETA bmdServiceName({}) mapping modelServiceName:{})", new Object[]{_CLASSTAG, bmdServiceName, orgBMDServiceNameByBMCode});
            } else {
                targetProd = bmCode2.getTargetProd();
                bmdServiceName = bmCode2.getBmdApi();
                if (bmdServiceName == null) {
                    logger.warn("{} BETA bmdApiName is null cause bmCode:{}) when looking serviceName({})", new Object[]{_CLASSTAG, bmCode2, serviceName});
                    bmdServiceName = BMDataEaiServiceNameUtil.generateBMDEaiId(serviceName, bmCode2);
                    logger.debug("{} BETA use org bmdApiName {} by serviceName({})", new Object[]{_CLASSTAG, bmdServiceName, serviceName});
                }
            }
        }
        BMProperties bmProperties = BMProperties.getProperties();
        if (bmProperties != null && bmProperties.getRole() == BMRole.mix) {
            DWEAIHeader targetEaiHeader = this.eaiHeaderRepository.getEaiServiceHeader(bmdServiceName);
            if (targetEaiHeader != null) {
                logger.debug("{} *** BM({}) ***, local service({}) starting", new Object[]{_CLASSTAG, bmProperties.getRole(), bmdServiceName});
                Map<String, Object> bmdRequestHeaders = BMDataRequestHeaderUtil.getHeaders(headers, bmdServiceName, targetProd);
                String finalTargetProd = targetProd;
                DWSourceAppSwitchProcessor switchContextAppIdProcessor = new DWSourceAppSwitchProcessor();
                Object dweaiResult = switchContextAppIdProcessor.process(() -> finalTargetProd, () -> this.eaiServiceInvoker.invokeInnerService(targetEaiHeader, bmdRequestHeaders, messageBody, false));
                return dweaiResult;
            }
            logger.warn("{} *** BM({}) *** local service({}) not found", new Object[]{_CLASSTAG, bmProperties.getRole(), bmdServiceName});
            throw new RuntimeException(String.format("local service(%s) not found", bmdServiceName));
        }
        logger.debug("{} start invoke bmd serviceName({}),targetProd({})", new Object[]{_CLASSTAG, bmdServiceName, targetProd});
        if (StringUtils.isBlank((CharSequence)targetProd)) {
            throw new RuntimeException(ResourceBundleUtils.getString("lcdp.modeldriven.publish.fail.targetProd.NotBlack"));
        }
        RequestModel requestModel = new RequestModel();
        requestModel.setServiceProd(targetProd);
        requestModel.setServiceName(bmdServiceName);
        requestModel.setHostProd(targetProd);
        requestModel.setHostVer("1.0.0");
        requestModel.setInvokeType(InvokeTypeEnum.SYNC);
        requestModel.setBodyJsonString(DWGsonProvider.getGson().toJson(messageBody));
        headers.forEach((key, value) -> {
            if (!BMConstants.BM_EXCLUDE_HEADER_ATTRIBUTES.contains(key.toLowerCase())) {
                requestModel.addHeader(key, value.toString());
            }
        });
        Map profile = DWServiceContext.getContext().getProfile();
        if (MapUtils.isEmpty((Map)profile)) {
            requestModel.setTenantId("");
        } else {
            requestModel.setTenantId((String)profile.get(DWTenantUtils.getIamTenantIdKey()));
        }
        ResponseModel responseModel = null;
        StopWatch stopWatch = StopWatch.createStarted();
        try {
            logger.debug("{} ---> bmd({}), service({}), stage:begin, time({})", new Object[]{_CLASSTAG, targetProd, bmdServiceName, stopWatch.getTime()});
            responseModel = Invoker.invokeRestSync((RequestModel)requestModel);
            logger.debug("{} ---> bmd({}), service({}), stage:response, response({}), time({})", new Object[]{_CLASSTAG, targetProd, bmdServiceName, responseModel, stopWatch.getTime()});
        }
        catch (Exception e) {
            if (e.getCause() == null) {
                logger.warn("{} ---> bmd({}), service({}), stage:exception message({})), time({})", new Object[]{_CLASSTAG, "lcdp.bmd.crud.code.get", targetProd, e.getMessage(), stopWatch.getTime()});
            } else {
                logger.warn("{} ---> bmd({}), service({}), stage:exception message({}) and cause({}), time({})", new Object[]{_CLASSTAG, "lcdp.bmd.crud.code.get", targetProd, e.getMessage(), e.getCause().getMessage(), stopWatch.getTime()});
            }
            throw new RuntimeException(e);
        }
        finally {
            if (!stopWatch.isStopped()) {
                stopWatch.stop();
            }
        }
        Object returnValue = !excludeService.contains(serviceName) && !serviceWithAppInfo.contains(serviceName) ? this.bmAdapterHandler.processBMDataResult(responseModel.getBodyJsonString()) : DWGsonProvider.getGson().fromJson(responseModel.getBodyJsonString(), DWEAIResult.class);
        return returnValue;
    }

    public DWEAIResult invokeGetBMDCodes(String targetProd) throws Exception {
        String targetServiceName = "lcdp.bmd.crud.code.get";
        RequestModel requestModel = new RequestModel();
        requestModel.setServiceProd(targetProd);
        requestModel.setServiceName(targetServiceName);
        requestModel.setHostProd(targetProd);
        requestModel.setInvokeType(InvokeTypeEnum.SYNC);
        HashMap reqBody = new HashMap();
        HashMap stdData = new HashMap();
        HashMap parameter = new HashMap();
        reqBody.put("std_data", stdData);
        stdData.put("parameter", parameter);
        requestModel.setBodyJsonString(DWGsonProvider.getGson().toJson(reqBody));
        HashMap eocMap = new HashMap();
        requestModel.setEocMap(eocMap);
        requestModel.addHeader("digi-middleware-auth-app", DWApplicationConfigUtils.getProperty((String)"iamApToken"));
        ResponseModel responseModel = null;
        StopWatch stopWatch = StopWatch.createStarted();
        try {
            logger.info("{} bmd({}), service({}), stage:begin, time({})", new Object[]{_CLASSTAG, targetProd, targetServiceName, stopWatch.getTime()});
            responseModel = Invoker.invokeRestSync((RequestModel)requestModel);
        }
        catch (Exception e) {
            if (e.getCause() == null) {
                logger.warn("{} ---> bmd({}), service({}), stage:exception message({})), time({})", new Object[]{_CLASSTAG, "lcdp.bmd.crud.code.get", targetProd, e.getMessage(), stopWatch.getTime()});
            } else {
                logger.warn("{} ---> bmd({}), service({}), stage:exception message({}) and cause({}), time({})", new Object[]{_CLASSTAG, "lcdp.bmd.crud.code.get", targetProd, e.getMessage(), e.getCause().getMessage(), stopWatch.getTime()});
            }
            throw new RuntimeException(e);
        }
        finally {
            if (!stopWatch.isStopped()) {
                stopWatch.stop();
            }
        }
        logger.info("{} bmd({}), service({}), stage:finished, time({})", new Object[]{_CLASSTAG, targetProd, targetServiceName, stopWatch.getTime()});
        DWEAIResult eaiResult = (DWEAIResult)DWGsonProvider.getGson().fromJson(responseModel.getBodyJsonString(), DWEAIResult.class);
        return eaiResult;
    }
}

