/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.container.DWMethod;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.app.service.eai.EAIService;
import com.digiwin.lcdp.modeldriven.constants.ModelDrivenConstants;
import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.enums.ModelApiTypeEnum;
import com.digiwin.lcdp.modeldriven.pojo.BindApi;
import com.digiwin.lcdp.modeldriven.utils.ApiNameUtil;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiTypeUtil {
    private static final Logger logger = LoggerFactory.getLogger(ApiTypeUtil.class);
    private static final String _CLASSTAG = "[" + ApiTypeUtil.class.getSimpleName() + "]";

    public static String convertApiConfigApiType(String stdServicePostfixFromStdEaiMethod) {
        if (ModelDrivenConstants.METHOD_NAME_BELONG_LIST.contains(stdServicePostfixFromStdEaiMethod)) {
            return ModelApiTypeEnum.LIST.getApiTypeName();
        }
        if (ModelDrivenConstants.METHOD_NAME_BELONG_DETAIL.contains(stdServicePostfixFromStdEaiMethod)) {
            return ModelApiTypeEnum.DETAIL.getApiTypeName();
        }
        return stdServicePostfixFromStdEaiMethod;
    }

    public static String getApiType(BMCode bmCode, String digiServiceName) {
        String apiType = "";
        if (!Objects.isNull(bmCode)) {
            apiType = bmCode.getApiType();
        }
        if (StringUtils.isBlank((CharSequence)apiType)) {
            apiType = ApiNameUtil.getServiceNameType(digiServiceName);
            logger.warn("{}[getApiType] get ApiType({}) by serviceName({}}), bmCode({})", new Object[]{_CLASSTAG, apiType, digiServiceName, bmCode});
        }
        return apiType;
    }

    public static String getStdApiType(DWEAIHeader eaiHeader, String postfix) {
        String serviceType = null;
        String realServiceName = eaiHeader.getServiceType().getSimpleName();
        DWMethod dwMethod = eaiHeader.getMappingMethod();
        String methodName = dwMethod.getMethodName();
        String hitStyle = "";
        if ("IModelDrivenEAICrudService".equals(realServiceName)) {
            hitStyle = "IModelDrivenEAICrudService";
            switch (methodName) {
                case "get": {
                    serviceType = ModelApiTypeEnum.DETAIL.getApiTypeName();
                    break;
                }
                case "getList": {
                    serviceType = ModelApiTypeEnum.LIST.getApiTypeName();
                    break;
                }
                case "post": {
                    serviceType = ModelApiTypeEnum.CREATE.getApiTypeName();
                    break;
                }
                case "put": {
                    serviceType = ModelApiTypeEnum.UPDATE.getApiTypeName();
                    break;
                }
                case "delete": {
                    serviceType = ModelApiTypeEnum.DELETE.getApiTypeName();
                    break;
                }
                case "putValid": {
                    serviceType = ModelApiTypeEnum.VALID.getApiTypeName();
                    break;
                }
                case "putInvalid": {
                    serviceType = ModelApiTypeEnum.INVALID.getApiTypeName();
                    break;
                }
            }
        } else if ("IBMEAICrudService".equals(realServiceName)) {
            hitStyle = "IBMEAICrudService";
            block24 : switch (methodName) {
                case "get": {
                    if (StringUtils.isNotBlank((CharSequence)postfix)) {
                        switch (postfix) {
                            case "list.get": {
                                serviceType = ModelApiTypeEnum.LIST.getApiTypeName();
                                break block24;
                            }
                            case "detail.get": {
                                serviceType = ModelApiTypeEnum.DETAIL.getApiTypeName();
                                break block24;
                            }
                        }
                        serviceType = ModelApiTypeEnum.LIST.getApiTypeName();
                        break;
                    }
                    serviceType = ModelApiTypeEnum.LIST.getApiTypeName();
                    break;
                }
                case "post": {
                    serviceType = ModelApiTypeEnum.CREATE.getApiTypeName();
                    break;
                }
                case "put": {
                    if (StringUtils.isNotBlank((CharSequence)postfix)) {
                        switch (postfix) {
                            case "valid": {
                                serviceType = ModelApiTypeEnum.VALID.getApiTypeName();
                                break block24;
                            }
                            case "invalid": {
                                serviceType = ModelApiTypeEnum.INVALID.getApiTypeName();
                                break block24;
                            }
                        }
                        serviceType = ModelApiTypeEnum.UPDATE.getApiTypeName();
                        break;
                    }
                    serviceType = ModelApiTypeEnum.UPDATE.getApiTypeName();
                    break;
                }
                case "delete": {
                    serviceType = ModelApiTypeEnum.DELETE.getApiTypeName();
                    break;
                }
            }
        }
        logger.debug("{} apiType hitStyle:{}", (Object)_CLASSTAG, (Object)hitStyle);
        return serviceType;
    }

    public static String getApiTypeForBMDataLayer(DWEAIHeader eaiHeader, List<BindApi> bmdApiListConfig, boolean hasBindApiList) {
        String apiType = hasBindApiList ? ApiTypeUtil.getApiTypeInBMDataLayer(eaiHeader, bmdApiListConfig) : ApiTypeUtil.getApiTypeInBMDataLayer(eaiHeader);
        return apiType;
    }

    public static String getApiTypeInBMDataLayer(DWEAIHeader eaiHeader, List<BindApi> bindApiListConfig) {
        String serviceType = null;
        Optional<BindApi> optBindApi = bindApiListConfig.stream().filter(bindApi -> bindApi.getApiName().equals(eaiHeader.getEAIServiceId())).findFirst();
        if (optBindApi.isPresent()) {
            serviceType = optBindApi.get().getApiType();
        }
        return serviceType;
    }

    public static String getApiTypeInBMDataLayer(DWEAIHeader eaiHeader) {
        EAIService methodAnnotation;
        String methodAnnotEaiId;
        String serviceType = null;
        DWMethod dwMethod = eaiHeader.getMappingMethod();
        String hitStyle = "";
        Method method = dwMethod.getMethod();
        if (dwMethod.getMethod().isAnnotationPresent(EAIService.class) && (methodAnnotEaiId = (methodAnnotation = method.getAnnotation(EAIService.class)).id()).startsWith("lcdp.bmd.crud.eai.")) {
            hitStyle = "annotation name(lcdp.bmd.crud.eai.)";
            switch (methodAnnotEaiId) {
                case "lcdp.bmd.crud.eai.get": {
                    serviceType = ModelApiTypeEnum.LIST.getApiTypeName();
                    break;
                }
                case "lcdp.bmd.crud.eai.create": {
                    serviceType = ModelApiTypeEnum.CREATE.getApiTypeName();
                    break;
                }
                case "lcdp.bmd.crud.eai.update": {
                    serviceType = ModelApiTypeEnum.UPDATE.getApiTypeName();
                    break;
                }
                case "lcdp.bmd.crud.eai.delete": {
                    serviceType = ModelApiTypeEnum.DELETE.getApiTypeName();
                    break;
                }
            }
        }
        return serviceType;
    }
}

