/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWOnColumn;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryJoinRelation;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.eai.exception.DWEaiException;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.lcdp.modeldriven.config.ModelDrivenDaoProperties;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.database.PatchSql;
import com.digiwin.lcdp.modeldriven.database.sql.ModelExtendSql;
import com.digiwin.lcdp.modeldriven.enums.PublishStatusEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelPublishedEspResult;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.utils.DBTableUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiResultUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlParserUtil;
import com.digiwin.lcdp.modeldriven.utils.SqlParserUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class DBExecuteHandler {
    private static final Logger log = LoggerFactory.getLogger(DBExecuteHandler.class);
    private static String logTag = "[" + DBExecuteHandler.class.getSimpleName() + "]";
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;
    @Autowired
    @Qualifier(value="dw-modeldriven-dao-properties")
    public ModelDrivenDaoProperties modelDrivenDaoProperties;
    private static final String _sql_table_existed = "show TABLES LIKE '%s'";
    private static final String logSqlFormat = "%d type:%s sql:%s; sqlParam:%s";

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public ModelPublishedEspResult executeCreateTableOfCreateModelDriven(List<SqlParam> ddlSqlParams, List<SqlParam> dmlSqlParams, ModelDTO model) {
        ModelPublishedEspResult publishedEspResult = new ModelPublishedEspResult();
        HashMap<String, Integer> returnValue = new HashMap<String, Integer>();
        String reportCurrentSql = "dummy";
        String code = model.getCode();
        int ddlExecuteCount = 0;
        try {
            DWDataSetOperationOption daoDDLOption = ModelDataUtil.getDisabledCommonDataSetOperationOption();
            daoDDLOption.set("queryTimeout", (Object)this.modelDrivenDaoProperties.getDdlTimeout());
            for (SqlParam sqlParam : ddlSqlParams) {
                String sql;
                reportCurrentSql = sql = sqlParam.getSql();
                Object[] sqlParams = sqlParam.getParams();
                log.info(String.format(logSqlFormat, ddlExecuteCount, "ddl", sql.toString(), Objects.isNull(sqlParams) ? "null" : Arrays.asList(sqlParams).toString()));
                int createCount = this.dao.update((IDWSQLOptions)daoDDLOption, sql, sqlParams);
                ++ddlExecuteCount;
            }
            returnValue.put("DDLExecuteCount", ddlExecuteCount);
            DWDataSetOperationOption daoOption = ModelDataUtil.getDisabledCommonDataSetOperationOption();
            int dmlExecuteCount = 0;
            for (SqlParam sqlParam : dmlSqlParams) {
                String sql;
                reportCurrentSql = sql = sqlParam.getSql();
                Object[] sqlParams = sqlParam.getParams();
                if (log.isDebugEnabled()) {
                    log.debug(String.format(logSqlFormat, dmlExecuteCount, "dml", sql.toString(), Objects.isNull(sqlParams) ? "null" : Arrays.asList(sqlParams).toString()));
                }
                int insertOrUpdateCount = this.dao.update((IDWSQLOptions)daoOption, sql, sqlParams);
                ++dmlExecuteCount;
            }
            returnValue.put("DMLExecuteCount", dmlExecuteCount);
        }
        catch (Exception e) {
            log.info("{} code({}) exception1 execute({}), e.getMessage({})", new Object[]{logTag, code, reportCurrentSql, e.getMessage()});
            publishedEspResult.setPublishStatusEnum(PublishStatusEnum.FAILURE);
            publishedEspResult.setMessage(e.getMessage());
            throw new RuntimeException(String.format("[DBExecuteHandler] code(%s) exception 2", code), e);
        }
        log.info("{} finished code({}) create table", (Object)logTag, (Object)code);
        publishedEspResult.setPublishStatusEnum(PublishStatusEnum.SUCCESS);
        return publishedEspResult;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public DWEAIResult executeAlterTable(Map<String, Object> params) throws Exception {
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        ModelDTO draftModel = modelDrivenContext.getDraftModel();
        DWEAIResult result = new DWEAIResult();
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        String reportCurrentSql = "dummy";
        String code = draftModel.getCode();
        int tableExecuteCount = 0;
        if (params.containsKey("ddl")) {
            LinkedList ddlSqlParams = (LinkedList)MapUtils.getObject(params, (Object)"ddl", new LinkedList());
            if (CollectionUtils.isNotEmpty((Collection)ddlSqlParams)) {
                try {
                    DWDataSetOperationOption daoDDLOption = ModelDataUtil.getDisabledCommonDataSetOperationOption();
                    daoDDLOption.set("queryTimeout", (Object)this.modelDrivenDaoProperties.getDdlTimeout());
                    for (Object sqlParam : ddlSqlParams) {
                        String sql;
                        reportCurrentSql = sql = ((SqlParam)sqlParam).getSql();
                        Object[] sqlParams = ((SqlParam)sqlParam).getParams();
                        if (log.isDebugEnabled()) {
                            log.debug(String.format(logSqlFormat, tableExecuteCount, "ddl", sql.toString(), Objects.isNull(sqlParams) ? "null" : Arrays.asList(sqlParams).toString()));
                        }
                        log.debug("code({}), option.timeout({}), current sql:{}", new Object[]{code, this.modelDrivenDaoProperties.getDdlTimeout(), sql});
                        this.dao.update((IDWSQLOptions)daoDDLOption, sql, new Object[0]);
                        ++tableExecuteCount;
                    }
                }
                catch (Exception e) {
                    Map<String, Object> currentModifyColumns = ModelSqlParserUtil.getModifyColumn(reportCurrentSql);
                    modelDrivenContext.getExtraMap().put("exceptionAlterDDL", currentModifyColumns);
                    throw new RuntimeException(String.format(logTag + "[executeAlterTable] \u5beb\u5165 \u5931\u6557 (%s) when executing sql (%s)", e.getMessage(), reportCurrentSql), e);
                }
            } else {
                log.info("{} code({}) no ddl sql", (Object)logTag, (Object)code);
            }
        }
        DWDataSetOperationOption daoOption = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        int rdbmsExecuteCount = 0;
        try {
            if (params.containsKey("dml")) {
                LinkedList dmlSqlParams = (LinkedList)MapUtils.getObject(params, (Object)"dml", new LinkedList());
                for (SqlParam sqlParam : dmlSqlParams) {
                    String sql;
                    reportCurrentSql = sql = sqlParam.getSql();
                    Object[] sqlParams = sqlParam.getParams();
                    if (log.isDebugEnabled()) {
                        log.debug(String.format(logSqlFormat, rdbmsExecuteCount, "dml", sql.toString(), Objects.isNull(sqlParams) ? "null" : Arrays.asList(sqlParams).toString()));
                    }
                    this.dao.update((IDWSQLOptions)daoOption, sql, sqlParams);
                    ++rdbmsExecuteCount;
                }
            }
            returnValue.put("rdbmsExecuteCount", rdbmsExecuteCount);
            returnValue.put("tableExecuteCount", tableExecuteCount);
            result = EaiResultUtil.getDWEAIResult(returnValue);
        }
        catch (Exception e) {
            String execCode = "-1";
            Object message = e.getMessage();
            if (e instanceof SQLException) {
                SQLException sqle = (SQLException)e;
                execCode = String.valueOf(sqle.getErrorCode());
                message = (String)message + "(" + sqle.getSQLState() + ")";
                result = new DWEAIResult(execCode, sqle.getSQLState(), e.getMessage(), null);
            } else {
                execCode = "-1";
                message = (String)message + " when executing sql(" + reportCurrentSql + ")";
                result = new DWEAIResult(execCode, "-1", (String)message, null);
            }
            log.info("{} exception 2 code({}) result({})", new Object[]{logTag, code, result.toString()});
            throw new DWEaiException(code, (String)message);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public DWEAIResult executeDeleteTable(Map<String, Object> params, ModelDTO model) throws Exception {
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        String modelCodeName = model.getCode();
        DWDataSetOperationOption daoOption = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        int rdbmsExecuteCount = 0;
        String reportCurrentSql = "dummy";
        DWDataSetOperationOption daoDDLOption = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        daoDDLOption.set("queryTimeout", (Object)this.modelDrivenDaoProperties.getDdlTimeout());
        int tableExecuteCount = 0;
        LinkedList ddlSqlParams = (LinkedList)MapUtils.getObject(params, (Object)"ddl", new LinkedList());
        for (Object sqlParam : ddlSqlParams) {
            String sql;
            reportCurrentSql = sql = ((SqlParam)sqlParam).getSql();
            Object[] sqlParams = ((SqlParam)sqlParam).getParams();
            log.info(String.format(logSqlFormat, rdbmsExecuteCount, "ddl", sql.toString(), Objects.isNull(sqlParams) ? "null" : Arrays.asList(sqlParams).toString()));
            try {
                this.dao.update((IDWSQLOptions)daoDDLOption, sql, new Object[0]);
            }
            catch (Exception e) {
                log.info("{} code({}): something message({}) when execute({})", new Object[]{logTag, modelCodeName, e.getMessage(), reportCurrentSql});
            }
            finally {
                log.debug("{} code({}) drop model code finished", (Object)logTag, (Object)modelCodeName);
            }
            ++tableExecuteCount;
        }
        LinkedList dmlSqlParams = (LinkedList)MapUtils.getObject(params, (Object)"dml", new LinkedList());
        for (SqlParam sqlParam : dmlSqlParams) {
            String sql;
            reportCurrentSql = sql = sqlParam.getSql();
            Object[] sqlParams = sqlParam.getParams();
            log.info(String.format(logSqlFormat, rdbmsExecuteCount, "dml", sql.toString(), Objects.isNull(sqlParams) ? "null" : Arrays.asList(sqlParams).toString()));
            this.dao.update((IDWSQLOptions)daoOption, sql, sqlParams);
            ++rdbmsExecuteCount;
        }
        returnValue.put("rdbmsExecuteCount", rdbmsExecuteCount);
        returnValue.put("tableExecuteCount", tableExecuteCount);
        DWEAIResult result = EaiResultUtil.getDWEAIResult(returnValue);
        return result;
    }

    public boolean checkTableExist(String dbTableName) {
        boolean tableExisted = true;
        try {
            DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
            List daoQueryResult = this.dao.select((IDWSQLOptions)option, String.format(_sql_table_existed, dbTableName), new Object[0]);
            if (CollectionUtils.isEmpty((Collection)daoQueryResult)) {
                tableExisted = false;
            }
            log.error("{}[checkTableExist] realTableName({}) tableExisted={}", new Object[]{logTag, dbTableName, tableExisted});
        }
        catch (Exception e) {
            StringBuffer message = new StringBuffer();
            tableExisted = false;
            if (e != null && e.getCause() instanceof SQLException) {
                SQLException sqlException = (SQLException)e.getCause();
                message = message.append(String.format("sqlState(%s), sqlErrorCode(%d), sqlMessage(%s)", sqlException.getSQLState(), sqlException.getErrorCode(), sqlException.getMessage()));
            }
            log.error("{}[checkTableExist] realTableName({}) is not valid, message:{}", new Object[]{logTag, dbTableName, message});
        }
        return tableExisted;
    }

    public List checkAndGetCreateTableSqlByDBFunc(String dbTableName) {
        List returnValue = new ArrayList();
        try {
            boolean isTableExist = this.checkTableExist(dbTableName);
            if (isTableExist) {
                returnValue = this.getCreateTableSqlByDBFunc(dbTableName);
            }
        }
        catch (Exception e) {
            StringBuffer message = new StringBuffer();
            if (e != null) {
                Throwable throwable = e.getCause();
                if (throwable instanceof SQLException) {
                    SQLException sqlException = (SQLException)throwable;
                    message = message.append(String.format("sqlState(%s), sqlErrorCode(%d), sqlMessage(%s)", sqlException.getSQLState(), sqlException.getErrorCode(), sqlException.getMessage()));
                } else {
                    message = message.append(throwable.getMessage());
                }
            }
            log.error("{} realTableName({}) is not valid, message:{}", new Object[]{logTag, dbTableName, message});
            throw new RuntimeException(message.toString());
        }
        return returnValue;
    }

    public List getCreateTableSqlByDBFunc(String dbTableName) {
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        List returnValue = this.dao.select((IDWSQLOptions)option, "show create table `" + dbTableName + "`", new Object[0]);
        log.error("{}[getCreateTableSqlByDBFunc] realTableName({}) create table sql: {}", new Object[]{logTag, dbTableName, returnValue});
        return returnValue;
    }

    public List<String> getTableNamesGeneratedByModelDriven(List<String> tableNames) {
        List queryTableNames = tableNames.stream().distinct().collect(Collectors.toList());
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_lcdp_model_info");
        queryInfo.setDistinct(true);
        queryInfo.setSelectFields(new String[]{"table_name"});
        DWQueryCondition condition = new DWQueryCondition();
        condition.addFieldInfo("table_name", DWQueryValueOperator.In, queryTableNames.toArray());
        queryInfo.setCondition(condition);
        DWDataSet daoResult = this.dao.select(queryInfo, option);
        DWDataTable dataTable = daoResult.getTable("dw_lcdp_model_info");
        List<String> distinctTableNames = dataTable.getRows().stream().map(dwDataRow -> (String)dwDataRow.get("table_name")).collect(Collectors.toList());
        return distinctTableNames;
    }

    public List<String> getModelTableNamesFromModelInfo(String code) {
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_lcdp_model_info");
        queryInfo.setDistinct(true);
        queryInfo.setSelectFields(new String[]{"table_name"});
        DWQueryCondition condition = new DWQueryCondition();
        condition.addFieldInfo("code", DWQueryValueOperator.Equals, new Object[]{code});
        queryInfo.setCondition(condition);
        DWDataSet daoResult = this.dao.select(queryInfo, option);
        DWDataTable dataTable = daoResult.getTable("dw_lcdp_model_info");
        List<String> distinctTableNames = dataTable.getRows().stream().map(dwDataRow -> (String)dwDataRow.get("table_name")).collect(Collectors.toList());
        return distinctTableNames;
    }

    public static void executeSqlCommands(DWDao dwdao, List<String> sqlCommands) throws SQLException {
        if (CollectionUtils.isNotEmpty(sqlCommands)) {
            StopWatch stopWatch = StopWatch.createStarted();
            try (Connection connection = dwdao.getQueryRunner().getDataSource().getConnection();){
                Statement statement = connection.createStatement();
                AtomicInteger index = new AtomicInteger(1);
                sqlCommands.forEach(sql -> {
                    try {
                        log.debug("{}[executeSqlCommands][{}] add sql to batch({})", new Object[]{logTag, index.getAndIncrement(), sql});
                        statement.addBatch((String)sql);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                });
                log.debug("{} starting execute sqls ...", (Object)logTag);
                statement.executeBatch();
                stopWatch.stop();
                log.info("{} result: finished execute {} sqls(cost:{} ms)", new Object[]{logTag, sqlCommands.size(), stopWatch.getTime()});
            }
            catch (Exception e) {
                stopWatch.stop();
                log.info("{} result: exception when execute {} sqls(cost:{} ms)", new Object[]{logTag, sqlCommands.size(), stopWatch.getTime()});
                e.printStackTrace();
            }
        } else {
            log.warn("{} result: no sqls to be executed", (Object)logTag);
        }
    }

    public List<String> getDBExistedTables(ModelSchemaDTO modelSchemaDTO) {
        ArrayList<String> tableNames = new ArrayList<String>();
        if (this.checkTableExist(modelSchemaDTO.getName())) {
            tableNames.add(modelSchemaDTO.getName());
        }
        if (CollectionUtils.isNotEmpty(modelSchemaDTO.getChildren())) {
            modelSchemaDTO.getChildren().forEach(modelSchema -> tableNames.addAll(this.getDBExistedTables((ModelSchemaDTO)modelSchema)));
        }
        return tableNames;
    }

    public void upgradeModelDrivenDatabase(List<String> dbTableNames) throws JSQLParserException {
        DWDataSetOperationOption daoOption = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        log.info("{}[upgradeModelDrivenDatabase] process {}", (Object)logTag, (Object)"dw_service_mapping");
        if (dbTableNames.contains("dw_service_mapping")) {
            List data = this.getCreateTableSqlByDBFunc("dw_service_mapping");
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                log.info("{}[upgradeModelDrivenDatabase] --> basic table({}) is existed", (Object)logTag, (Object)"dw_service_mapping");
                CreateTable ccjCreateTable = ModelSqlParserUtil.fetchCCJCreateTable(data);
                List ccjColumnDefinitions = ccjCreateTable.getColumnDefinitions();
                String targetProdFullName = String.join((CharSequence)".", "dw_service_mapping", "target_prod");
                boolean hasTargetProdColumn = ccjColumnDefinitions.stream().anyMatch(ccjColumnDef -> DBTableUtil.removeBackQuoteSymbol(ccjColumnDef.getColumnName()).equalsIgnoreCase("target_prod"));
                if (!hasTargetProdColumn) {
                    SqlParam sqlParamOfServiceMappingPatch = PatchSql.getServiceMapppingPatchSql();
                    this.dao.update((IDWSQLOptions)daoOption, sqlParamOfServiceMappingPatch.getSql(), new Object[0]);
                    this.dao.update((IDWSQLOptions)daoOption, "insert into dw_rdbms_fields  (table_name, seq, field_name, is_key, field_type, status_code, field_display_name, default_value, nullable, is_version, size, scale, is_auto_increment)  values (?, ?, ?, ?, ?, 'N', ?, ?, ?, 'N', ?, ?, ?)  ON DUPLICATE KEY UPDATE table_name=?, seq=?, field_name=?, is_key=?, field_type=?, status_code='N', field_display_name=?, default_value=?, nullable=?, is_version='N', size=?, scale=?, is_auto_increment=? ", sqlParamOfServiceMappingPatch.getParams());
                    log.info("{} patched column({}), cause not existed!", (Object)logTag, (Object)targetProdFullName);
                } else {
                    log.debug("{} column{} existed, ignored patch!", (Object)logTag, (Object)targetProdFullName);
                }
            } else {
                log.info("{}[upgradeModelDrivenDatabase] --> basic table({}) get create table sql is empty, ignored patch", (Object)logTag, (Object)"dw_service_mapping");
            }
        } else {
            log.info("{} basic table({}) not existed!", (Object)logTag, (Object)"dw_service_mapping");
        }
        log.info("{}[upgradeModelDrivenDatabase] process {}", (Object)logTag, (Object)"dw_lcdp_data_view");
        if (!dbTableNames.contains("dw_lcdp_data_view")) {
            log.info("{}[upgradeModelDrivenDatabase] --> basic table({}) is not existed", (Object)logTag, (Object)"dw_lcdp_data_view");
            List<String> insertAndCreateDataViewSqls = PatchSql.getDataViewInitSqls();
            for (String insertOrCreateSql : insertAndCreateDataViewSqls) {
                this.dao.update((IDWSQLOptions)daoOption, insertOrCreateSql, new Object[0]);
            }
            log.info("{} basic table({}) created!", (Object)logTag, (Object)"dw_lcdp_data_view");
        } else {
            log.info("{} basic table({}) existed! ignored patch", (Object)logTag, (Object)"dw_lcdp_data_view");
        }
        log.info("{}[upgradeModelDrivenDatabase] process {}", (Object)logTag, (Object)"dw_lcdp_model_activity");
        if (!dbTableNames.contains("dw_lcdp_model_activity")) {
            log.info("{}[upgradeModelDrivenDatabase] --> basic table({}) is not existed", (Object)logTag, (Object)"dw_lcdp_model_activity");
            List<String> insertAndCreateActivitySqlSqls = PatchSql.getActivityInitSqls();
            for (String insertOrCreateSql : insertAndCreateActivitySqlSqls) {
                this.dao.update((IDWSQLOptions)daoOption, insertOrCreateSql, new Object[0]);
            }
            log.info("{} basic table({}) created!", (Object)logTag, (Object)"dw_lcdp_model_activity");
        } else {
            log.info("{} basic table({}) existed! ignored patch", (Object)logTag, (Object)"dw_lcdp_model_activity");
        }
        log.info("{}[upgradeModelDrivenDatabase] process {}", (Object)logTag, (Object)"dw_lcdp_model_extend");
        if (!dbTableNames.contains("dw_lcdp_model_extend")) {
            log.info("{}[upgradeModelDrivenDatabase] --> basic table({}) is not existed", (Object)logTag, (Object)"dw_lcdp_model_extend");
            List<String> insertAndCreateSqls = ModelExtendSql.getCreateTableAndRdbmsSqls();
            for (String insertOrCreateSql : insertAndCreateSqls) {
                this.dao.update((IDWSQLOptions)daoOption, insertOrCreateSql, new Object[0]);
            }
            log.info("{} basic table({}) created!", (Object)logTag, (Object)"dw_lcdp_model_extend");
        } else {
            log.info("{} basic table({}) existed! ignored patch", (Object)logTag, (Object)"dw_lcdp_model_extend");
        }
    }

    public List<String> getDBTableNames() {
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        List daoQueryResult = this.dao.select((IDWSQLOptions)option, "show tables", new Object[0]);
        ArrayList<String> tableNames = new ArrayList<String>();
        daoQueryResult.stream().forEach(rowMap -> rowMap.values().forEach(row -> tableNames.add((String)row)));
        log.debug("{}[getDBTables] db table total({})", (Object)logTag, (Object)tableNames.size());
        return tableNames;
    }

    public static void initalSqlExecute(String dbConnectionString, String account, String password, String sqlFilePath) throws Exception {
        Connection connection = DriverManager.getConnection(dbConnectionString, account, password);
        Statement statement = connection.createStatement();
        List<String> sqls = SqlParserUtil.getSql(sqlFilePath);
        log.debug("{} sqlPath:{} sqlContents:{}", new Object[]{logTag, sqlFilePath, sqls});
        sqls.forEach(sql -> {
            try {
                statement.addBatch((String)sql);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
        statement.executeBatch();
        statement.close();
    }

    public DWDataRow getModelDataRow(String tableName) {
        log.debug("{} starting get model from tableName {}", (Object)logTag, (Object)tableName);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        option.setManagementFieldEnabled(false);
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_lcdp_model_info");
        queryInfo.setJoinOnColumn(DWQueryJoinRelation.Join, "dw_lcdp_model", new DWOnColumn[]{new DWOnColumn("code", DWQueryValueOperator.Equals, "code")});
        queryInfo.addEqualInfo("table_name", (Object)tableName);
        queryInfo.addSelectField(new String[]{"dw_lcdp_model.*"});
        DWDataRow dataRow = this.dao.selectOne(queryInfo, option);
        return dataRow;
    }

    public List<String> getExtendPublishedMainModelCode(String mainTableCode) {
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_lcdp_model_extend");
        queryInfo.addFieldInfo("main_table_code", DWQueryValueOperator.Equals, new Object[]{mainTableCode});
        queryInfo.addSelectField(new String[]{"extend_model_code"});
        DWDataSet dataSet = this.dao.select(queryInfo, option);
        DWDataTable dwModelTable = dataSet.getTables().getPrimaryTable();
        ArrayList<String> extendModelCodes = new ArrayList<String>();
        for (DWDataRow tempRow : dwModelTable.getRows()) {
            Map dataRowData = tempRow.getData();
            extendModelCodes.add((String)dataRowData.get("extend_model_code"));
        }
        return extendModelCodes;
    }

    public List<String> getExtendPublishedModelCodes(List<String> parentModelCodes) {
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_lcdp_model_extend");
        queryInfo.addFieldInfo("code", DWQueryValueOperator.In, (Object[])parentModelCodes.toArray(new String[0]));
        queryInfo.addSelectField(new String[]{"extend_model_code"});
        DWDataSet dataSet = this.dao.select(queryInfo, option);
        DWDataTable dwModelTable = dataSet.getTables().getPrimaryTable();
        ArrayList<String> extendModelCodes = new ArrayList<String>();
        for (DWDataRow tempRow : dwModelTable.getRows()) {
            Map dataRowData = tempRow.getData();
            extendModelCodes.add((String)dataRowData.get("extend_model_code"));
        }
        return extendModelCodes;
    }
}

