/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.utils.BMCenterUtil;
import com.digiwin.lcdp.modeldriven.customize.utils.BMEaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.eai.builder.EaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.eai.builder.ModelStandardEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.utils.EaiHeaderUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class EaiHeaderByProdUtil {
    private static final Logger log = LoggerFactory.getLogger(EaiHeaderByProdUtil.class);
    private static final String _CLASSTAG = "[" + EaiHeaderByProdUtil.class.getSimpleName() + "]";
    @Autowired
    private DWEAIHeaderRepository dwEAIHeaderRepository;
    @Autowired
    @Qualifier(value="dw-modeldriven-crud-eai-builder")
    private ModelStandardEaiHeaderBuilder modelStandardEAIHeaderBuilder;
    @Autowired(required=false)
    @Qualifier(value="modeldriven-customize-crud-eai-builder")
    private EaiHeaderBuilder customizeEAIHeaderBuilder;
    @Autowired(required=false)
    @Qualifier(value="modeldriven-customize-bmmix-builder")
    private EaiHeaderBuilder bmMixEAIHeaderBuilder;
    @Autowired
    EaiHeaderUtil eaiHeaderUtil;

    public List<DWEAIHeader> genModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        List<Object> newEaiHeaders = new ArrayList();
        BMProperties bmProperties = BMProperties.getProperties();
        if (bmProperties == null || !bmProperties.isEnabled()) {
            newEaiHeaders = this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos, this.modelStandardEAIHeaderBuilder);
            return newEaiHeaders;
        }
        newEaiHeaders = bmProperties.getRole() == BMRole.mix ? this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos, this.bmMixEAIHeaderBuilder) : this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos, this.customizeEAIHeaderBuilder);
        return newEaiHeaders;
    }

    public Map<String, Map<String, List<DWEAIHeader>>> genModelDrivenEaiHeadersByProd(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        BMProperties bmProperties = BMProperties.getProperties();
        Map<String, Map<String, List<DWEAIHeader>>> newEaiHeadersMap = new HashMap<String, Map<String, List<DWEAIHeader>>>();
        HashMap<String, List<DWServiceMapping>> serviceMappingMap = new HashMap<String, List<DWServiceMapping>>();
        if (bmProperties.getRole() == BMRole.mix) {
            serviceMappings.stream().forEach(serviceMapping -> {
                String appInfoProd = BMEaiServiceNameUtil.getAppProd(serviceMapping.getExposeEaiId(), serviceMapping.getTableName());
                if (StringUtils.isNotBlank((CharSequence)appInfoProd)) {
                    if (serviceMappingMap.containsKey(appInfoProd)) {
                        ((List)serviceMappingMap.get(appInfoProd)).add(serviceMapping);
                    } else {
                        ArrayList<DWServiceMapping> serviceMappingList = new ArrayList<DWServiceMapping>();
                        serviceMappingList.add((DWServiceMapping)serviceMapping);
                        serviceMappingMap.put(appInfoProd, serviceMappingList);
                    }
                }
            });
            Map<String, List<MappingModelInfo>> mappingModelInfoMap = EaiHeaderByProdUtil.getModelInfoMap(mappingModelInfos);
            newEaiHeadersMap = this.bmMixEAIHeaderBuilder.getProdTechEaiHeaders(serviceMappingMap, mappingModelInfoMap);
        }
        return newEaiHeadersMap;
    }

    public List<DWEAIHeader> genModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos, EaiHeaderBuilder eaiHeaderBuilder) throws Exception {
        log.info("{} genEaiHeaders using {}", (Object)_CLASSTAG, (Object)eaiHeaderBuilder.toString());
        List<DWEAIHeader> newEaiHeaders = eaiHeaderBuilder.getEaiHeaders(serviceMappings, mappingModelInfos);
        return newEaiHeaders;
    }

    public Map<String, Map<String, List<DWEAIHeader>>> updateAndGetModelDrivenEaiHeadersByProd(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        Map<String, Map<String, List<DWEAIHeader>>> newEaiHeaders = this.genModelDrivenEaiHeadersByProd(serviceMappings, mappingModelInfos);
        this.addAndUpdateDWEaiHeadersByProd(newEaiHeaders);
        return newEaiHeaders;
    }

    private void addAndUpdateDWEaiHeadersByProd(Map<String, Map<String, List<DWEAIHeader>>> newEaiHeaders) throws Exception {
        ArrayList<DWEAIHeader> allNewEaiHeaders = new ArrayList<DWEAIHeader>();
        for (String prod : newEaiHeaders.keySet()) {
            Map<String, List<DWEAIHeader>> prodEaiHeaders = newEaiHeaders.get(prod);
            for (String type : prodEaiHeaders.keySet()) {
                List<DWEAIHeader> typeEaiHeaders = prodEaiHeaders.get(type);
                if (CollectionUtils.isNotEmpty(typeEaiHeaders)) {
                    List allNewEaiHeaderList = allNewEaiHeaders.stream().map(newEaiHeader -> newEaiHeader.getEAIServiceId()).collect(Collectors.toList());
                    List typeNewHeaders = typeEaiHeaders.stream().filter(typeEaiHeader -> !allNewEaiHeaderList.contains(typeEaiHeader.getEAIServiceId())).collect(Collectors.toList());
                    allNewEaiHeaders.addAll(typeNewHeaders);
                    log.debug("{} added: {}", (Object)_CLASSTAG, typeNewHeaders.stream().map(newEaiHeader -> newEaiHeader.getEAIServiceId()).collect(Collectors.toList()));
                    continue;
                }
                log.info("{}[addAndUpdateDWEaiHeadersByProd] ignored add prod({}) type({}), cause empty newEaiHeaders", new Object[]{_CLASSTAG, prod, type});
            }
        }
        log.debug("{} get all new DWEAIHeaders({})", (Object)_CLASSTAG, (Object)allNewEaiHeaders.size());
        this.addAndUpdateDWEaiHeaders(allNewEaiHeaders);
    }

    public void addAndUpdateDWEaiHeaders(List<DWEAIHeader> newEaiHeaders) throws Exception {
        this.eaiHeaderUtil.addAndUpdateCommonsHeaders(newEaiHeaders);
    }

    public List<DWHeader> getDropEaiHeaders(List<DWEAIHeader> draftEaiHeaders, List<DWHeader> actualHeaders) {
        List<Object> dropEaiHeaders = new ArrayList<DWHeader>();
        if (CollectionUtils.isNotEmpty(actualHeaders)) {
            dropEaiHeaders = actualHeaders.stream().filter(actual -> draftEaiHeaders.stream().noneMatch(draft -> ((DWEAIHeader)actual).getEAIServiceId().equals(draft.getEAIServiceId()))).collect(Collectors.toList());
            log.info("{} drop size({}) ({})", new Object[]{_CLASSTAG, dropEaiHeaders.size(), dropEaiHeaders});
        } else {
            log.info("{} ignored drop any DWEAIHeader", (Object)_CLASSTAG);
        }
        return dropEaiHeaders;
    }

    public void executeDropExistedEaiHeaders(List<DWHeader> dropEaiHeaders) {
        List orgDWHeaders = this.dwEAIHeaderRepository.getHeaders("commons");
        int repoBefore = orgDWHeaders.size();
        dropEaiHeaders.stream().forEach(dropDWHeader -> orgDWHeaders.remove(dropDWHeader));
        List dropList = dropEaiHeaders.stream().map(dropEaiHeader -> ((DWEAIHeader)dropEaiHeader).getEAIServiceId()).collect(Collectors.toList());
        int repoAfter = orgDWHeaders.size();
        log.info("{} drop DWEAIHeaderRepository--> dropped({},{})(dwEAIHeaderRepo: before({}), after({}))", new Object[]{_CLASSTAG, dropList.size(), dropList, repoBefore, orgDWHeaders.size()});
    }

    public List<DWEAIHeader> getAddEaiHeaders(List<DWEAIHeader> draftEaiHeaders, List<DWHeader> actualHeaders) {
        List<Object> addEaiHeaders = new ArrayList();
        addEaiHeaders = draftEaiHeaders.stream().filter(draft -> actualHeaders.stream().noneMatch(actual -> Objects.equals(draft.getEAIServiceId(), ((DWEAIHeader)actual).getEAIServiceId()))).collect(Collectors.toList());
        int dropHeaderCount = addEaiHeaders.size();
        log.info("{} drop size({}) ({})", new Object[]{_CLASSTAG, dropHeaderCount, addEaiHeaders});
        return addEaiHeaders;
    }

    public List<DWEAIHeader> genServiceModelInfoData(ModelSchemaDTO masterModelSchema, String modelDrivenProdPrefix, String code) throws Exception {
        String masterTableName = masterModelSchema.getName();
        String userExposePrefixEaiId = EaiServiceNameUtil.getEaiPrefixName(modelDrivenProdPrefix, masterTableName);
        String modelSchemaStr = ModelDataUtil.getModelSchemaStr(masterModelSchema);
        List<ModelSchemaDTO> allChildrenSchemas = ModelSchemaUtil.getChildrenModelSchema(masterModelSchema.getChildren());
        DWServiceMapping serviceMapping = new DWServiceMapping();
        serviceMapping.setTableName(masterTableName);
        serviceMapping.setExposeEaiId(userExposePrefixEaiId);
        serviceMapping.setModelSchema(modelSchemaStr);
        serviceMapping.setCode(code);
        ArrayList<DWServiceMapping> serviceMappings = new ArrayList<DWServiceMapping>();
        serviceMappings.add(serviceMapping);
        List<MappingModelInfo> mappingModelInfos = ModelDataUtil.getChildrenMappingModelInfo(allChildrenSchemas, masterTableName, userExposePrefixEaiId, code);
        BMProperties bmProperties = BMProperties.getProperties();
        if (bmProperties != null && bmProperties.isEnabled()) {
            BMCenterUtil.modifyServiceMapping(serviceMappings);
            BMCenterUtil.modifyMappingModelInfo(mappingModelInfos);
        }
        List<DWEAIHeader> eaiHeaders = this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos);
        return eaiHeaders;
    }

    public List<DWHeader> getExistedEaiHeaders(List<DWEAIHeader> dweaiHeaders) {
        List<Object> existedEaiHeaders = new ArrayList<DWHeader>();
        if (CollectionUtils.isNotEmpty(dweaiHeaders)) {
            List orgDWHeaders = this.dwEAIHeaderRepository.getHeaders("commons");
            existedEaiHeaders = orgDWHeaders.stream().filter(orgDWHeader -> orgDWHeader instanceof DWEAIHeader && dweaiHeaders.stream().anyMatch(dweaiHeader -> ((DWEAIHeader)orgDWHeader).getEAIServiceId().equals(dweaiHeader.getEAIServiceId()))).collect(Collectors.toList());
            log.info("{} get existedEaiHeaders({} from DWEAIHeaderRepository({}({})))", new Object[]{_CLASSTAG, existedEaiHeaders.size(), "commons", orgDWHeaders.size()});
        } else {
            log.info("{} ignored get existedEaiHeaders  from DWEAIHeaderRepository", (Object)_CLASSTAG);
        }
        return existedEaiHeaders;
    }

    public static Map<String, List<MappingModelInfo>> getModelInfoMap(List<MappingModelInfo> mappingModelInfos) {
        HashMap<String, List<MappingModelInfo>> mappingModelInfoMap = new HashMap<String, List<MappingModelInfo>>();
        mappingModelInfos.stream().forEach(mappingModelInfo -> {
            String appInfoProd = BMEaiServiceNameUtil.getAppProd(mappingModelInfo.getEaiid(), mappingModelInfo.getTablename());
            if (StringUtils.isNotBlank((CharSequence)appInfoProd)) {
                if (mappingModelInfoMap.containsKey(appInfoProd)) {
                    ((List)mappingModelInfoMap.get(appInfoProd)).add(mappingModelInfo);
                } else {
                    ArrayList<MappingModelInfo> serviceMappingList = new ArrayList<MappingModelInfo>();
                    serviceMappingList.add((MappingModelInfo)mappingModelInfo);
                    mappingModelInfoMap.put(appInfoProd, serviceMappingList);
                }
            }
        });
        return mappingModelInfoMap;
    }
}

