/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.metadata.DWMetadata;
import com.digiwin.app.metadata.exceptions.DWMetadataNotFoundException;
import com.digiwin.app.metadata.rdbms.DWRdbmsField;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.data.permission.DWRowPermissionBase;
import com.digiwin.data.permission.DWRowPermissionDefaultMatchOption;
import com.digiwin.data.permission.DWRowPermissionEmpty;
import com.digiwin.data.permission.DWRowPermissionGroup;
import com.digiwin.data.permission.DWRowPermissionMatchOption;
import com.digiwin.data.permission.DWUserPermission;
import com.digiwin.lcdp.modeldriven.constants.ModelDBConstants;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.utils.BMDataModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.enums.AlterAutoIncrementEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterColumnEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterIndexEnum;
import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.ModelCreateTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelFieldDTO;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.ModelTableSchemaCache;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.model.TableSqlParamDTO;
import com.digiwin.lcdp.modeldriven.utils.ApTokenUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMetadataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelNewSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelTablePartialSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelTableSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.compare.ColumnCompareUtil;
import com.digiwin.lcdp.modeldriven.utils.compare.IndexCompareUtil;
import com.digiwin.lcdp.modeldriven.utils.compare.TableCompareUtil;
import com.digiwin.utils.DWTenantUtils;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.parser.SimpleNode;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.alter.AlterExpression;
import net.sf.jsqlparser.statement.alter.AlterOperation;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelSqlGenerator {
    private static final Logger log = LoggerFactory.getLogger(ModelSqlGenerator.class);
    private static final String CLASS_LOG_TAG = "[" + ModelSqlGenerator.class.getSimpleName() + "]";
    private static final SimpleDateFormat bindedSqlDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static SqlParam generateAlterTableSql(String tableName, String tableComment) {
        String modifyTableCommentSql = String.format("ALTER TABLE `%s` %s '%s' ", tableName, "COMMENT", tableComment);
        return new SqlParam(modifyTableCommentSql, new Object[0]);
    }

    public static SqlParam generateAlterTableCollationSql(String tableName, String collation) {
        String modifyTableCommentSql = String.format("ALTER TABLE `%s` COLLATE '%s' ", tableName, collation);
        return new SqlParam(modifyTableCommentSql, new Object[0]);
    }

    public static LinkedList<SqlParam> generateAlterIndexSql(String tableName, AlterIndexEnum alterIndexEnum, TableIndex tableIndex) {
        LinkedList<SqlParam> sqlParams = new LinkedList<SqlParam>();
        String targetIndexId = tableIndex.getName();
        ModelIndexDTO targetModelIndex = ModelSchemaUtil.convertTableIndexToModelIndex(tableIndex);
        Map<String, ModelTableSchemaCache> publishedTableCache = ModelDrivenContext.getContext().getPublishedTableCache();
        ModelTableSchemaCache modelTableSchemaCache = publishedTableCache.getOrDefault(tableName, new ModelTableSchemaCache());
        Map<String, Object> publishedRemainIndexes = modelTableSchemaCache.getPublishedRemainIndexes();
        switch (alterIndexEnum) {
            case ADD: {
                String indexAddSpecification = IndexCompareUtil.generateIndexes(tableIndex);
                String indexAddSql = String.format("ALTER TABLE `%s` %s %s", tableName, alterIndexEnum.getSqlChar(), indexAddSpecification);
                sqlParams.add(new SqlParam(indexAddSql, new Object[0]));
                publishedRemainIndexes.put(targetIndexId, targetModelIndex);
                log.info("publishedRemainIndexes add {}({})", (Object)targetIndexId, (Object)targetModelIndex);
                break;
            }
            case MODIFY: {
                String alterSpecification = IndexCompareUtil.generateIndexes(tableIndex);
                if (targetIndexId.equals("PRIMARY KEY")) break;
                if (publishedRemainIndexes.containsKey(targetIndexId)) {
                    log.info("flag1");
                    String indexDropByModifySql = String.format("ALTER TABLE `%s` DROP INDEX `%s`", tableName, targetIndexId);
                    String indexAddByModifySql = String.format("ALTER TABLE `%s` ADD %s", tableName, alterSpecification);
                    sqlParams.add(new SqlParam(indexDropByModifySql, new Object[0]));
                    sqlParams.add(new SqlParam(indexAddByModifySql, new Object[0]));
                    publishedRemainIndexes.put(targetIndexId, targetModelIndex);
                    log.info("publishedRemainIndexes modify {} ({})", (Object)targetIndexId, (Object)targetModelIndex);
                    break;
                }
                String indexAddByModifySql = String.format("ALTER TABLE `%s` ADD %s", tableName, alterSpecification);
                sqlParams.add(new SqlParam(indexAddByModifySql, new Object[0]));
                publishedRemainIndexes.put(targetIndexId, targetModelIndex);
                log.info("publishedRemainIndexes add {} when modify", (Object)targetIndexId);
                break;
            }
            case DROP: {
                if (publishedRemainIndexes.containsKey(targetIndexId) && !targetIndexId.equals("PRIMARY KEY")) {
                    log.info("flag2");
                    String dropColumnSql = String.format("ALTER TABLE `%s` DROP INDEX `%s` ", tableName, targetIndexId);
                    sqlParams.add(new SqlParam(dropColumnSql, null));
                    publishedRemainIndexes.remove(targetIndexId);
                    log.info("publishedRemainIndexes: remove {}", (Object)targetIndexId);
                    break;
                }
                log.warn("publishedRemainIndexes: ignored to drop {}", (Object)targetIndexId);
                break;
            }
            default: {
                throw new DWRuntimeException("\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c");
            }
        }
        return sqlParams;
    }

    public static LinkedList<SqlParam> generateAlterColumnsSql(String tableName, AlterColumnEnum alterColumnEnum, TableColumn draftTableColumn) {
        ModelTable actualModelTable = ModelDrivenContext.getActualModelTable(tableName);
        boolean isExistedTable = false;
        if (actualModelTable != null) {
            isExistedTable = true;
        }
        LinkedList<SqlParam> sqlParams = new LinkedList<SqlParam>();
        switch (alterColumnEnum) {
            case ADD_COLUMN: {
                String addColumnSql = String.format("ALTER TABLE `%s` %s `%s` %s %s %s %s %s '%s' ", tableName, alterColumnEnum.getSqlChar(), draftTableColumn.getColumnName(), ColumnCompareUtil.getTypeDDL(draftTableColumn), ColumnCompareUtil.getNullableEnum(draftTableColumn.nullable()).getSqlChar(), ColumnCompareUtil.columnUniqueValue(draftTableColumn.getUnique()), ColumnCompareUtil.getDefaultValue(draftTableColumn, isExistedTable), "COMMENT", draftTableColumn.getComment());
                sqlParams.add(new SqlParam(addColumnSql, new Object[0]));
                break;
            }
            case MODIFY_COLUMN: {
                String pkCondtion;
                String autoIncrementOrDefaultValue = ColumnCompareUtil.getSqlByAutoIncrementOrDefaultValue(draftTableColumn, false);
                String modifyColumnSql = String.format("ALTER TABLE `%s` %s `%s` %s %s %s %s '%s' %s ", tableName, alterColumnEnum.getSqlChar(), draftTableColumn.getColumnName(), ColumnCompareUtil.getTypeDDL(draftTableColumn), ColumnCompareUtil.getNullableEnum(draftTableColumn.nullable()).getSqlChar(), autoIncrementOrDefaultValue, "COMMENT", draftTableColumn.getComment(), TableCompareUtil.getCollation(draftTableColumn.getDataType(), isExistedTable, alterColumnEnum));
                if (autoIncrementOrDefaultValue.toUpperCase().contains("AUTO_INCREMENT") && StringUtils.isNotBlank((CharSequence)(pkCondtion = ModelSqlGenerator.getPrimaryKeyCondition(tableName, autoIncrementOrDefaultValue, draftTableColumn)))) {
                    modifyColumnSql = String.join((CharSequence)",", modifyColumnSql, pkCondtion);
                }
                sqlParams.add(new SqlParam(modifyColumnSql, new Object[0]));
                break;
            }
            case DROP_COLUMN: {
                String dropColumnSql = String.format("ALTER TABLE `%s` %s `%s` ", tableName, alterColumnEnum.getSqlChar(), draftTableColumn.getColumnName());
                sqlParams.add(new SqlParam(dropColumnSql, new Object[0]));
                break;
            }
            default: {
                throw new DWRuntimeException("\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c");
            }
        }
        return sqlParams;
    }

    public static SqlParam generateAlterColumnRemoveAutoIncreAndPkSql(String tableName, AlterColumnEnum alterColumnEnum, TableColumn tableColumn) {
        switch (alterColumnEnum) {
            case MODIFY_COLUMN: {
                String modifyColumnSql = String.format("ALTER TABLE `%s` %s `%s` %s NULL %s '%s' , DROP %s", tableName, alterColumnEnum.getSqlChar(), tableColumn.getColumnName(), ColumnCompareUtil.getTypeDDL(tableColumn), "COMMENT", tableColumn.getComment(), "PRIMARY KEY");
                return new SqlParam(modifyColumnSql, new Object[0]);
            }
        }
        throw new DWRuntimeException("\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c");
    }

    public static SqlParam generateDropTableSql(String tableName) {
        SqlParam sqlParam = ModelSqlGenerator.generateRenameTableSql(tableName);
        return sqlParam;
    }

    public static SqlParam generateRenameTableSql(String tableName) {
        Table alterTable = new Table(tableName);
        Alter alterScript = new Alter();
        alterScript.setTable(alterTable);
        AlterExpression renameTableNameExpression = new AlterExpression();
        renameTableNameExpression.setOperation(AlterOperation.RENAME_TABLE);
        Long timeStamp = new Timestamp(System.currentTimeMillis() / 1000L).getTime();
        renameTableNameExpression.setNewTableName(String.join((CharSequence)"_", "md", timeStamp.toString(), tableName));
        alterScript.addAlterExpression(renameTableNameExpression);
        String sql = alterScript.toString();
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(sql);
        return sqlParam;
    }

    public static SqlParam generateDeleteServiceMappingSql(ModelTable modelTable) {
        String tableName = modelTable.getName();
        SqlParam deleteServiceMapping = ModelSqlGenerator.generateDeleteServiceMappingSql(tableName);
        return deleteServiceMapping;
    }

    public static SqlParam generateDeleteServiceMappingSql(String tableName) {
        String deleteRdbmsTableSql = String.format("delete from %s where table_name = ?", "dw_service_mapping");
        return new SqlParam(deleteRdbmsTableSql, new Object[]{tableName});
    }

    public static SqlParam generateInsertModelSql(ModelDTO model) {
        String code = model.getCode();
        String modelSchemaStr = ModelDataUtil.getDraftModelSchemaFromContextDraftJson();
        String tenantSidColumnName = DWTenantUtils.getTenantColumnName();
        Object tenantSid = DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey());
        Object tenantUserSid = DWServiceContext.getContext().getProfile().get("userSid");
        String insertServiceMappingSql = String.format("insert into dw_lcdp_model (code, description, model_schema, target_tenant_id, app_id, %s , create_user_sid , create_time ) values(?, ?, ?, ?, ?, ?, ? ,?)", tenantSidColumnName);
        return new SqlParam(insertServiceMappingSql, new Object[]{code, model.getDescription(), modelSchemaStr, model.getTargetTenantId(), model.getAppId(), tenantSid, tenantUserSid, new Date()});
    }

    public static LinkedList<SqlParam> generateUpdateModelInfoSql(List<ModelTable> modelTables, String code) {
        LinkedList<SqlParam> updateSqlParams = ModelSqlGenerator.generateDeleteModelInfoSql(code);
        updateSqlParams.addAll(ModelSqlGenerator.generateInsertModelInfoSql(modelTables, code));
        return updateSqlParams;
    }

    public static LinkedList<SqlParam> generateDeleteModelSql(String code) {
        String insertModelInfoSql = String.format("delete from dw_lcdp_model where code=?", new Object[0]);
        Object[] sqlParamParams = new Object[]{code};
        SqlParam sqlParam = new SqlParam(insertModelInfoSql, sqlParamParams);
        LinkedList<SqlParam> sqlParams = new LinkedList<SqlParam>();
        sqlParams.add(sqlParam);
        return sqlParams;
    }

    public static LinkedList<SqlParam> generateDeleteModelInfoSql(String code) {
        String insertModelInfoSql = String.format("delete from dw_lcdp_model_info where code=?", new Object[0]);
        Object[] sqlParamParams = new Object[]{code};
        SqlParam sqlParam = new SqlParam(insertModelInfoSql, sqlParamParams);
        LinkedList<SqlParam> sqlParams = new LinkedList<SqlParam>();
        sqlParams.add(sqlParam);
        return sqlParams;
    }

    public static LinkedList<SqlParam> generateDeleteDataViewSql(String code) {
        String deleteDataViewSql = String.format("delete from dw_lcdp_data_view where modelId=?", new Object[0]);
        Object[] sqlParamParams = new Object[]{code};
        SqlParam sqlParam = new SqlParam(deleteDataViewSql, sqlParamParams);
        LinkedList<SqlParam> sqlParams = new LinkedList<SqlParam>();
        sqlParams.add(sqlParam);
        return sqlParams;
    }

    public static LinkedList<SqlParam> generateDeleteActivitySql(String code) {
        String deleteActivitySql = String.format("delete from dw_lcdp_model_activity where code=?", new Object[0]);
        Object[] sqlParamParams = new Object[]{code};
        SqlParam sqlParam = new SqlParam(deleteActivitySql, sqlParamParams);
        LinkedList<SqlParam> sqlParams = new LinkedList<SqlParam>();
        sqlParams.add(sqlParam);
        return sqlParams;
    }

    public static List<SqlParam> generateInsertModelInfoSql(List<ModelTable> modelTables, String code) {
        ArrayList<SqlParam> sqlParams = new ArrayList<SqlParam>();
        for (ModelTable modelTable : modelTables) {
            SqlParam sqlParam = ModelSqlGenerator.generateInsertModelInfoSql(modelTable, code);
            sqlParams.add(sqlParam);
        }
        return sqlParams;
    }

    public static SqlParam generateInsertModelInfoSql(ModelTable modelTable, String code) {
        String tenantSidColumnName = DWTenantUtils.getTenantColumnName();
        Object tenantSid = DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey());
        String tenantId = ApTokenUtil.getCurrentTenantId();
        Object tenantUserSid = DWServiceContext.getContext().getProfile().get("userSid");
        String appId = ApTokenUtil.getCurrentAppId();
        String tableName = modelTable.getName();
        String insertModelInfoSql = String.format("insert into dw_lcdp_model_info (code, table_name, app_id, tenant_id, create_user_sid, create_time, %s ) values( ?, ?, ?, ?, ?, ?, ? ) ON DUPLICATE KEY UPDATE app_id=?, tenant_id=?, update_user_sid=?, %s =? ", tenantSidColumnName, tenantSidColumnName);
        Object[] sqlParamParams = new Object[]{code, tableName, appId, tenantId, tenantUserSid, new Date(), tenantSid, appId, tenantId, tenantUserSid, tenantSid};
        SqlParam sqlParam = new SqlParam(insertModelInfoSql, sqlParamParams);
        return sqlParam;
    }

    public static List<SqlParam> generateUpdateModelSql(ModelDTO model) {
        String code = model.getCode();
        String modelSchemaStr = ModelDataUtil.getDraftModelSchemaFromContextDraftJson();
        Object tenantUserSid = DWServiceContext.getContext().getProfile().get("userSid");
        Object[] params = new Object[]{model.getDescription(), modelSchemaStr, tenantUserSid, code, model.getAppId()};
        String updateModelSql = "update dw_lcdp_model set description=?, model_schema=? , update_user_sid=? where code=? and app_id=? ";
        SqlParam modelSqlParam = new SqlParam(updateModelSql, params);
        ArrayList<SqlParam> returnValue = new ArrayList<SqlParam>();
        returnValue.add(modelSqlParam);
        return returnValue;
    }

    public static SqlParam generateUpdateRdbmsTableSql(ModelTable modelTable) {
        String updateRdbmsTableSql = "update dw_rdbms_tables  set table_display_name = ? , table_description = ? where table_name = ?";
        return new SqlParam(updateRdbmsTableSql, new Object[]{modelTable.getComment(), modelTable.getComment(), modelTable.getName()});
    }

    public static SqlParam generateUpdateRdbmsFieldSql(String tableName, TableColumn tableColumn) {
        String isPk = ColumnCompareUtil.booleanToYN(tableColumn.isPK());
        String defaultValue = tableColumn.getDefaultValue() != null ? tableColumn.getDefaultValue() : "null";
        Integer size = ColumnCompareUtil.getUpdateSize(tableColumn.getSize(), tableColumn.getDataType().getDefaultSize());
        Integer scale = ColumnCompareUtil.getUpdateSize(tableColumn.getScale(), tableColumn.getDataType().getDefaultScale());
        String nullable = ColumnCompareUtil.booleanToYN(tableColumn.nullable());
        String autoIncrement = ColumnCompareUtil.booleanToYN(tableColumn.getAutoIncrement() != false || tableColumn.getAutoIncrement() != false);
        String updateRdbmsFieldSql = "update dw_rdbms_fields  set field_name = ?, is_key = ?, field_type = ? , field_display_name = ?, default_value = ?, nullable = ?, size = ? , scale = ? , is_auto_increment = ? where table_name = ? and field_name = ?";
        return new SqlParam(updateRdbmsFieldSql, new Object[]{tableColumn.getColumnName(), isPk, tableColumn.getDataType().getName(), tableColumn.getComment(), defaultValue, nullable, size, scale, autoIncrement, tableName, tableColumn.getColumnName()});
    }

    public static SqlParam generateUpdateRdbmsFieldRemovePrimarySql(String tableName) {
        String updateRdbmsFieldSql = "update dw_rdbms_fields set is_key = ? where table_name = ?";
        return new SqlParam(updateRdbmsFieldSql, new Object[]{"N", tableName});
    }

    public static SqlParam generateInsertOrUpdateRdbmsFieldWithRemoveAutoIncrementSql(String tableName, TableColumn tableColumn) {
        String insertRdbmsFieldSql = "insert into dw_rdbms_fields (table_name, seq, field_name, field_display_name, nullable, is_auto_increment)  values (?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE table_name=?, default_value=?, nullable=?, is_auto_increment=?";
        Object[] sqlParamParams = new Object[]{tableName, 0, tableColumn.getColumnName(), tableColumn.getColumnName(), "N", "N", tableName, null, "N", "N"};
        return new SqlParam(insertRdbmsFieldSql, sqlParamParams);
    }

    public static SqlParam generateDeleteRdbmsTableSql(String tableName) {
        String deleteRdbmsTableSql = "delete from dw_rdbms_tables where table_name = ?";
        return new SqlParam(deleteRdbmsTableSql, new Object[]{tableName});
    }

    public static SqlParam generateDeleteRdbmsFieldSql(ModelTable modelTable) {
        String tableName = modelTable.getName();
        return ModelSqlGenerator.generateDeleteRdbmsFieldSql(tableName);
    }

    public static SqlParam generateDeleteRdbmsFieldSql(String tableName) {
        String deleteRdbmsFieldSql = "delete from dw_rdbms_fields where table_name = ?";
        return new SqlParam(deleteRdbmsFieldSql, new Object[]{tableName});
    }

    public static SqlParam generateDeleteRdbmsFieldSql(String tableName, String columnName) {
        if (columnName == null || columnName.isEmpty()) {
            return ModelSqlGenerator.generateDeleteRdbmsFieldSql(tableName);
        }
        String deleteRdbmsTableSql = "delete from dw_rdbms_fields where table_name = ? and field_name = ?";
        return new SqlParam(deleteRdbmsTableSql, new Object[]{tableName, columnName});
    }

    public static SqlParam generateDeleteRdbmsRelationForChildTableSql(String primaryTableName, String childTableName) {
        String sql = "delete from dw_rdbms_relations where primary_table_no = ? and reference_table_no = ?";
        return new SqlParam(sql, new Object[]{primaryTableName, childTableName});
    }

    public static String generateConstrainChainValue(List<String> tablePks) {
        String returnValue = tablePks.stream().map(customColumn -> "`" + customColumn + "`").collect(Collectors.joining(","));
        return returnValue;
    }

    public static String getCombinedSql(SqlParam sqlParam) throws JSQLParserException {
        String sql;
        block12: {
            Statement statement;
            Object[] params;
            block11: {
                Object value;
                int i;
                sql = sqlParam.getSql();
                sql = sql.replaceAll("^\\s+", "");
                params = sqlParam.getParams();
                if (StringUtils.startsWithIgnoreCase((CharSequence)sql, (CharSequence)"CREATE TABLE") || StringUtils.startsWithIgnoreCase((CharSequence)sql, (CharSequence)"ALTER TABLE")) {
                    return sql;
                }
                statement = CCJSqlParserUtil.parse((String)sql, null);
                if (!(statement instanceof Insert)) break block11;
                Insert insert = (Insert)statement;
                ItemsList itemsList = insert.getItemsList();
                List duplicateUpdateExpressionList = insert.getDuplicateUpdateExpressionList();
                if (!(itemsList instanceof ExpressionList)) break block12;
                ExpressionList list = (ExpressionList)itemsList;
                List listExp = list.getExpressions();
                int paramIndex = 0;
                for (Expression expression : listExp) {
                    if (expression instanceof JdbcParameter) {
                        i = ((JdbcParameter)expression).getIndex();
                        value = params[i - 1];
                        sql = sql.replaceFirst("\\?", (String)(value == null ? "null" : (value instanceof String ? "'" + String.valueOf(value) + "'" : (value instanceof Date ? "'" + bindedSqlDateTimeFormat.format(value) + "'" : value.toString()))));
                        log.debug("process paramIndex({}) org({}) , new({}), new sql({})", new Object[]{paramIndex, "?", value == null ? "null" : "'" + value.toString() + "'", sql});
                    } else if (expression instanceof StringValue) {
                        SimpleNode node = expression.getASTNode();
                        log.debug("process paramIndex({}) node({})", (Object)paramIndex, node.jjtGetValue());
                    } else if (expression instanceof NullValue) {
                        log.debug("process paramIndex({}) node({})", (Object)paramIndex, (Object)"NULL/null");
                    }
                    ++paramIndex;
                }
                if (CollectionUtils.isNotEmpty((Collection)duplicateUpdateExpressionList)) {
                    int paramLength = list.getExpressions().stream().filter(item -> item.toString().equals("?")).toArray().length;
                    int duplicateUpdateLenthg = duplicateUpdateExpressionList.stream().filter(item -> item.toString().equals("?")).toArray().length;
                    for (i = 0; i < duplicateUpdateLenthg; ++i) {
                        value = params[paramLength + i];
                        sql = sql.replaceFirst("\\?", (String)(value == null ? "null" : (value instanceof String ? "'" + String.valueOf(value) + "'" : (value instanceof Date ? "'" + bindedSqlDateTimeFormat.format(value) + "'" : value.toString()))));
                    }
                }
                break block12;
            }
            if (statement instanceof Select || statement instanceof Update || statement instanceof Delete) {
                int i = 0;
                while (sql.indexOf("?") != -1) {
                    Object value = params[i];
                    ++i;
                    sql = sql.replaceFirst("\\?", (String)(value == null ? "null" : (value instanceof String ? "'" + String.valueOf(value) + "'" : (value instanceof Date ? "'" + bindedSqlDateTimeFormat.format(value) + "'" : value.toString()))));
                }
            }
        }
        return sql;
    }

    public static Map<String, Object> getModelSql(ModelDTO model) throws Exception {
        List<ModelSchemaDTO> childrenModelSchema;
        List<ModelSchemaDTO> childrenSchemas;
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        ModelSchemaDTO modelSchema = model.getSchema();
        String code = model.getCode();
        ArrayList sqlList = new ArrayList();
        ArrayList<String> bindedSql = new ArrayList<String>();
        SqlParam createModelSqlParam = ModelSqlGenerator.generateInsertModelSql(model);
        bindedSql.add(ModelSqlGenerator.getCombinedSql(createModelSqlParam));
        ModelTable mainModelTable = ModelSchemaUtil.getCurrentLevelModelTable(modelSchema);
        SqlParam createMainModelInfoSqlParam = ModelSqlGenerator.generateInsertModelInfoSql(mainModelTable, model.getCode());
        bindedSql.add(ModelSqlGenerator.getCombinedSql(createMainModelInfoSqlParam));
        SqlParam createServiceMappingSqlParam = ModelSqlGenerator.generateInsertOrUpdateServiceMapping(model);
        bindedSql.add(ModelSqlGenerator.getCombinedSql(createServiceMappingSqlParam));
        SqlParam createTableSqlParam = ModelNewSqlGenerator.generateCreateTableSql(mainModelTable);
        bindedSql.add(createTableSqlParam.getSql());
        SqlParam insertRdbmsTableSqlParam = ModelNewSqlGenerator.generateInsertRdbmsTableSql(mainModelTable);
        bindedSql.add(ModelSqlGenerator.getCombinedSql(insertRdbmsTableSqlParam));
        List<SqlParam> insertRdbmsFieldSqlParam = ModelNewSqlGenerator.generateInsertOrUpdateRdbmsFieldSql(mainModelTable);
        if (CollectionUtils.isNotEmpty(insertRdbmsFieldSqlParam)) {
            insertRdbmsFieldSqlParam.forEach(sqlParam -> {
                try {
                    bindedSql.add(ModelSqlGenerator.getCombinedSql(sqlParam));
                }
                catch (JSQLParserException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(childrenSchemas = modelSchema.getChildren()) && CollectionUtils.isNotEmpty(childrenModelSchema = ModelSchemaUtil.getChildrenModelSchema(childrenSchemas))) {
            for (ModelSchemaDTO childModelSchemaDTO : childrenModelSchema) {
                ModelTable childModelTable = ModelSchemaUtil.getCurrentLevelModelTable(childModelSchemaDTO);
                SqlParam createClildTableSqlParam = ModelNewSqlGenerator.generateCreateTableSql(childModelTable);
                bindedSql.add(createClildTableSqlParam.getSql());
                SqlParam insertClildModelInfoSqlParam = ModelSqlGenerator.generateInsertModelInfoSql(childModelTable, code);
                bindedSql.add(ModelSqlGenerator.getCombinedSql(insertClildModelInfoSqlParam));
                SqlParam insertChildRdbmsTableSqlParam = ModelNewSqlGenerator.generateInsertRdbmsTableSql(childModelTable);
                bindedSql.add(ModelSqlGenerator.getCombinedSql(insertChildRdbmsTableSqlParam));
                List<SqlParam> insertChildRdbmsFieldSqlParam = ModelNewSqlGenerator.generateInsertOrUpdateRdbmsFieldSql(childModelTable);
                if (!CollectionUtils.isNotEmpty(insertRdbmsFieldSqlParam)) continue;
                insertChildRdbmsFieldSqlParam.forEach(sqlParam -> {
                    try {
                        bindedSql.add(ModelSqlGenerator.getCombinedSql(sqlParam));
                    }
                    catch (JSQLParserException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        returnValue.put(code, sqlList);
        returnValue.put("bindedSql", bindedSql);
        return returnValue;
    }

    public static TableSqlParamDTO getCreateTable(ModelTable modelTable) {
        TableSqlParamDTO tableSqlParamDTO = new TableSqlParamDTO();
        SqlParam createRdbmsTableParam = ModelNewSqlGenerator.generateInsertRdbmsTableSql(modelTable);
        tableSqlParamDTO.getDmlSqlParams().add(createRdbmsTableParam);
        List<SqlParam> createRdbmsFieldsParam = ModelNewSqlGenerator.generateInsertOrUpdateRdbmsFieldSql(modelTable);
        tableSqlParamDTO.getDmlSqlParams().addAll(createRdbmsFieldsParam);
        SqlParam createTableSqlParam = ModelNewSqlGenerator.generateCreateTableSql(modelTable);
        tableSqlParamDTO.getDdlSqlParams().add(createTableSqlParam);
        if (log.isDebugEnabled()) {
            log.debug(">>>>> gen Insert Rdbms SQL: {}", (Object)modelTable.getName(), (Object)tableSqlParamDTO.toString());
            log.debug(">>>>> gen Create Table SQL: {}", (Object)modelTable.getName(), (Object)createTableSqlParam);
        }
        return tableSqlParamDTO;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> getDropChildTables(List<ModelTable> childTableNames) {
        LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        for (ModelTable modelTable : childTableNames) {
            ArrayList<SqlParam> dmlSqlParams = new ArrayList<SqlParam>();
            ArrayList<SqlParam> ddlSqlParams = new ArrayList<SqlParam>();
            LinkedHashMap<String, ArrayList<SqlParam>> childDDMLValue = new LinkedHashMap<String, ArrayList<SqlParam>>();
            String childTableName = modelTable.getName();
            log.debug("{} start gen delete(rename) table: {}", (Object)CLASS_LOG_TAG, (Object)childTableName);
            SqlParam deleteRdbmsTableParam = ModelSqlGenerator.generateDeleteRdbmsTableSql(childTableName);
            dmlSqlParams.add(deleteRdbmsTableParam);
            SqlParam deleteRdbmsFieldsParam = ModelSqlGenerator.generateDeleteRdbmsFieldSql(modelTable);
            dmlSqlParams.add(deleteRdbmsFieldsParam);
            childDDMLValue.put("dml", dmlSqlParams);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> modelTable({}) gen Delete Rdbms Table, SQL({})", (Object)childTableName, (Object)deleteRdbmsTableParam);
                log.debug(">>>>> modelTable({}) gen Delete Rdbms Fields, SQL({})", (Object)childTableName, (Object)deleteRdbmsFieldsParam);
            }
            SqlParam renameTableSqlParam = ModelSqlGenerator.generateRenameTableSql(childTableName);
            log.debug(">>>>> modelTable({}) gen Alter table SQL: {}", (Object)childTableName, (Object)renameTableSqlParam);
            ddlSqlParams.add(renameTableSqlParam);
            childDDMLValue.put("ddl", ddlSqlParams);
            returnValue.put(childTableName, childDDMLValue);
        }
        return returnValue;
    }

    public static Map<String, Object> getAlterIndexesInfo(String tableName, AlterIndexEnum alterIndexEnum, List<TableIndex> tableIndexes, LinkedList<SqlParam> alterDDLSqlParam) {
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        tableIndexes.forEach(tableIndex -> {
            LinkedList<Object> alterTableSqlParams = new LinkedList();
            alterTableSqlParams = ModelSqlGenerator.generateAlterIndexSql(tableName, alterIndexEnum, tableIndex);
            alterDDLSqlParam.addAll(alterTableSqlParams);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter indexes Params: tableName = {}, alterIndexEnum = {}, tableIndex = {}", new Object[]{tableName, alterIndexEnum, tableIndex});
                log.debug(">>>>> gen Alter indexes SQL: {}", alterTableSqlParams);
            }
        });
        return returnValue;
    }

    public static LinkedHashMap<String, List<SqlParam>> getAlterTableInfo(ModelTable modelTable) {
        LinkedHashMap<String, List<SqlParam>> returnValue = new LinkedHashMap<String, List<SqlParam>>();
        LinkedList<SqlParam> alterDDLSqlParam = new LinkedList<SqlParam>();
        LinkedList<SqlParam> alterDMLSqlParam = new LinkedList<SqlParam>();
        returnValue.put("dml", alterDMLSqlParam);
        returnValue.put("ddl", alterDDLSqlParam);
        String tableName = modelTable.getName();
        String tableComment = modelTable.getComment();
        SqlParam alterTableSqlParam = ModelSqlGenerator.generateAlterTableSql(tableName, tableComment);
        alterDDLSqlParam.add(alterTableSqlParam);
        SqlParam alterRdbmsSqlParam = ModelSqlGenerator.generateUpdateRdbmsTableSql(modelTable);
        alterDMLSqlParam.add(alterRdbmsSqlParam);
        if (log.isDebugEnabled()) {
            log.debug(">>>>> gen Alter Table Params: tableName = {}, tableComment = {} ", (Object)tableName, (Object)tableComment);
            log.debug(">>>>> gen Alter Table SQL: {}", (Object)alterTableSqlParam);
            log.debug(">>>>> gen Update Rdbms Tables Params: customTables = {}", (Object)modelTable);
            log.debug(">>>>> gen Update Rdbms Tables SQL: sql = {}, params = {}", (Object)alterRdbmsSqlParam.getSql(), (Object)alterRdbmsSqlParam.getParams());
        }
        return returnValue;
    }

    public static Map<AlterIndexEnum, List<TableIndex>> getAlterColumnUniqueIndexesWhenModifyModel(List<ModelFieldDTO> draftModelFields, List<ModelFieldDTO> publishedModelFields, List<TableIndex> actualTableIndexes) {
        log.debug("[ModelSqlGenerator][getAlterColumnUniqueIndexes]");
        List modifyColumnsOfDraft = draftModelFields.stream().filter(draftModelField -> ModelSchemaUtil.checkRelatedType(draftModelField) && !draftModelField.getAutoIncrement() && !ModelDBConstants.UNIQUE_INDEX_EXCLUDED_DATATYPE.contains(draftModelField.getFieldType()) && publishedModelFields.stream().anyMatch(publishedModelField -> Objects.equals(draftModelField.getFieldId(), publishedModelField.getFieldId()) && !Objects.equals(draftModelField.getUnique(), publishedModelField.getUnique()))).collect(Collectors.toList());
        log.info("[ModelSqlGenerator]comparing column-unique -> compare modify({}), actual({})", modifyColumnsOfDraft.stream().map(idx -> idx.getFieldId()).collect(Collectors.toList()), actualTableIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()));
        List validAddColumnUniqueIndexes = modifyColumnsOfDraft.stream().filter(modelField -> modelField.getUnique() && actualTableIndexes.stream().noneMatch(actualTableIndex -> Objects.equals(actualTableIndex.getName(), modelField.getFieldId()))).map(ModelSchemaUtil::convertModelFieldToTableUniqueIndex).collect(Collectors.toList());
        log.info(CLASS_LOG_TAG + " column-unique -> validAddColumnUniqueIndexes({})", validAddColumnUniqueIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()));
        List validDropColumnUniqueIndexes = modifyColumnsOfDraft.stream().filter(modelField -> !modelField.getUnique() && actualTableIndexes.stream().anyMatch(actualTableIndex -> Objects.equals(actualTableIndex.getName(), modelField.getFieldId()))).map(ModelSchemaUtil::convertModelFieldToTableUniqueIndex).collect(Collectors.toList());
        log.info(CLASS_LOG_TAG + " comparing column-unique -> validDropColumnUniqueIndexes({})", validDropColumnUniqueIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()));
        HashMap<AlterIndexEnum, List<TableIndex>> alterColumnUniqueIndexes = new HashMap<AlterIndexEnum, List<TableIndex>>();
        alterColumnUniqueIndexes.put(AlterIndexEnum.ADD, validAddColumnUniqueIndexes);
        alterColumnUniqueIndexes.put(AlterIndexEnum.DROP, validDropColumnUniqueIndexes);
        return alterColumnUniqueIndexes;
    }

    public static Map<AlterIndexEnum, List<TableIndex>> getAlterIndexesMapWithActualModelTable(ModelTable draftModelTable, ModelTable publishedModelTable, ModelTable actualModelTable) {
        List<TableIndex> dropColumnUniqueIndexes;
        List<TableIndex> modifyUniqueIndexesFromColumn;
        List<TableIndex> draftTableIndexes = draftModelTable.getIndexes();
        List<TableIndex> publishedTableIndexes = null;
        if (publishedModelTable != null) {
            publishedTableIndexes = publishedModelTable.getIndexes();
        }
        List<TableIndex> actualTableIndexes = actualModelTable.getIndexes();
        log.debug("{}[getAlterIndexesMap] comparing indexes -> 1.[draftTableIndexes]{}, 2.[publishedTableIndexes]{}, 3.[actualIndexes]{}", new Object[]{CLASS_LOG_TAG, draftTableIndexes, publishedTableIndexes, actualTableIndexes});
        List<TableIndex> addIndexes = IndexCompareUtil.getAddIndexes(draftTableIndexes, actualTableIndexes);
        List<TableIndex> modifyIndexes = IndexCompareUtil.getModifyIndexes(draftTableIndexes, actualTableIndexes);
        List<TableIndex> dropIndexes = IndexCompareUtil.getDropIndexes(draftTableIndexes, actualTableIndexes, publishedTableIndexes);
        Map<AlterIndexEnum, List<TableIndex>> alterColumnsUniqueMap = IndexCompareUtil.getAlterColumnUniqueIndexes(draftModelTable.getColumns(), actualModelTable.getColumns());
        List<TableIndex> addColumnUniqueIndexes = alterColumnsUniqueMap.get((Object)AlterIndexEnum.ADD);
        if (CollectionUtils.isNotEmpty(addColumnUniqueIndexes)) {
            addIndexes.addAll(addColumnUniqueIndexes);
        }
        if (CollectionUtils.isNotEmpty(modifyUniqueIndexesFromColumn = alterColumnsUniqueMap.get((Object)AlterIndexEnum.MODIFY))) {
            modifyIndexes.addAll(modifyUniqueIndexesFromColumn);
        }
        if (CollectionUtils.isNotEmpty(dropColumnUniqueIndexes = alterColumnsUniqueMap.get((Object)AlterIndexEnum.DROP))) {
            dropIndexes.addAll(dropColumnUniqueIndexes);
        }
        HashMap<AlterIndexEnum, List<TableIndex>> alterTableIndexesMap = new HashMap<AlterIndexEnum, List<TableIndex>>();
        if (CollectionUtils.isNotEmpty(addIndexes)) {
            alterTableIndexesMap.put(AlterIndexEnum.ADD, addIndexes);
        }
        if (CollectionUtils.isNotEmpty(modifyIndexes)) {
            alterTableIndexesMap.put(AlterIndexEnum.MODIFY, modifyIndexes);
        }
        if (CollectionUtils.isNotEmpty(dropIndexes)) {
            alterTableIndexesMap.put(AlterIndexEnum.DROP, dropIndexes);
        }
        if (log.isDebugEnabled()) {
            log.debug("publishing model table({}) (comparing indexes) -> addIndexes = {}, modifyIndexes = {}, dropIndexes = {}", new Object[]{draftModelTable.getName(), addIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()), modifyIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()), dropIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList())});
        }
        return alterTableIndexesMap;
    }

    public static Map<AlterIndexEnum, List<TableIndex>> getCreateAndModifyIndexesMapWithActualModelTable(ModelTable draftModelTable, ModelTable actualModelTable) {
        List<TableIndex> modifyUniqueIndexesFromColumn;
        List<TableIndex> draftTableIndexes = draftModelTable.getIndexes();
        Object publishedTableIndexes = null;
        List<TableIndex> actualTableIndexes = actualModelTable.getIndexes();
        log.debug(CLASS_LOG_TAG + "[getAlterIndexesMap] comparing indexes -> 1.[draftTableIndexes]{}, 2.[publishedTableIndexes]{}, 3.[actualIndexes]{}", new Object[]{draftTableIndexes, publishedTableIndexes, actualTableIndexes});
        List<TableIndex> addIndexes = IndexCompareUtil.getAddIndexes(draftTableIndexes, actualTableIndexes);
        List<TableIndex> modifyIndexes = IndexCompareUtil.getModifyIndexes(draftTableIndexes, actualTableIndexes);
        Map<AlterIndexEnum, List<TableIndex>> alterColumnsUniqueMap = IndexCompareUtil.getAlterColumnUniqueIndexes(draftModelTable.getColumns(), actualModelTable.getColumns());
        List<TableIndex> addColumnUniqueIndexes = alterColumnsUniqueMap.get((Object)AlterIndexEnum.ADD);
        if (CollectionUtils.isNotEmpty(addColumnUniqueIndexes)) {
            addIndexes.addAll(addColumnUniqueIndexes);
        }
        if (CollectionUtils.isNotEmpty(modifyUniqueIndexesFromColumn = alterColumnsUniqueMap.get((Object)AlterIndexEnum.MODIFY))) {
            modifyIndexes.addAll(modifyUniqueIndexesFromColumn);
        }
        ArrayList<TableIndex> dropIndexes = new ArrayList<TableIndex>();
        List<TableIndex> dropColumnUniqueIndexes = alterColumnsUniqueMap.get((Object)AlterIndexEnum.DROP);
        if (CollectionUtils.isNotEmpty(dropColumnUniqueIndexes)) {
            dropIndexes.addAll(dropColumnUniqueIndexes);
        }
        HashMap<AlterIndexEnum, List<TableIndex>> alterTableIndexesMap = new HashMap<AlterIndexEnum, List<TableIndex>>();
        if (CollectionUtils.isNotEmpty(addIndexes)) {
            alterTableIndexesMap.put(AlterIndexEnum.ADD, addIndexes);
        }
        if (CollectionUtils.isNotEmpty(modifyIndexes)) {
            alterTableIndexesMap.put(AlterIndexEnum.MODIFY, modifyIndexes);
        }
        if (CollectionUtils.isNotEmpty(dropIndexes)) {
            alterTableIndexesMap.put(AlterIndexEnum.DROP, dropIndexes);
        }
        if (log.isDebugEnabled()) {
            log.debug("publishing model table({}) (comparing indexes) -> addIndexes = {}, modifyIndexes = {}, dropIndexes = {}", new Object[]{draftModelTable.getName(), addIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()), modifyIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()), dropIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList())});
        }
        return alterTableIndexesMap;
    }

    public static SqlParam getDropPrimaryKeySql(String tableName) {
        String dropPrimaryKeySql = String.format("ALTER TABLE `%s` DROP PRIMARY KEY", tableName);
        if (log.isDebugEnabled()) {
            log.debug(">>>>> gen Alter Columns Params: tableName = {}, sql = {}", (Object)tableName, (Object)dropPrimaryKeySql);
        }
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(dropPrimaryKeySql);
        sqlParam.setParams(new Object[0]);
        return sqlParam;
    }

    public static void getAddPrimaryKeyOnly(ModelTable modelTable, LinkedList<SqlParam> ddlSqlParams, LinkedList<SqlParam> dmlSqlParams) {
        List<String> remainPks;
        String primaryKeysSql = IndexCompareUtil.generatePrimaryKeys(modelTable.getColumns());
        TableIndex modelTablePk = modelTable.getIndexes().stream().filter(tableIndex -> tableIndex.getType() == IndexTypeEnum.PRIMARY_KEY).findFirst().orElse(null);
        ModelTableSchemaCache target = ModelDrivenContext.getPublishedTableCache(modelTable.getName());
        Map<String, Object> indexes = target.getPublishedRemainIndexes();
        TableIndex pkTableIndex = (TableIndex)indexes.get("PRIMARY KEY");
        if (modelTablePk == null || (remainPks = pkTableIndex.getMember()).size() != 1 || remainPks.get(0).equals(modelTablePk.getMember().get(0))) {
            // empty if block
        }
        String alterTableAddPrimarySql = String.format("ALTER TABLE `%s` ADD %s ", modelTable.getName(), primaryKeysSql);
        if (log.isDebugEnabled()) {
            log.debug(">>>>> gen Alter Columns Params: tableName = {}, sql = {}", (Object)modelTable.getName(), (Object)alterTableAddPrimarySql);
        }
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(alterTableAddPrimarySql);
        sqlParam.setParams(new Object[0]);
        ddlSqlParams.add(sqlParam);
    }

    public static SqlParam getAlterPrimaryKeySql(ModelTable modelTable) {
        String primaryKeysSql = IndexCompareUtil.generatePrimaryKeys(modelTable.getColumns());
        String dropAndAddTablePrimarySql = String.format("ALTER TABLE `%s` DROP PRIMARY KEY, ADD %s ", modelTable.getName(), primaryKeysSql);
        if (log.isDebugEnabled()) {
            log.debug(">>>>> gen Alter Columns Params: tableName = {}, sql = {}", (Object)modelTable.getName(), (Object)dropAndAddTablePrimarySql);
        }
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(dropAndAddTablePrimarySql);
        sqlParam.setParams(new Object[0]);
        return sqlParam;
    }

    public static List<SqlParam> getAlterPrimaryKeySql(ModelTable draftSimpleModelTable, ModelTable publishedSimpleModelTable, Map<AlterColumnEnum, List<TableColumn>> alterColumnsMap) {
        List<String> draftModelPks = ModelSchemaUtil.getPrimaryKeys(draftSimpleModelTable.getColumns());
        List<String> publishedModelPks = ModelSchemaUtil.getPrimaryKeys(publishedSimpleModelTable.getColumns());
        List<TableColumn> dropTableColumns = alterColumnsMap.get((Object)AlterColumnEnum.MODIFY_COLUMN);
        List dropPKTableColumns = dropTableColumns.stream().filter(dropTableColumn -> dropTableColumn.isPK()).collect(Collectors.toList());
        AtomicBoolean isChangePk = new AtomicBoolean(false);
        alterColumnsMap.forEach((alterColumnEnum, tableColumns) -> {
            if (!isChangePk.get() && !CollectionUtils.isEmpty((Collection)tableColumns)) {
                tableColumns.stream().forEach(tableColumn -> {
                    if (tableColumn.isPK().booleanValue()) {
                        isChangePk.set(true);
                    }
                });
            }
        });
        ArrayList<SqlParam> sqlParams = new ArrayList<SqlParam>();
        if (isChangePk.get()) {
            String dropAndAddTablePrimarySql = String.format("ALTER TABLE `%s` DROP %s ", draftSimpleModelTable.getName(), "PRIMARY KEY");
            List<TableColumn> draftColumns = draftSimpleModelTable.getColumns();
            if (CollectionUtils.isNotEmpty(draftColumns)) {
                String primaryKeysSql = IndexCompareUtil.generatePrimaryKeys(draftColumns);
                dropAndAddTablePrimarySql = String.format(dropAndAddTablePrimarySql + " , ADD %s ", primaryKeysSql);
            }
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter Columns Params: tableName = {}, sql = {}", (Object)draftSimpleModelTable.getName(), (Object)dropAndAddTablePrimarySql);
            }
            SqlParam sqlParam = new SqlParam();
            sqlParam.setSql(dropAndAddTablePrimarySql);
            sqlParam.setParams(new Object[0]);
            sqlParams.add(sqlParam);
        }
        return sqlParams;
    }

    public static void getAlterAutoIncrementSql(ModelTable modelTable, LinkedList<SqlParam> ddlSqlParams, LinkedList<SqlParam> dmlSqlParams) {
        TableColumn tableColumn = modelTable.getColumns().stream().filter(currentTableColumn -> currentTableColumn.getAutoIncrement()).findFirst().get();
        if (Objects.nonNull((Object)tableColumn)) {
            String modifyColumnSql = String.format("ALTER TABLE `%s` %s `%s`  %s %s %s %s '%s'", modelTable.getName(), AlterColumnEnum.MODIFY_COLUMN.getSqlChar(), tableColumn.getColumnName(), ColumnCompareUtil.getTypeDDL(tableColumn), ColumnCompareUtil.getNullableEnum(tableColumn.nullable()).getSqlChar(), "AUTO_INCREMENT", "COMMENT", tableColumn.getComment());
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter Columns Params: tableName = {}, sql = {}", (Object)modelTable.getName(), (Object)modifyColumnSql);
            }
            SqlParam sqlParam = new SqlParam();
            sqlParam.setSql(modifyColumnSql);
            sqlParam.setParams(new Object[0]);
            ddlSqlParams.add(sqlParam);
        }
    }

    public static void removePk(List<String> pks, String dropPk) {
        pks.remove(dropPk);
    }

    public static List<SqlParam> genDropOrAddPrimaryKey(String tableName, List<String> remainPks, boolean isDropFirst) {
        if (log.isDebugEnabled()) {
            log.debug("[genDropOrAddPrimaryKey] tableName({}), remainPks({}), isDropFirst({})", new Object[]{tableName, remainPks, isDropFirst});
        }
        List sqlPks = remainPks.stream().map(pk -> "`" + pk + "`").collect(Collectors.toList());
        Table alterTable = new Table("`" + tableName + "`");
        Alter alterPkScript = new Alter();
        alterPkScript.setTable(alterTable);
        ArrayList<AlterExpression> alterExpressions = new ArrayList<AlterExpression>();
        if (isDropFirst) {
            AlterExpression dropPkNameExpression = new AlterExpression();
            dropPkNameExpression.setOperation(AlterOperation.DROP_PRIMARY_KEY);
            alterExpressions.add(dropPkNameExpression);
            if (log.isDebugEnabled()) {
                log.debug("[genDropOrAddPrimaryKey] tableName = {}, after drop pk", (Object)tableName);
            }
        }
        if (CollectionUtils.isNotEmpty(sqlPks)) {
            AlterExpression addPkNameExpression = new AlterExpression();
            addPkNameExpression.setOperation(AlterOperation.ADD);
            addPkNameExpression.addPkColumns(sqlPks);
            alterExpressions.add(addPkNameExpression);
            if (log.isDebugEnabled()) {
                log.debug("[genDropOrAddPrimaryKey] tableName = {}, add Pks = {}", (Object)tableName, sqlPks);
            }
        }
        alterPkScript.setAlterExpressions(alterExpressions);
        String dropAndAddTablePrimarySql = alterPkScript.toString();
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(dropAndAddTablePrimarySql);
        sqlParam.setParams(new Object[0]);
        ArrayList<SqlParam> returnValue = new ArrayList<SqlParam>();
        returnValue.add(sqlParam);
        return returnValue;
    }

    public static List<SqlParam> genDropAndAddPrimaryKeyByDropColumnsSql(ModelTable publishedModelTable, List<TableColumn> draftHavePkOfDropTableColumns) {
        String tableName = publishedModelTable.getName();
        List<String> publishedPks = ModelSchemaUtil.getPrimaryKeys(publishedModelTable.getColumns());
        List<String> dropPks = ModelSchemaUtil.getPrimaryKeys(draftHavePkOfDropTableColumns);
        if (log.isDebugEnabled()) {
            log.debug("[genDropAndAddPrimaryKeyByDropColumnsSql] tableName = {}, draft dropPks = {}, publishedPks = {}", new Object[]{tableName, dropPks, publishedPks});
        }
        dropPks.stream().forEach(dropPk -> publishedPks.remove(dropPk));
        List sqlPks = publishedPks.stream().map(pk -> "`" + pk + "`").collect(Collectors.toList());
        Table alterTable = new Table("`" + tableName + "`");
        Alter alterPkScript = new Alter();
        alterPkScript.setTable(alterTable);
        ArrayList<AlterExpression> alterExpressions = new ArrayList<AlterExpression>();
        AlterExpression dropPkNameExpression = new AlterExpression();
        dropPkNameExpression.setOperation(AlterOperation.DROP_PRIMARY_KEY);
        alterExpressions.add(dropPkNameExpression);
        if (CollectionUtils.isNotEmpty(sqlPks)) {
            AlterExpression addPkNameExpression = new AlterExpression();
            addPkNameExpression.setOperation(AlterOperation.ADD);
            addPkNameExpression.addPkColumns(sqlPks);
            alterExpressions.add(addPkNameExpression);
            if (log.isDebugEnabled()) {
                log.debug("[genDropAndAddPrimaryKeyByDropColumnsSql] tableName = {}, after drop pk, add Pks = {}", (Object)tableName, sqlPks);
            }
        }
        alterPkScript.setAlterExpressions(alterExpressions);
        String dropAndAddTablePrimarySql = alterPkScript.toString();
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(dropAndAddTablePrimarySql);
        sqlParam.setParams(new Object[0]);
        ArrayList<SqlParam> returnValue = new ArrayList<SqlParam>();
        returnValue.add(sqlParam);
        return returnValue;
    }

    public static LinkedList<SqlParam> genAlterTableUniqueIndex(ModelTable modelTable, List<String> newIndexMember, ModelIndexDTO publishedModelIndexDTO) {
        String uniqueId;
        LinkedList<SqlParam> returnValue = new LinkedList<SqlParam>();
        String tableName = modelTable.getName();
        Map<String, ModelTableSchemaCache> publishedTableCache = ModelDrivenContext.getContext().getPublishedTableCache();
        ModelTableSchemaCache modelTableSchemaCache = publishedTableCache.get(tableName);
        Map<String, Object> publishedRemainIndexes = modelTableSchemaCache.getPublishedRemainIndexes();
        if (publishedRemainIndexes.containsKey(uniqueId = publishedModelIndexDTO.getId()) && !uniqueId.equals("PRIMARY KEY")) {
            log.info("flag3");
            String dropAndAddModelIndexSql = String.format("ALTER TABLE `%s` DROP INDEX `%s` ", tableName, uniqueId);
            SqlParam sqlParam = new SqlParam();
            sqlParam.setSql(dropAndAddModelIndexSql);
            sqlParam.setParams(new Object[0]);
            returnValue.add(sqlParam);
            publishedRemainIndexes.remove(uniqueId);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter unique index: tableName:{}, sql:{}, dropped index:({})", new Object[]{tableName, dropAndAddModelIndexSql, publishedModelIndexDTO});
            }
        } else {
            log.warn(">>>>> ignored to gen Alter unique index: tableName = {}, unique id = {}, cause remain({})", new Object[]{tableName, uniqueId, publishedRemainIndexes});
        }
        return returnValue;
    }

    public static void updateAlterColumnsInfoOnly(String tableName, AlterColumnEnum alterColumnEnum, List<TableColumn> modelColumns, LinkedHashMap<AlterAutoIncrementEnum, TableColumn> changedAutoIncrmt, LinkedList<SqlParam> targetDDLSqlParam, LinkedList<SqlParam> targetDMLSqlParam) {
        modelColumns.forEach(modelColumn -> {
            LinkedList<SqlParam> alterTableSqlParam = ModelSqlGenerator.generateAlterColumnsSql(tableName, alterColumnEnum, modelColumn);
            targetDDLSqlParam.addAll(alterTableSqlParam);
            if (alterColumnEnum == AlterColumnEnum.DROP_COLUMN) {
                SqlParam deleteRdbmsFieldSql = ModelSqlGenerator.generateDeleteRdbmsFieldSql(tableName, modelColumn.getColumnName());
                targetDMLSqlParam.add(deleteRdbmsFieldSql);
            }
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter Columns Params: tableName = {}, alterColumnEnum = {}, customColumn = {}", new Object[]{tableName, alterColumnEnum, modelColumn});
                log.debug(">>>>> gen Alter Columns SQL: {}", alterTableSqlParam);
            }
        });
    }

    public static String getUserRowPermissionConditionSql(DWUserPermission userPermission, PlainSelect select) throws Exception {
        String sql = null;
        Field rowPermissionField = DWUserPermission.class.getDeclaredField("rowPermission");
        rowPermissionField.setAccessible(true);
        Object userRowPermission = rowPermissionField.get(userPermission);
        if (userPermission.isSuperadmin()) {
            log.debug(String.format("[report permission] superadmin", new Object[0]));
            return "";
        }
        if (userRowPermission != null) {
            if (userRowPermission instanceof DWRowPermissionGroup) {
                ModelSqlGenerator.dealDWRowPermissionGroup(userRowPermission, select);
            } else if (userRowPermission instanceof DWRowPermissionEmpty) {
                sql = " 1 <> 1";
            } else {
                DWRowPermissionBase dwRowPermissionSingleFieldValue = (DWRowPermissionBase)userRowPermission;
                dwRowPermissionSingleFieldValue.setFilterField(select.getFromItem().getAlias() == null ? select.getFromItem().toString() + "." + dwRowPermissionSingleFieldValue.getFilterField() : select.getFromItem().getAlias().toString() + "." + dwRowPermissionSingleFieldValue.getFilterField());
            }
            log.debug(String.format("[report permission] row permission sql: {} permission type is :{}", new Object[0]), (Object)((DWRowPermissionBase)userRowPermission).getSQLContainValues((DWRowPermissionMatchOption)new DWRowPermissionDefaultMatchOption(true)), rowPermissionField.get(userPermission));
        } else {
            log.debug(String.format("[report permission] has no row permission", new Object[0]));
        }
        if (sql == null && "".equals(sql = userPermission.getRowPermission().getSQLContainValues((DWRowPermissionMatchOption)new DWRowPermissionDefaultMatchOption(true)))) {
            sql = " 1 <> 1";
        }
        return sql;
    }

    private static void dealDWRowPermissionGroup(Object rowPermission, PlainSelect select) {
        DWRowPermissionGroup rowPermissionGroup = (DWRowPermissionGroup)rowPermission;
        List dwRowPermissions = rowPermissionGroup.getFilterValue();
        Iterator it = dwRowPermissions.iterator();
        while (it.hasNext()) {
            Object filterVaule = it.next();
            if (filterVaule instanceof DWRowPermissionGroup) {
                ModelSqlGenerator.dealDWRowPermissionGroup(filterVaule, select);
                continue;
            }
            DWRowPermissionBase dwRowPermissionFilterValue = (DWRowPermissionBase)filterVaule;
            if (!ModelSqlGenerator.verifyRowPermission(dwRowPermissionFilterValue)) {
                it.remove();
                continue;
            }
            dwRowPermissionFilterValue.setFilterField(select.getFromItem().getAlias() == null ? select.getFromItem().toString() + "." + dwRowPermissionFilterValue.getFilterField() : select.getFromItem().getAlias().toString() + "." + dwRowPermissionFilterValue.getFilterField());
        }
    }

    private static boolean verifyRowPermission(DWRowPermissionBase rowPermission) {
        String filterTable = rowPermission.getFilterTable();
        String filterField = rowPermission.getFilterField();
        try {
            DWMetadata<?> masterTableRdbmsMetadata = ModelDrivenMetadataUtil.loadRdbmsMetadata(filterTable);
            return masterTableRdbmsMetadata.getFields().stream().anyMatch(field -> ((DWRdbmsField)field).getName().equals(filterField));
        }
        catch (DWMetadataNotFoundException e) {
            return false;
        }
    }

    public static String getPrimaryKeyCondition(String tableName, String autoIncrementOrDefaultValue, TableColumn tableColumn) {
        String primaryKeyCondition = "";
        String targetColumnName = tableColumn.getColumnName();
        ArrayList<String> draftPks = new ArrayList<String>();
        draftPks.add(targetColumnName);
        if (autoIncrementOrDefaultValue.toUpperCase().contains("AUTO_INCREMENT")) {
            ModelTableSchemaCache target = ModelDrivenContext.getPublishedTableCache(tableName);
            Map<String, Object> remainIndexes = target.getPublishedRemainIndexes();
            if (remainIndexes.containsKey("PRIMARY KEY")) {
                TableIndex actualPKTableIndex = (TableIndex)remainIndexes.get("PRIMARY KEY");
                List<String> remainPks = actualPKTableIndex.getMember();
                if (remainPks.size() == 1 && remainPks.get(0).equals(targetColumnName)) {
                    log.debug(CLASS_LOG_TAG + "[getPrimaryKeyCondition] no changed(remainPks({}), draftColumnName({}))", remainPks, (Object)targetColumnName);
                } else if (!remainPks.equals(draftPks)) {
                    log.info(CLASS_LOG_TAG + "[getPrimaryKeyCondition] 1.remainPks({}) size>1,", remainPks);
                    primaryKeyCondition = String.format(" DROP %s , ADD %s (`%s`) ", "PRIMARY KEY", "PRIMARY KEY", targetColumnName);
                    remainPks.clear();
                    remainPks.add(targetColumnName);
                    log.info(CLASS_LOG_TAG + "[getPrimaryKeyCondition] 2.primaryCondition({}), ", (Object)primaryKeyCondition);
                }
            } else {
                primaryKeyCondition = String.format(" ADD %s (`%s`)", "PRIMARY KEY", targetColumnName);
                ArrayList<String> members = new ArrayList<String>();
                members.add(targetColumnName);
                TableIndex tableIndex = new TableIndex();
                tableIndex.setMember(members);
                tableIndex.setType(IndexTypeEnum.PRIMARY_KEY);
                remainIndexes.put("PRIMARY KEY", tableIndex);
                log.info(CLASS_LOG_TAG + "[getPrimaryKeyCondition] primaryCondition({}), new pk index()", (Object)primaryKeyCondition, (Object)tableIndex);
            }
        }
        log.info(CLASS_LOG_TAG + " add pkCondtion({}) on {}.{}", new Object[]{primaryKeyCondition, tableName, tableColumn.getColumnName()});
        return primaryKeyCondition;
    }

    public static TableSqlParamDTO getAlterTable(ModelTable draftModelTable, ModelTable pulbishedModelTable, ModelTable actualModelTable) {
        TableSqlParamDTO tableSqlParamDTO = new TableSqlParamDTO();
        LinkedList<SqlParam> alterDMLSqlParam = new LinkedList<SqlParam>();
        LinkedList<SqlParam> alterDDLSqlParam = new LinkedList<SqlParam>();
        LinkedList<String> ddlTablePartialSqlParams = new LinkedList<String>();
        List<TableColumn> draftTableColumns = draftModelTable.getColumns();
        List<TableColumn> actualTableColumns = actualModelTable.getColumns();
        if (!Objects.equals(draftModelTable.getComment(), actualModelTable.getComment())) {
            List<String> alterComment = ModelTablePartialSqlGenerator.getAlterTableInfoWhenExistedModel(draftModelTable);
            ddlTablePartialSqlParams.addAll(alterComment);
            SqlParam alterRdbmsSqlParam = ModelSqlGenerator.generateUpdateRdbmsTableSql(draftModelTable);
            alterDMLSqlParam.add(alterRdbmsSqlParam);
        }
        Map<AlterIndexEnum, List<TableIndex>> alterIndexesMap = ModelSqlGenerator.getAlterIndexesMapWithActualModelTable(draftModelTable, pulbishedModelTable, actualModelTable);
        LinkedHashMap<AlterAutoIncrementEnum, TableColumn> changedAutoIncrmtMap = ColumnCompareUtil.getChangeAutoIncrementColumn(draftTableColumns, actualTableColumns);
        List<String> newPartialTableColumns = ModelTablePartialSqlGenerator.updateColumnsSqlParams(draftModelTable, actualModelTable, changedAutoIncrmtMap, alterDMLSqlParam);
        newPartialTableColumns.stream().filter(newSql -> ddlTablePartialSqlParams.stream().noneMatch(ddlSqlParam -> Objects.equals(ddlSqlParam, newSql))).forEach(filteredSql -> ddlTablePartialSqlParams.add((String)filteredSql));
        if (MapUtils.isNotEmpty(alterIndexesMap)) {
            alterIndexesMap.forEach((alterIndexEnum, tableColumns) -> {
                if (!CollectionUtils.isEmpty((Collection)tableColumns)) {
                    List<String> dirtyIndexPartialSqls = ModelTablePartialSqlGenerator.getAlterIndexesInfo(pulbishedModelTable.getName(), alterIndexEnum, tableColumns);
                    ddlTablePartialSqlParams.addAll(dirtyIndexPartialSqls);
                }
            });
        }
        List<SqlParam> alterTableDDL = ModelTableSqlGenerator.getCombinedSqls(draftModelTable.getName(), ddlTablePartialSqlParams);
        alterDDLSqlParam.addAll(alterTableDDL);
        List<SqlParam> insertOrUpdateRdbmsFieldsParam = ModelNewSqlGenerator.generateInsertOrUpdateRdbmsFieldSql(draftModelTable);
        alterDMLSqlParam.addAll(insertOrUpdateRdbmsFieldsParam);
        tableSqlParamDTO.setDdlSqlParams(alterDDLSqlParam);
        tableSqlParamDTO.setDmlSqlParams(alterDMLSqlParam);
        return tableSqlParamDTO;
    }

    public static List<SqlParam> getInsertOrUpdateServiceMapping(ModelDTO draftModel) {
        ModelCreateTypeEnum useExistedTable = draftModel.getUseExistedTable();
        LinkedList<SqlParam> serviceMappingSqlParams = new LinkedList<SqlParam>();
        SqlParam insertOrUpdateServiceMappingSqlParam = ModelSqlGenerator.generateInsertOrUpdateServiceMapping(draftModel);
        if (insertOrUpdateServiceMappingSqlParam != null) {
            serviceMappingSqlParams.add(insertOrUpdateServiceMappingSqlParam);
        }
        return serviceMappingSqlParams;
    }

    public static SqlParam generateInsertOrUpdateServiceMapping(ModelDTO model) {
        SqlParam insertOrUpdateServiceMappingSqlParam;
        ModelSchemaDTO draftModelSchema = model.getSchema();
        BMProperties bmProperties = BMProperties.getProperties();
        if (bmProperties != null && bmProperties.isEnabled() && (bmProperties.getRole() == BMRole.bmd || bmProperties.getRole() == BMRole.mix)) {
            ModelDrivenContext.getContext().setPublishedModel(model);
            insertOrUpdateServiceMappingSqlParam = BMDataModelSqlGenerator.generateInsertServiceMappingSql();
        } else {
            ModelTable modelTable = ModelSchemaUtil.getCurrentLevelModelTable(draftModelSchema);
            insertOrUpdateServiceMappingSqlParam = ModelNewSqlGenerator.generateInsertServiceMappingSql(modelTable);
        }
        return insertOrUpdateServiceMappingSqlParam;
    }

    public static Map<String, Object> getExecutableSql(List<SqlParam> ddlSqlParams, List<SqlParam> dmlSqlParams) {
        LinkedHashMap<String, Object> executeSql = new LinkedHashMap<String, Object>();
        List<String> ddlSqls = ModelSqlGenerator.getExecutableSql(ddlSqlParams);
        executeSql.put("ddl", ddlSqls);
        List<String> dmlSqls = ModelSqlGenerator.getExecutableSql(dmlSqlParams);
        executeSql.put("dml", dmlSqls);
        return executeSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getExecutableSql(List<SqlParam> sqlParams) {
        LinkedList<String> sqls = new LinkedList<String>();
        for (SqlParam sqlParam : sqlParams) {
            String sql = sqlParam.getSql();
            try {
                sql = ModelSqlGenerator.getCombinedSql(sqlParam);
            }
            catch (Exception e) {
                String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
                log.error("{}[getExecutableSql] sql parser error:{}, sql({})", new Object[]{CLASS_LOG_TAG, errorMessage, sql});
            }
            finally {
                sqls.add(sql);
            }
        }
        return sqls;
    }
}

