/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.ddl.model.Field;
import com.digiwin.app.resource.DWApplicationMessageResourceBundleUtils;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.enums.AlterAutoIncrementEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterIndexEnum;
import com.digiwin.lcdp.modeldriven.enums.PublishStatusEnum;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.model.TableSqlParamDTO;
import com.digiwin.lcdp.modeldriven.utils.ModelIndexUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelNewSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelTablePartialSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import com.digiwin.lcdp.modeldriven.utils.compare.ColumnCompareUtil;
import com.digiwin.lcdp.modeldriven.utils.compare.IndexCompareUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelTableSqlGenerator {
    private static final Logger log = LoggerFactory.getLogger(ModelTableSqlGenerator.class);
    private static final String _CLASSTAG = "[" + ModelTableSqlGenerator.class.getSimpleName() + "]";

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> filterAlterTableCommand() throws Exception {
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        ModelSchemaDTO draftModelSchema = modelDrivenContext.getDraftModel().getSchema();
        ModelSchemaDTO publishedModelSchema = modelDrivenContext.getPublishedModel().getSchema();
        return ModelTableSqlGenerator.filterAlterTableCommand(draftModelSchema, publishedModelSchema);
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> filterAlterTableCommand(ModelSchemaDTO draftModelSchema, ModelSchemaDTO publishedModelSchema) throws Exception {
        ModelSchemaUtil.checkModelSchema(draftModelSchema, false);
        ModelSchemaUtil.checkModelSchema(publishedModelSchema, false);
        String masterTableName = draftModelSchema.getName();
        HashMap<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new HashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        log.debug("=============== filterAlterTableCommand ====== {} =========", (Object)masterTableName);
        log.debug("{}[filterAlterTableCommand] alterTable starting....parent(current) TableName({})", (Object)_CLASSTAG, (Object)masterTableName);
        if (!Objects.equals(draftModelSchema.getName(), publishedModelSchema.getName())) {
            throw new DWBusinessException(String.format(ResourceBundleUtils.getString("lcdp.modeldriven.publish.fail.CannotChangeMasterModelName"), new Object[0]));
        }
        LinkedHashMap alterMap = new LinkedHashMap();
        LinkedList<SqlParam> alterDMLSqlParam = new LinkedList<SqlParam>();
        LinkedList<SqlParam> alterDDLSqlParam = new LinkedList<SqlParam>();
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map dbModelTables = (Map)modelDrivenContext.getExtraMap().get("actualModelTablesFromDB");
        Map draftModelTableMap = (Map)modelDrivenContext.getExtraMap().get("draftModelTables");
        ModelTable draftModelTable = (ModelTable)draftModelTableMap.get(masterTableName);
        if (dbModelTables.containsKey(masterTableName)) {
            Map publishedModelTableMap = (Map)modelDrivenContext.getExtraMap().get("publishedModelTables");
            ModelTable publishedModelTable = (ModelTable)publishedModelTableMap.get(masterTableName);
            TableSqlParamDTO tableSqlParamDTO = ModelSqlGenerator.getAlterTable(draftModelTable, publishedModelTable, (ModelTable)dbModelTables.get(masterTableName));
            alterDMLSqlParam.addAll(tableSqlParamDTO.getDmlSqlParams());
            alterDDLSqlParam.addAll(tableSqlParamDTO.getDdlSqlParams());
        } else {
            log.info("{}[filterAlterTableCommand] table({}) is not existed", (Object)_CLASSTAG, (Object)masterTableName);
            TableSqlParamDTO tableSqlParamDTO = ModelSqlGenerator.getCreateTable(draftModelTable);
            alterDMLSqlParam.addAll(tableSqlParamDTO.getDmlSqlParams());
            alterDDLSqlParam.addAll(tableSqlParamDTO.getDdlSqlParams());
        }
        if (!CollectionUtils.isEmpty(alterDMLSqlParam) || !CollectionUtils.isEmpty(alterDDLSqlParam)) {
            alterMap.put("ddl", alterDDLSqlParam);
            alterMap.put("dml", alterDMLSqlParam);
            returnValue.put(publishedModelSchema.getName(), alterMap);
        }
        return returnValue;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> getSqlsWithCompareActualOnly(ModelSchemaDTO draftModelSchema) {
        String tableName = draftModelSchema.getName();
        HashMap<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new HashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        log.debug("=============== getSqlsWithCompareActualOnly ====== {} =========", (Object)tableName);
        log.debug("{}[getSqlsWithCompareActualOnly] alterTable starting....TableName({})", (Object)_CLASSTAG, (Object)tableName);
        LinkedHashMap alterMap = new LinkedHashMap();
        LinkedList<SqlParam> dmlSqlParams = new LinkedList<SqlParam>();
        LinkedList<SqlParam> ddlSqlParams = new LinkedList<SqlParam>();
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map dbModelTables = (Map)modelDrivenContext.getExtraMap().get("actualModelTablesFromDB");
        Map draftModelTableMap = (Map)modelDrivenContext.getExtraMap().get("draftModelTables");
        ModelTable draftModelTable = (ModelTable)draftModelTableMap.get(tableName);
        String currentTableName = draftModelTable.getName();
        log.info("{}[getSqlsWithCompareActualOnly] ----- process table({}) ----", (Object)_CLASSTAG, (Object)currentTableName);
        List<TableColumn> draftTableColumns = draftModelTable.getColumns();
        boolean hasPrimaryKey = draftTableColumns.stream().anyMatch(Field::isPK);
        if (!hasPrimaryKey) {
            throw new IllegalArgumentException(String.format("The table(%s) must include a primary key!", currentTableName));
        }
        if (dbModelTables.containsKey(currentTableName)) {
            log.info("{}[getSqlsWithCompareActualOnly] --> table({}) is existed", (Object)_CLASSTAG, (Object)currentTableName);
            LinkedList<String> ddlTablePartialSqlParams = new LinkedList<String>();
            ModelTable actualModelTable = (ModelTable)dbModelTables.get(currentTableName);
            List<TableColumn> actualTableColumns = actualModelTable.getColumns();
            LinkedHashMap<AlterAutoIncrementEnum, TableColumn> changedAutoIncrmtMap = ColumnCompareUtil.getChangeAutoIncrementColumn(draftTableColumns, actualTableColumns);
            boolean isChangeAutoIncrement = MapUtils.isNotEmpty(changedAutoIncrmtMap);
            LinkedHashMap<AlterIndexEnum, TableIndex> changedPkMap = IndexCompareUtil.getChangePkIndex(draftModelTable, actualModelTable);
            boolean isChangePk = MapUtils.isNotEmpty(changedPkMap);
            log.info("{}[getSqlsWithCompareActualOnly] table({}), isChangeAutoIncrement({}), isChangePk({})", new Object[]{_CLASSTAG, currentTableName, isChangeAutoIncrement, isChangePk});
            List<String> newPartialTableColumns = ModelTablePartialSqlGenerator.updateColumnsSqlParams(draftModelTable, actualModelTable, changedAutoIncrmtMap, dmlSqlParams);
            newPartialTableColumns.stream().filter(newSql -> ddlTablePartialSqlParams.stream().noneMatch(ddlSqlParam -> Objects.equals(ddlSqlParam, newSql))).forEach(filteredSql -> ddlTablePartialSqlParams.add((String)filteredSql));
            Map<AlterIndexEnum, List<TableIndex>> alterIndexesMap = ModelSqlGenerator.getCreateAndModifyIndexesMapWithActualModelTable(draftModelTable, actualModelTable);
            if (MapUtils.isNotEmpty(alterIndexesMap)) {
                alterIndexesMap.forEach((alterIndexEnum, tableColumns) -> {
                    if (!CollectionUtils.isEmpty((Collection)tableColumns)) {
                        List<String> dirtyIndexPartialSqls = ModelTablePartialSqlGenerator.getAlterIndexesInfo(currentTableName, alterIndexEnum, tableColumns);
                        ddlTablePartialSqlParams.addAll(dirtyIndexPartialSqls);
                    }
                });
            }
            LinkedList<String> partialTableOptionAttributes = ModelTablePartialSqlGenerator.getAlterTableOptionsWhenNewPublish(draftModelTable.getComment());
            ddlTablePartialSqlParams.addAll(partialTableOptionAttributes);
            List<SqlParam> alterTableDDL = ModelTableSqlGenerator.getCombinedSqls(currentTableName, ddlTablePartialSqlParams);
            ddlSqlParams.addAll(alterTableDDL);
            SqlParam insertRdbmsTableSqlParam = ModelNewSqlGenerator.generateInsertRdbmsTableSql(draftModelTable);
            dmlSqlParams.add(insertRdbmsTableSqlParam);
            List<SqlParam> insertOrUpdateRdbmsFieldsParam = ModelNewSqlGenerator.generateInsertOrUpdateRdbmsFieldSql(draftModelTable);
            dmlSqlParams.addAll(insertOrUpdateRdbmsFieldsParam);
        } else {
            log.info("{}[getSqlsWithCompareActualOnly] table({}) is not existed", (Object)_CLASSTAG, (Object)currentTableName);
            TableSqlParamDTO tableSqlParamDTO = ModelSqlGenerator.getCreateTable(draftModelTable);
            dmlSqlParams.addAll(tableSqlParamDTO.getDmlSqlParams());
            ddlSqlParams.addAll(tableSqlParamDTO.getDdlSqlParams());
        }
        if (!CollectionUtils.isEmpty(dmlSqlParams) || !CollectionUtils.isEmpty(ddlSqlParams)) {
            alterMap.put("ddl", ddlSqlParams);
            alterMap.put("dml", dmlSqlParams);
            returnValue.put(draftModelSchema.getName(), alterMap);
        }
        return returnValue;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> getCreateOrAlterTableCommand(List<ModelSchemaDTO> draftChildren, List<ModelSchemaDTO> publishedChildren) throws Exception {
        HashMap<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new HashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        List newDraftChildren = draftChildren.stream().filter(draftChild -> publishedChildren.stream().noneMatch(publishedChildModelSchema -> Objects.equals(draftChild.getName(), publishedChildModelSchema.getName()))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(newDraftChildren)) {
            newDraftChildren.stream().forEach(newDraftChild -> {
                try {
                    Map<String, LinkedHashMap<String, List<SqlParam>>> createChildrenTableCommandData = ModelTableSqlGenerator.getSqlsWithCompareActualOnly(newDraftChild);
                    if (MapUtils.isNotEmpty(createChildrenTableCommandData)) {
                        returnValue.putAll(createChildrenTableCommandData);
                    }
                }
                catch (Exception e) {
                    String i18nMesg = DWApplicationMessageResourceBundleUtils.getString((String)"published_alter_table_detail_failed", (Object[])new Object[0]);
                    log.error("{} error:{} -> draftChildModelSchema = {}, publishedChildModelSchema = null", new Object[]{_CLASSTAG, i18nMesg, newDraftChild.getName()});
                    throw new RuntimeException(i18nMesg, e);
                }
            });
        }
        draftChildren.forEach(draftChildSchema -> publishedChildren.stream().filter(publishedChildSchema -> Objects.equals(draftChildSchema.getName(), publishedChildSchema.getName())).findFirst().ifPresent(publishedChildFormSchema -> {
            try {
                Map<String, LinkedHashMap<String, List<SqlParam>>> childrenAlterData = ModelTableSqlGenerator.filterAlterTableCommand(draftChildSchema, publishedChildFormSchema);
                if (MapUtils.isNotEmpty(childrenAlterData)) {
                    returnValue.putAll(childrenAlterData);
                }
            }
            catch (Exception e) {
                String i18nMesg = DWApplicationMessageResourceBundleUtils.getString((String)"published_alter_table_detail_failed", (Object[])new Object[0]);
                log.error("{}{} -> draftChildModelSchema = {}, publishedChildModelSchema = {}", new Object[]{_CLASSTAG, i18nMesg, draftChildSchema, publishedChildFormSchema});
                throw new RuntimeException(i18nMesg, e);
            }
        }));
        return returnValue;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> compareAndGetChildrenAlterData(List<ModelSchemaDTO> draftChildren, List<ModelSchemaDTO> publishedChildrenSchemas) throws Exception {
        Map<String, LinkedHashMap<String, List<SqlParam>>> createOrAlterChildrenTableCommandData;
        List shouldDropChildModelTables;
        List<ModelTable> dropChildModelTables;
        Map<String, LinkedHashMap<String, List<SqlParam>>> dropChildTableCommandData;
        HashMap<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new HashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        if (CollectionUtils.isEmpty(draftChildren) && CollectionUtils.isEmpty(publishedChildrenSchemas)) {
            return returnValue;
        }
        List draftChildrenModelSchemaNames = draftChildren.stream().map(draftModelSchema -> draftModelSchema.getName()).collect(Collectors.toList());
        Map dbModelTables = (Map)ModelDrivenContext.getContext().getExtraMap().get("actualModelTablesFromDB");
        ArrayList<ModelTable> actualChildren = new ArrayList<ModelTable>();
        for (String draftChildModelSchemaName : draftChildrenModelSchemaNames) {
            if (!dbModelTables.containsKey(draftChildModelSchemaName)) continue;
            actualChildren.add((ModelTable)dbModelTables.get(draftChildModelSchemaName));
        }
        LinkedHashMap tempDDLDML = new LinkedHashMap();
        AtomicReference<PublishStatusEnum> alterStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        ArrayList dmlSqlParams = new ArrayList();
        ArrayList ddlSqlParams = new ArrayList();
        tempDDLDML.put("dml", dmlSqlParams);
        tempDDLDML.put("ddl", ddlSqlParams);
        boolean draftChildrenEmpty = CollectionUtils.isEmpty(draftChildren);
        boolean publishedChildrenEmpty = CollectionUtils.isEmpty(publishedChildrenSchemas);
        if (draftChildrenEmpty && !publishedChildrenEmpty && MapUtils.isNotEmpty(dropChildTableCommandData = ModelSqlGenerator.getDropChildTables(dropChildModelTables = (shouldDropChildModelTables = publishedChildrenSchemas.stream().map(publishedModelSchema -> ModelSchemaUtil.getModelTables(publishedModelSchema)).flatMap(Collection::stream).collect(Collectors.toList())).stream().filter(modelTable -> dbModelTables.containsKey(modelTable.getName())).collect(Collectors.toList())))) {
            returnValue.putAll(dropChildTableCommandData);
            dropChildModelTables.stream().forEach(dropModelTable -> dbModelTables.remove(dropModelTable.getName()));
            alterStatus.set(PublishStatusEnum.CHANGED);
        }
        if (!draftChildrenEmpty && publishedChildrenEmpty && MapUtils.isNotEmpty(createOrAlterChildrenTableCommandData = ModelTableSqlGenerator.getCreateOrAlterTableCommand(draftChildren, publishedChildrenSchemas))) {
            returnValue.putAll(createOrAlterChildrenTableCommandData);
            alterStatus.set(PublishStatusEnum.CHANGED);
        }
        if (!draftChildrenEmpty && !publishedChildrenEmpty) {
            List<ModelTable> dropChildModelTables2;
            List shouldDropChildren;
            List<ModelSchemaDTO> newChildren = draftChildren.stream().filter(draftChild -> publishedChildrenSchemas.stream().noneMatch(publishedChildModelSchema -> Objects.equals(draftChild.getName(), publishedChildModelSchema.getName()))).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(newChildren)) {
                Map<String, LinkedHashMap<String, List<SqlParam>>> createChildrenTableCommandData = ModelTableSqlGenerator.getNewChildren(newChildren);
                returnValue.putAll(createChildrenTableCommandData);
                newChildren.stream().forEach(newModelSchema -> dbModelTables.put(newModelSchema.getName(), ModelSchemaUtil.getCurrentLevelModelTable(newModelSchema)));
                alterStatus.set(PublishStatusEnum.CHANGED);
            }
            if (CollectionUtils.isNotEmpty(shouldDropChildren = publishedChildrenSchemas.stream().filter(draftChildFModelSchema -> draftChildren.stream().noneMatch(publishedChildFormSchema -> Objects.equals(draftChildFModelSchema.getName(), publishedChildFormSchema.getName()))).collect(Collectors.toList())) && CollectionUtils.isNotEmpty(dropChildModelTables2 = shouldDropChildren.stream().filter(dropChildModelSchema -> dbModelTables.containsKey(dropChildModelSchema.getName())).map(dropChildModelSchema -> ModelSchemaUtil.convertToSimpleModelTable(dropChildModelSchema)).collect(Collectors.toList()))) {
                Map<String, LinkedHashMap<String, List<SqlParam>>> dropChildrenTableCommandData = ModelSqlGenerator.getDropChildTables(dropChildModelTables2);
                returnValue.putAll(dropChildrenTableCommandData);
                dropChildModelTables2.stream().forEach(dropModelTable -> dbModelTables.remove(dropModelTable.getName()));
                alterStatus.set(PublishStatusEnum.CHANGED);
            }
        }
        draftChildren.forEach(draftChildModelSchema -> publishedChildrenSchemas.stream().filter(publishedChildFormSchema -> Objects.equals(draftChildModelSchema.getName(), publishedChildFormSchema.getName())).findFirst().ifPresent(publishedChildFormSchema -> {
            try {
                Map<String, LinkedHashMap<String, List<SqlParam>>> childrenAlterData = ModelTableSqlGenerator.filterAlterTableCommand(draftChildModelSchema, publishedChildFormSchema);
                if (MapUtils.isNotEmpty(childrenAlterData)) {
                    returnValue.putAll(childrenAlterData);
                    alterStatus.set(PublishStatusEnum.CHANGED);
                }
            }
            catch (Exception e) {
                String i18nMesg = DWApplicationMessageResourceBundleUtils.getString((String)"published_alter_table_detail_failed", (Object[])new Object[0]);
                log.error("{}{} -> draftChildModelSchema = {}, publishedChildModelSchema = {}", new Object[]{_CLASSTAG, i18nMesg, draftChildModelSchema, publishedChildFormSchema});
                throw new RuntimeException(i18nMesg, e);
            }
        }));
        return returnValue;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> getChildrenFullLevelAlterTableCommands(String tableName, List<ModelSchemaDTO> draftChildrenSchemas, List<ModelSchemaDTO> publishedChildrenSchemas) throws Exception {
        Map<String, LinkedHashMap<String, List<SqlParam>>> returnValue = ModelTableSqlGenerator.getRecursiveAlterChildTableCommand(tableName, draftChildrenSchemas, publishedChildrenSchemas, 1);
        return returnValue;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> getRecursiveAlterChildTableCommand(String tableName, List<ModelSchemaDTO> draftChildrenSchemas, List<ModelSchemaDTO> publishedChildrenSchemas, int level) throws Exception {
        HashMap<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new HashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        List<Object> draftChildrenModelNames = new ArrayList();
        if (CollectionUtils.isNotEmpty(draftChildrenSchemas)) {
            draftChildrenModelNames = draftChildrenSchemas.stream().map(draftChildrenSchema -> draftChildrenSchema.getName()).collect(Collectors.toList());
        }
        log.debug("{}[recursiveChildrenTable] level[{}] tableName({}) --> process children models({})", new Object[]{_CLASSTAG, level, tableName, draftChildrenModelNames});
        if (level <= 5) {
            log.debug("{} level({}) parentModel:{}, process childModelSchema", new Object[]{_CLASSTAG, level, tableName});
            Map<String, LinkedHashMap<String, List<SqlParam>>> childrenAlterData = ModelTableSqlGenerator.compareAndGetChildrenAlterData(draftChildrenSchemas, publishedChildrenSchemas);
            if (MapUtils.isNotEmpty(childrenAlterData)) {
                returnValue.putAll(childrenAlterData);
                log.debug("{} level({}) parentModel:{}, add ddl sqls of sub draftChildSchemaNames({})", new Object[]{_CLASSTAG, level, tableName, childrenAlterData.keySet()});
            }
            for (ModelSchemaDTO draftChildSchema : draftChildrenSchemas) {
                Map<String, LinkedHashMap<String, List<SqlParam>>> modelSchemaDTOList;
                String draftChildSchemaName = draftChildSchema.getName();
                log.debug("{} level({}) process sub draftChildSchemaName({})", (Object)level, (Object)draftChildSchemaName);
                Optional<ModelSchemaDTO> matchPublishedSchema = publishedChildrenSchemas.stream().filter(modelSchemaDTO -> modelSchemaDTO.getName().equals(draftChildSchemaName)).findFirst();
                int nextLevel = level + 1;
                if (matchPublishedSchema.isPresent()) {
                    modelSchemaDTOList = ModelTableSqlGenerator.getRecursiveAlterChildTableCommand(draftChildSchemaName, draftChildSchema.getChildren(), matchPublishedSchema.get().getChildren(), nextLevel);
                    returnValue.putAll(modelSchemaDTOList);
                    continue;
                }
                modelSchemaDTOList = ModelTableSqlGenerator.getRecursiveAlterChildTableCommand(tableName, draftChildSchema.getChildren(), new ArrayList<ModelSchemaDTO>(), nextLevel);
                returnValue.putAll(modelSchemaDTOList);
            }
        } else if (CollectionUtils.isNotEmpty(draftChildrenModelNames)) {
            log.warn("{} level[{}] tableName({}) --> ignored draftChildren({}) cause level > MAXLEVEL({})", new Object[]{_CLASSTAG, level, tableName, draftChildrenModelNames, 5});
        }
        return returnValue;
    }

    public static Map<String, Object> getAlterCommentInfoWithCollation(String tableName, String tableComment, LinkedList<SqlParam> sqlParams) {
        LinkedHashMap alertTableMap = new LinkedHashMap();
        SqlParam alterTableSqlParam = ModelTableSqlGenerator.generateAlterTableSqlWithCollation(tableName, tableComment, "utf8mb4_bin");
        sqlParams.add(alterTableSqlParam);
        if (log.isDebugEnabled()) {
            log.debug(">>>>> gen Alter Table Params: tableName = {}, tableComment = {}", (Object)tableName, (Object)tableComment);
            log.debug(">>>>> gen Alter Table SQL: {}", (Object)alterTableSqlParam);
        }
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        returnValue.put("success", true);
        returnValue.put("sqlParams", alertTableMap);
        return returnValue;
    }

    public static SqlParam generateAlterTableSqlWithCollation(String tableName, String tableComment, String collation) {
        String modifyTableCommentSql = String.format("ALTER TABLE `%s` %s '%s', COLLATE '%s' ", tableName, "COMMENT", tableComment, collation);
        return new SqlParam(modifyTableCommentSql, new Object[0]);
    }

    public static SqlParam generateAlterTableCollationSql(String tableName, String collation) {
        String modifyTableCommentSql = String.format("ALTER TABLE `%s` COLLATE '%s' ", tableName, collation);
        return new SqlParam(modifyTableCommentSql, new Object[0]);
    }

    public static SqlParam generateAlterTableCollationSql(String tableName) {
        SqlParam alterTableSqlParam = ModelTableSqlGenerator.generateAlterTableCollationSql(tableName, "utf8mb4_bin");
        return alterTableSqlParam;
    }

    public static LinkedList getAlterTableUniqueIndex(String tableName, ModelTable draftModelTable, ModelTable actualModelTable) {
        LinkedList<SqlParam> returnValue = new LinkedList<SqlParam>();
        List<TableIndex> draftTableIndexes = draftModelTable.getIndexes();
        List<ModelIndexDTO> draftModelIndexes = ModelIndexUtil.covertModelIndex(draftTableIndexes);
        List<ModelIndexDTO> draftColumnUniqueIndexes = ModelIndexUtil.getColumnUniqueIndexes(draftModelTable);
        draftModelIndexes.addAll(draftColumnUniqueIndexes);
        List<String> draftModelIndexesNames = ModelIndexUtil.getIndexNames(draftModelIndexes);
        List<TableIndex> existedModelTableIndexes = actualModelTable.getIndexes();
        List<ModelIndexDTO> publishedTableIndexes = ModelIndexUtil.covertModelIndex(existedModelTableIndexes);
        List<ModelIndexDTO> publishedUniqueIndexes = ModelIndexUtil.getColumnUniqueIndexes(actualModelTable);
        publishedTableIndexes.addAll(publishedUniqueIndexes);
        for (ModelIndexDTO publishedModelIndex : publishedTableIndexes) {
            String existedUniqueIndexId = publishedModelIndex.getId();
            if (!draftModelIndexesNames.contains(existedUniqueIndexId)) continue;
            ModelIndexDTO draftMatchModelIndex = draftModelIndexes.stream().filter(draftModelIndex -> draftModelIndex.getId().equals(existedUniqueIndexId)).findFirst().get();
            List<String> draftIndexMember = draftMatchModelIndex.getMember();
            List<String> existedIndexMember = publishedModelIndex.getMember();
            log.info("{} tableName =({}), unique index({}) >>> draftMember = {}, existedMember = {}", new Object[]{_CLASSTAG, tableName, existedUniqueIndexId, draftIndexMember, existedIndexMember});
            if (CollectionUtils.isEqualCollection(draftIndexMember, existedIndexMember)) continue;
            LinkedList<SqlParam> uniqueIndexSqlParams = ModelSqlGenerator.genAlterTableUniqueIndex(actualModelTable, new ArrayList<String>(), publishedModelIndex);
            returnValue.addAll(uniqueIndexSqlParams);
            log.info("{} alterDDLSqlParam add ddl sql:{}", (Object)_CLASSTAG, uniqueIndexSqlParams);
        }
        return returnValue;
    }

    public static List<SqlParam> getCombinedSqls(String tableName, List<String> ddlTablePartialSqlParams) {
        ArrayList<SqlParam> returnValue = new ArrayList<SqlParam>();
        if (CollectionUtils.isNotEmpty(ddlTablePartialSqlParams)) {
            String columnAlter = StringUtil.join(ddlTablePartialSqlParams, (String)",");
            String alterTableSql = "ALTER TABLE `" + tableName + "` " + columnAlter;
            log.debug("{}[getCombinedSqls] >>> gen ALTER TABLE SQL: {}", (Object)_CLASSTAG, (Object)alterTableSql);
            SqlParam combinedDDLSqlParam = new SqlParam(alterTableSql, new Object[0]);
            returnValue.add(combinedDDLSqlParam);
        } else {
            log.debug("{} >>> gen nothing cause partial sql is empty", (Object)_CLASSTAG);
        }
        return returnValue;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> getNewChildren(List<ModelSchemaDTO> childModelSchemas) throws Exception {
        Map<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        if (CollectionUtils.isEmpty(childModelSchemas)) {
            return returnValue;
        }
        List<ModelTable> childTables = childModelSchemas.stream().map(childModelSchema -> {
            ModelTable newModelTable = ModelSchemaUtil.getCurrentLevelModelTable(childModelSchema);
            return newModelTable;
        }).collect(Collectors.toList());
        returnValue = ModelNewSqlGenerator.getCreateChildTablesCommand(null, "code", childTables, null);
        return returnValue;
    }
}

