/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.utils;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.model.ModelAppInfoDTO;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.utils.ApTokenUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BMCenterUtil {
    private static final Logger logger = LoggerFactory.getLogger(BMCenterUtil.class);
    private static final String _CLASSTAG = "[" + BMCenterUtil.class.getSimpleName() + "]";

    public static String getProdOfSite() {
        String appIdOfProperties = ApTokenUtil.getAppIdByApplicationConfig();
        return appIdOfProperties;
    }

    public static String getEaiServicePrefix(String targetProdOfDWServiceMapping) {
        String[] appIdToken = targetProdOfDWServiceMapping.toLowerCase().split("-");
        List appIdTokens = Stream.of(appIdToken).collect(Collectors.toList());
        if (appIdTokens.size() >= 2) {
            appIdTokens.remove(appIdTokens.size() - 1);
        }
        String validStr = StringUtils.join(appIdTokens, (String)".");
        return validStr;
    }

    public static String getTargetProdForServiceMapping(String targetProd) {
        targetProd = targetProd.toLowerCase().replaceAll("-", "_");
        return targetProd;
    }

    public static void modifyServiceMapping(DWServiceMapping serviceMapping, String targetProd) {
        serviceMapping.setTargetProd(targetProd);
    }

    public static void modifyServiceMapping(List<DWServiceMapping> serviceMappings) {
        ModelDTO modelDTO = ModelDrivenContext.getContext().getDraftModel();
        ModelAppInfoDTO modelAppInfo = modelDTO.getAppInfo();
        String targetProd = modelAppInfo.getTargetProd();
        BMCenterUtil.modifyServiceMapping(serviceMappings, targetProd);
    }

    public static void modifyServiceMapping(List<DWServiceMapping> serviceMappings, String targetProd) {
        BMProperties bmProperties = BMProperties.getProperties();
        if (bmProperties != null && bmProperties.isEnabled()) {
            serviceMappings.stream().forEach(dwServiceMapping -> BMCenterUtil.modifyServiceMapping(dwServiceMapping, targetProd));
        }
    }

    public static void modifyMappingModelInfo(List<MappingModelInfo> mappingModelInfos) {
        ModelDTO modelDTO = ModelDrivenContext.getContext().getDraftModel();
        ModelAppInfoDTO modelAppInfo = modelDTO.getAppInfo();
        String targetProd = modelAppInfo.getTargetProd();
        mappingModelInfos.stream().forEach(mappingModelInfo -> BMCenterUtil.modifyMappingModelInfo(mappingModelInfo, targetProd));
    }

    public static void modifyMappingModelInfo(MappingModelInfo mappingModelInfo, String targetProd) {
        mappingModelInfo.setTargetProd(targetProd);
    }

    public static String getTargetProd(String serviceName, Map<String, BMCode> bmCodes) {
        BMProperties bmProperties = BMProperties.getProperties();
        String targetProdOfBmCode = "";
        if (bmCodes.containsKey(serviceName)) {
            BMCode targetBMCode = bmCodes.get(serviceName);
            targetProdOfBmCode = targetBMCode.getTargetProd();
            if (StringUtils.isBlank((CharSequence)targetProdOfBmCode)) {
                logger.warn("{} *** BM({}) *** serviceName:({}) targetProd is blank in bmCodes", new Object[]{_CLASSTAG, bmProperties.getRole(), serviceName});
            } else {
                return targetProdOfBmCode;
            }
        }
        String targetProd = "";
        String bmTargetProdsOfApplicationProperties = DWApplicationConfigUtils.getProperty((String)"lcdp.bm.target.prod");
        if (StringUtils.isBlank((CharSequence)bmTargetProdsOfApplicationProperties)) {
            logger.warn("{} *** BM({}) *** serviceName:({}), bmTargetProds is blank in bmCodes", new Object[]{_CLASSTAG, bmProperties.getRole(), serviceName});
            throw new RuntimeException("<<< bmTargetProds properties is not configured");
        }
        List bmTargetProdList = Stream.of(bmTargetProdsOfApplicationProperties.split(",")).collect(Collectors.toList());
        targetProd = (String)bmTargetProdList.get(0);
        logger.warn("{} *** BM({}) *** serviceName:({}), targetProd({}), cause targetProd is blank in bmCodes", new Object[]{_CLASSTAG, bmProperties.getRole(), serviceName, targetProd});
        return targetProd;
    }

    public static BMCode getBMCode(String serviceName, Map<String, BMCode> bmCodes) {
        if (bmCodes.containsKey(serviceName)) {
            BMCode targetBMCode = bmCodes.get(serviceName);
            return targetBMCode;
        }
        return null;
    }

    private String getApiType(String apiName, String prod) throws Exception {
        String apiType = null;
        if (apiName.startsWith((String)(prod = ((String)prod).toLowerCase().replace("-", ".") + ".lc."))) {
            if (apiName.endsWith(".get")) {
                apiType = "get";
            }
        } else if (apiName.endsWith(".list.get")) {
            apiType = "list.get";
        }
        if (apiName.endsWith(".detail.get")) {
            apiType = "detail.get";
        } else if (apiName.endsWith(".create")) {
            apiType = "create";
        } else if (apiName.endsWith(".update")) {
            apiType = "update";
        } else if (apiName.endsWith(".valid")) {
            apiType = "valid";
        } else if (apiName.endsWith(".invalid")) {
            apiType = "invalid";
        } else if (apiName.endsWith(".delete")) {
            apiType = "delete";
        }
        return apiType;
    }
}

