/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.ddl.enums.DataTypeEnum;
import com.digiwin.lcdp.modeldriven.constants.ModelDBConstants;
import com.digiwin.lcdp.modeldriven.enums.ModelFieldRelationTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelFieldDTO;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.utils.ModelDataTypeUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBColumnUtil {
    private static final Logger logger = LoggerFactory.getLogger(DBColumnUtil.class);
    private static String logTag = "[" + DBColumnUtil.class.getSimpleName() + "]";

    @Deprecated
    public static TableColumn convertToTableColumn_org(ModelFieldDTO modelField) {
        TableColumn tableColumn = new TableColumn();
        tableColumn.setColumnName(modelField.getFieldId());
        tableColumn.setComment(modelField.getFieldName());
        tableColumn.setDataType(DataTypeEnum.valueOf((String)modelField.getFieldType()));
        tableColumn.setNullable(Optional.ofNullable(modelField.getNotNull()).orElse(true) == false);
        tableColumn.setDefaultValue(modelField.getDefaultValue());
        tableColumn.setAutoIncrement(modelField.getAutoIncrement());
        tableColumn.setPK(modelField.isPk());
        tableColumn.setLang(modelField.getLang());
        if (StringUtils.isNotBlank((CharSequence)modelField.getSize())) {
            if (DBColumnUtil.checkResetNullToSizeScaleOfDataType(tableColumn)) {
                tableColumn.setSize(null);
                tableColumn.setScale(null);
                logger.debug(logTag + " tableColumn({}), size/scale reset null", (Object)tableColumn.getColumnName());
            } else {
                tableColumn.setSize(new Integer(modelField.getSize()));
            }
        }
        if (tableColumn.getSize() != null && StringUtils.isNotBlank((CharSequence)modelField.getScale())) {
            tableColumn.setScale(new Integer(modelField.getScale()));
        }
        DBColumnUtil.resetColumnSize(tableColumn);
        if (StringUtils.isNotBlank((CharSequence)modelField.getDefaultValueType())) {
            String defaultValueType = modelField.getDefaultValueType();
            if (defaultValueType.equalsIgnoreCase("expression")) {
                tableColumn.setDefaultValueIsExpr(true);
            }
            tableColumn.setDefaultValueType(defaultValueType);
        }
        tableColumn.setUnique(modelField.getUnique());
        tableColumn.setRelationTypeEnum(ModelFieldRelationTypeEnum.valueOf(modelField.getType()));
        return tableColumn;
    }

    public static TableColumn convertToTableColumn(ModelFieldDTO modelField) {
        TableColumn tableColumn = new TableColumn();
        tableColumn.setColumnName(modelField.getFieldId());
        tableColumn.setComment(modelField.getFieldName());
        tableColumn.setDataType(DataTypeEnum.valueOf((String)ModelDataTypeUtil.getDatabaseDataType(modelField.getFieldType())));
        tableColumn.setNullable(Optional.ofNullable(modelField.getNotNull()).orElse(true) == false);
        tableColumn.setDefaultValue(modelField.getDefaultValue());
        tableColumn.setAutoIncrement(modelField.getAutoIncrement());
        tableColumn.setPK(modelField.isPk());
        tableColumn.setLang(modelField.getLang());
        if (!StringUtils.isEmpty((CharSequence)modelField.getSize())) {
            tableColumn.setSize(new Integer(modelField.getSize()));
        }
        if (!StringUtils.isEmpty((CharSequence)modelField.getScale())) {
            tableColumn.setScale(new Integer(modelField.getScale()));
        }
        if (StringUtils.isNotBlank((CharSequence)modelField.getDefaultValueType())) {
            String defaultValueType = modelField.getDefaultValueType();
            if (defaultValueType.equalsIgnoreCase("expression")) {
                tableColumn.setDefaultValueIsExpr(true);
            }
            tableColumn.setDefaultValueType(defaultValueType);
        }
        tableColumn.setUnique(modelField.getUnique());
        tableColumn.setRelationTypeEnum(ModelFieldRelationTypeEnum.valueOf(modelField.getType()));
        return tableColumn;
    }

    public static void resetColumnSize(TableColumn tableColumn) {
        DataTypeEnum dataType = tableColumn.getDataType();
        String type = dataType.getType();
        String name = dataType.getName();
        if ("TIME".equals(type) && ModelDBConstants.MYSQL_SQL_DATATYPE_TIME_NAME_WITH_SIZE.stream().anyMatch(timeType -> name.equals(timeType) && tableColumn.getSize() == null)) {
            Integer orgSize = tableColumn.getSize();
            tableColumn.setSize(0);
            logger.debug(logTag + "columnName({}) reset Size, size({} --> {})", new Object[]{tableColumn.getColumnName(), orgSize, 0});
        }
    }

    public static boolean checkResetNullToSizeScaleOfDataType(TableColumn tableColumn) {
        DataTypeEnum datatype = tableColumn.getDataType();
        String dataTypeType = datatype.getType();
        String dataTypeName = datatype.getName();
        boolean needReset = ModelDBConstants.SQL_DATATYPE_TYPE_WITHOUT_SIZE.contains(dataTypeType) || ModelDBConstants.SQL_DATATYPE_NAME_WITHOUT_SIZE.contains(dataTypeName);
        return needReset;
    }

    public static TableColumn getAutoIncrementColumn(List<TableColumn> tableColumns) {
        TableColumn tableColumnWithAutoIncrement = tableColumns.stream().filter(tableColumn -> tableColumn.getAutoIncrement()).findFirst().orElse(null);
        return tableColumnWithAutoIncrement;
    }

    public static String getMessageLang(TableColumn tableColumn, String locale) {
        String columnComment = "";
        Map<String, Map<String, String>> langMap = tableColumn.getLang();
        if (tableColumn.getLang() != null && langMap.containsKey("fieldName")) {
            Map<String, String> fieldNameLang = langMap.get("fieldName");
            columnComment = fieldNameLang.get(locale);
        }
        if (StringUtils.isBlank((CharSequence)columnComment)) {
            columnComment = tableColumn.getComment();
        }
        return columnComment;
    }
}

