/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.enums.AlterColumnEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterIndexEnum;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.ModelTableSchemaCache;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.compare.ColumnCompareUtil;
import com.digiwin.lcdp.modeldriven.utils.compare.IndexCompareUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelTablePartialSqlGenerator {
    private static final Logger log = LoggerFactory.getLogger(ModelTablePartialSqlGenerator.class);
    private static final String CLASS_LOG_TAG = "[" + ModelTablePartialSqlGenerator.class.getSimpleName() + "]";

    public static LinkedList<String> getAlterTableOptionsWhenNewPublish(String tableComment) {
        String alterTableOptComment = String.format("COMMENT='%s' ", tableComment);
        String alterTableOptCharsetCollation = String.format("CONVERT TO CHARACTER SET '%s' COLLATE '%s'", "utf8mb4", "utf8mb4_bin");
        if (log.isDebugEnabled()) {
            log.debug("{}[getAlterTableOptionsWhenNewPublish] >>>>> gen Table partial sql: {}", (Object)CLASS_LOG_TAG, (Object)alterTableOptComment);
            log.debug("{}[getAlterTableOptionsWhenNewPublish] >>>>> gen Table partial sql: {}", (Object)CLASS_LOG_TAG, (Object)alterTableOptCharsetCollation);
        }
        LinkedList<String> returnValue = new LinkedList<String>();
        returnValue.add(alterTableOptComment);
        returnValue.add(alterTableOptCharsetCollation);
        return returnValue;
    }

    public static List<String> updateColumnsSqlParams(ModelTable draftModelTable, LinkedList<SqlParam> dmlSqlParams) {
        LinkedList<String> ddlTablePartialSqlParams = new LinkedList<String>();
        String tableName = draftModelTable.getName();
        Map<AlterColumnEnum, List<TableColumn>> alterColumnsMap = ModelSchemaUtil.getAlterColumnsMap(draftModelTable);
        if (MapUtils.isNotEmpty(alterColumnsMap)) {
            alterColumnsMap.forEach((alterColumnEnum, tableColumns) -> {
                if (!CollectionUtils.isEmpty((Collection)tableColumns)) {
                    List<String> newColumnPartialSqls = ModelTablePartialSqlGenerator.updateAlterColumnsInfoOnly(tableName, alterColumnEnum, tableColumns, dmlSqlParams);
                    newColumnPartialSqls.stream().filter(newSql -> ddlTablePartialSqlParams.stream().noneMatch(ddlSqlParam -> Objects.equals(ddlSqlParam, newSql))).forEach(ddlTablePartialSqlParams::add);
                }
            });
        }
        return ddlTablePartialSqlParams;
    }

    public static List<String> updateAlterColumnsInfoOnly(String tableName, AlterColumnEnum alterColumnEnum, List<TableColumn> modelColumns, LinkedList<SqlParam> targetDMLSqlParam) {
        LinkedList<String> columnPartialDDLSqlParam = new LinkedList<String>();
        modelColumns.forEach(modelColumn -> {
            LinkedList<String> alterTableSqlParam = ModelTablePartialSqlGenerator.generateAlterColumnsSql(tableName, alterColumnEnum, modelColumn);
            alterTableSqlParam.stream().filter(newSql -> columnPartialDDLSqlParam.stream().noneMatch(ddlSqlParam -> Objects.equals(ddlSqlParam, newSql))).forEach(filteredSql -> columnPartialDDLSqlParam.add((String)filteredSql));
            if (alterColumnEnum == AlterColumnEnum.DROP_COLUMN) {
                SqlParam deleteRdbmsFieldSql = ModelSqlGenerator.generateDeleteRdbmsFieldSql(tableName, modelColumn.getColumnName());
                targetDMLSqlParam.add(deleteRdbmsFieldSql);
            }
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter Columns Params: tableName = {}, alterColumnEnum = {}, customColumn = {}", new Object[]{tableName, alterColumnEnum, modelColumn});
                log.debug(">>>>> gen Alter Columns SQL: {}", alterTableSqlParam);
            }
        });
        return columnPartialDDLSqlParam;
    }

    public static LinkedList<String> generateAlterColumnsSql(String tableName, AlterColumnEnum alterColumnEnum, TableColumn draftTableColumn) {
        LinkedList<String> sqlPartials = new LinkedList<String>();
        String autoIncrementOrDefaultValue = ColumnCompareUtil.getSqlByAutoIncrementOrDefaultValue(draftTableColumn, false);
        String pkConditionSql = "";
        switch (alterColumnEnum) {
            case ADD_COLUMN: {
                String addColumnSql = String.format(" %s `%s` %s %s %s %s %s '%s' ", alterColumnEnum.getSqlChar(), draftTableColumn.getColumnName(), ColumnCompareUtil.getTypeDDL(draftTableColumn), ColumnCompareUtil.getNullableEnum(draftTableColumn.nullable()).getSqlChar(), ColumnCompareUtil.columnUniqueValue(draftTableColumn.getUnique()), autoIncrementOrDefaultValue, "COMMENT", draftTableColumn.getComment());
                if (autoIncrementOrDefaultValue.toUpperCase().contains("AUTO_INCREMENT")) {
                    pkConditionSql = ModelSqlGenerator.getPrimaryKeyCondition(tableName, autoIncrementOrDefaultValue, draftTableColumn);
                    Map<String, ModelTableSchemaCache> publishedTableCache = ModelDrivenContext.getContext().getPublishedTableCache();
                    ModelTableSchemaCache publishedTableSchemaCache = publishedTableCache.get(tableName);
                    publishedTableSchemaCache.setAutoIncrementColumn(draftTableColumn);
                    log.debug("{} generateAlterColumnsSql: add publishedTableSchemaCache.setAutoIncrementColumn({}), sql({})", new Object[]{CLASS_LOG_TAG, draftTableColumn.getColumnName(), addColumnSql});
                }
                sqlPartials.add(addColumnSql);
                if (!StringUtils.isNotBlank((CharSequence)pkConditionSql)) break;
                sqlPartials.add(pkConditionSql);
                break;
            }
            case MODIFY_COLUMN: {
                String modifyColumnSql = ModelTablePartialSqlGenerator.genColumnModifySql(tableName, alterColumnEnum, draftTableColumn, autoIncrementOrDefaultValue);
                if (autoIncrementOrDefaultValue.toUpperCase().contains("AUTO_INCREMENT")) {
                    pkConditionSql = ModelSqlGenerator.getPrimaryKeyCondition(tableName, autoIncrementOrDefaultValue, draftTableColumn);
                    Map<String, ModelTableSchemaCache> publishedTableCache = ModelDrivenContext.getContext().getPublishedTableCache();
                    ModelTableSchemaCache publishedTableSchemaCache = publishedTableCache.get(tableName);
                    publishedTableSchemaCache.setAutoIncrementColumn(draftTableColumn);
                    log.debug("{} generateAlterColumnsSql: modify publishedTableSchemaCache.setAutoIncrementColumn({}), sql({})", new Object[]{CLASS_LOG_TAG, draftTableColumn.getColumnName(), modifyColumnSql});
                }
                sqlPartials.add(modifyColumnSql);
                if (!StringUtils.isNotBlank((CharSequence)pkConditionSql)) break;
                sqlPartials.add(pkConditionSql);
                break;
            }
            case DROP_COLUMN: {
                String dropColumnSql = String.format(" %s `%s` ", alterColumnEnum.getSqlChar(), draftTableColumn.getColumnName());
                Map<String, ModelTableSchemaCache> publishedTableCache = ModelDrivenContext.getContext().getPublishedTableCache();
                ModelTableSchemaCache publishedTableSchemaCache = publishedTableCache.get(tableName);
                TableColumn remainAutoIncrementColumn = publishedTableSchemaCache.getAutoIncrementColumn();
                if (remainAutoIncrementColumn != null && StringUtils.equals((CharSequence)remainAutoIncrementColumn.getColumnName(), (CharSequence)draftTableColumn.getColumnName())) {
                    publishedTableSchemaCache.setAutoIncrementColumn(null);
                    log.debug("{} generateAlterColumnsSql: clean ModelContext Cache, setAutoIncrementColumn null, remain name({}), published name({}), sql({})", new Object[]{CLASS_LOG_TAG, remainAutoIncrementColumn.getColumnName(), draftTableColumn.getColumnName(), dropColumnSql});
                }
                sqlPartials.add(dropColumnSql);
                break;
            }
            default: {
                throw new DWRuntimeException("\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c");
            }
        }
        return sqlPartials;
    }

    public static List<String> getAlterTableInfoWhenExistedModel(ModelTable modelTable) {
        String alterTableOptComment = String.format("%s '%s' ", "COMMENT", modelTable.getComment());
        if (log.isDebugEnabled()) {
            log.debug("{}[getAlterTableInfoWhenExistedModel] gen Table partial sql: {}", (Object)CLASS_LOG_TAG, (Object)alterTableOptComment);
        }
        ArrayList<String> returnValue = new ArrayList<String>();
        returnValue.add(alterTableOptComment);
        return returnValue;
    }

    public static List<String> getAlterIndexesInfo(String tableName, AlterIndexEnum alterIndexEnum, List<TableIndex> tableIndexes) {
        ArrayList<String> returnValue = new ArrayList<String>();
        tableIndexes.forEach(tableIndex -> {
            List<String> alterTableSqlParams = ModelTablePartialSqlGenerator.generateAlterIndexSql(tableName, alterIndexEnum, tableIndex);
            returnValue.addAll(alterTableSqlParams);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter indexes Params: tableName = {}, alterIndexEnum = {}, tableIndex = {}", new Object[]{tableName, alterIndexEnum, tableIndex});
                log.debug(">>>>> gen Alter indexes SQL: {}", alterTableSqlParams);
            }
        });
        return returnValue;
    }

    public static List<String> generateAlterIndexSql(String tableName, AlterIndexEnum alterIndexEnum, TableIndex tableIndex) {
        LinkedList<String> indexPartialSqls = new LinkedList<String>();
        String targetIndexId = tableIndex.getName();
        ModelIndexDTO targetModelIndex = ModelSchemaUtil.convertTableIndexToModelIndex(tableIndex);
        Map<String, ModelTableSchemaCache> publishedTableCache = ModelDrivenContext.getContext().getPublishedTableCache();
        ModelTableSchemaCache modelTableSchemaCache = publishedTableCache.getOrDefault(tableName, new ModelTableSchemaCache());
        Map<String, Object> publishedRemainIndexes = modelTableSchemaCache.getPublishedRemainIndexes();
        switch (alterIndexEnum) {
            case ADD: {
                String indexAddSpecification = IndexCompareUtil.generateIndexes(tableIndex);
                String indexAddSql = String.format(" %s %s", alterIndexEnum.getSqlChar(), indexAddSpecification);
                indexPartialSqls.add(indexAddSql);
                publishedRemainIndexes.put(targetIndexId, targetModelIndex);
                log.info("publishedRemainIndexes add {}({})", (Object)targetIndexId, (Object)targetModelIndex);
                break;
            }
            case MODIFY: {
                String alterSpecification = IndexCompareUtil.generateIndexes(tableIndex);
                if (targetIndexId.equals("PRIMARY KEY")) break;
                if (publishedRemainIndexes.containsKey(targetIndexId)) {
                    log.info("flag1");
                    String indexDropByModifySql = String.format(" DROP INDEX `%s`", targetIndexId);
                    String indexAddByModifySql = String.format(" ADD %s", alterSpecification);
                    indexPartialSqls.add(indexDropByModifySql);
                    indexPartialSqls.add(indexAddByModifySql);
                    publishedRemainIndexes.put(targetIndexId, targetModelIndex);
                    log.info("publishedRemainIndexes modify {}, sql({})", (Object)targetIndexId, indexPartialSqls);
                    break;
                }
                String indexAddByModifySql = String.format(" ADD %s", alterSpecification);
                indexPartialSqls.add(indexAddByModifySql);
                publishedRemainIndexes.put(targetIndexId, targetModelIndex);
                log.info("publishedRemainIndexes add {} when modify", (Object)targetIndexId);
                break;
            }
            case DROP: {
                if (publishedRemainIndexes.containsKey(targetIndexId) && !targetIndexId.equals("PRIMARY KEY")) {
                    log.info("flag2");
                    String dropColumnSql = String.format(" DROP INDEX `%s`", targetIndexId);
                    indexPartialSqls.add(dropColumnSql);
                    publishedRemainIndexes.remove(targetIndexId);
                    log.info("publishedRemainIndexes: remove {}", (Object)targetIndexId);
                    break;
                }
                log.warn("publishedRemainIndexes: ignored to drop {}", (Object)targetIndexId);
                break;
            }
            default: {
                throw new DWRuntimeException("\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c");
            }
        }
        return indexPartialSqls;
    }

    public static String genColumnModifySql(String tableName, AlterColumnEnum alterColumnEnum, TableColumn draftTableColumn, String autoIncrementOrDefaultValue) {
        String modifyColumnSql = String.format(" %s `%s` %s %s %s %s '%s' ", alterColumnEnum.getSqlChar(), draftTableColumn.getColumnName(), ColumnCompareUtil.getTypeDDL(draftTableColumn), ColumnCompareUtil.getNullableEnum(draftTableColumn.nullable()).getSqlChar(), autoIncrementOrDefaultValue, "COMMENT", draftTableColumn.getComment());
        return modifyColumnSql;
    }

    public static LinkedList<String> addRelationSql(String tableName, TableColumn draftTableColumn, List<String> sqlPartials) {
        LinkedList<String> relationSqls = new LinkedList<String>();
        LinkedList<String> sqls = ModelTablePartialSqlGenerator.getRelationColumnRemovedAutoIncrementSql(tableName, draftTableColumn);
        relationSqls.addAll(sqls);
        sqlPartials.addAll(relationSqls);
        return relationSqls;
    }

    public static LinkedList<String> getRelationColumnRemovedAutoIncrementSql(String tableName, TableColumn draftTableColumn) {
        Map draftModelTableMap;
        List<TableColumn> tableColumns;
        TableColumn remainTargetDraftColumn;
        LinkedList<String> returnValue = new LinkedList<String>();
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map<String, ModelTableSchemaCache> publishedTableCache = modelDrivenContext.getPublishedTableCache();
        ModelTableSchemaCache publishedTableSchemaCache = publishedTableCache.get(tableName);
        TableColumn remainAutoIncrementColumn = publishedTableSchemaCache.getAutoIncrementColumn();
        if (remainAutoIncrementColumn != null && !StringUtils.equals((CharSequence)remainAutoIncrementColumn.getColumnName(), (CharSequence)draftTableColumn.getColumnName()) && (remainTargetDraftColumn = (TableColumn)(tableColumns = ((ModelTable)(draftModelTableMap = (Map)modelDrivenContext.getExtraMap().get("draftModelTables")).get(tableName)).getColumns()).stream().filter(tableColumn -> tableColumn.getColumnName().equals(remainAutoIncrementColumn.getColumnName())).findFirst().orElse(null)) != null) {
            String remainAutoIncrementOrDefaultValue = ColumnCompareUtil.getSqlByAutoIncrementOrDefaultValue(remainTargetDraftColumn, false);
            String removeRemainAutoIncrmtSql = ModelTablePartialSqlGenerator.genColumnModifySql(tableName, AlterColumnEnum.MODIFY_COLUMN, remainTargetDraftColumn, remainAutoIncrementOrDefaultValue);
            returnValue.add(removeRemainAutoIncrmtSql);
            publishedTableSchemaCache.setAutoIncrementColumn(null);
            log.debug("{} publishedTableSchemaCache setAutoIncrementColumn null, cause new autoIncrement({}), sql({})", new Object[]{CLASS_LOG_TAG, draftTableColumn.getColumnName(), removeRemainAutoIncrmtSql});
        }
        return returnValue;
    }
}

