/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.lcdp.modeldriven.constants.ModelDrivenConstants;
import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.ModelApiTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.ModelFieldRelationTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelApiField;
import com.digiwin.lcdp.modeldriven.model.ModelApiFieldStateTransferConfig;
import com.digiwin.lcdp.modeldriven.model.ModelAssociatedInfo;
import com.digiwin.lcdp.modeldriven.model.ModelFieldDTO;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.BindApi;
import com.digiwin.lcdp.modeldriven.utils.ModelQuerySelectUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import com.digiwin.utils.DWTenantUtils;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamValidateUtil {
    private static final Logger log = LoggerFactory.getLogger(ParamValidateUtil.class);
    private static final String _CLASSTAG = "[" + ParamValidateUtil.class.getSimpleName() + "]";

    public static void validateRequestParamWithPkAndBk(List<Map<String, Object>> paramDatas, ModelSchemaDTO masterModelSchema, ModelApiTypeEnum apiType) {
        ParamValidateUtil.validateRequestParam(paramDatas, masterModelSchema, apiType, true);
    }

    public static void validateRequestParamWithoutPkAndBk(List<Map<String, Object>> paramDatas, ModelSchemaDTO masterModelSchema, ModelApiTypeEnum apiType) {
        ParamValidateUtil.validateRequestParam(paramDatas, masterModelSchema, apiType, false);
    }

    public static void validateRequestParam(List<Map<String, Object>> paramDatas, ModelSchemaDTO masterModelSchema, ModelApiTypeEnum apiType, boolean validatePkAndBk) {
        Optional<BindApi> apiConfigOpt;
        Map<String, ModelSchemaDTO> modelSchemaMap = ModelSchemaUtil.getModelSchemaMap(masterModelSchema);
        Map<String, List<Map<String, Object>>> tileParamDatas = ParamValidateUtil.tileParameters(masterModelSchema, paramDatas);
        Map<String, List<ModelApiField>> tileRequestParamOfApiConfig = null;
        List<BindApi> bindApiListConfig = masterModelSchema.getBindApiListConfig();
        if (CollectionUtils.isNotEmpty(bindApiListConfig) && (apiConfigOpt = bindApiListConfig.stream().filter(apiConfig -> apiType.getValue().equals(apiConfig.getApiType())).findFirst()).isPresent()) {
            tileRequestParamOfApiConfig = ParamValidateUtil.tileApiField(apiConfigOpt.get().getApiConfig().getRequest_parameters());
        }
        for (Map.Entry<String, List<Map<String, Object>>> next : tileParamDatas.entrySet()) {
            String tableName = next.getKey();
            List<Map<String, Object>> paramData = next.getValue();
            if (!CollectionUtils.isNotEmpty(paramData)) continue;
            ModelSchemaDTO targetModelSchema = modelSchemaMap.get(tableName);
            for (Map<String, Object> data : paramData) {
                if (tileRequestParamOfApiConfig != null) {
                    ParamValidateUtil.validateAndFilterByApiConfig(data, tileRequestParamOfApiConfig.get(tableName), targetModelSchema);
                    continue;
                }
                if (!tableName.equals(masterModelSchema.getName()) || !validatePkAndBk) continue;
                ParamValidateUtil.validatePKAndBK(data, targetModelSchema);
            }
        }
    }

    public static Map<String, List<ModelApiField>> getApiResponseConfigByApiType(ModelSchemaDTO masterModelSchema, ModelApiTypeEnum apiType) {
        BindApi apiConfig2;
        Optional<BindApi> detailGetApiConfigOpt;
        Map<String, List<ModelApiField>> tileApiConfig = new HashMap<String, List<ModelApiField>>();
        if (masterModelSchema.getBindApiListConfig() != null && (detailGetApiConfigOpt = masterModelSchema.getBindApiListConfig().stream().filter(apiConfig -> apiType.getValue().equals(apiConfig.getApiType())).findFirst()).isPresent() && CollectionUtils.isNotEmpty((apiConfig2 = detailGetApiConfigOpt.get()).getApiConfig().getResponse_object())) {
            tileApiConfig = ParamValidateUtil.tileApiField(apiConfig2.getApiConfig().getResponse_object());
        }
        return tileApiConfig;
    }

    public static void validateManageStatusSource(List<Map<String, Object>> sourceDatas, List<Map<String, Object>> paramDatas, ModelSchemaDTO masterModelSchema, ModelApiTypeEnum apiType) {
        Map<String, List<ModelApiField>> tileApiConfig = null;
        List<BindApi> bindApiListConfig = masterModelSchema.getBindApiListConfig();
        if (CollectionUtils.isNotEmpty(bindApiListConfig)) {
            Optional<ModelApiField> manageStatusOpt;
            List modelApiFields;
            Optional<BindApi> apiConfigOpt = bindApiListConfig.stream().filter(apiConfig -> apiType.getValue().equals(apiConfig.getApiType())).findFirst();
            if (apiConfigOpt.isPresent()) {
                tileApiConfig = ParamValidateUtil.tileApiField(apiConfigOpt.get().getApiConfig().getRequest_parameters());
            }
            if (CollectionUtils.isNotEmpty((Collection)(modelApiFields = (List)tileApiConfig.get(masterModelSchema.getName()))) && (manageStatusOpt = modelApiFields.stream().filter(modelApiField -> "manage_status".equals(modelApiField.getData_name())).findFirst()).isPresent()) {
                ModelApiField manageStatusField = manageStatusOpt.get();
                ModelApiFieldStateTransferConfig manageStatusConfig = manageStatusField.getStateTransferConfig();
                if (!manageStatusField.getShow()) {
                    List errorSourceDatas = sourceDatas.stream().filter(data -> !manageStatusConfig.getSourceId().equals(data.get("manage_status"))).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(errorSourceDatas)) {
                        throw new RuntimeException(String.format(ResourceBundleUtils.getString("paramValidate.apiConfig.errorPrefix") + ResourceBundleUtils.getString("paramValidate.apiConfig.managestatusStateError"), manageStatusOpt.get().getStateTransferConfig().getSourceId(), ((Map)errorSourceDatas.get(0)).entrySet()));
                    }
                    paramDatas.forEach(paramData -> paramData.put("manage_status", manageStatusConfig.getTargetIds()));
                }
            }
        }
    }

    public static Map<String, List<Map<String, Object>>> tileParameters(ModelSchemaDTO modelSchema, List<Map<String, Object>> masterTableParams) {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>();
        ArrayList newMasterTableRows = new ArrayList();
        masterTableParams.forEach(eachTableParam -> {
            List<ModelSchemaDTO> childrenModelSchema = modelSchema.getChildren();
            HashMap newMasterTableRow = new HashMap();
            eachTableParam.forEach((key, value) -> {
                if (childrenModelSchema.stream().map(ModelSchemaDTO::getName).collect(Collectors.toList()).contains(key)) {
                    List<Map<String, Object>> childrenTableParamterRows = new ArrayList();
                    if (value instanceof List) {
                        childrenTableParamterRows = (List)value;
                    } else if (value instanceof Map) {
                        childrenTableParamterRows.add((Map)value);
                    }
                    Map<String, List<Map<String, Object>>> childrenTableDatas = ParamValidateUtil.tileParameters(childrenModelSchema.stream().filter(schema -> schema.getName().equalsIgnoreCase((String)key)).findFirst().get(), childrenTableParamterRows);
                    childrenTableDatas.forEach((childrenTableName, childrenTableRows) -> {
                        if (CollectionUtils.isNotEmpty((Collection)((Collection)result.get(childrenTableName)))) {
                            ((List)result.get(childrenTableName)).addAll(childrenTableRows);
                        } else {
                            result.put((String)childrenTableName, (List<Map<String, Object>>)childrenTableRows);
                        }
                    });
                } else {
                    newMasterTableRow.put(key, value);
                }
            });
            newMasterTableRows.add(newMasterTableRow);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)result.get(modelSchema.getName())))) {
            ((List)result.get(modelSchema.getName())).addAll(newMasterTableRows);
        } else {
            result.put(modelSchema.getName(), newMasterTableRows);
        }
        return result;
    }

    public static Map<String, List<ModelApiField>> tileApiField(List<ModelApiField> apiFields) {
        HashMap<String, List<ModelApiField>> result = new HashMap<String, List<ModelApiField>>();
        if (CollectionUtils.isNotEmpty(apiFields)) {
            apiFields.forEach(modelApiField -> {
                if (CollectionUtils.isNotEmpty(modelApiField.getField())) {
                    result.putAll(ParamValidateUtil.tileApiField(modelApiField.getField()));
                    String[] split = modelApiField.getFullPath().split("\\.");
                    int length = split.length;
                    String fieldName = split[length - 1];
                    result.put(fieldName, modelApiField.getField());
                }
            });
        }
        return result;
    }

    public static void validateAndFilterByApiConfig(Map<String, Object> rowData, List<ModelApiField> fields, ModelSchemaDTO targetModelSchema) {
        if (CollectionUtils.isNotEmpty(fields)) {
            StringBuilder builder = new StringBuilder("");
            List requestParamList = fields.stream().filter(field -> field.getShow()).map(field -> {
                String[] split = field.getFullPath().split("\\.");
                int length = split.length;
                return split[length - 1];
            }).collect(Collectors.toList());
            List missingFields = fields.stream().filter(field -> {
                String[] split = field.getFullPath().split("\\.");
                int length = split.length;
                String fieldName = split[length - 1];
                return field.getShow() && field.getRequired() && !rowData.keySet().contains(fieldName);
            }).collect(Collectors.toList());
            Iterator<Map.Entry<String, Object>> iterator = rowData.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> next = iterator.next();
                if (requestParamList.contains(next.getKey())) continue;
                iterator.remove();
            }
            if (CollectionUtils.isNotEmpty(missingFields)) {
                builder.append(ResourceBundleUtils.getString("paramValidate.apiConfig.errorPrefix") + ResourceBundleUtils.getString("paramValidate.apiConfig.missFields")).append(String.join((CharSequence)",", missingFields.stream().map(field -> {
                    String[] split = field.getFullPath().split("\\.");
                    int length = split.length;
                    String fieldName = split[length - 1];
                    return "'" + fieldName + "'";
                }).collect(Collectors.toList())));
            }
            if (!"".equals(builder.toString())) {
                throw new RuntimeException(builder.toString());
            }
        }
    }

    public static void validatePKAndBK(Map<String, Object> rowData, ModelSchemaDTO modelSchema) {
        Optional<ModelFieldDTO> pkOpt = modelSchema.getFields().stream().filter(field -> field.isPk()).findFirst();
        Optional<ModelIndexDTO> bkIndexOpt = modelSchema.getIndex().stream().filter(index -> index.getType().toLowerCase().equals(IndexTypeEnum.UNIQUE_INDEX.getIndexChar())).findFirst();
        ModelIndexDTO bkIndex = null;
        ModelFieldDTO pkField = null;
        if (bkIndexOpt.isPresent()) {
            bkIndex = bkIndexOpt.get();
        }
        if (bkIndex != null) {
            String bkIndexId = bkIndex.getId();
            bkIndex.getMember().forEach(indexField -> {
                if (!indexField.equals(DWTenantUtils.getTenantColumnName()) && rowData.get(indexField) == null) {
                    throw new RuntimeException(String.format(ResourceBundleUtils.getString("paramValidate.bkValidateFail"), bkIndexId, indexField, rowData.entrySet()));
                }
            });
        } else if (pkOpt.isPresent()) {
            pkField = pkOpt.get();
            if (rowData.get(pkField.getFieldId()) == null) {
                throw new RuntimeException(String.format(ResourceBundleUtils.getString("paramValidate.pkValidateFail"), pkField.getFieldId(), rowData.entrySet()));
            }
        } else {
            throw new RuntimeException(String.format(ResourceBundleUtils.getString("paramValidate.pkAndBkNotExist"), modelSchema.getName()));
        }
    }

    public static void filterParam(Map<String, Object> rowData, ModelSchemaDTO modelSchema) {
        Iterator<Map.Entry<String, Object>> iterator = rowData.entrySet().iterator();
        Gson gson = DWGsonProvider.getGson();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> next = iterator.next();
            String field = next.getKey();
            Object value = next.getValue();
            if (ModelDrivenConstants.EXCLUDE_VALIDATE_FIELDS.contains(field)) continue;
            ModelFieldDTO modelFieldDTO = modelSchema.getFields().stream().filter(modelSchemaField -> modelSchemaField.getFieldId().equals(field)).findFirst().orElse(null);
            if (modelFieldDTO != null && !StringUtils.isEmpty((CharSequence)modelFieldDTO.getFieldType()) && (modelFieldDTO.getFieldType().toUpperCase().equals("DATETIME") || modelFieldDTO.getFieldType().toUpperCase().equals("TIMESTAMP") || modelFieldDTO.getFieldType().toUpperCase().equals("DATE"))) {
                rowData.put(field, "".equals(value) ? null : value);
            }
            if (modelFieldDTO != null && "JSON".equalsIgnoreCase(modelFieldDTO.getFieldType())) {
                rowData.put(field, gson.toJson(rowData.get(field)));
            }
            if (modelFieldDTO != null) continue;
            iterator.remove();
        }
    }

    public static void filterOutChildrenTableParam(Map<String, Object> rowData, ModelSchemaDTO modelSchema) {
        Iterator<Map.Entry<String, Object>> iterator = rowData.entrySet().iterator();
        List<ModelSchemaDTO> childrenSchema = ModelSchemaUtil.getChildrenModelSchema(modelSchema.getChildren());
        if (CollectionUtils.isEmpty(childrenSchema)) {
            return;
        }
        List childrenTableNames = childrenSchema.stream().map(childSchema -> childSchema.getName()).collect(Collectors.toList());
        while (iterator.hasNext()) {
            Map.Entry<String, Object> next = iterator.next();
            String field = next.getKey();
            if (!childrenTableNames.contains(field)) continue;
            iterator.remove();
            log.warn("[filterOutChildrenTableParam] ignored field '{}', cause match children name({})", (Object)field, childrenTableNames);
        }
    }

    public static void validateStrategyOfChildrenTableRow(ModelSchemaDTO modelSchema, List<Map<String, Object>> masterTableParams) {
        for (Map<String, Object> masterTableParam : masterTableParams) {
            List<ModelSchemaDTO> childrenModelSchema = modelSchema.getChildren();
            List childTables = childrenModelSchema.stream().map(ModelSchemaDTO::getName).collect(Collectors.toList());
            masterTableParam.forEach((key, value) -> {
                if (childTables.contains(key)) {
                    List<Map<String, Object>> childrenTableParamterRows = new ArrayList();
                    if (value instanceof List) {
                        childrenTableParamterRows = (List)value;
                    } else if (value instanceof Map) {
                        childrenTableParamterRows.add((Map)value);
                    }
                    if (CollectionUtils.isNotEmpty(childrenTableParamterRows)) {
                        ParamValidateUtil.validateStrategy(childrenTableParamterRows, (String)((Map)childrenTableParamterRows.get(0)).get("update_type"));
                    }
                    ParamValidateUtil.validateStrategyOfChildrenTableRow(childrenModelSchema.stream().filter(schema -> schema.getName().equalsIgnoreCase((String)key)).findFirst().get(), childrenTableParamterRows);
                }
            });
        }
    }

    public static void validateStrategy(List<Map<String, Object>> childParams, String updateType) {
        childParams.forEach(childParam -> {
            if (ModelDrivenConstants.UPDATE_TYPE_SUBTABLE_PART_TYPE1.contains(updateType)) {
                if (!ModelDrivenConstants.UPDATE_TYPE_SUBTABLE_PART_TYPE1.contains(childParam.get("update_type"))) {
                    throw new RuntimeException(String.format("'update_type' should be the same as parent table update type in %s ,error row:%s", String.join((CharSequence)" or ", ModelDrivenConstants.UPDATE_TYPE_SUBTABLE_PART_TYPE1), childParam.entrySet()));
                }
            } else if (updateType != null && !updateType.equalsIgnoreCase((String)childParam.get("update_type"))) {
                throw new RuntimeException(String.format("'update_type' should be the same as parent table update type %s ,error row:%s", updateType, childParam.entrySet()));
            }
        });
    }

    public static List<Map<String, Object>> filterParameters(ModelSchemaDTO modelSchema, List<Map<String, Object>> masterTableParams) {
        ArrayList<Map<String, Object>> newMasterTableRows = new ArrayList<Map<String, Object>>();
        block0: for (Map<String, Object> masterTableParam : masterTableParams) {
            List<ModelSchemaDTO> childrenModelSchema = modelSchema.getChildren();
            List childTables = childrenModelSchema.stream().map(ModelSchemaDTO::getName).collect(Collectors.toList());
            boolean childrenRowAllNullFlag = true;
            for (Map.Entry<String, Object> next : masterTableParam.entrySet()) {
                String paramKey = next.getKey();
                Object paramValue = next.getValue();
                if (!childTables.contains(paramKey)) continue;
                List<Map> childrenTableParamterRows = new ArrayList();
                if (paramValue instanceof List) {
                    childrenTableParamterRows = (List)paramValue;
                } else if (paramValue instanceof Map) {
                    childrenTableParamterRows.add((Map)paramValue);
                }
                if (!CollectionUtils.isNotEmpty(childrenTableParamterRows)) continue;
                childrenRowAllNullFlag = false;
                if (((Map)childrenTableParamterRows.get(0)).get("update_type") == null || !ModelDrivenConstants.UPDATE_TYPE_SUBTABLE_PART_TYPE2.contains(((Map)childrenTableParamterRows.get(0)).get("update_type"))) continue;
                newMasterTableRows.add(masterTableParam);
                break block0;
            }
            if (!childrenRowAllNullFlag) continue;
            newMasterTableRows.add(masterTableParam);
        }
        return newMasterTableRows;
    }

    @Deprecated
    protected static List<String> getSelectFieldsByApiConfig_bak(Map<String, List<ModelApiField>> tileApiConfig, String targetTableName, ModelSchemaDTO modelSchema) {
        ArrayList<String> selectFields = new ArrayList<String>();
        Map<String, String> tableAliasMap = ParamValidateUtil.generateJoinTableAlias(modelSchema);
        List<ModelApiField> modelApiFields = tileApiConfig.get(targetTableName);
        for (ModelApiField modelApiField : modelApiFields) {
            String[] split = modelApiField.getFullPath().split("\\.");
            int length = split.length;
            String field = split[length - 1];
            String fieldTypeOfModelApiField = modelApiField.getModelFieldType();
            if (modelSchema == null || fieldTypeOfModelApiField != null && ModelFieldRelationTypeEnum.valueOf(fieldTypeOfModelApiField) == ModelFieldRelationTypeEnum.SIMPLE && modelApiField.getShow()) {
                String selectField = ModelQuerySelectUtil.getSelectField(modelApiField);
                selectFields.add(selectField);
                continue;
            }
            if (fieldTypeOfModelApiField == null || ModelFieldRelationTypeEnum.valueOf(fieldTypeOfModelApiField) != ModelFieldRelationTypeEnum.QUOTE_QUERY && ModelFieldRelationTypeEnum.valueOf(fieldTypeOfModelApiField) != ModelFieldRelationTypeEnum.QUOTE || !modelApiField.getShow()) continue;
            Optional<ModelFieldDTO> modelFieldOpt = modelSchema.getFields().stream().filter(modelField -> modelField.getFieldId().equalsIgnoreCase(field) && ModelFieldRelationTypeEnum.valueOf(modelField.getType()) == ModelFieldRelationTypeEnum.QUOTE_QUERY).findFirst();
            if (modelFieldOpt.isPresent()) {
                ModelFieldDTO modelFieldDTO = modelFieldOpt.get();
                List<ModelFieldDTO> fieldAssociatedFields = modelFieldDTO.getAssociatedInfo().getAssociatedFields();
                if (CollectionUtils.isNotEmpty(fieldAssociatedFields)) {
                    for (ModelFieldDTO associatedField : fieldAssociatedFields) {
                        String selectField = tableAliasMap.get(modelFieldDTO.getAssociatedInfo().getTableName()) + "." + associatedField.getFieldId() + " AS `" + associatedField.getAlias().getFieldId() + "`";
                        selectFields.add(selectField);
                    }
                    continue;
                }
                String selectField = ModelQuerySelectUtil.getSelectField(modelApiField);
                selectFields.add(selectField);
                continue;
            }
            String selectField = ModelQuerySelectUtil.getSelectField(modelApiField);
            selectFields.add(selectField);
            log.warn("added selectField({}), cause apiConfig's field({}) quote_query/quote is not matched in modelSchema({})", new Object[]{selectField, modelApiField.getFullPath(), modelSchema.getName()});
        }
        return selectFields;
    }

    public static List<String> getSelectFieldsByApiConfig(Map<String, List<ModelApiField>> tileApiConfig, String targetTableName, ModelSchemaDTO modelSchema) {
        ArrayList<String> selectFields = new ArrayList<String>();
        Map<String, String> tableAliasMap = ParamValidateUtil.generateJoinTableAlias(modelSchema);
        List<ModelApiField> modelApiFields = tileApiConfig.get(targetTableName);
        List<ModelFieldDTO> modelFields = modelSchema.getFields();
        for (ModelApiField modelApiField : modelApiFields) {
            Object selectField;
            String fieldTypeOfModelApiField = modelApiField.getModelFieldType();
            if (modelSchema == null || fieldTypeOfModelApiField != null && ModelFieldRelationTypeEnum.valueOf(fieldTypeOfModelApiField) == ModelFieldRelationTypeEnum.SIMPLE && modelApiField.getShow()) {
                String selectField2 = ModelQuerySelectUtil.getSelectField(modelApiField);
                selectFields.add(selectField2);
                continue;
            }
            if (fieldTypeOfModelApiField == null || ModelFieldRelationTypeEnum.valueOf(fieldTypeOfModelApiField) != ModelFieldRelationTypeEnum.QUOTE_QUERY && ModelFieldRelationTypeEnum.valueOf(fieldTypeOfModelApiField) != ModelFieldRelationTypeEnum.QUOTE || !modelApiField.getShow()) continue;
            String[] split = modelApiField.getFullPath().split("\\.");
            int length = split.length;
            String field = split[length - 1];
            Optional<ModelFieldDTO> modelFieldOpt = modelFields.stream().filter(modelField -> modelField.getFieldId().equalsIgnoreCase(field) && ModelFieldRelationTypeEnum.valueOf(modelField.getType()) == ModelFieldRelationTypeEnum.QUOTE_QUERY).findFirst();
            if (modelFieldOpt.isPresent()) {
                ModelFieldDTO modelFieldDTO = modelFieldOpt.get();
                ModelAssociatedInfo modelAssociatedInfo = modelFieldDTO.getAssociatedInfo();
                if (modelAssociatedInfo != null) {
                    String associatedTableName = modelAssociatedInfo.getTableName();
                    String quoteQueryTable = tableAliasMap.get(associatedTableName);
                    if (StringUtils.isNotBlank((CharSequence)quoteQueryTable)) {
                        selectField = quoteQueryTable + "." + field + " AS `" + modelApiField.getData_name() + "`";
                        log.warn("{} added selectField({}), cause apiConfig's field({}) quote_query/quote matched, modelField({}) associatedInfo matched in modelSchema({})", new Object[]{_CLASSTAG, selectField, modelApiField.getFullPath(), modelFieldDTO.getFieldId(), modelSchema.getName()});
                    } else {
                        selectField = ModelQuerySelectUtil.getSelectField(modelApiField);
                        log.warn("{} added selectField({}), cause apiConfig's field({}) quote_query/quote matched, modelField({}) associatedInfo is not matched in modelSchema({})", new Object[]{_CLASSTAG, selectField, modelApiField.getFullPath(), modelFieldDTO.getFieldId(), modelSchema.getName()});
                    }
                } else {
                    selectField = modelApiField.getFullPath() + " AS `" + modelApiField.getData_name() + "`";
                }
                selectFields.add((String)selectField);
                continue;
            }
            String quoteQueryTable = tableAliasMap.get(split[0]);
            if (StringUtils.isNotBlank((CharSequence)quoteQueryTable)) {
                selectField = quoteQueryTable + "." + field + " AS `" + modelApiField.getData_name() + "`";
                log.warn("{} added selectField({}), cause apiConfig's field({}) quote_query/quote is matched in modelSchema({})", new Object[]{_CLASSTAG, selectField, modelApiField.getFullPath(), modelSchema.getName()});
            } else {
                selectField = ModelQuerySelectUtil.getSelectField(modelApiField);
                log.warn("{} added selectField({}), cause apiConfig's field({}) quote_query/quote is not matched in modelSchema({})", new Object[]{_CLASSTAG, selectField, modelApiField.getFullPath(), modelSchema.getName()});
            }
            selectFields.add((String)selectField);
        }
        return selectFields;
    }

    public static List<String> getSelectFieldsByApiConfigV2(Map<String, List<ModelApiField>> tileApiConfig, String targetTableName, ModelSchemaDTO modelSchema, DWQueryInfo queryInfo) {
        ArrayList<String> selectFields = new ArrayList<String>();
        Map<String, String> tableAliasMap = ParamValidateUtil.generateJoinTableAlias(queryInfo);
        List<ModelApiField> modelApiFields = tileApiConfig.get(targetTableName);
        List queryInfoTableNames = tableAliasMap.keySet().stream().collect(Collectors.toList());
        queryInfoTableNames.add(queryInfo.getTableName());
        for (ModelApiField modelApiField : modelApiFields) {
            String fieldTypeOfModelApiField = modelApiField.getModelFieldType();
            if (modelSchema == null || fieldTypeOfModelApiField != null && ModelFieldRelationTypeEnum.valueOf(fieldTypeOfModelApiField) == ModelFieldRelationTypeEnum.SIMPLE && modelApiField.getShow()) {
                String selectField = ModelQuerySelectUtil.getSelectField(modelApiField);
                selectFields.add(selectField);
                continue;
            }
            if (fieldTypeOfModelApiField == null || ModelFieldRelationTypeEnum.valueOf(fieldTypeOfModelApiField) != ModelFieldRelationTypeEnum.QUOTE_QUERY && ModelFieldRelationTypeEnum.valueOf(fieldTypeOfModelApiField) != ModelFieldRelationTypeEnum.QUOTE || !modelApiField.getShow()) continue;
            String[] split = modelApiField.getFullPath().split("\\.");
            int length = split.length;
            String field = split[length - 1];
            String fieldTableName = ModelQuerySelectUtil.getTableName(modelApiField);
            if (queryInfoTableNames.contains(fieldTableName)) {
                if (tableAliasMap.containsKey(fieldTableName)) {
                    fieldTableName = tableAliasMap.get(fieldTableName);
                } else {
                    log.debug("{} ignored replace tableName selectField({}), exists in queryJoins, not in tableAlias in modelSchema({})", new Object[]{_CLASSTAG, modelApiField, modelSchema.getName()});
                }
                selectFields.add(String.join((CharSequence)".", fieldTableName, field) + " AS `" + modelApiField.getData_name() + "`");
                continue;
            }
            log.debug("{} ignored selectField({}), not exist in queryInfoTableNames (both queryJoins and tableAlias) of modelSchema({})", new Object[]{_CLASSTAG, modelApiField, modelSchema.getName()});
        }
        return selectFields;
    }

    public static String generateTableAlias(int num) {
        if (num > 702) {
            throw new RuntimeException("too many join tables,please contact lcdp developers");
        }
        int hignNum = num / 26;
        if (hignNum >= 1) {
            char[] code = new char[]{(char)((char)hignNum + 96), (char)((char)(num - hignNum * 26) + 97)};
            return new String(code);
        }
        char[] code = new char[]{(char)((char)num + 97)};
        return new String(code);
    }

    public static Map<String, String> generateJoinTableAlias(ModelSchemaDTO modelSchema) {
        List<ModelFieldDTO> modelFieldDTOs = modelSchema.getFields();
        List quoteQueryFields = modelFieldDTOs.stream().filter(modelField -> ModelFieldRelationTypeEnum.valueOf(modelField.getType()) == ModelFieldRelationTypeEnum.QUOTE_QUERY).collect(Collectors.toList());
        List joinTables = quoteQueryFields.stream().map(modelField -> modelField.getAssociatedInfo().getTableName()).collect(Collectors.toList());
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        for (int i = 0; i < joinTables.size(); ++i) {
            aliasMap.put((String)joinTables.get(i), ParamValidateUtil.generateTableAlias(i));
        }
        return aliasMap;
    }

    public static Map<String, String> generateJoinTableAlias(DWQueryInfo queryInfo) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        List queryJoins = queryInfo.getJoin();
        queryJoins.stream().filter(queryJoin -> StringUtils.isNotBlank((CharSequence)queryJoin.getJoinTableAlias())).forEach(queryJoin -> aliasMap.put(queryJoin.getJoinTableName(), queryJoin.getJoinTableAlias()));
        return aliasMap;
    }
}

