/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.core.helper;

import com.digiwin.core.model.LicenseCreatorParam;
import com.digiwin.core.model.LicenseVerifyManager;
import com.digiwin.core.model.LicenseVerifyParam;
import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.DefaultCipherParam;
import de.schlichtherle.license.DefaultKeyStoreParam;
import de.schlichtherle.license.DefaultLicenseParam;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseCreator;
import de.schlichtherle.license.LicenseParam;
import java.util.prefs.Preferences;
import javax.security.auth.x500.X500Principal;

public class ParamInitHelper {
    private static final X500Principal DEFAULT_HOLDER_AND_ISSUER = new X500Principal("CN=a, OU=a, O=a, L=a, ST=a, C=a");

    public static LicenseParam initLicenseParam(LicenseCreatorParam param) {
        Preferences preferences = Preferences.userNodeForPackage(LicenseCreator.class);
        DefaultCipherParam cipherParam = new DefaultCipherParam(param.getStorePass());
        DefaultKeyStoreParam privateStoreParam = new DefaultKeyStoreParam(LicenseCreator.class, param.getPrivateKeysStorePath(), param.getPrivateAlias(), param.getStorePass(), param.getKeyPass());
        return new DefaultLicenseParam(param.getSubject(), preferences, (KeyStoreParam)privateStoreParam, (CipherParam)cipherParam);
    }

    public static LicenseContent initLicenseContent(LicenseCreatorParam param) {
        LicenseContent licenseContent = new LicenseContent();
        licenseContent.setHolder(DEFAULT_HOLDER_AND_ISSUER);
        licenseContent.setIssuer(DEFAULT_HOLDER_AND_ISSUER);
        licenseContent.setSubject(param.getSubject());
        licenseContent.setIssued(param.getIssuedTime());
        licenseContent.setNotBefore(param.getIssuedTime());
        licenseContent.setNotAfter(param.getExpiryTime());
        licenseContent.setConsumerType(param.getConsumerType());
        licenseContent.setConsumerAmount(param.getConsumerAmount().intValue());
        licenseContent.setInfo(param.getDescription());
        licenseContent.setExtra((Object)param.getLicenseExtraCheck());
        return licenseContent;
    }

    public static LicenseParam initLicenseParam(LicenseVerifyParam param) {
        Preferences preferences = Preferences.userNodeForPackage(LicenseVerifyManager.class);
        DefaultCipherParam cipherParam = new DefaultCipherParam(param.getStorePass());
        DefaultKeyStoreParam publicStoreParam = new DefaultKeyStoreParam(LicenseVerifyManager.class, param.getPublicKeysStorePath(), param.getPublicAlias(), param.getStorePass(), null);
        return new DefaultLicenseParam(param.getSubject(), preferences, (KeyStoreParam)publicStoreParam, (CipherParam)cipherParam);
    }
}

