/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.core.model;

import com.digiwin.core.model.LicenseExtraParam;
import com.digiwin.core.utils.JsonUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class LicenseCreatorParam
implements Serializable {
    private static final long serialVersionUID = -7793154252684580872L;
    private String subject;
    private String privateAlias;
    private String keyPass;
    private String privateKeysStorePath;
    private String storePass;
    private String licensePath;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date issuedTime = new Date();
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date expiryTime;
    private String consumerType = "user";
    private Integer consumerAmount = 1;
    private String description = "";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private LicenseExtraParam licenseExtraCheck;

    public static long getSerialVersionUID() {
        return -7793154252684580872L;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getPrivateAlias() {
        return this.privateAlias;
    }

    public void setPrivateAlias(String privateAlias) {
        this.privateAlias = privateAlias;
    }

    public String getKeyPass() {
        return this.keyPass;
    }

    public void setKeyPass(String keyPass) {
        this.keyPass = keyPass;
    }

    public String getStorePass() {
        return this.storePass;
    }

    public void setStorePass(String storePass) {
        this.storePass = storePass;
    }

    public String getLicensePath() {
        return this.licensePath + "/license.lic";
    }

    public void setLicensePath(String licensePath) {
        this.licensePath = licensePath;
    }

    public String getPrivateKeysStorePath() {
        return this.privateKeysStorePath;
    }

    public void setPrivateKeysStorePath(String privateKeysStorePath) {
        this.privateKeysStorePath = privateKeysStorePath;
    }

    public Date getIssuedTime() {
        return this.issuedTime;
    }

    public void setIssuedTime(String issuedTime, String timeZone) throws ParseException {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
        this.issuedTime = this.dateFormat.parse(issuedTime);
    }

    public Date getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(String expiryTime, String timeZone) throws ParseException {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
        this.expiryTime = this.dateFormat.parse(expiryTime);
    }

    public String getConsumerType() {
        return this.consumerType;
    }

    public void setConsumerType(String consumerType) {
        this.consumerType = consumerType;
    }

    public Integer getConsumerAmount() {
        return this.consumerAmount;
    }

    public void setConsumerAmount(Integer consumerAmount) {
        this.consumerAmount = consumerAmount;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LicenseExtraParam getLicenseExtraCheck() {
        return this.licenseExtraCheck;
    }

    public void setLicenseExtraCheck(LicenseExtraParam licenseExtraCheck) {
        this.licenseExtraCheck = licenseExtraCheck;
    }

    public String toString() {
        return "LicenseCreatorParam{subject='" + this.subject + '\'' + ", privateAlias='" + this.privateAlias + '\'' + ", keyPass='" + this.keyPass + '\'' + ", privateKeysStorePath='" + this.privateKeysStorePath + '\'' + ", storePass='" + this.storePass + '\'' + ", licensePath='" + this.licensePath + '\'' + ", issuedTime=" + this.issuedTime + ", expiryTime=" + this.expiryTime + ", consumerType='" + this.consumerType + '\'' + ", consumerAmount=" + this.consumerAmount + ", description='" + this.description + '\'' + ", licenseExtraCheck=" + this.licenseExtraCheck + '}';
    }

    public static void main(String[] args) {
        LicenseCreatorParam param = new LicenseCreatorParam();
        LicenseExtraParam check = new LicenseExtraParam();
        param.setLicenseExtraCheck(check);
        System.out.println(JsonUtils.objectToJson(param));
    }
}

