/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.core.model;

import com.digiwin.core.model.LicenseExtraParam;
import com.digiwin.core.service.AServerInfos;
import com.digiwin.core.utils.CommonUtils;
import com.digiwin.core.utils.DateUtils;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseContentException;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.LicenseNotary;
import de.schlichtherle.license.LicenseParam;
import de.schlichtherle.license.NoLicenseInstalledException;
import de.schlichtherle.xml.GenericCertificate;
import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;

public class LicenseCustomManager
extends LicenseManager {
    private static final String XML_CHARSET = "UTF-8";
    private static final int DEFAULT_BUFF_SIZE = 8192;

    public LicenseCustomManager() {
    }

    public LicenseCustomManager(LicenseParam param) {
        super(param);
    }

    protected synchronized byte[] create(LicenseContent content, LicenseNotary notary) throws Exception {
        this.initialize(content);
        this.validateCreate(content);
        GenericCertificate certificate = notary.sign((Object)content);
        return this.getPrivacyGuard().cert2key(certificate);
    }

    protected synchronized LicenseContent install(byte[] key, LicenseNotary notary) throws Exception {
        GenericCertificate certificate = this.getPrivacyGuard().key2cert(key);
        notary.verify(certificate);
        LicenseContent licenseContent = (LicenseContent)this.load(certificate.getEncoded());
        this.validate(licenseContent);
        this.setLicenseKey(key);
        this.setCertificate(certificate);
        return licenseContent;
    }

    protected synchronized LicenseContent verify(LicenseNotary notary) throws Exception {
        byte[] key = this.getLicenseKey();
        if (null == key) {
            throw new NoLicenseInstalledException(this.getLicenseParam().getSubject());
        }
        GenericCertificate certificate = this.getPrivacyGuard().key2cert(key);
        notary.verify(certificate);
        LicenseContent content = (LicenseContent)this.load(certificate.getEncoded());
        this.validate(content);
        this.setCertificate(certificate);
        return content;
    }

    protected synchronized void validateCreate(LicenseContent content) throws LicenseContentException {
        Date now = new Date();
        Date notBefore = content.getNotBefore();
        Date notAfter = content.getNotAfter();
        if (null != notAfter && now.after(notAfter)) {
            String message = "\u8bc1\u4e66\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4";
            System.out.println("message = " + message);
            throw new LicenseContentException(message);
        }
        if (null != notBefore && null != notAfter && notAfter.before(notBefore)) {
            String message = "\u8bc1\u4e66\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u8bc1\u4e66\u5931\u6548\u65f6\u95f4";
            System.out.println("message = " + message);
            throw new LicenseContentException(message);
        }
        String consumerType = content.getConsumerType();
        if (null == consumerType) {
            String message = "\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
            System.out.println("message = " + message);
            throw new LicenseContentException(message);
        }
    }

    protected synchronized void validate(LicenseContent content) throws LicenseContentException {
        Date now = new Date();
        Date notAfter = content.getNotAfter();
        if (now.after(notAfter)) {
            throw new LicenseContentException("\u7cfb\u7edf\u8bc1\u4e66\u8fc7\u671f\uff0c\u5f53\u524d\u65f6\u95f4\u5df2\u8d85\u8fc7\u8bc1\u4e66\u6709\u6548\u671f -- " + DateUtils.date2Str(content.getNotAfter()) + "");
        }
        super.validate(content);
        LicenseExtraParam expectedCheck = (LicenseExtraParam)content.getExtra();
        LicenseExtraParam serverCheckModel = AServerInfos.getServer(null).getServerInfos();
        if (expectedCheck != null && serverCheckModel != null) {
            if (expectedCheck.isIpCheck() && !this.checkIpAddress(expectedCheck.getIpAddress(), serverCheckModel.getIpAddress())) {
                String message = "\u7cfb\u7edf\u8bc1\u4e66\u65e0\u6548\uff0c\u5f53\u524d\u670d\u52a1\u5668\u7684IP\u6ca1\u5728\u6388\u6743\u8303\u56f4\u5185";
                System.out.println("message = " + message);
                throw new LicenseContentException(message);
            }
            if (expectedCheck.isMacCheck() && !this.checkIpAddress(expectedCheck.getMacAddress(), serverCheckModel.getMacAddress())) {
                String message = "\u7cfb\u7edf\u8bc1\u4e66\u65e0\u6548\uff0c\u5f53\u524d\u670d\u52a1\u5668\u7684Mac\u5730\u5740\u6ca1\u5728\u6388\u6743\u8303\u56f4\u5185";
                System.out.println("message = " + message);
                throw new LicenseContentException(message);
            }
            if (expectedCheck.isBoardCheck() && !this.checkSerial(expectedCheck.getMainBoardSerial(), serverCheckModel.getMainBoardSerial())) {
                String message = "\u7cfb\u7edf\u8bc1\u4e66\u65e0\u6548\uff0c\u5f53\u524d\u670d\u52a1\u5668\u7684\u4e3b\u677f\u5e8f\u5217\u53f7\u6ca1\u5728\u6388\u6743\u8303\u56f4\u5185";
                System.out.println("message = " + message);
                throw new LicenseContentException(message);
            }
            if (expectedCheck.isCpuCheck() && !this.checkSerial(expectedCheck.getCpuSerial(), serverCheckModel.getCpuSerial())) {
                String message = "\u7cfb\u7edf\u8bc1\u4e66\u65e0\u6548\uff0c\u5f53\u524d\u670d\u52a1\u5668\u7684CPU\u5e8f\u5217\u53f7\u6ca1\u5728\u6388\u6743\u8303\u56f4\u5185";
                System.out.println("message = " + message);
                throw new LicenseContentException(message);
            }
        } else {
            System.out.println("\u4e0d\u80fd\u83b7\u53d6\u670d\u52a1\u5668\u786c\u4ef6\u4fe1\u606f");
            throw new LicenseContentException("\u4e0d\u80fd\u83b7\u53d6\u670d\u52a1\u5668\u786c\u4ef6\u4fe1\u606f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object load(String encoded) {
        BufferedInputStream inputStream = null;
        XMLDecoder decoder = null;
        try {
            inputStream = new BufferedInputStream(new ByteArrayInputStream(encoded.getBytes(XML_CHARSET)));
            decoder = new XMLDecoder(new BufferedInputStream(inputStream, 8192), null, null);
            Object object = decoder.readObject();
            return object;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (decoder != null) {
                    decoder.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                System.out.println("XMLDecoder\u89e3\u6790XML\u5931\u8d25 ");
                e.printStackTrace();
            }
        }
        return null;
    }

    private boolean checkIpAddress(List<String> expectedList, List<String> serverList) {
        if (CommonUtils.isEmpty(expectedList)) {
            return false;
        }
        if (CommonUtils.isEmpty(serverList)) {
            return false;
        }
        for (String expected : expectedList) {
            if (!serverList.contains(expected.trim())) continue;
            return true;
        }
        return false;
    }

    private boolean checkSerial(String expectedSerial, String serverSerial) {
        if (CommonUtils.isNotEmpty(expectedSerial)) {
            if (CommonUtils.isNotEmpty(serverSerial)) {
                return expectedSerial.equals(serverSerial);
            }
            return false;
        }
        return true;
    }
}

