/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.core.model;

import com.digiwin.core.helper.ParamInitHelper;
import com.digiwin.core.model.LicenseCustomManager;
import com.digiwin.core.model.LicenseResult;
import com.digiwin.core.model.LicenseVerifyParam;
import com.digiwin.core.utils.DateUtils;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseContentException;
import de.schlichtherle.license.LicenseParam;
import de.schlichtherle.license.NoLicenseInstalledException;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;

public class LicenseVerifyManager {
    public synchronized LicenseResult install(LicenseVerifyParam param) {
        try {
            LicenseParam licenseParam = ParamInitHelper.initLicenseParam(param);
            LicenseCustomManager licenseManager = new LicenseCustomManager(licenseParam);
            File licenseFile = new File(param.getLicensePath());
            licenseManager.uninstall();
            LicenseContent content = licenseManager.install(licenseFile);
            String message = MessageFormat.format("\u8bc1\u4e66\u5b89\u88c5\u6210\u529f\uff0c\u8bc1\u4e66\u6709\u6548\u671f\uff1a{0} - {1}", DateUtils.date2Str(content.getNotBefore()), DateUtils.date2Str(content.getNotAfter()));
            System.out.println("message = " + message);
            return new LicenseResult(message, content);
        }
        catch (LicenseContentException contentExc) {
            String message = contentExc.getMessage();
            System.out.println("message = " + message);
            return new LicenseResult(false, message, (Exception)((Object)contentExc));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new LicenseResult(false, e.getMessage(), e);
        }
    }

    public LicenseResult verify(LicenseVerifyParam param) {
        LicenseParam licenseParam = ParamInitHelper.initLicenseParam(param);
        LicenseCustomManager licenseManager = new LicenseCustomManager(licenseParam);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            String licensePath = param.getLicensePath();
            if (licensePath == null || licensePath == "") {
                String msg = "license.lic\u8def\u5f84\u672a\u6307\u5b9a\uff0c\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff01";
                System.out.println("msg = " + msg);
                return new LicenseResult(false, msg, new Exception(msg));
            }
            if (!licensePath.contains("classpath:")) {
                new File(licensePath);
            }
            LicenseContent licenseContent = licenseManager.verify();
            String message = MessageFormat.format("\u8bc1\u4e66\u6821\u9a8c\u901a\u8fc7\uff0c\u8bc1\u4e66\u6709\u6548\u671f\uff1a{0} - {1}", format.format(licenseContent.getNotBefore()), format.format(licenseContent.getNotAfter()));
            System.out.println("message = " + message);
            return new LicenseResult(message, licenseContent);
        }
        catch (NoLicenseInstalledException ex) {
            String message = "\u8bc1\u4e66\u672a\u5b89\u88c5\uff01";
            System.out.println("message = " + message);
            return new LicenseResult(false, message, (Exception)((Object)ex));
        }
        catch (LicenseContentException cex) {
            cex.printStackTrace();
            return new LicenseResult(false, cex.getMessage(), (Exception)((Object)cex));
        }
        catch (FileNotFoundException fnfe) {
            String msg = String.format("license.lic\u6587\u4ef6\uff08%s\uff09\u4e0d\u5b58\u5728\uff0c\u9a8c\u8bc1\u5931\u8d25\uff01", param.getLicensePath());
            System.out.println("msg = " + msg);
            return new LicenseResult(false, msg, fnfe);
        }
        catch (Exception e) {
            String message = "\u8bc1\u4e66\u6821\u9a8c\u5931\u8d25\uff01";
            System.out.println("message = " + message);
            return new LicenseResult(false, message, e);
        }
    }
}

