/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.core.service;

import com.digiwin.core.model.LicenseExtraParam;
import com.digiwin.core.service.LinuxServerInfos;
import com.digiwin.core.service.WindowsServerInfos;
import com.digiwin.core.utils.CommonUtils;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AServerInfos {
    public LicenseExtraParam getServerInfos() {
        LicenseExtraParam result = new LicenseExtraParam();
        try {
            this.initServerInfos();
            result.setIpAddress(GxServerInfosContainer.ipAddress);
            result.setMacAddress(GxServerInfosContainer.macAddress);
            result.setCpuSerial(GxServerInfosContainer.cpuSerial);
            result.setMainBoardSerial(GxServerInfosContainer.mainBoardSerial);
            result.setIpCheck(GxServerInfosContainer.isIpCheck);
            result.setMacCheck(GxServerInfosContainer.isMacCheck);
            result.setCpuCheck(GxServerInfosContainer.isCpuCheck);
            result.setBoardCheck(GxServerInfosContainer.isBoardCheck);
        }
        catch (Exception e) {
            System.out.println("\u83b7\u53d6\u670d\u52a1\u5668\u786c\u4ef6\u4fe1\u606f\u5931\u8d25 " + e);
        }
        return result;
    }

    private void initServerInfos() throws Exception {
        if (GxServerInfosContainer.ipAddress == null) {
            GxServerInfosContainer.ipAddress = this.getIpAddress();
        }
        if (GxServerInfosContainer.macAddress == null) {
            GxServerInfosContainer.macAddress = this.getMacAddress();
        }
        if (GxServerInfosContainer.cpuSerial == null) {
            GxServerInfosContainer.cpuSerial = this.getCPUSerial();
        }
        if (GxServerInfosContainer.mainBoardSerial == null) {
            GxServerInfosContainer.mainBoardSerial = this.getMainBoardSerial();
        }
    }

    public List<String> getIpAddress() throws Exception {
        List<InetAddress> inetAddresses = this.getLocalAllInetAddress();
        if (CommonUtils.isNotEmpty(inetAddresses)) {
            return inetAddresses.stream().map(InetAddress::getHostAddress).distinct().map(String::toLowerCase).collect(Collectors.toList());
        }
        return null;
    }

    public List<String> getMacAddress() throws Exception {
        List<InetAddress> inetAddresses = this.getLocalAllInetAddress();
        if (CommonUtils.isNotEmpty(inetAddresses)) {
            return inetAddresses.stream().map(this::getMacByInetAddress).distinct().collect(Collectors.toList());
        }
        return null;
    }

    public static AServerInfos getServer(String osName) {
        if ("".equals(osName) || osName == null) {
            osName = System.getProperty("os.name").toLowerCase();
        }
        AServerInfos abstractServerInfos = osName.startsWith("windows") ? new WindowsServerInfos() : (osName.startsWith("linux") ? new LinuxServerInfos() : new LinuxServerInfos());
        return abstractServerInfos;
    }

    public static String getServerTempPath() {
        String property = System.getProperty("user.dir");
        return property;
    }

    protected abstract String getCPUSerial() throws Exception;

    protected abstract String getMainBoardSerial() throws Exception;

    private List<InetAddress> getLocalAllInetAddress() throws Exception {
        ArrayList<InetAddress> result = new ArrayList<InetAddress>(4);
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface ni = networkInterfaces.nextElement();
            Enumeration<InetAddress> addresses = ni.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address.isLoopbackAddress() || address.isLinkLocalAddress() || address.isMulticastAddress()) continue;
                result.add(address);
            }
        }
        return result;
    }

    private String getMacByInetAddress(InetAddress inetAddr) {
        try {
            byte[] mac = NetworkInterface.getByInetAddress(inetAddr).getHardwareAddress();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                String temp;
                if (i != 0) {
                    stringBuilder.append("-");
                }
                if ((temp = Integer.toHexString(mac[i] & 0xFF)).length() == 1) {
                    stringBuilder.append("0").append(temp);
                    continue;
                }
                stringBuilder.append(temp);
            }
            return stringBuilder.toString().toUpperCase();
        }
        catch (SocketException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class GxServerInfosContainer {
        private static List<String> ipAddress = null;
        private static List<String> macAddress = null;
        private static String cpuSerial = null;
        private static String mainBoardSerial = null;
        private static boolean isIpCheck = true;
        private static boolean isMacCheck = true;
        private static boolean isCpuCheck = true;
        private static boolean isBoardCheck = true;

        private GxServerInfosContainer() {
        }
    }
}

