/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.core.utils;

import com.digiwin.core.utils.CommonUtils;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    private static SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH_mm_ss");
    private static DateTimeFormatter dtF = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static Calendar calendar = Calendar.getInstance();

    public static synchronized String getCurrentDateForFile() {
        long currentTimeMillis = System.currentTimeMillis();
        Date date = new Date(currentTimeMillis);
        return sDateFormat.format(date);
    }

    public static Long getTime(String time) {
        if (CommonUtils.isEmpty(time)) {
            System.out.println("\u65f6\u95f4[" + time + "]\u683c\u5f0f\u4e0d\u5408\u6cd5");
            return null;
        }
        if (time.length() < 11) {
            dtF = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate parse = LocalDate.parse(time, dtF);
            return LocalDate.from(parse).atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
        }
        LocalDateTime parse = LocalDateTime.parse(time, dtF);
        return LocalDateTime.from(parse).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static synchronized String getDate() {
        Date date = new Date();
        sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sDateFormat.format(date);
    }

    public static synchronized String date2Str(Long time) {
        Date date = new Date(time);
        sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sDateFormat.format(date);
    }

    public static synchronized String date2Str(Date time) {
        sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sDateFormat.format(time);
    }

    public static synchronized Date str2Date(String time) {
        sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return sDateFormat.parse(time);
        }
        catch (Exception var2) {
            System.out.println("\u5b57\u7b26\u4e32[" + time + "]\u8f6c\u6362\u65e5\u671f\u683c\u5f0f\u5f02\u5e38");
            return null;
        }
    }

    public static Date addYear(Date date, int mount) {
        calendar.setTime(date);
        calendar.add(1, mount);
        return calendar.getTime();
    }

    public static Date addYear(Long time, int mount) {
        Date date = new Date(time);
        calendar.setTime(date);
        calendar.add(1, mount);
        return calendar.getTime();
    }

    public static Date addMonth(Date date, int mount) {
        calendar.setTime(date);
        calendar.add(2, mount);
        return calendar.getTime();
    }

    public static Date addMonth(Long time, int mount) {
        Date date = new Date(time);
        calendar.setTime(date);
        calendar.add(1, mount);
        return calendar.getTime();
    }

    public static Date addDay(Date date, int mount) {
        calendar.setTime(date);
        calendar.add(5, mount);
        return calendar.getTime();
    }

    public static Date addDay(Long time, int mount) {
        Date date = new Date(time);
        calendar.setTime(date);
        calendar.add(5, mount);
        return calendar.getTime();
    }

    public static void main(String[] args) {
        Long time = 1555588742901L;
        DateUtils.date2Str(time);
    }
}

