/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.core.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class JsonUtils {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    public static String objectToJson(Object data) {
        try {
            return MAPPER.writeValueAsString(data);
        }
        catch (JsonProcessingException var2) {
            var2.printStackTrace();
            return null;
        }
    }

    public static String objectToJsonWithType(Object data, TypeReference typeReference) {
        try {
            return MAPPER.writerFor(typeReference).writeValueAsString(data);
        }
        catch (JsonProcessingException var3) {
            var3.printStackTrace();
            return null;
        }
    }

    public static <T> T jsonToPojo(String jsonData, Class<T> beanType) {
        try {
            return (T)MAPPER.readValue(jsonData, beanType);
        }
        catch (Exception var3) {
            var3.printStackTrace();
            return null;
        }
    }

    public static <T> List<T> jsonToList(String jsonData, Class<T> beanType) {
        JavaType javaType = MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{beanType});
        try {
            return (List)MAPPER.readValue(jsonData, javaType);
        }
        catch (Exception var4) {
            var4.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> parseMap(String jsonStr) throws IOException {
        return (Map)MAPPER.readValue(jsonStr, Map.class);
    }

    public static List<String> parseList(String jsonStr) throws IOException {
        return (List)MAPPER.readValue(jsonStr, (TypeReference)new TypeReference<List<String>>(){});
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        MAPPER.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }
}

