/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.common.object;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectUtil {
    private static final Logger logger = LoggerFactory.getLogger(ObjectUtil.class);

    public static String getObjectFieldValByName(Object object, String name) {
        try {
            Field[] fieldList = object.getClass().getDeclaredFields();
            Optional<Field> fieldOptional = Arrays.stream(fieldList).filter(e -> e.getName().equalsIgnoreCase(name)).findFirst();
            if (!fieldOptional.isPresent()) {
                return "";
            }
            Field field = fieldOptional.get();
            field.setAccessible(true);
            Object val = field.get(object);
            return Objects.isNull(val) ? "" : String.valueOf(val);
        }
        catch (Exception e2) {
            logger.error("ObjectUtil getObjectFieldValByName error :", (Throwable)e2);
            return "";
        }
    }
}

