/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.common.string;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegexUtil {
    public static final String REGEX_IP = "^((?:(?:25[0-5]|2[0-4]\\d|[01]?\\d?\\d)\\.){3}(?:25[0-5]|2[0-4]\\d|[01]?\\d?\\d))$";
    public static final Pattern PATTERN_REGEX_IP = Pattern.compile("^((?:(?:25[0-5]|2[0-4]\\d|[01]?\\d?\\d)\\.){3}(?:25[0-5]|2[0-4]\\d|[01]?\\d?\\d))$");
    public static final String REGEX_DOMAIN = "^[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+\\.?$";
    public static final Pattern PATTERN_REGEX_DOMAIN = Pattern.compile("^[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+\\.?$");
    public static final String REGEX_CHINESE_WORD = "^[\\u4e00-\\u9fa5]+$";
    public static final Pattern PATTERN_REGEX_CHINESE_WORD = Pattern.compile("^[\\u4e00-\\u9fa5]+$");
    public static final String REGEX_NUMBER_ALPHABET_WORD = "^[A-Za-z0-9]+$";
    public static final Pattern PATTERN_REGEX_NUMBER_ALPHABET_WORD = Pattern.compile("^[A-Za-z0-9]+$");
    public static final String REGEX_POSITIVE_NEGATIVE_DECIMAL_NUMBER = "^(\\-|\\+)?\\d+(\\.\\d+)?((E|e)(\\-)?\\d+)?$";
    public static final Pattern PATTERN_REGEX_POSITIVE_NEGATIVE_DECIMAL_NUMBER = Pattern.compile("^(\\-|\\+)?\\d+(\\.\\d+)?((E|e)(\\-)?\\d+)?$");
    public static final String REGEX_AI_ASSISTANT_QUESTION_TEMPLATE = "\\\u300c.*?\\\u300d";
    public static final Pattern PATTERN_REGEX_AI_ASSISTANT_TEMPLATE = Pattern.compile("\\\u300c.*?\\\u300d");

    public static boolean isMatch(String regex, CharSequence input) {
        return input != null && input.length() > 0 && Pattern.matches(regex, input);
    }

    public static boolean isMatch(Pattern pattern, CharSequence input) {
        return input != null && input.length() > 0 && pattern.matcher(input).matches();
    }

    public static List<String> getMatches(String regex, CharSequence input) {
        if (input == null) {
            return null;
        }
        ArrayList<String> matches = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            matches.add(matcher.group());
        }
        return matches;
    }
}

